/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.admin.impl;

import com.biglybt.core.Core;
import com.biglybt.core.ipchecker.natchecker.NatChecker;
import com.biglybt.core.networkmanager.admin.NetworkAdminException;
import com.biglybt.core.networkmanager.admin.NetworkAdminProgressListener;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminProtocolTester;
import com.biglybt.core.versioncheck.VersionCheckClient;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class NetworkAdminTCPTester
implements NetworkAdminProtocolTester {
    private final Core core;
    private final NetworkAdminProgressListener listener;

    protected NetworkAdminTCPTester(Core _core, NetworkAdminProgressListener _listener) {
        this.core = _core;
        this.listener = _listener;
    }

    @Override
    public InetAddress testOutbound(InetAddress bind_ip, int bind_port, boolean ipv6) throws NetworkAdminException {
        try {
            return VersionCheckClient.getSingleton().getExternalIpAddressTCP(bind_ip, bind_port, ipv6);
        }
        catch (Throwable e) {
            try {
                Socket socket = new Socket();
                if (bind_ip != null) {
                    socket.bind(new InetSocketAddress(bind_ip, bind_port));
                } else if (bind_port != 0) {
                    socket.bind(new InetSocketAddress(bind_port));
                }
                socket.setSoTimeout(10000);
                socket.connect(new InetSocketAddress("www.google.com", 80), 10000);
                socket.close();
                return null;
            }
            catch (Throwable f) {
                throw new NetworkAdminException("Outbound test failed", e);
            }
        }
    }

    @Override
    public InetAddress testInbound(InetAddress bind_ip, int local_port, boolean ipv6) throws NetworkAdminException {
        NatChecker checker = new NatChecker(this.core, bind_ip, local_port, ipv6, false);
        if (checker.getResult() == 1) {
            return checker.getExternalAddress();
        }
        throw new NetworkAdminException("NAT test failed: " + checker.getAdditionalInfo());
    }
}

