/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.impl.ByteBucket;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;

public class ByteBucketST
implements ByteBucket {
    private int rate;
    private int burst_rate;
    private long avail_bytes;
    private long prev_update_time;
    private boolean frozen;

    public ByteBucketST(int rate_bytes_per_sec) {
        this(rate_bytes_per_sec, rate_bytes_per_sec + rate_bytes_per_sec / 5);
    }

    private ByteBucketST(int rate_bytes_per_sec, int burst_rate) {
        this.rate = rate_bytes_per_sec;
        this.burst_rate = burst_rate;
        this.avail_bytes = 0L;
        this.prev_update_time = SystemTime.getSteppedMonotonousTime();
        this.ensureByteBucketMinBurstRate();
    }

    @Override
    public int getAvailableByteCount() {
        if (this.avail_bytes < 0x6400000L) {
            this.update_avail_byte_count();
        }
        return (int)this.avail_bytes;
    }

    @Override
    public void setBytesUsed(int bytes_used) {
        if (this.avail_bytes >= 0x6400000L) {
            return;
        }
        this.avail_bytes -= (long)bytes_used;
        if (this.avail_bytes < 0L) {
            this.avail_bytes = 0L;
        }
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    public int getBurstRate() {
        return this.burst_rate;
    }

    @Override
    public void setRate(int rate_bytes_per_sec) {
        this.setRate(rate_bytes_per_sec, rate_bytes_per_sec + rate_bytes_per_sec / 5);
    }

    public void setRate(int rate_bytes_per_sec, int burst_rate) {
        if (rate_bytes_per_sec < 0) {
            Debug.out("rate_bytes_per_sec [" + rate_bytes_per_sec + "] < 0");
            rate_bytes_per_sec = 0;
        }
        if (burst_rate < rate_bytes_per_sec) {
            Debug.out("burst_rate [" + burst_rate + "] < rate_bytes_per_sec [" + rate_bytes_per_sec + "]");
            burst_rate = rate_bytes_per_sec;
        }
        this.rate = rate_bytes_per_sec;
        this.burst_rate = burst_rate;
        if (this.avail_bytes > (long)burst_rate) {
            this.avail_bytes = burst_rate;
        }
        this.ensureByteBucketMinBurstRate();
    }

    @Override
    public void setFrozen(boolean f) {
        if (f && this.frozen) {
            Debug.out("Already frozen!");
        }
        this.frozen = f;
    }

    private void update_avail_byte_count() {
        if (this.frozen) {
            return;
        }
        long now = SystemTime.getSteppedMonotonousTime();
        if (this.prev_update_time < now) {
            this.avail_bytes += (now - this.prev_update_time) * (long)this.rate / 1000L;
            this.prev_update_time = now;
            if (this.avail_bytes > (long)this.burst_rate) {
                this.avail_bytes = this.burst_rate;
            } else if (this.avail_bytes < 0L) {
                Debug.out("ERROR: avail_bytes < 0: " + this.avail_bytes);
            }
        }
    }

    private void ensureByteBucketMinBurstRate() {
        int mss = NetworkManager.getMinMssSize();
        if (this.burst_rate < mss) {
            this.burst_rate = mss;
        }
    }
}

