/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.networkmanager.EventWaiter;
import com.biglybt.core.networkmanager.NetworkConnectionBase;
import com.biglybt.core.networkmanager.RateHandler;
import com.biglybt.core.networkmanager.TransportBase;
import com.biglybt.core.networkmanager.impl.RateControlledEntity;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiPeerDownloader2
implements RateControlledEntity {
    private static final int MOVE_TO_IDLE_TIME = 500;
    private static final Object ADD_ACTION = new Object();
    private static final Object REMOVE_ACTION = new Object();
    private volatile ArrayList<NetworkConnectionBase> connections_cow = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("MultiPeerDownloader");
    private final RateHandler main_handler;
    private volatile List<Object[]> pending_actions;
    private final ConnectionList active_connections = new ConnectionList();
    private final ConnectionList idle_connections = new ConnectionList();
    private long last_idle_check;
    private volatile EventWaiter waiter;

    public MultiPeerDownloader2(RateHandler _main_handler) {
        this.main_handler = _main_handler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.main_handler;
    }

    public void addPeerConnection(NetworkConnectionBase connection) {
        if (connection == null) {
            Debug.out("connection is null");
            return;
        }
        EventWaiter waiter_to_kick = null;
        try {
            this.connections_mon.enter();
            int cow_size = this.connections_cow.size();
            if (cow_size == 0 && (waiter_to_kick = this.waiter) != null) {
                this.waiter = null;
            }
            ArrayList<NetworkConnectionBase> conn_new = new ArrayList<NetworkConnectionBase>(cow_size + 1);
            conn_new.addAll(this.connections_cow);
            conn_new.add(connection);
            this.connections_cow = conn_new;
            if (this.pending_actions == null) {
                this.pending_actions = new ArrayList<Object[]>();
            }
            this.pending_actions.add(new Object[]{ADD_ACTION, connection});
        }
        finally {
            this.connections_mon.exit();
        }
        if (waiter_to_kick != null) {
            waiter_to_kick.eventOccurred();
        }
    }

    public boolean removePeerConnection(NetworkConnectionBase connection) {
        if (connection == null) {
            Debug.out("connection is null");
            return false;
        }
        try {
            this.connections_mon.enter();
            ArrayList<NetworkConnectionBase> conn_new = new ArrayList<NetworkConnectionBase>(this.connections_cow);
            boolean removed = conn_new.remove(connection);
            if (!removed) {
                return false;
            }
            this.connections_cow = conn_new;
            if (this.pending_actions == null) {
                this.pending_actions = new ArrayList<Object[]>();
            }
            this.pending_actions.add(new Object[]{REMOVE_ACTION, connection});
            return true;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    @Override
    public boolean canProcess(EventWaiter waiter) {
        try {
            int[] allowed = this.main_handler.getCurrentNumBytesAllowed();
            return allowed[0] >= 1;
        }
        catch (RuntimeException e) {
            Debug.out(this.getString(), e);
            throw e;
        }
    }

    @Override
    public long getBytesReadyToWrite() {
        return 0L;
    }

    @Override
    public int getConnectionCount(EventWaiter _waiter) {
        int result = this.connections_cow.size();
        if (result == 0) {
            this.waiter = _waiter;
        }
        return result;
    }

    @Override
    public int getReadyConnectionCount(EventWaiter waiter) {
        int res = 0;
        for (NetworkConnectionBase connection : this.connections_cow) {
            TransportBase tb = connection.getTransportBase();
            if (tb == null || tb.isReadyForRead(waiter) != 0L) continue;
            ++res;
        }
        return res;
    }

    @Override
    public int doProcessing(EventWaiter waiter, int max_bytes) {
        boolean protocol_is_free;
        int num_bytes_allowed;
        block23: {
            int[] bytes_allowed = this.main_handler.getCurrentNumBytesAllowed();
            num_bytes_allowed = bytes_allowed[0];
            boolean bl = protocol_is_free = bytes_allowed[1] > 0;
            if (num_bytes_allowed >= 1) break block23;
            return 0;
        }
        try {
            long now;
            if (max_bytes > 0 && max_bytes < num_bytes_allowed) {
                num_bytes_allowed = max_bytes;
            }
            if (this.pending_actions != null) {
                try {
                    this.connections_mon.enter();
                    int i = 0;
                    while (i < this.pending_actions.size()) {
                        Object[] entry = this.pending_actions.get(i);
                        NetworkConnectionBase connection = (NetworkConnectionBase)entry[1];
                        if (entry[0] == ADD_ACTION) {
                            this.active_connections.add(connection);
                        } else {
                            this.active_connections.remove(connection);
                            this.idle_connections.remove(connection);
                        }
                        ++i;
                    }
                    this.pending_actions = null;
                }
                finally {
                    this.connections_mon.exit();
                }
            }
            if ((now = SystemTime.getSteppedMonotonousTime()) - this.last_idle_check > 500L) {
                this.last_idle_check = now;
                ConnectionEntry entry = this.idle_connections.head();
                while (entry != null) {
                    NetworkConnectionBase connection = entry.connection;
                    ConnectionEntry next = entry.next;
                    TransportBase tb = connection.getTransportBase();
                    if (tb != null && tb.isReadyForRead(waiter) == 0L) {
                        this.idle_connections.remove(entry);
                        this.active_connections.addToStart(entry);
                    }
                    entry = next;
                }
            }
            int num_bytes_remaining = num_bytes_allowed;
            int data_bytes_read = 0;
            int protocol_bytes_read = 0;
            ConnectionEntry entry = this.active_connections.head();
            int num_entries = this.active_connections.size();
            int i = 0;
            while (i < num_entries && entry != null && num_bytes_remaining > 0) {
                NetworkConnectionBase connection = entry.connection;
                ConnectionEntry next = entry.next;
                TransportBase tb = connection.getTransportBase();
                if (tb != null) {
                    long ready = tb.isReadyForRead(waiter);
                    if (ready == 0L) {
                        int mss = connection.getMssSize();
                        int allowed = num_bytes_remaining > mss ? mss : num_bytes_remaining;
                        int bytes_read = 0;
                        try {
                            int[] read = connection.getIncomingMessageQueue().receiveFromTransport(allowed, protocol_is_free);
                            data_bytes_read += read[0];
                            protocol_bytes_read += read[1];
                            bytes_read = read[0] + read[1];
                        }
                        catch (Throwable e) {
                            if (!(e instanceof IOException) && !Debug.getNestedExceptionMessage(e).contains("Incorrect mix")) {
                                Debug.printStackTrace(e);
                            }
                            connection.notifyOfException(e);
                        }
                        num_bytes_remaining -= bytes_read;
                        this.active_connections.moveToEnd(entry);
                    } else if (ready > 500L) {
                        this.active_connections.remove(entry);
                        this.idle_connections.addToEnd(entry);
                    }
                    entry = next;
                }
                ++i;
            }
            int total_bytes_read = num_bytes_allowed - num_bytes_remaining;
            if (total_bytes_read > 0) {
                this.main_handler.bytesProcessed(data_bytes_read, protocol_bytes_read);
                return total_bytes_read;
            }
            return 0;
        }
        catch (RuntimeException e) {
            Debug.out(this.getString(), e);
            throw e;
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean getPriorityBoost() {
        return false;
    }

    @Override
    public String getString() {
        StringBuilder str = new StringBuilder();
        str.append("MPD (").append(this.connections_cow.size()).append("/").append(this.active_connections.size()).append("/").append(this.idle_connections.size()).append(": ");
        int num = 0;
        for (NetworkConnectionBase connection : this.connections_cow) {
            if (num++ > 0) {
                str.append(",");
            }
            str.append(connection.getString());
        }
        return str.toString();
    }

    protected static class ConnectionEntry {
        ConnectionEntry next;
        ConnectionEntry prev;
        final NetworkConnectionBase connection;

        protected ConnectionEntry(NetworkConnectionBase _connection) {
            this.connection = _connection;
        }
    }

    protected static class ConnectionList {
        private int size;
        private ConnectionEntry head;
        private ConnectionEntry tail;

        protected ConnectionList() {
        }

        protected ConnectionEntry add(NetworkConnectionBase connection) {
            ConnectionEntry entry = new ConnectionEntry(connection);
            if (this.head == null) {
                this.head = this.tail = entry;
            } else {
                this.tail.next = entry;
                entry.prev = this.tail;
                this.tail = entry;
            }
            ++this.size;
            return entry;
        }

        protected void addToEnd(ConnectionEntry entry) {
            entry.next = null;
            entry.prev = this.tail;
            if (this.tail == null) {
                this.head = this.tail = entry;
            } else {
                this.tail.next = entry;
                this.tail = entry;
            }
            ++this.size;
        }

        protected void addToStart(ConnectionEntry entry) {
            entry.next = this.head;
            entry.prev = null;
            if (this.head == null) {
                this.head = this.tail = entry;
            } else {
                this.head.prev = entry;
                this.head = entry;
            }
            ++this.size;
        }

        protected void moveToEnd(ConnectionEntry entry) {
            if (entry != this.tail) {
                ConnectionEntry prev = entry.prev;
                ConnectionEntry next = entry.next;
                if (prev == null) {
                    this.head = next;
                } else {
                    prev.next = next;
                }
                next.prev = prev;
                entry.prev = this.tail;
                entry.next = null;
                this.tail.next = entry;
                this.tail = entry;
            }
        }

        protected ConnectionEntry remove(NetworkConnectionBase connection) {
            ConnectionEntry entry = this.head;
            while (entry != null) {
                if (entry.connection == connection) {
                    this.remove(entry);
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        protected void remove(ConnectionEntry entry) {
            ConnectionEntry prev = entry.prev;
            ConnectionEntry next = entry.next;
            if (prev == null) {
                this.head = next;
            } else {
                prev.next = next;
            }
            if (next == null) {
                this.tail = prev;
            } else {
                next.prev = prev;
            }
            --this.size;
        }

        protected int size() {
            return this.size;
        }

        protected ConnectionEntry head() {
            return this.head;
        }
    }
}

