/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.impl.ProtocolDecoderPHE;
import com.biglybt.core.networkmanager.impl.TransportHelperFilter;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import java.util.ArrayList;
import java.util.List;

public abstract class ProtocolDecoder {
    static final LogIDs LOGID = LogIDs.NWMAN;
    private static final int TIMEOUT_CHECK = 5000;
    private static final int LOG_TICKS = 12;
    static final List<ProtocolDecoder> decoders = new ArrayList<ProtocolDecoder>();
    static final AEMonitor class_mon = new AEMonitor("TCPProtocolDecoder:class");
    static int loop = 0;

    static {
        SimpleTimer.addPeriodicEvent("ProtocolDecoder:timeouts", 5000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent ev) {
                ArrayList<ProtocolDecoder> copy;
                ++loop;
                try {
                    class_mon.enter();
                    if (loop % 12 == 0 && Logger.isEnabled() && decoders.size() > 0) {
                        Logger.log(new LogEvent(LOGID, "Active protocol decoders = " + decoders.size()));
                    }
                    copy = new ArrayList<ProtocolDecoder>(decoders);
                }
                finally {
                    class_mon.exit();
                }
                if (copy.size() > 0) {
                    ArrayList<ProtocolDecoder> to_remove = new ArrayList<ProtocolDecoder>();
                    long now = SystemTime.getCurrentTime();
                    for (ProtocolDecoder decoder : copy) {
                        if (!decoder.isComplete(now)) continue;
                        to_remove.add(decoder);
                    }
                    if (to_remove.size() > 0) {
                        try {
                            class_mon.enter();
                            for (ProtocolDecoder decoder : to_remove) {
                                decoders.remove(decoder);
                            }
                        }
                        finally {
                            class_mon.exit();
                        }
                    }
                }
            }
        });
    }

    protected ProtocolDecoder(boolean run_timer) {
        if (run_timer) {
            try {
                class_mon.enter();
                decoders.add(this);
            }
            finally {
                class_mon.exit();
            }
        }
    }

    public abstract boolean isComplete(long var1);

    public abstract TransportHelperFilter getFilter();

    public static void addSecrets(String name, byte[][] secrets) {
        ProtocolDecoderPHE.addSecretsSupport(name, secrets);
    }

    public static void removeSecrets(byte[][] secrets) {
        ProtocolDecoderPHE.removeSecretsSupport(secrets);
    }
}

