/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.networkmanager.EventWaiter;
import com.biglybt.core.networkmanager.NetworkConnectionBase;
import com.biglybt.core.networkmanager.RateHandler;
import com.biglybt.core.networkmanager.TransportBase;
import com.biglybt.core.networkmanager.impl.RateControlledEntity;
import com.biglybt.core.util.Debug;
import java.io.IOException;

public class SinglePeerDownloader
implements RateControlledEntity {
    private final NetworkConnectionBase connection;
    private final RateHandler rate_handler;

    public SinglePeerDownloader(NetworkConnectionBase connection, RateHandler rate_handler) {
        this.connection = connection;
        this.rate_handler = rate_handler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.rate_handler;
    }

    @Override
    public boolean canProcess(EventWaiter waiter) {
        block3: {
            try {
                TransportBase tb = this.connection.getTransportBase();
                if (tb != null && tb.isReadyForRead(waiter) == 0L) break block3;
                return false;
            }
            catch (RuntimeException e) {
                Debug.out(this.getString(), e);
                throw e;
            }
        }
        int[] allowed = this.rate_handler.getCurrentNumBytesAllowed();
        return allowed[0] >= 1;
    }

    @Override
    public int doProcessing(EventWaiter waiter, int max_bytes) {
        int protocol_bytes_read;
        int data_bytes_read;
        int bytes_read;
        block12: {
            boolean protocol_is_free;
            int num_bytes_allowed;
            block11: {
                block10: {
                    try {
                        TransportBase tb = this.connection.getTransportBase();
                        if (tb != null && tb.isReadyForRead(waiter) == 0L) break block10;
                        return 0;
                    }
                    catch (RuntimeException e) {
                        Debug.out(this.getString(), e);
                        throw e;
                    }
                }
                int[] allowed = this.rate_handler.getCurrentNumBytesAllowed();
                num_bytes_allowed = allowed[0];
                boolean bl = protocol_is_free = allowed[1] > 0;
                if (num_bytes_allowed >= 1) break block11;
                return 0;
            }
            if (max_bytes > 0 && max_bytes < num_bytes_allowed) {
                num_bytes_allowed = max_bytes;
            }
            bytes_read = 0;
            data_bytes_read = 0;
            protocol_bytes_read = 0;
            try {
                int[] read = this.connection.getIncomingMessageQueue().receiveFromTransport(num_bytes_allowed, protocol_is_free);
                data_bytes_read = read[0];
                protocol_bytes_read = read[1];
                bytes_read = data_bytes_read + protocol_bytes_read;
            }
            catch (Throwable e) {
                if (!(e instanceof IOException)) {
                    Debug.printStackTrace(e);
                }
                this.connection.notifyOfException(e);
                return 0;
            }
            if (bytes_read >= 1) break block12;
            return 0;
        }
        this.rate_handler.bytesProcessed(data_bytes_read, protocol_bytes_read);
        return bytes_read;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean getPriorityBoost() {
        return false;
    }

    @Override
    public long getBytesReadyToWrite() {
        return 0L;
    }

    @Override
    public int getConnectionCount(EventWaiter waiter) {
        return 1;
    }

    @Override
    public int getReadyConnectionCount(EventWaiter waiter) {
        TransportBase tb = this.connection.getTransportBase();
        if (tb != null && tb.isReadyForRead(waiter) == 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getString() {
        int[] temp = this.rate_handler.getCurrentNumBytesAllowed();
        String ba = "";
        int[] nArray = temp;
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            ba = String.valueOf(ba) + (ba.isEmpty() ? "" : ",") + t;
            ++n2;
        }
        return "SPD: bytes_allowed=" + ba + " " + this.connection.getString();
    }
}

