/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.networkmanager.EventWaiter;
import com.biglybt.core.networkmanager.NetworkConnectionBase;
import com.biglybt.core.networkmanager.RateHandler;
import com.biglybt.core.networkmanager.TransportBase;
import com.biglybt.core.networkmanager.impl.RateControlledEntity;
import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.util.Debug;
import java.io.IOException;

public class SinglePeerUploader
implements RateControlledEntity {
    private final NetworkConnectionBase connection;
    private final RateHandler rate_handler;

    public SinglePeerUploader(NetworkConnectionBase connection, RateHandler rate_handler) {
        this.connection = connection;
        this.rate_handler = rate_handler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.rate_handler;
    }

    @Override
    public boolean canProcess(EventWaiter waiter) {
        block7: {
            block6: {
                try {
                    TransportBase tb = this.connection.getTransportBase();
                    if (tb != null && tb.isReadyForWrite(waiter)) break block6;
                    return false;
                }
                catch (RuntimeException e) {
                    Debug.out(this.getString(), e);
                    throw e;
                }
            }
            if (this.connection.getOutgoingMessageQueue().getTotalSize() >= 1) break block7;
            return false;
        }
        int[] allowed = this.rate_handler.getCurrentNumBytesAllowed();
        if (allowed[0] < 1) {
            boolean protocol_is_free;
            boolean bl = protocol_is_free = allowed[1] > 0;
            if (protocol_is_free) {
                Message first = this.connection.getOutgoingMessageQueue().peekFirstMessage();
                return first != null && first.getType() == 0;
            }
            return false;
        }
        return true;
    }

    @Override
    public int doProcessing(EventWaiter waiter, int max_bytes) {
        int total_written;
        int protocol_bytes_written;
        int data_bytes_written;
        block15: {
            int[] written;
            int num_bytes_available;
            boolean protocol_is_free;
            int num_bytes_allowed;
            block14: {
                block13: {
                    block12: {
                        try {
                            TransportBase tb = this.connection.getTransportBase();
                            if (tb != null && tb.isReadyForWrite(waiter)) break block12;
                            return 0;
                        }
                        catch (RuntimeException e) {
                            Debug.out(this.getString(), e);
                            throw e;
                        }
                    }
                    int[] allowed = this.rate_handler.getCurrentNumBytesAllowed();
                    num_bytes_allowed = allowed[0];
                    boolean bl = protocol_is_free = allowed[1] > 0;
                    if (num_bytes_allowed >= 1) break block13;
                    if (protocol_is_free) {
                        num_bytes_allowed = 0;
                        break block13;
                    }
                    return 0;
                }
                if (max_bytes > 0 && max_bytes < num_bytes_allowed) {
                    num_bytes_allowed = max_bytes;
                }
                if ((num_bytes_available = this.connection.getOutgoingMessageQueue().getTotalSize()) >= 1) break block14;
                this.connection.getOutgoingMessageQueue().isDestroyed();
                return 0;
            }
            int num_bytes_to_write = num_bytes_allowed > num_bytes_available ? num_bytes_available : num_bytes_allowed;
            try {
                written = this.connection.getOutgoingMessageQueue().deliverToTransport(num_bytes_to_write, protocol_is_free, false);
            }
            catch (Throwable e) {
                int[] written2 = new int[2];
                if (!(e instanceof IOException)) {
                    Debug.printStackTrace(e);
                }
                this.connection.notifyOfException(e);
                return 0;
            }
            data_bytes_written = written[0];
            protocol_bytes_written = written[1];
            total_written = data_bytes_written + protocol_bytes_written;
            if (total_written >= 1) break block15;
            return 0;
        }
        this.rate_handler.bytesProcessed(data_bytes_written, protocol_bytes_written);
        return total_written;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean getPriorityBoost() {
        return this.connection.getOutgoingMessageQueue().getPriorityBoost();
    }

    @Override
    public long getBytesReadyToWrite() {
        return this.connection.getOutgoingMessageQueue().getTotalSize();
    }

    @Override
    public int getConnectionCount(EventWaiter waiter) {
        return 1;
    }

    @Override
    public int getReadyConnectionCount(EventWaiter waiter) {
        TransportBase tb = this.connection.getTransportBase();
        if (tb != null && tb.isReadyForWrite(waiter)) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getString() {
        int[] temp = this.rate_handler.getCurrentNumBytesAllowed();
        String ba = "";
        int[] nArray = temp;
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            ba = String.valueOf(ba) + (ba.isEmpty() ? "" : ",") + t;
            ++n2;
        }
        return "SPU: bytes_allowed=" + ba + " " + this.connection.getString();
    }
}

