/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.networkmanager.impl.TransportHelper;
import com.biglybt.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TransportHelperFilterInserter
implements TransportHelperFilter {
    private final TransportHelperFilter target_filter;
    private ByteBuffer read_insert;

    public TransportHelperFilterInserter(TransportHelperFilter _target_filter, ByteBuffer _read_insert) {
        this.target_filter = _target_filter;
        this.read_insert = _read_insert;
    }

    @Override
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        return this.target_filter.write(buffers, array_offset, length);
    }

    @Override
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        long total_read = 0L;
        if (this.read_insert != null) {
            int pos_before = this.read_insert.position();
            int i = array_offset;
            while (i < array_offset + length) {
                ByteBuffer buffer = buffers[i];
                int space = buffer.remaining();
                if (space > 0) {
                    if (space < this.read_insert.remaining()) {
                        int old_limit = this.read_insert.limit();
                        this.read_insert.limit(this.read_insert.position() + space);
                        buffer.put(this.read_insert);
                        this.read_insert.limit(old_limit);
                    } else {
                        buffer.put(this.read_insert);
                    }
                    if (!this.read_insert.hasRemaining()) break;
                }
                ++i;
            }
            total_read = this.read_insert.position() - pos_before;
            if (this.read_insert.hasRemaining()) {
                return total_read;
            }
            this.read_insert = null;
        }
        return total_read += this.target_filter.read(buffers, array_offset, length);
    }

    @Override
    public boolean hasBufferedWrite() {
        return this.target_filter.hasBufferedWrite();
    }

    @Override
    public boolean hasBufferedRead() {
        return this.read_insert != null || this.target_filter.hasBufferedRead();
    }

    @Override
    public TransportHelper getHelper() {
        return this.target_filter.getHelper();
    }

    @Override
    public void setTrace(boolean on) {
        this.target_filter.setTrace(on);
    }

    @Override
    public boolean isEncrypted() {
        return this.target_filter.isEncrypted();
    }

    @Override
    public String getName(boolean verbose) {
        return this.target_filter.getName(verbose);
    }
}

