/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.networkmanager.EventWaiter;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.impl.RateControlledEntity;
import com.biglybt.core.stats.CoreStats;
import com.biglybt.core.stats.CoreStatsProvider;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.average.AverageFactory;
import com.biglybt.core.util.average.MovingImmediateAverage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WriteController
implements CoreStatsProvider,
AEDiagnosticsEvidenceGenerator {
    static int IDLE_SLEEP_TIME = 50;
    static boolean AGGRESIVE_WRITE = false;
    static int BOOSTER_GIFT = 5120;
    volatile ArrayList<RateControlledEntity> normal_priority_entities = new ArrayList();
    volatile ArrayList<RateControlledEntity> boosted_priority_entities = new ArrayList();
    volatile ArrayList<RateControlledEntity> high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("WriteController:EM");
    private int next_normal_position = 0;
    private int next_boost_position = 0;
    private int next_high_position = 0;
    private long booster_process_time;
    private int booster_normal_written;
    private int booster_boost_written;
    private int booster_stat_index;
    private final int[] booster_normal_writes = new int[5];
    private final int[] booster_gifts = new int[5];
    private MovingImmediateAverage booster_boost_average = AverageFactory.MovingImmediateAverage(5);
    private MovingImmediateAverage booster_normal_average = AverageFactory.MovingImmediateAverage(5);
    private MovingImmediateAverage booster_boost_avail_average = AverageFactory.MovingImmediateAverage(5);
    private MovingImmediateAverage booster_normal_avail_average = AverageFactory.MovingImmediateAverage(5);
    private MovingImmediateAverage booster_boost_data_average = AverageFactory.MovingImmediateAverage(5);
    private MovingImmediateAverage booster_normal_data_average = AverageFactory.MovingImmediateAverage(5);
    private int aggressive_np_normal_priority_count;
    private int aggressive_np_high_priority_count;
    private long process_loop_time;
    private long wait_count;
    private long progress_count;
    private long non_progress_count;
    private final EventWaiter write_waiter = new EventWaiter();
    private NetworkManager net_man;
    private int entity_count = 0;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.control.write.idle.time", "network.control.write.aggressive", "Bias Upload Slack KBs"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                IDLE_SLEEP_TIME = COConfigurationManager.getIntParameter("network.control.write.idle.time");
                AGGRESIVE_WRITE = COConfigurationManager.getBooleanParameter("network.control.write.aggressive");
                BOOSTER_GIFT = COConfigurationManager.getIntParameter("Bias Upload Slack KBs") * 1024;
            }
        });
    }

    public WriteController() {
        AEThread2 write_processor_thread = new AEThread2("WriteController:WriteProcessor"){

            @Override
            public void run() {
                WriteController.this.writeProcessorLoop();
            }
        };
        write_processor_thread.setPriority(9);
        write_processor_thread.start();
        HashSet<String> types = new HashSet<String>();
        types.add("net.write.control.wait.count");
        types.add("net.write.control.np.count");
        types.add("net.write.control.p.count");
        types.add("net.write.control.entity.count");
        types.add("net.write.control.con.count");
        types.add("net.write.control.ready.con.count");
        types.add("net.write.control.ready.byte.count");
        CoreStats.registerProvider(types, this);
        AEDiagnostics.addWeakEvidenceGenerator(this);
    }

    public String getBiasDetails() {
        if (this.boosted_priority_entities.size() == 0) {
            return "";
        }
        return "n=" + this.normal_priority_entities.size() + " " + DisplayFormatters.formatByteCountToKiBEtc((long)this.booster_normal_data_average.getAverage()) + "," + DisplayFormatters.formatByteCountToKiBEtcPerSec((long)this.booster_normal_average.getAverage()) + "," + DisplayFormatters.formatByteCountToKiBEtcPerSec((long)this.booster_normal_avail_average.getAverage()) + ";" + "b=" + this.boosted_priority_entities.size() + " " + DisplayFormatters.formatByteCountToKiBEtc((long)this.booster_boost_data_average.getAverage()) + "," + DisplayFormatters.formatByteCountToKiBEtcPerSec((long)this.booster_boost_average.getAverage()) + "," + DisplayFormatters.formatByteCountToKiBEtcPerSec((long)this.booster_boost_avail_average.getAverage()) + ";" + "h=" + this.high_priority_entities.size();
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Write Controller");
        try {
            RateControlledEntity entity;
            writer.indent();
            ArrayList<RateControlledEntity> ref = this.normal_priority_entities;
            writer.println("normal - " + ref.size());
            int i = 0;
            while (i < ref.size()) {
                entity = ref.get(i);
                writer.println(entity.getString());
                ++i;
            }
            ref = this.boosted_priority_entities;
            writer.println("boosted - " + ref.size());
            i = 0;
            while (i < ref.size()) {
                entity = ref.get(i);
                writer.println(entity.getString());
                ++i;
            }
            ref = this.high_priority_entities;
            writer.println("priority - " + ref.size());
            i = 0;
            while (i < ref.size()) {
                entity = ref.get(i);
                writer.println(entity.getString());
                ++i;
            }
        }
        finally {
            writer.exdent();
        }
    }

    public void updateStats(Set types, Map values) {
        if (types.contains("net.write.control.wait.count")) {
            values.put("net.write.control.wait.count", new Long(this.wait_count));
        }
        if (types.contains("net.write.control.np.count")) {
            values.put("net.write.control.np.count", new Long(this.non_progress_count));
        }
        if (types.contains("net.write.control.p.count")) {
            values.put("net.write.control.p.count", new Long(this.progress_count));
        }
        if (types.contains("net.write.control.entity.count")) {
            values.put("net.write.control.entity.count", new Long(this.high_priority_entities.size() + this.boosted_priority_entities.size() + this.normal_priority_entities.size()));
        }
        if (types.contains("net.write.control.con.count") || types.contains("net.write.control.ready.con.count") || types.contains("net.write.control.ready.byte.count")) {
            long ready_bytes = 0L;
            int ready_connections = 0;
            int connections = 0;
            ArrayList[] refs = new ArrayList[]{this.normal_priority_entities, this.boosted_priority_entities, this.high_priority_entities};
            int i = 0;
            while (i < refs.length) {
                ArrayList ref = refs[i];
                int j = 0;
                while (j < ref.size()) {
                    RateControlledEntity entity = (RateControlledEntity)ref.get(j);
                    connections += entity.getConnectionCount(this.write_waiter);
                    ready_connections += entity.getReadyConnectionCount(this.write_waiter);
                    ready_bytes += entity.getBytesReadyToWrite();
                    ++j;
                }
                ++i;
            }
            values.put("net.write.control.con.count", new Long(connections));
            values.put("net.write.control.ready.con.count", new Long(ready_connections));
            values.put("net.write.control.ready.byte.count", new Long(ready_bytes));
        }
    }

    void writeProcessorLoop() {
        boolean check_high_first = true;
        long last_check = SystemTime.getMonotonousTime();
        this.net_man = NetworkManager.getSingleton();
        int tick_count = 0;
        while (true) {
            this.process_loop_time = SystemTime.getMonotonousTime();
            ++tick_count;
            try {
                if (check_high_first) {
                    check_high_first = false;
                    if (!this.doHighPriorityWrite() && !this.doNormalPriorityWrite(tick_count) && this.write_waiter.waitForEvent(this.hasConnections() ? IDLE_SLEEP_TIME : 1000)) {
                        ++this.wait_count;
                    }
                } else {
                    check_high_first = true;
                    if (!this.doNormalPriorityWrite(tick_count) && !this.doHighPriorityWrite() && this.write_waiter.waitForEvent(this.hasConnections() ? IDLE_SLEEP_TIME : 1000)) {
                        ++this.wait_count;
                    }
                }
            }
            catch (Throwable t) {
                Debug.out("writeProcessorLoop() EXCEPTION: ", t);
            }
            if (this.process_loop_time - last_check <= 5000L) continue;
            last_check = this.process_loop_time;
            boolean changed = false;
            ArrayList<RateControlledEntity> ref = this.normal_priority_entities;
            for (RateControlledEntity e : ref) {
                if (!e.getPriorityBoost()) continue;
                changed = true;
                break;
            }
            if (!changed) {
                ref = this.boosted_priority_entities;
                for (RateControlledEntity e : ref) {
                    if (e.getPriorityBoost()) continue;
                    changed = true;
                    break;
                }
            }
            if (!changed) continue;
            try {
                this.entities_mon.enter();
                ArrayList<RateControlledEntity> new_normal = new ArrayList<RateControlledEntity>();
                ArrayList<RateControlledEntity> new_boosted = new ArrayList<RateControlledEntity>();
                for (RateControlledEntity e : this.normal_priority_entities) {
                    if (e.getPriorityBoost()) {
                        new_boosted.add(e);
                        continue;
                    }
                    new_normal.add(e);
                }
                for (RateControlledEntity e : this.boosted_priority_entities) {
                    if (e.getPriorityBoost()) {
                        new_boosted.add(e);
                        continue;
                    }
                    new_normal.add(e);
                }
                this.normal_priority_entities = new_normal;
                this.boosted_priority_entities = new_boosted;
                continue;
            }
            finally {
                this.entities_mon.exit();
                continue;
            }
            break;
        }
    }

    private boolean hasConnections() {
        if (this.entity_count == 0) {
            return false;
        }
        ArrayList<RateControlledEntity> ref = this.high_priority_entities;
        for (RateControlledEntity e : ref) {
            if (e.getConnectionCount(this.write_waiter) <= 0) continue;
            return true;
        }
        ref = this.boosted_priority_entities;
        for (RateControlledEntity e : ref) {
            if (e.getConnectionCount(this.write_waiter) <= 0) continue;
            return true;
        }
        ref = this.normal_priority_entities;
        for (RateControlledEntity e : ref) {
            if (e.getConnectionCount(this.write_waiter) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean doNormalPriorityWrite(int tick_count) {
        int result = this.processNextReadyNormalPriorityEntity(tick_count);
        if (result > 0) {
            ++this.progress_count;
            return true;
        }
        if (result == 0) {
            ++this.non_progress_count;
            if (AGGRESIVE_WRITE) {
                ++this.aggressive_np_normal_priority_count;
                if (this.aggressive_np_normal_priority_count < this.normal_priority_entities.size() + this.boosted_priority_entities.size()) {
                    return true;
                }
                this.aggressive_np_normal_priority_count = 0;
            }
        }
        return false;
    }

    private boolean doHighPriorityWrite() {
        RateControlledEntity ready_entity = this.getNextReadyHighPriorityEntity();
        if (ready_entity != null) {
            if (ready_entity.doProcessing(this.write_waiter, 0) > 0) {
                ++this.progress_count;
                return true;
            }
            ++this.non_progress_count;
            if (AGGRESIVE_WRITE) {
                ++this.aggressive_np_high_priority_count;
                if (this.aggressive_np_high_priority_count < this.high_priority_entities.size()) {
                    return true;
                }
                this.aggressive_np_high_priority_count = 0;
            }
        }
        return false;
    }

    private int processNextReadyNormalPriorityEntity(int tick_count) {
        ArrayList<RateControlledEntity> boosted_ref = this.boosted_priority_entities;
        ArrayList<RateControlledEntity> normal_ref = this.normal_priority_entities;
        int boosted_size = boosted_ref.size();
        int normal_size = normal_ref.size();
        boolean frozen = false;
        boolean do_boosting = boosted_size > 0;
        try {
            if (do_boosting && this.process_loop_time - this.booster_process_time >= 1000L) {
                this.booster_process_time = this.process_loop_time;
                this.booster_gifts[this.booster_stat_index] = BOOSTER_GIFT;
                this.booster_normal_writes[this.booster_stat_index] = this.booster_normal_written;
                ++this.booster_stat_index;
                if (this.booster_stat_index >= this.booster_gifts.length) {
                    this.booster_stat_index = 0;
                }
                this.booster_boost_average.update(this.booster_boost_written);
                this.booster_normal_average.update(this.booster_normal_written);
                this.booster_normal_written = 0;
                this.booster_boost_written = 0;
                int max_normal = 0;
                int normal_data = 0;
                for (RateControlledEntity e : normal_ref) {
                    if (!e.canProcess(this.write_waiter)) continue;
                    normal_data = (int)((long)normal_data + e.getBytesReadyToWrite());
                    int max = e.getRateHandler().getCurrentNumBytesAllowed()[0];
                    if (max <= max_normal) continue;
                    max_normal = max;
                }
                this.booster_normal_data_average.update(normal_data);
                this.booster_normal_avail_average.update(max_normal);
                int max_booster = 0;
                int booster_data = 0;
                for (RateControlledEntity e : boosted_ref) {
                    if (!e.canProcess(this.write_waiter)) continue;
                    booster_data = (int)((long)booster_data + e.getBytesReadyToWrite());
                    int max = e.getRateHandler().getCurrentNumBytesAllowed()[0];
                    if (max <= max_booster) continue;
                    max_booster = max;
                }
                this.booster_boost_data_average.update(booster_data);
                this.booster_boost_avail_average.update(max_booster);
            }
            if (do_boosting && this.booster_boost_data_average.getAverage() == 0.0) {
                int boosted;
                this.next_boost_position = this.next_boost_position >= boosted_size ? 0 : this.next_boost_position;
                RateControlledEntity entity = boosted_ref.get(this.next_boost_position);
                ++this.next_boost_position;
                if (entity.canProcess(this.write_waiter) && (boosted = entity.doProcessing(this.write_waiter, 0)) > 0) {
                    this.booster_boost_written += boosted;
                }
                do_boosting = false;
            }
            if (do_boosting) {
                int num_checked;
                int total_gifts = 0;
                int total_normal_writes = this.booster_normal_written;
                int i = 0;
                while (i < this.booster_gifts.length) {
                    total_gifts += this.booster_gifts[i];
                    total_normal_writes += this.booster_normal_writes[i];
                    ++i;
                }
                int effective_gift = total_gifts - total_normal_writes;
                if (effective_gift > 0) {
                    num_checked = 0;
                    int gift_remaining = effective_gift;
                    while (num_checked < normal_size && gift_remaining > 0) {
                        int gift_used;
                        this.next_normal_position = this.next_normal_position >= normal_size ? 0 : this.next_normal_position;
                        RateControlledEntity entity = normal_ref.get(this.next_normal_position);
                        ++this.next_normal_position;
                        ++num_checked;
                        if (!entity.canProcess(this.write_waiter) || (gift_used = entity.doProcessing(this.write_waiter, gift_remaining)) <= 0) continue;
                        this.booster_normal_written += gift_used;
                        gift_remaining -= gift_used;
                    }
                    int gift_used = effective_gift - gift_remaining;
                    if (gift_used > 0) {
                        int i2 = this.booster_stat_index;
                        while (gift_used > 0 && i2 < this.booster_stat_index + this.booster_gifts.length) {
                            int avail = this.booster_gifts[i2 % this.booster_gifts.length];
                            if (avail > 0) {
                                int temp = Math.min(avail, gift_used);
                                gift_used -= temp;
                                this.booster_gifts[i2 % this.booster_gifts.length] = avail -= temp;
                            }
                            ++i2;
                        }
                    }
                }
                for (num_checked = 0; num_checked < boosted_size; ++num_checked) {
                    int boosted;
                    this.next_boost_position = this.next_boost_position >= boosted_size ? 0 : this.next_boost_position;
                    RateControlledEntity entity = boosted_ref.get(this.next_boost_position);
                    ++this.next_boost_position;
                    if (!entity.canProcess(this.write_waiter) || (boosted = entity.doProcessing(this.write_waiter, 0)) <= 0) continue;
                    this.booster_boost_written += boosted;
                    int n = boosted;
                    return n;
                }
                frozen = true;
                this.net_man.getUploadProcessor().setRateLimiterFreezeState(true);
            } else {
                this.booster_normal_written = 0;
                this.booster_boost_written = 0;
            }
            for (int num_checked = 0; num_checked < normal_size; ++num_checked) {
                this.next_normal_position = this.next_normal_position >= normal_size ? 0 : this.next_normal_position;
                RateControlledEntity entity = normal_ref.get(this.next_normal_position);
                ++this.next_normal_position;
                if (!entity.canProcess(this.write_waiter)) continue;
                int bytes = entity.doProcessing(this.write_waiter, 0);
                if (bytes > 0) {
                    this.booster_normal_written += bytes;
                }
                int n = bytes;
                return n;
            }
            return -1;
        }
        finally {
            if (frozen) {
                this.net_man.getUploadProcessor().setRateLimiterFreezeState(false);
            }
        }
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList<RateControlledEntity> ref = this.high_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_high_position = this.next_high_position >= size ? 0 : this.next_high_position;
            RateControlledEntity entity = ref.get(this.next_high_position);
            ++this.next_high_position;
            if (!entity.canProcess(this.write_waiter)) continue;
            return entity;
        }
        return null;
    }

    public void addWriteEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                high_new.addAll(this.high_priority_entities);
                high_new.add(entity);
                this.high_priority_entities = high_new;
            } else if (entity.getPriorityBoost()) {
                ArrayList<RateControlledEntity> boost_new = new ArrayList<RateControlledEntity>(this.boosted_priority_entities.size() + 1);
                boost_new.addAll(this.boosted_priority_entities);
                boost_new.add(entity);
                this.boosted_priority_entities = boost_new;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                norm_new.addAll(this.normal_priority_entities);
                norm_new.add(entity);
                this.normal_priority_entities = norm_new;
            }
            this.entity_count = this.normal_priority_entities.size() + this.boosted_priority_entities.size() + this.high_priority_entities.size();
        }
        finally {
            this.entities_mon.exit();
        }
        this.write_waiter.eventOccurred();
    }

    public boolean removeWriteEntity(RateControlledEntity entity) {
        boolean found = false;
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities);
                if (high_new.remove(entity)) {
                    this.high_priority_entities = high_new;
                    found = true;
                } else {
                    Debug.out("entity not found");
                }
            } else if (this.boosted_priority_entities.contains(entity)) {
                ArrayList<RateControlledEntity> boosted_new = new ArrayList<RateControlledEntity>(this.boosted_priority_entities);
                boosted_new.remove(entity);
                this.boosted_priority_entities = boosted_new;
                found = true;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities);
                if (norm_new.remove(entity)) {
                    this.normal_priority_entities = norm_new;
                    found = true;
                } else {
                    Debug.out("entity not found");
                }
            }
            this.entity_count = this.normal_priority_entities.size() + this.boosted_priority_entities.size() + this.high_priority_entities.size();
        }
        finally {
            this.entities_mon.exit();
        }
        return found;
    }

    public int getEntityCount() {
        return this.entity_count;
    }
}

