/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl.http;

import com.biglybt.core.networkmanager.RawMessage;
import com.biglybt.core.networkmanager.impl.http.HTTPMessage;
import com.biglybt.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageStreamEncoder;

public class HTTPMessageEncoder
implements MessageStreamEncoder {
    private HTTPNetworkConnection http_connection;

    public void setConnection(HTTPNetworkConnection _http_connection) {
        this.http_connection = _http_connection;
    }

    @Override
    public RawMessage[] encodeMessage(Message message) {
        String id = message.getID();
        RawMessage raw_message = null;
        if (id.equals("BT_HANDSHAKE")) {
            raw_message = this.http_connection.encodeHandShake(message);
        } else if (id.equals("BT_CHOKE")) {
            raw_message = this.http_connection.encodeChoke();
        } else if (id.equals("BT_UNCHOKE")) {
            raw_message = this.http_connection.encodeUnchoke();
        } else if (id.equals("BT_BITFIELD")) {
            raw_message = this.http_connection.encodeBitField();
        } else {
            if (id.equals("BT_PIECE")) {
                return this.http_connection.encodePiece(message);
            }
            if (id.equals("HTTP_DATA")) {
                raw_message = ((HTTPMessage)message).encode(message);
            }
        }
        if (raw_message == null) {
            raw_message = this.http_connection.getEmptyRawMessage(message);
        }
        return new RawMessage[]{raw_message};
    }
}

