/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl.http;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.biglybt.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.biglybt.core.networkmanager.impl.http.HTTPNetworkManager;
import com.biglybt.core.peer.impl.PEPeerControl;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HTTPUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class HTTPNetworkConnectionFile
extends HTTPNetworkConnection {
    private boolean switching;

    protected HTTPNetworkConnectionFile(HTTPNetworkManager _manager, NetworkConnection _connection, PEPeerTransport _peer) {
        super(_manager, _connection, _peer);
    }

    @Override
    protected void decodeHeader(HTTPMessageDecoder decoder, final String header) throws IOException {
        boolean partial_content;
        Object range;
        if (this.switching) {
            Debug.out("new header received while paused");
            throw new IOException("Bork");
        }
        if (!this.isSeed()) {
            return;
        }
        PEPeerControl control = this.getPeerControl();
        DiskManager dm = control.getDiskManager();
        if (dm == null) {
            Debug.out("Disk manager is null");
            throw new IOException("Disk manager unavailable");
        }
        TOTorrent to_torrent = dm.getTorrent();
        char[] chars = header.toCharArray();
        int last_pos = 0;
        int line_num = 0;
        String target_str = null;
        DiskManagerFileInfo target_file = null;
        long file_offset = 0L;
        ArrayList<long[]> ranges = new ArrayList<long[]>();
        boolean keep_alive = false;
        int i = 1;
        while (i < chars.length) {
            if (chars[i - 1] == '\r' && chars[i] == '\n') {
                String line = new String(chars, last_pos, i - last_pos).trim();
                last_pos = i;
                if (++line_num == 1) {
                    line = line.substring(line.indexOf("files/") + 6);
                    int hash_end = line.indexOf("/");
                    final byte[] old_hash = control.getHash();
                    final byte[] new_hash = URLDecoder.decode(line.substring(0, hash_end), "ISO-8859-1").getBytes("ISO-8859-1");
                    if (!Arrays.equals(new_hash, old_hash)) {
                        this.switching = true;
                        decoder.pauseInternally();
                        this.flushRequests(new HTTPNetworkConnection.flushListener(){
                            private boolean triggered;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void flushed() {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    if (this.triggered) {
                                        return;
                                    }
                                    this.triggered = true;
                                }
                                HTTPNetworkConnectionFile.this.getManager().reRoute(HTTPNetworkConnectionFile.this, old_hash, new_hash, header);
                            }
                        });
                        return;
                    }
                    line = line.substring(hash_end + 1);
                    String file = line = line.substring(0, line.lastIndexOf(32));
                    if (to_torrent.isSimpleTorrent()) {
                        target_file = dm.getFiles()[0];
                    } else {
                        target_str = file;
                        StringTokenizer tok = new StringTokenizer(file, "/");
                        ArrayList<byte[]> bits = new ArrayList<byte[]>();
                        while (tok.hasMoreTokens()) {
                            bits.add(URLDecoder.decode(tok.nextToken(), "ISO-8859-1").getBytes("ISO-8859-1"));
                        }
                        if (!to_torrent.isSimpleTorrent() && bits.size() > 1 && Arrays.equals(to_torrent.getName(), (byte[])bits.get(0))) {
                            bits.remove(0);
                        }
                        DiskManagerFileInfo[] files = dm.getFiles();
                        file_offset = 0L;
                        int j = 0;
                        while (j < files.length) {
                            TOTorrentFile torrent_file = files[j].getTorrentFile();
                            byte[][] comps = torrent_file.getPathComponents();
                            if (comps.length == bits.size()) {
                                boolean match = true;
                                int k = 0;
                                while (k < comps.length) {
                                    if (!Arrays.equals(comps[k], (byte[])bits.get(k))) {
                                        match = false;
                                        break;
                                    }
                                    ++k;
                                }
                                if (match) {
                                    target_file = files[j];
                                    break;
                                }
                            }
                            file_offset += torrent_file.getLength();
                            ++j;
                        }
                    }
                } else if ((line = line.toLowerCase(MessageText.LOCALE_ENGLISH)).startsWith("range") && target_file != null) {
                    if ((line = line.substring(5).trim()).startsWith(":")) {
                        String range_str = line.substring(1).trim();
                        if (range_str.startsWith("bytes=")) {
                            long file_length = target_file.getLength();
                            StringTokenizer tok2 = new StringTokenizer(range_str.substring(6), ",");
                            while (tok2.hasMoreTokens()) {
                                range = tok2.nextToken();
                                try {
                                    long start;
                                    long end;
                                    int pos = ((String)range).indexOf(45);
                                    if (pos == -1) continue;
                                    String lhs = ((String)range).substring(0, pos);
                                    String rhs = ((String)range).substring(pos + 1);
                                    if (lhs.length() == 0) {
                                        end = file_length - 1L;
                                        start = file_length - Long.parseLong(rhs);
                                    } else if (rhs.length() == 0) {
                                        end = file_length - 1L;
                                        start = Long.parseLong(lhs);
                                    } else {
                                        start = Long.parseLong(lhs);
                                        end = Long.parseLong(rhs);
                                    }
                                    ranges.add(new long[]{start, end});
                                }
                                catch (Throwable pos) {
                                    // empty catch block
                                }
                            }
                        }
                        if (ranges.size() == 0) {
                            this.log("Invalid range specification: '" + line + "'");
                            this.sendAndClose(this.getManager().getRangeNotSatisfiable());
                            return;
                        }
                    }
                } else if (line.contains("keep-alive")) {
                    keep_alive = true;
                }
            }
            ++i;
        }
        if (target_file == null) {
            this.log("Failed to find file '" + target_str + "'");
            this.sendAndClose(this.getManager().getNotFound());
            return;
        }
        try {
            String name = target_file.getFile(true).getName();
            int pos = name.lastIndexOf(".");
            if (pos != -1) {
                this.setContentType(HTTPUtils.guessContentTypeFromFileType(name.substring(pos + 1)));
            }
        }
        catch (Throwable name) {
            // empty catch block
        }
        long file_length = target_file.getLength();
        boolean bl = partial_content = ranges.size() > 0;
        if (!partial_content) {
            long[] lArray = new long[2];
            lArray[1] = file_length - 1L;
            ranges.add(lArray);
        }
        long[] offsets = new long[ranges.size()];
        long[] lengths = new long[ranges.size()];
        int i2 = 0;
        while (i2 < ranges.size()) {
            range = (long[])ranges.get(i2);
            long start = range[0];
            long end = range[1];
            if (start < 0L || start >= file_length || end < 0L || end >= file_length || start > end) {
                this.log("Invalid range specification: '" + start + "-" + end + "'");
                this.sendAndClose(this.getManager().getRangeNotSatisfiable());
                return;
            }
            offsets[i2] = file_offset + start;
            lengths[i2] = end - start + 1L;
            ++i2;
        }
        this.addRequest(new HTTPNetworkConnection.httpRequest(offsets, lengths, file_length, partial_content, keep_alive));
    }
}

