/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl.tcp;

import com.biglybt.core.networkmanager.ProtocolStartpoint;
import com.biglybt.core.networkmanager.TransportStartpoint;
import com.biglybt.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.biglybt.core.networkmanager.impl.tcp.TransportEndpointTCP;
import com.biglybt.core.proxy.AEProxyAddressMapper;
import com.biglybt.core.proxy.AEProxyFactory;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;

public class TransportStartpointTCP
implements TransportStartpoint,
ProtocolStartpoint {
    private static final AEProxyAddressMapper proxy_address_mapper = AEProxyFactory.getAddressMapper();
    private final TCPTransportImpl transport;
    private final TransportEndpointTCP ep;

    public TransportStartpointTCP(TCPTransportImpl _transport, TransportEndpointTCP _ep) {
        this.transport = _transport;
        this.ep = _ep;
    }

    @Override
    public ProtocolStartpoint getProtocolStartpoint() {
        return this;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public InetSocketAddress getAddress() {
        Socket socket;
        SocketChannel channel2 = this.ep.getSocketChannel();
        if (channel2 != null && (socket = channel2.socket()) != null) {
            return (InetSocketAddress)socket.getLocalSocketAddress();
        }
        return null;
    }

    @Override
    public InetSocketAddress getNotionalAddress() {
        Socket socket;
        SocketChannel channel2 = this.ep.getSocketChannel();
        if (channel2 != null && (socket = channel2.socket()) != null) {
            InetSocketAddress target;
            AEProxyAddressMapper.AppliedPortMapping applied_mapping = proxy_address_mapper.applyPortMapping(socket.getInetAddress(), socket.getPort());
            InetSocketAddress local = applied_mapping.getLocalAddress();
            if (local != null) {
                return local;
            }
            if (!this.transport.isIncoming() && (local = proxy_address_mapper.getLocalAddress(target = this.ep.getProtocolEndpoint().getAddress())) != null) {
                return local;
            }
            return (InetSocketAddress)socket.getLocalSocketAddress();
        }
        return null;
    }

    @Override
    public String getDescription() {
        InetSocketAddress address = this.getAddress();
        if (address == null) {
            return "not connected";
        }
        return address.toString();
    }
}

