/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peer.impl;

import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapEntry;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peer.impl.PEPieceWriteImpl;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.SystemTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PEPieceImpl
implements PEPiece {
    private static final LogIDs LOGID = LogIDs.PIECES;
    private final DiskManagerPiece dmPiece;
    private final PiecePicker piecePicker;
    private final int nbBlocks;
    private long creationTime = SystemTime.getCurrentTime();
    private final String[] requested;
    private boolean fully_requested;
    private final boolean[] downloaded;
    private boolean fully_downloaded;
    private long time_last_download;
    private final String[] writers;
    private final List writes;
    private String reservedBy;
    private int speed;
    private int resumePriority;
    private Object real_time_data;
    protected static final AEMonitor class_mon = new AEMonitor("PEPiece:class");

    public PEPieceImpl(PiecePicker _picker, DiskManagerPiece _dm_piece, int _pieceSpeed) {
        this.piecePicker = _picker;
        this.dmPiece = _dm_piece;
        this.speed = _pieceSpeed;
        this.nbBlocks = this.dmPiece.getNbBlocks();
        this.requested = new String[this.nbBlocks];
        this.fixupPadFile();
        boolean[] written = this.dmPiece.getWritten();
        this.downloaded = written == null ? new boolean[this.nbBlocks] : (boolean[])written.clone();
        this.writers = new String[this.nbBlocks];
        this.writes = new ArrayList(0);
    }

    @Override
    public DiskManagerPiece getDMPiece() {
        return this.dmPiece;
    }

    @Override
    public long getCreationTime() {
        long now = SystemTime.getCurrentTime();
        if (now >= this.creationTime && this.creationTime > 0L) {
            return this.creationTime;
        }
        this.creationTime = now;
        return now;
    }

    @Override
    public long getTimeSinceLastActivity() {
        long now = SystemTime.getCurrentTime();
        long lastWriteTime = this.getLastDownloadTime(now);
        if (lastWriteTime > 0L) {
            return now - lastWriteTime;
        }
        long lastCreateTime = this.creationTime;
        if (lastCreateTime > 0L && now >= lastCreateTime) {
            return now - lastCreateTime;
        }
        this.creationTime = now;
        return 0L;
    }

    @Override
    public long getLastDownloadTime(long now) {
        if (this.time_last_download <= now) {
            return this.time_last_download;
        }
        this.time_last_download = now;
        return this.time_last_download;
    }

    @Override
    public boolean isRequested(int blockNumber) {
        return this.requested[blockNumber] != null;
    }

    @Override
    public boolean isDownloaded(int blockNumber) {
        return this.downloaded[blockNumber];
    }

    @Override
    public void setDownloaded(int offset) {
        this.time_last_download = SystemTime.getCurrentTime();
        this.downloaded[offset / 16384] = true;
        int i = 0;
        while (i < this.nbBlocks) {
            if (!this.downloaded[i]) {
                return;
            }
            ++i;
        }
        this.fully_downloaded = true;
        this.fully_requested = false;
    }

    @Override
    public void clearDownloaded(int offset) {
        this.downloaded[offset / 16384] = false;
        this.fully_downloaded = false;
    }

    @Override
    public boolean isDownloaded() {
        return this.fully_downloaded;
    }

    @Override
    public boolean[] getDownloaded() {
        return this.downloaded;
    }

    @Override
    public boolean hasUndownloadedBlock() {
        int i = 0;
        while (i < this.nbBlocks) {
            if (!this.downloaded[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setWritten(String peer, int blockNumber) {
        this.writers[blockNumber] = peer;
        this.dmPiece.setWritten(blockNumber);
    }

    @Override
    public void clearRequested(int blockNumber) {
        this.requested[blockNumber] = this.downloaded[blockNumber] ? this.writers[blockNumber] : null;
        this.fully_requested = false;
    }

    @Override
    public boolean isRequested() {
        return this.fully_requested;
    }

    @Override
    public void setRequested() {
        this.fully_requested = true;
    }

    public void checkRequests() {
        if (this.getTimeSinceLastActivity() < 30000L) {
            return;
        }
        int cleared = 0;
        PEPeerManager manager = this.piecePicker.getPeerManager();
        int i = 0;
        while (i < this.nbBlocks) {
            String requester;
            if (!(this.downloaded[i] || this.dmPiece.isWritten(i) || (requester = this.requested[i]) == null || manager.requestExists(requester, this.getPieceNumber(), i * 16384, this.getBlockSize(i)))) {
                this.clearRequested(i);
                ++cleared;
            }
            ++i;
        }
        if (cleared > 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this.dmPiece.getManager().getTorrent(), LOGID, 1, "checkRequests(): piece #" + this.getPieceNumber() + " cleared " + cleared + " requests"));
            }
        } else if (this.fully_requested && this.getNbUnrequested() > 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this.dmPiece.getManager().getTorrent(), LOGID, 1, "checkRequests(): piece #" + this.getPieceNumber() + " reset fully requested"));
            }
            this.fully_requested = false;
        }
    }

    @Override
    public boolean hasUnrequestedBlock() {
        boolean[] written = this.dmPiece.getWritten();
        int i = 0;
        while (i < this.nbBlocks) {
            if (!(this.downloaded[i] || this.requested[i] != null || written != null && written[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int[] getAndMarkBlocks(PEPeer peer, int nbWanted, int[] request_hint, boolean reverse_order) {
        int block_index;
        int blocksFound;
        int i;
        String ip = peer.getIp();
        boolean[] written = this.dmPiece.getWritten();
        if (request_hint != null) {
            int block_index2;
            int blocksFound2;
            int i2;
            int hint_block_start = request_hint[1] / 16384;
            int hint_block_end = (request_hint[1] + request_hint[2] - 1) / 16384;
            if (reverse_order) {
                i2 = Math.min(this.nbBlocks - 1, hint_block_end);
                while (i2 >= hint_block_start) {
                    blocksFound2 = 0;
                    block_index2 = i2;
                    while (!(blocksFound2 >= nbWanted || block_index2 >= this.nbBlocks || this.downloaded[block_index2] || this.requested[block_index2] != null || written != null && written[block_index2])) {
                        this.requested[block_index2] = ip;
                        ++blocksFound2;
                        --block_index2;
                    }
                    if (blocksFound2 > 0) {
                        return new int[]{block_index2 + 1, blocksFound2};
                    }
                    --i2;
                }
            } else {
                i2 = hint_block_start;
                while (i2 < this.nbBlocks && i2 <= hint_block_end) {
                    blocksFound2 = 0;
                    block_index2 = i2;
                    while (!(blocksFound2 >= nbWanted || block_index2 >= this.nbBlocks || this.downloaded[block_index2] || this.requested[block_index2] != null || written != null && written[block_index2])) {
                        this.requested[block_index2] = ip;
                        ++blocksFound2;
                        ++block_index2;
                    }
                    if (blocksFound2 > 0) {
                        return new int[]{i2, blocksFound2};
                    }
                    ++i2;
                }
            }
        }
        if (reverse_order) {
            i = this.nbBlocks - 1;
            while (i >= 0) {
                blocksFound = 0;
                block_index = i;
                while (!(blocksFound >= nbWanted || block_index < 0 || this.downloaded[block_index] || this.requested[block_index] != null || written != null && written[block_index])) {
                    this.requested[block_index] = ip;
                    ++blocksFound;
                    --block_index;
                }
                if (blocksFound > 0) {
                    return new int[]{block_index + 1, blocksFound};
                }
                --i;
            }
        } else {
            i = 0;
            while (i < this.nbBlocks) {
                blocksFound = 0;
                block_index = i;
                while (!(blocksFound >= nbWanted || block_index >= this.nbBlocks || this.downloaded[block_index] || this.requested[block_index] != null || written != null && written[block_index])) {
                    this.requested[block_index] = ip;
                    ++blocksFound;
                    ++block_index;
                }
                if (blocksFound > 0) {
                    return new int[]{i, blocksFound};
                }
                ++i;
            }
        }
        int[] nArray = new int[2];
        nArray[0] = -1;
        return nArray;
    }

    @Override
    public void getAndMarkBlock(PEPeer peer, int index) {
        this.requested[index] = peer.getIp();
        if (this.getNbUnrequested() <= 0) {
            this.setRequested();
        }
    }

    @Override
    public int getNbRequests() {
        int result = 0;
        int i = 0;
        while (i < this.nbBlocks) {
            if (!this.downloaded[i] && this.requested[i] != null) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    @Override
    public int getNbUnrequested() {
        int result = 0;
        boolean[] written = this.dmPiece.getWritten();
        int i = 0;
        while (i < this.nbBlocks) {
            if (!(this.downloaded[i] || this.requested[i] != null || written != null && written[i])) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean setRequested(PEPeer peer, int blockNumber) {
        if (!this.downloaded[blockNumber]) {
            this.requested[blockNumber] = peer.getIp();
            return true;
        }
        return false;
    }

    @Override
    public boolean isRequestable() {
        return this.dmPiece.isDownloadable() && !this.fully_downloaded && !this.fully_requested;
    }

    @Override
    public int getBlockSize(int blockNumber) {
        int length;
        if (blockNumber == this.nbBlocks - 1 && (length = this.dmPiece.getLength()) % 16384 != 0) {
            return length % 16384;
        }
        return 16384;
    }

    @Override
    public int getBlockNumber(int offset) {
        return offset / 16384;
    }

    @Override
    public int getNbBlocks() {
        return this.nbBlocks;
    }

    public List getPieceWrites() {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        return result;
    }

    public List getPieceWrites(int blockNumber) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (write.getBlockNumber() == blockNumber) continue;
            iter.remove();
        }
        return result;
    }

    public List getPieceWrites(PEPeer peer) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (peer != null && peer.getIp().equals(write.getSender())) continue;
            iter.remove();
        }
        return result;
    }

    public List getPieceWrites(String ip) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (write.getSender().equals(ip)) continue;
            iter.remove();
        }
        return result;
    }

    private void fixupPadFile() {
        DMPieceMapEntry pme2;
        DMPieceList pl = this.dmPiece.getPieceList();
        if (pl.size() == 2 && (pme2 = pl.get(1)).getFile().getTorrentFile().isPadFile()) {
            int pad_block_start;
            DMPieceMapEntry pme1 = pl.get(0);
            int len1 = pme1.getLength();
            int i = pad_block_start = (len1 + 16384 - 1) / 16384;
            while (i < this.nbBlocks) {
                this.dmPiece.setWritten(i);
                ++i;
            }
        }
    }

    @Override
    public void reset() {
        this.dmPiece.reset();
        this.fixupPadFile();
        boolean[] written = this.dmPiece.getWritten();
        int i = 0;
        while (i < this.nbBlocks) {
            this.requested[i] = null;
            this.downloaded[i] = written == null ? false : written[i];
            this.writers[i] = null;
            ++i;
        }
        this.fully_downloaded = false;
        this.time_last_download = 0L;
        this.reservedBy = null;
        this.real_time_data = null;
    }

    @Override
    public Object getRealTimeData() {
        return this.real_time_data;
    }

    @Override
    public void setRealTimeData(Object o) {
        this.real_time_data = o;
    }

    protected void addWrite(PEPieceWriteImpl write) {
        try {
            class_mon.enter();
            this.writes.add(write);
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void addWrite(int blockNumber, String sender, byte[] hash, boolean correct) {
        this.addWrite(new PEPieceWriteImpl(blockNumber, sender, hash, correct));
    }

    @Override
    public String[] getWriters() {
        return this.writers;
    }

    @Override
    public int getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(int newSpeed) {
        this.speed = newSpeed;
    }

    @Override
    public void setLastRequestedPeerSpeed(int peerSpeed) {
        if (peerSpeed > this.speed) {
            ++this.speed;
        }
    }

    @Override
    public PiecePicker getPiecePicker() {
        return this.piecePicker;
    }

    @Override
    public PEPeerManager getManager() {
        return this.piecePicker.getPeerManager();
    }

    @Override
    public void setReservedBy(String peer) {
        this.reservedBy = peer;
    }

    @Override
    public String getReservedBy() {
        return this.reservedBy;
    }

    public void reDownloadBlock(int blockNumber) {
        this.downloaded[blockNumber] = false;
        this.requested[blockNumber] = null;
        this.fully_downloaded = false;
        this.writers[blockNumber] = null;
        this.dmPiece.reDownloadBlock(blockNumber);
    }

    public void reDownloadBlocks(String address) {
        int i = 0;
        while (i < this.writers.length) {
            String writer = this.writers[i];
            if (writer != null && writer.equals(address)) {
                this.reDownloadBlock(i);
            }
            ++i;
        }
    }

    @Override
    public void setResumePriority(int p) {
        this.resumePriority = p;
    }

    @Override
    public int getResumePriority() {
        return this.resumePriority;
    }

    @Override
    public int getAvailability() {
        return this.piecePicker.getPeerManager().getAvailability(this.dmPiece.getPieceNumber());
    }

    @Override
    public int getNbWritten() {
        return this.dmPiece.getNbWritten();
    }

    public boolean[] getWritten() {
        return this.dmPiece.getWritten();
    }

    @Override
    public boolean isWritten() {
        return this.dmPiece.isWritten();
    }

    @Override
    public boolean isWritten(int block) {
        return this.dmPiece.isWritten(block);
    }

    @Override
    public int getPieceNumber() {
        return this.dmPiece.getPieceNumber();
    }

    @Override
    public int getLength() {
        return this.dmPiece.getLength();
    }

    public void setRequestable() {
        this.fully_downloaded = false;
        this.fully_requested = false;
        this.dmPiece.setDownloadable();
    }

    @Override
    public String getString() {
        String text = "";
        text = String.valueOf(text) + (this.isRequestable() ? "reqable," : "");
        text = String.valueOf(text) + "req=" + this.getNbRequests() + ",";
        text = String.valueOf(text) + (this.isRequested() ? "reqstd," : "");
        text = String.valueOf(text) + (this.isDownloaded() ? "downed," : "");
        text = String.valueOf(text) + (this.getReservedBy() != null ? "resrv," : "");
        text = String.valueOf(text) + "speed=" + this.getSpeed() + ",";
        if ((text = String.valueOf(text) + (this.piecePicker == null ? "pri=" + this.getResumePriority() : this.piecePicker.getPieceString(this.dmPiece.getPieceNumber()))).endsWith(",")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

