/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peer.impl.control;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerCheckRequestListener;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerReadRequestListener;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapEntry;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.impl.PEPeerControlHashHandler;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.peer.impl.control.PEPeerControlImpl;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.TOTorrentFileHashTree;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.ConcurrentHasher;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class PEPeerControlHashHandlerImpl
implements PEPeerControlHashHandler,
TOTorrentFileHashTree.PieceTreeProvider {
    private static final Object KEY_PEER_STATS = new Object();
    private final PEPeerControlImpl peer_manager;
    private final TOTorrent torrent;
    private final DiskManager disk_manager;
    private final int piece_length;
    private final ByteArrayHashMap<TOTorrentFileHashTree> file_map;
    private long last_update = SystemTime.getMonotonousTime();
    private Set<PeerHashRequest> active_requests = new LinkedHashSet<PeerHashRequest>();
    private Map<PEPeerTransport, List<PeerHashRequest>> peer_requests = new HashMap<PEPeerTransport, List<PeerHashRequest>>();
    private PeerHashRequest[][] piece_requests;
    private AtomicInteger piece_hashes_received = new AtomicInteger();
    private boolean save_done_on_complete;
    private final Set<TOTorrentFileHashTree> incomplete_trees = new HashSet<TOTorrentFileHashTree>();
    private final Map<TOTorrentFileHashTree, PeerHashRequest> incomplete_tree_reqs = new HashMap<TOTorrentFileHashTree, PeerHashRequest>();
    private final int PIECE_TREE_CACHE_MAX = 20;
    private final Map<Integer, byte[][]> piece_tree_cache = new LinkedHashMap<Integer, byte[][]>(20, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, byte[][]> eldest) {
            return this.size() > 20;
        }
    };
    private volatile long last_piece_tree_request = -1L;
    private final Map<Integer, PieceTreeRequest> piece_tree_requests = new HashMap<Integer, PieceTreeRequest>();

    public PEPeerControlHashHandlerImpl(PEPeerControlImpl _peer_manager, TOTorrent _torrent, DiskManager _disk_manager) {
        this.peer_manager = _peer_manager;
        this.torrent = _torrent;
        this.disk_manager = _disk_manager;
        this.piece_length = this.disk_manager.getPieceLength();
        this.file_map = new ByteArrayHashMap();
        TOTorrentFile[] tOTorrentFileArray = this.torrent.getFiles();
        int n = tOTorrentFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            TOTorrentFile file = tOTorrentFileArray[n2];
            TOTorrentFileHashTree hash_tree = file.getHashTree();
            if (hash_tree != null) {
                this.file_map.put(hash_tree.getRootHash(), hash_tree);
                if (!hash_tree.isPieceLayerComplete()) {
                    this.incomplete_trees.add(hash_tree);
                }
            }
            ++n2;
        }
    }

    @Override
    public void stop() {
        if (this.piece_hashes_received.get() > 0) {
            this.peer_manager.getAdapter().saveTorrentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        List listeners;
        ArrayList<Object> expired;
        long now = SystemTime.getMonotonousTime();
        if (!this.save_done_on_complete && this.disk_manager.getRemaining() == 0L && this.piece_hashes_received.get() > 0) {
            this.save_done_on_complete = true;
            this.peer_manager.getAdapter().saveTorrentState();
        }
        if (this.last_piece_tree_request > 0L && now - this.last_piece_tree_request > 60000L) {
            this.last_piece_tree_request = -1L;
            Map<Integer, byte[][]> map = this.piece_tree_cache;
            synchronized (map) {
                this.piece_tree_cache.clear();
            }
        }
        if (now - this.last_update >= 30000L) {
            expired = new ArrayList<Object>();
            Map<Integer, PieceTreeRequest> map = this.piece_tree_requests;
            synchronized (map) {
                Iterator<PieceTreeRequest> iterator = this.piece_tree_requests.values().iterator();
                while (iterator.hasNext()) {
                    PieceTreeRequest req = iterator.next();
                    if (now - req.getCreateTime() <= 30000L) continue;
                    iterator.remove();
                    expired.add(req);
                }
            }
            for (PieceTreeRequest pieceTreeRequest : expired) {
                Debug.out("PieceTreeRequest expired, derp");
                pieceTreeRequest.complete(null);
            }
        }
        expired = new ArrayList();
        ArrayList<PeerHashRequest> arrayList = new ArrayList<PeerHashRequest>();
        Map<PEPeerTransport, List<PeerHashRequest>> map = this.peer_requests;
        synchronized (map) {
            Iterator<PeerHashRequest> request_it = this.active_requests.iterator();
            while (request_it.hasNext()) {
                PeerHashRequest peer_request = request_it.next();
                boolean remove = false;
                long age = now - peer_request.getCreateTime();
                if (age > 10000L) {
                    expired.add(peer_request);
                    remove = true;
                } else if (age > 5000L && peer_request.getPeer().getPeerState() != 30) {
                    arrayList.add(peer_request);
                    remove = true;
                }
                if (!remove) break;
                request_it.remove();
                PEPeerTransport peer = peer_request.getPeer();
                List<PeerHashRequest> peer_reqs = this.peer_requests.get(peer);
                if (peer_reqs == null) {
                    Debug.out("entry not found");
                } else {
                    peer_reqs.remove(peer_request);
                    if (peer_reqs.isEmpty()) {
                        this.peer_requests.remove(peer);
                    }
                }
                this.removeFromPieceRequests(peer_request);
                peer_request.setComplete();
            }
            if (this.incomplete_trees.isEmpty()) {
                if (!this.save_done_on_complete && this.piece_hashes_received.get() > 0) {
                    this.save_done_on_complete = true;
                    this.peer_manager.getAdapter().saveTorrentState();
                }
            } else {
                byte[][] pieces = null;
                int[] peer_availability = null;
                boolean has_seeds = false;
                Iterator<PeerHashRequest> request_it2 = this.incomplete_tree_reqs.values().iterator();
                while (request_it2.hasNext()) {
                    PeerHashRequest peer_request = request_it2.next();
                    if (!peer_request.isComplete()) continue;
                    request_it2.remove();
                }
                Iterator<TOTorrentFileHashTree> tree_it = this.incomplete_trees.iterator();
                block17: while (tree_it.hasNext()) {
                    if (this.incomplete_tree_reqs.size() >= 10) break;
                    TOTorrentFileHashTree tree = tree_it.next();
                    PeerHashRequest peer_request = this.incomplete_tree_reqs.get(tree);
                    if (peer_request != null) continue;
                    if (tree.isPieceLayerComplete()) {
                        tree_it.remove();
                        continue;
                    }
                    if (pieces == null) {
                        try {
                            pieces = this.torrent.getPieces();
                        }
                        catch (Throwable e) {
                            break;
                        }
                    }
                    TOTorrentFile file = tree.getFile();
                    int start = file.getFirstPieceNumber();
                    int end = file.getLastPieceNumber();
                    int i = start;
                    while (i <= end) {
                        if (pieces[i] == null) {
                            PeerHashRequest req;
                            if (peer_availability == null) {
                                PiecePicker piece_picker = this.peer_manager.getPiecePicker();
                                if (piece_picker.getMinAvailability() >= 1.0f) {
                                    has_seeds = true;
                                } else {
                                    peer_availability = piece_picker.getAvailability();
                                }
                            }
                            if ((has_seeds || peer_availability[i] >= true) && (req = this.hashRequestSupport(i, null)) != null) {
                                this.incomplete_tree_reqs.put(tree, req);
                                continue block17;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        for (PeerHashRequest peerHashRequest : arrayList) {
            listeners = peerHashRequest.getListeners();
            if (listeners == null) continue;
            for (DiskManagerCheckRequestListener.HashListener l : listeners) {
                if (this.hashRequest(l.getPieceNumber(), l)) continue;
                l.complete(false);
            }
        }
        for (PeerHashRequest peerHashRequest : expired) {
            listeners = peerHashRequest.getListeners();
            if (listeners == null) continue;
            for (DiskManagerCheckRequestListener.HashListener l : listeners) {
                try {
                    l.complete(false);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        this.last_update = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeerHashRequest request(PEPeerTransport peer, int piece_number, DiskManagerCheckRequestListener.HashListener listener_maybe_null) {
        PeerHashRequest peer_request;
        TOTorrentFileHashTree.HashRequest hash_req;
        TOTorrentFile file = this.disk_manager.getPieceList(piece_number).get(0).getFile().getTorrentFile();
        TOTorrentFileHashTree tree = file.getHashTree();
        if (tree == null) {
            return null;
        }
        Map<PEPeerTransport, List<PeerHashRequest>> map = this.peer_requests;
        synchronized (map) {
            block15: {
                block14: {
                    if (this.piece_requests != null && this.piece_requests[piece_number] != null) {
                        if (listener_maybe_null != null) {
                            this.piece_requests[piece_number][0].addListener(listener_maybe_null);
                        }
                        return this.piece_requests[piece_number][0];
                    }
                    hash_req = tree.requestPieceHash(piece_number, peer.getAvailable());
                    if (hash_req != null) break block14;
                    return null;
                }
                if (this.active_requests.size() <= 2048) break block15;
                Debug.out("Too many active hash requests");
                return null;
            }
            peer_request = new PeerHashRequest(peer, file, hash_req, listener_maybe_null);
            this.active_requests.add(peer_request);
            List<PeerHashRequest> peer_reqs = this.peer_requests.get(peer);
            if (peer_reqs == null) {
                peer_reqs = new ArrayList<PeerHashRequest>();
                this.peer_requests.put(peer, peer_reqs);
            }
            peer_reqs.add(peer_request);
            if (this.piece_requests == null) {
                this.piece_requests = new PeerHashRequest[this.torrent.getNumberOfPieces()][];
            }
            int offset = hash_req.getOffset() + file.getFirstPieceNumber();
            int length = hash_req.getLength();
            PeerHashRequest[] pr = new PeerHashRequest[]{peer_request};
            int pos = offset;
            int end = offset + length;
            while (pos < end && pos < this.piece_requests.length) {
                PeerHashRequest[] existing = this.piece_requests[pos];
                if (existing == null) {
                    this.piece_requests[pos] = pr;
                } else {
                    int len = existing.length;
                    PeerHashRequest[] temp = new PeerHashRequest[len + 1];
                    int i = 0;
                    while (i < len) {
                        temp[i] = existing[i];
                        ++i;
                    }
                    temp[len] = peer_request;
                    this.piece_requests[pos] = temp;
                }
                ++pos;
            }
        }
        peer.sendHashRequest(hash_req);
        return peer_request;
    }

    @Override
    public boolean hashRequest(int piece_number, DiskManagerCheckRequestListener.HashListener listener) {
        return this.hashRequestSupport(piece_number, listener) != null;
    }

    private PeerHashRequest hashRequestSupport(int piece_number, DiskManagerCheckRequestListener.HashListener listener) {
        List<PEPeer> peers = this.peer_manager.getPeers();
        PEPeer best_peer = null;
        int best_req_count = Integer.MAX_VALUE;
        for (PEPeer peer : peers) {
            BitFlags avail;
            if (peer.getPeerState() != 30 || (avail = peer.getAvailable()) == null || !avail.flags[piece_number]) continue;
            int req_count = peer.getOutgoingRequestCount();
            if (req_count == 0) {
                PeerHashRequest res = this.request((PEPeerTransport)peer, piece_number, listener);
                if (res == null) continue;
                return res;
            }
            if (req_count >= best_req_count) continue;
            best_peer = peer;
            best_req_count = req_count;
        }
        if (best_peer != null) {
            PeerHashRequest res = this.request((PEPeerTransport)best_peer, piece_number, listener);
            return res;
        }
        return null;
    }

    @Override
    public void sendingRequest(PEPeerTransport peer, DiskManagerReadRequest request2) {
        int piece_number = request2.getPieceNumber();
        try {
            if (this.torrent.getPieces()[piece_number] == null) {
                this.request(peer, piece_number, null);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public void receivedHashes(PEPeerTransport peer, byte[] root_hash, int base_layer, int index, int length, int proof_layers, byte[][] hashes) {
        this.receivedOrRejectedHashes(peer, root_hash, base_layer, index, length, proof_layers, hashes);
        this.piece_hashes_received.addAndGet(length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedOrRejectedHashes(PEPeerTransport peer, byte[] root_hash, int base_layer, int index, int length, int proof_layers, byte[][] hashes) {
        block15: {
            try {
                TOTorrentFileHashTree tree = this.file_map.get(root_hash);
                if (tree == null) break block15;
                if (hashes != null) {
                    tree.receivedHashes(root_hash, base_layer, index, length, proof_layers, hashes);
                }
                List listeners = null;
                Map<PEPeerTransport, List<PeerHashRequest>> map = this.peer_requests;
                synchronized (map) {
                    List<PeerHashRequest> peer_reqs = this.peer_requests.get(peer);
                    if (peer_reqs != null) {
                        Iterator<PeerHashRequest> it = peer_reqs.iterator();
                        PeerHashRequest match = null;
                        while (it.hasNext()) {
                            PeerHashRequest peer_request = it.next();
                            TOTorrentFileHashTree.HashRequest req = peer_request.getRequest();
                            if (!Arrays.equals(root_hash, req.getRootHash()) || base_layer != req.getBaseLayer() || index != req.getOffset() || length != req.getLength() || proof_layers != req.getProofLayers()) continue;
                            match = peer_request;
                            it.remove();
                            break;
                        }
                        if (match != null) {
                            if (peer_reqs.isEmpty()) {
                                this.peer_requests.remove(peer);
                            }
                            if (!this.active_requests.remove(match)) {
                                Debug.out("entry not found");
                            }
                            this.removeFromPieceRequests(match);
                            match.setComplete();
                            listeners = match.getListeners();
                        }
                    }
                }
                if (listeners != null) {
                    for (DiskManagerCheckRequestListener.HashListener l : listeners) {
                        try {
                            l.complete(hashes != null);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private void removeFromPieceRequests(PeerHashRequest peer_request) {
        if (this.active_requests.isEmpty()) {
            this.piece_requests = null;
        } else {
            int offset;
            TOTorrentFileHashTree.HashRequest req = peer_request.getRequest();
            int pos = offset = req.getOffset() + peer_request.getFile().getFirstPieceNumber();
            int end = offset + req.getLength();
            while (pos < end && pos < this.piece_requests.length) {
                PeerHashRequest[] existing = this.piece_requests[pos];
                if (existing == null) {
                    Debug.out("entry not found");
                } else if (existing.length == 1) {
                    if (existing[0] != peer_request) {
                        Debug.out("entry not found");
                    } else {
                        this.piece_requests[pos] = null;
                    }
                } else {
                    PeerHashRequest[] temp = new PeerHashRequest[existing.length - 1];
                    int temp_pos = 0;
                    boolean found = false;
                    PeerHashRequest[] peerHashRequestArray = existing;
                    int n = existing.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PeerHashRequest pr = peerHashRequestArray[n2];
                        if (pr == peer_request) {
                            found = true;
                        } else {
                            if (temp_pos == temp.length) break;
                            temp[temp_pos++] = pr;
                        }
                        ++n2;
                    }
                    if (found) {
                        this.piece_requests[pos] = temp;
                    } else {
                        Debug.out("entry not found");
                    }
                }
                ++pos;
            }
        }
    }

    @Override
    public void rejectedHashes(PEPeerTransport peer, byte[] root_hash, int base_layer, int index, int length, int proof_layers) {
        this.receivedOrRejectedHashes(peer, root_hash, base_layer, index, length, proof_layers, null);
    }

    @Override
    public void receivedHashRequest(PEPeerTransport peer, PEPeerControlHashHandler.HashesReceiver receiver, byte[] root_hash, int base_layer, int index, int length, int proof_layers) {
        PeerStats stats2 = (PeerStats)peer.getUserData(KEY_PEER_STATS);
        if (stats2 == null) {
            stats2 = new PeerStats(peer);
            peer.setUserData(KEY_PEER_STATS, stats2);
        }
        try {
            TOTorrentFileHashTree tree = this.file_map.get(root_hash);
            if (tree != null) {
                int related_bytes = base_layer == 0 ? 16384 * length : this.piece_length * length;
                stats2.hashesRequested(related_bytes);
                stats2.runTask(() -> {
                    if (!tree.requestHashes(this, new HashesReceiverImpl(peer, receiver), root_hash, base_layer, index, length, proof_layers)) {
                        receiver.receiveResult(null);
                    }
                });
                return;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        receiver.receiveResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getPieceTree(TOTorrentFileHashTree.PieceTreeReceiver receiver, TOTorrentFileHashTree tree, int piece_offset) {
        PieceTreeRequest piece_tree_request;
        byte[][] existing;
        final TOTorrentFile file = tree.getFile();
        final int piece_number = file.getFirstPieceNumber() + piece_offset;
        if (!this.disk_manager.isDone(piece_number)) {
            receiver.receivePieceTree(piece_offset, null);
            return;
        }
        Map<Integer, byte[][]> map = this.piece_tree_cache;
        synchronized (map) {
            existing = this.piece_tree_cache.get(piece_number);
        }
        if (existing != null) {
            this.last_piece_tree_request = SystemTime.getMonotonousTime();
            receiver.receivePieceTree(piece_offset, existing);
            return;
        }
        Map<Integer, PieceTreeRequest> map2 = this.piece_tree_requests;
        synchronized (map2) {
            piece_tree_request = this.piece_tree_requests.get(piece_number);
            if (piece_tree_request != null) {
                piece_tree_request.addListener(receiver);
                return;
            }
            piece_tree_request = new PieceTreeRequest(piece_offset, piece_number, receiver);
            this.piece_tree_requests.put(piece_number, piece_tree_request);
        }
        final PieceTreeRequest f_piece_tree_request = piece_tree_request;
        boolean went_async = false;
        try {
            try {
                final byte[] piece_hash = this.torrent.getPieces()[piece_number];
                final int piece_size = this.disk_manager.getPieceLength(piece_number);
                PEPeerTransport peer = ((HashesReceiverImpl)receiver.getHashesReceiver()).getPeer();
                PeerStats stats2 = (PeerStats)peer.getUserData(KEY_PEER_STATS);
                stats2.pieceTreeRequest(piece_size);
                this.disk_manager.enqueueReadRequest(this.disk_manager.createReadRequest(piece_number, 0, piece_size), new DiskManagerReadRequestListener(){

                    @Override
                    public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
                        boolean async_hashing = false;
                        try {
                            int v2_piece_length;
                            ByteBuffer byte_buffer = data.getBuffer((byte)2);
                            DMPieceList pieceList2 = PEPeerControlHashHandlerImpl.this.disk_manager.getPieceList(piece_number);
                            DMPieceMapEntry piece_entry = pieceList2.get(0);
                            if (pieceList2.size() == 2 && (v2_piece_length = piece_entry.getLength()) < PEPeerControlHashHandlerImpl.this.piece_length) {
                                byte_buffer.limit(byte_buffer.position() + v2_piece_length);
                            }
                            ConcurrentHasher hasher = ConcurrentHasher.getSingleton();
                            hasher.addRequest(byte_buffer, 2, piece_size, file.getLength(), completed_request -> {
                                block8: {
                                    byte[][] hashes = null;
                                    try {
                                        List<List<byte[]>> tree;
                                        if (!Arrays.equals(completed_request.getResult(), piece_hash) || (tree = completed_request.getHashTree()) == null) break block8;
                                        hashes = new byte[tree.size()][];
                                        int layer_index = hashes.length - 1;
                                        for (List<byte[]> entry : tree) {
                                            byte[] layer = new byte[entry.size() * 32];
                                            hashes[layer_index--] = layer;
                                            int layer_pos = 0;
                                            for (byte[] hash : entry) {
                                                System.arraycopy(hash, 0, layer, layer_pos, 32);
                                                layer_pos += 32;
                                            }
                                        }
                                        PEPeerControlHashHandlerImpl.this.last_piece_tree_request = SystemTime.getMonotonousTime();
                                        Map map = PEPeerControlHashHandlerImpl.this.piece_tree_cache;
                                        synchronized (map) {
                                            PEPeerControlHashHandlerImpl.this.piece_tree_cache.put(piece_number, hashes);
                                        }
                                    }
                                    finally {
                                        data.returnToPool();
                                        f_piece_tree_request.complete(hashes);
                                    }
                                }
                            }, false);
                            async_hashing = true;
                        }
                        finally {
                            if (!async_hashing) {
                                data.returnToPool();
                                f_piece_tree_request.complete(null);
                            }
                        }
                    }

                    @Override
                    public void readFailed(DiskManagerReadRequest request2, Throwable cause) {
                        f_piece_tree_request.complete(null);
                    }

                    @Override
                    public int getPriority() {
                        return -1;
                    }

                    @Override
                    public void requestExecuted(long bytes) {
                    }
                });
                went_async = true;
            }
            catch (Throwable e) {
                Debug.out(e);
                if (!went_async) {
                    piece_tree_request.complete(null);
                }
            }
        }
        finally {
            if (!went_async) {
                piece_tree_request.complete(null);
            }
        }
    }

    private static class HashesReceiverImpl
    implements TOTorrentFileHashTree.HashesReceiver {
        private final PEPeerTransport peer;
        private final PEPeerControlHashHandler.HashesReceiver receiver;

        HashesReceiverImpl(PEPeerTransport _peer, PEPeerControlHashHandler.HashesReceiver _receiver) {
            this.peer = _peer;
            this.receiver = _receiver;
        }

        @Override
        public void receiveHashes(byte[][] hashes) {
            this.receiver.receiveResult(hashes);
        }

        PEPeerTransport getPeer() {
            return this.peer;
        }
    }

    private static class PeerHashRequest {
        final PEPeerTransport peer;
        final TOTorrentFile torrent_file;
        final TOTorrentFileHashTree.HashRequest request;
        final long time = SystemTime.getMonotonousTime();
        List<DiskManagerCheckRequestListener.HashListener> listeners;
        boolean completed;

        private PeerHashRequest(PEPeerTransport _peer, TOTorrentFile _tf, TOTorrentFileHashTree.HashRequest _request, DiskManagerCheckRequestListener.HashListener _listener) {
            this.peer = _peer;
            this.torrent_file = _tf;
            this.request = _request;
            if (_listener != null) {
                this.listeners = new ArrayList<DiskManagerCheckRequestListener.HashListener>(1);
                this.listeners.add(_listener);
            }
        }

        private long getCreateTime() {
            return this.time;
        }

        private TOTorrentFile getFile() {
            return this.torrent_file;
        }

        private PEPeerTransport getPeer() {
            return this.peer;
        }

        private TOTorrentFileHashTree.HashRequest getRequest() {
            return this.request;
        }

        private void addListener(DiskManagerCheckRequestListener.HashListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<DiskManagerCheckRequestListener.HashListener>(1);
            }
            this.listeners.add(listener);
        }

        private List<DiskManagerCheckRequestListener.HashListener> getListeners() {
            return this.listeners;
        }

        private void setComplete() {
            this.completed = true;
        }

        private boolean isComplete() {
            return this.completed;
        }
    }

    private class PeerStats {
        private final PEPeerTransport peer;
        private final Average piece_tree_data_rate = Average.getInstance(1000, 10);
        private final Average hash_data_rate = Average.getInstance(1000, 10);
        private final Average hash_rate = Average.getInstance(1000, 10);
        private final LinkedList<Runnable> tasks = new LinkedList();

        PeerStats(PEPeerTransport _peer) {
            this.peer = _peer;
        }

        void pieceTreeRequest(int bytes) {
            this.piece_tree_data_rate.addValue(bytes);
        }

        void hashesRequested(int bytes_related) {
            this.hash_rate.addValue(100L);
            this.hash_data_rate.addValue(bytes_related);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runTask(Runnable task2) {
            long hd_rate = this.hash_data_rate.getAverage();
            long pt_rate = this.piece_tree_data_rate.getAverage();
            long peer_rate = this.peer.getStats().getDataSendRate();
            boolean rate_limit = false;
            if (pt_rate > 0x100000L && pt_rate > peer_rate * 2L) {
                rate_limit = true;
            }
            if (hd_rate > 0xA00000L && hd_rate > peer_rate * 4L) {
                rate_limit = true;
            }
            if (rate_limit) {
                LinkedList<Runnable> linkedList = this.tasks;
                synchronized (linkedList) {
                    this.tasks.addLast(task2);
                    if (this.tasks.size() > 1024) {
                        PEPeerControlHashHandlerImpl.this.peer_manager.removePeer(this.peer, "Too many hash requests", 0);
                        return;
                    }
                    if (this.tasks.size() == 1) {
                        SimpleTimer.addEvent("Peer.hash.rl", SystemTime.getOffsetTime(100L), new TimerEventPerformer(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void perform(TimerEvent event2) {
                                Runnable t;
                                LinkedList linkedList = PeerStats.this.tasks;
                                synchronized (linkedList) {
                                    t = (Runnable)PeerStats.this.tasks.removeFirst();
                                    if (!PeerStats.this.tasks.isEmpty()) {
                                        if (PeerStats.this.peer.getPeerState() == 50) {
                                            PeerStats.this.tasks.clear();
                                        } else {
                                            SimpleTimer.addEvent("Peer.hash.rl", SystemTime.getOffsetTime(100L), this);
                                        }
                                    }
                                }
                                t.run();
                            }
                        });
                    }
                }
            } else {
                task2.run();
            }
        }

        String getString() {
            return "hash rate=" + (float)this.hash_rate.getAverage() / 100.0f + ", hash data=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.hash_data_rate.getAverage()) + ", pt data=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.piece_tree_data_rate.getAverage()) + ", peer data=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.peer.getStats().getDataSendRate());
        }
    }

    private class PieceTreeRequest {
        private final int piece_offset;
        private final int piece_number;
        private final long time = SystemTime.getMonotonousTime();
        private final List<TOTorrentFileHashTree.PieceTreeReceiver> listeners = new ArrayList<TOTorrentFileHashTree.PieceTreeReceiver>();
        private boolean done;

        PieceTreeRequest(int _po, int _pn, TOTorrentFileHashTree.PieceTreeReceiver _listener) {
            this.piece_offset = _po;
            this.piece_number = _pn;
            this.listeners.add(_listener);
        }

        private long getCreateTime() {
            return this.time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener(TOTorrentFileHashTree.PieceTreeReceiver l) {
            Map map = PEPeerControlHashHandlerImpl.this.piece_tree_requests;
            synchronized (map) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(byte[][] piece_tree) {
            Map map = PEPeerControlHashHandlerImpl.this.piece_tree_requests;
            synchronized (map) {
                if (this.done) {
                    return;
                }
                this.done = true;
                PEPeerControlHashHandlerImpl.this.piece_tree_requests.remove(this.piece_number);
            }
            for (TOTorrentFileHashTree.PieceTreeReceiver listener : this.listeners) {
                try {
                    listener.receivePieceTree(this.piece_offset, piece_tree);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }
}

