/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peer.util;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.networkmanager.NetworkConnectionBase;
import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.networkmanager.TransportBase;
import com.biglybt.core.networkmanager.TransportEndpoint;
import com.biglybt.core.networkmanager.TransportStartpoint;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.admin.NetworkAdminASN;
import com.biglybt.core.networkmanager.admin.NetworkAdminASNListener;
import com.biglybt.core.networkmanager.admin.NetworkAdminException;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.util.PeerIdentityDataID;
import com.biglybt.core.peer.util.PeerIdentityManager;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.CRC32C;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.utils.LocationProvider;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class PeerUtils {
    public static final String CC_UNKNOWN = "??";
    private static final String CONFIG_MAX_CONN_PER_TORRENT = "Max.Peer.Connections.Per.Torrent";
    private static final String CONFIG_MAX_CONN_TOTAL = "Max.Peer.Connections.Total";
    public static int MAX_CONNECTIONS_PER_TORRENT;
    public static int MAX_CONNECTIONS_TOTAL;
    private static final NetworkAdmin network_admin;
    private static volatile long na_last_ip4_time;
    private static volatile long na_last_ip6_time;
    private static volatile byte[] na_last_ip4;
    private static volatile byte[] na_last_ip6;
    private static int na_tcp_port;
    private static final Set<Integer> ignore_peer_ports;
    static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static volatile LocationProvider country_provider;
    private static long country_provider_last_check;
    private static final Object country_key;
    private static final Object net_key;
    private static final Object ni_key;
    private static final Object ni_null;
    private static final Object ni_address_key;
    private static final Object asn_key;
    private static final Object asn_pending;
    private static final String[] asn_failed;

    static {
        COConfigurationManager.addParameterListener(CONFIG_MAX_CONN_PER_TORRENT, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(PeerUtils.CONFIG_MAX_CONN_PER_TORRENT);
            }
        });
        MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_PER_TORRENT);
        COConfigurationManager.addParameterListener(CONFIG_MAX_CONN_TOTAL, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(PeerUtils.CONFIG_MAX_CONN_TOTAL);
            }
        });
        MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_TOTAL);
        NetworkAdmin temp = null;
        try {
            temp = NetworkAdmin.getSingleton();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        network_admin = temp;
        COConfigurationManager.addAndFireParameterListener("TCP.Listen.Port", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                na_tcp_port = COConfigurationManager.getIntParameter(parameterName);
            }
        });
        ignore_peer_ports = new HashSet<Integer>();
        COConfigurationManager.addParameterListener("Ignore.peer.ports", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                PeerUtils.readIgnorePeerPorts();
            }
        });
        PeerUtils.readIgnorePeerPorts();
        country_key = new Object();
        net_key = new Object();
        ni_key = new Object();
        ni_null = new Object();
        ni_address_key = new Object();
        asn_key = new Object();
        asn_pending = new Object();
        asn_failed = new String[]{"", ""};
    }

    public static int getPeerPriority(String address, int port) {
        if (network_admin == null) {
            return 0;
        }
        try {
            InetAddress ia = HostNameToIPResolver.syncResolve(address);
            if (ia != null) {
                return PeerUtils.getPeerPriority(ia, port);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public static int getPeerPriority(InetAddress address, int peer_port) {
        return PeerUtils.getPeerPriority(address.getAddress(), peer_port);
    }

    public static int getPeerPriority(byte[] peer_address, short peer_port) {
        return PeerUtils.getPeerPriority(peer_address, peer_port & 0xFFFF);
    }

    public static int getPeerPriority(byte[] peer_address, int peer_port) {
        if (network_admin == null) {
            return 0;
        }
        if (peer_address == null) {
            return 0;
        }
        byte[] my_address = null;
        long now = SystemTime.getMonotonousTime();
        if (peer_address.length == 4) {
            if (na_last_ip4 != null && now - na_last_ip4_time < 120000L) {
                my_address = na_last_ip4;
            } else if (na_last_ip4_time == 0L || now - na_last_ip4_time > 10000L) {
                byte[] iab;
                na_last_ip4_time = now;
                InetAddress ia = network_admin.getDefaultPublicAddress(true);
                if (ia != null && (iab = ia.getAddress()) != null) {
                    na_last_ip4 = my_address = ia.getAddress();
                }
            }
            if (my_address == null) {
                my_address = na_last_ip4;
            }
        } else if (peer_address.length == 16) {
            if (na_last_ip6 != null && now - na_last_ip6_time < 120000L) {
                my_address = na_last_ip6;
            } else if (na_last_ip6_time == 0L || now - na_last_ip6_time > 10000L) {
                byte[] iab;
                na_last_ip6_time = now;
                InetAddress ia = network_admin.getDefaultPublicAddressV6();
                if (ia != null && (iab = ia.getAddress()) != null) {
                    my_address = ia.getAddress();
                    na_last_ip6 = my_address;
                }
            }
            if (my_address == null) {
                my_address = na_last_ip6;
            }
        } else {
            return 0;
        }
        if (my_address != null && my_address.length == peer_address.length) {
            return PeerUtils.getPeerPriority(my_address, na_tcp_port, peer_address, peer_port);
        }
        return 0;
    }

    private static int getPeerPriority(byte[] a1, int port1, byte[] a2, int port2) {
        byte[] a1_masked = new byte[a1.length];
        byte[] a2_masked = new byte[a2.length];
        int x = a1_masked.length == 4 ? 1 : 5;
        boolean same = true;
        int order = 0;
        int i = 0;
        while (i < a1_masked.length) {
            byte a1_byte = a1[i];
            byte a2_byte = a2[i];
            if (i < x || same) {
                a1_masked[i] = a1_byte;
                a2_masked[i] = a2_byte;
            } else {
                a1_masked[i] = (byte)(a1_byte & 0x55);
                a2_masked[i] = (byte)(a2_byte & 0x55);
            }
            if (i >= x && same) {
                boolean bl = same = a1_byte == a2_byte;
            }
            if (order == 0) {
                order = (a1_masked[i] & 0xFF) - (a2_masked[i] & 0xFF);
            }
            ++i;
        }
        if (same) {
            a1_masked = new byte[]{(byte)(port1 >> 8), (byte)port1};
            a2_masked = new byte[]{(byte)(port2 >> 8), (byte)port2};
            order = port1 - port2;
        }
        CRC32C crc32 = new CRC32C();
        if (order < 0) {
            crc32.updateWord(a1_masked, true);
            crc32.updateWord(a2_masked, true);
        } else {
            crc32.updateWord(a2_masked, true);
            crc32.updateWord(a1_masked, true);
        }
        long res = crc32.getValue();
        return (int)res;
    }

    public static int numNewConnectionsAllowed(PeerIdentityDataID data_id, int specific_max) {
        int allowed;
        int curConnPerTorrent = PeerIdentityManager.getIdentityCount(data_id);
        int curConnTotal = PeerIdentityManager.getTotalIdentityCount();
        int PER_TORRENT_LIMIT = specific_max;
        int perTorrentAllowed = -1;
        if (PER_TORRENT_LIMIT != 0) {
            int allowed2 = PER_TORRENT_LIMIT - curConnPerTorrent;
            if (allowed2 < 0) {
                allowed2 = 0;
            }
            perTorrentAllowed = allowed2;
        }
        int totalAllowed = -1;
        if (MAX_CONNECTIONS_TOTAL != 0) {
            allowed = MAX_CONNECTIONS_TOTAL - curConnTotal;
            if (allowed < 0) {
                allowed = 0;
            }
            totalAllowed = allowed;
        }
        allowed = -1;
        if (perTorrentAllowed > -1 && totalAllowed > -1) {
            allowed = Math.min(perTorrentAllowed, totalAllowed);
        } else if (perTorrentAllowed == -1 || totalAllowed == -1) {
            allowed = Math.max(perTorrentAllowed, totalAllowed);
        }
        return allowed;
    }

    private static void readIgnorePeerPorts() {
        String[] ports;
        String str = COConfigurationManager.getStringParameter("Ignore.peer.ports").trim();
        ignore_peer_ports.clear();
        if (str.length() > 0 && (ports = str.split("\\;")) != null && ports.length > 0) {
            int i = 0;
            while (i < ports.length) {
                String port = ports[i];
                int spreadPos = port.indexOf(45);
                if (spreadPos > 0 && spreadPos < port.length() - 1) {
                    try {
                        int iMin = Integer.parseInt(port.substring(0, spreadPos).trim());
                        int iMax = Integer.parseInt(port.substring(spreadPos + 1).trim());
                        iMin = Math.max(0, iMin);
                        iMax = Math.min(65535, iMax);
                        int j = iMin;
                        while (j <= iMax) {
                            ignore_peer_ports.add(j);
                            ++j;
                        }
                    }
                    catch (Throwable e) {
                        Debug.out("Invalid ignore-port entry: " + port);
                    }
                } else {
                    try {
                        ignore_peer_ports.add(Integer.parseInt(port.trim()));
                    }
                    catch (Throwable e) {
                        Debug.out("Invalid ignore-port entry: " + port);
                    }
                }
                ++i;
            }
        }
    }

    public static boolean ignorePeerPort(int port) {
        return ignore_peer_ports.contains(port);
    }

    public static byte[] createPeerID() {
        byte[] peerId = new byte[20];
        byte[] version = Constants.VERSION_ID;
        System.arraycopy(version, 0, peerId, 0, 8);
        int i = 8;
        while (i < 20) {
            int pos = (int)(Math.random() * (double)chars.length());
            peerId[i] = (byte)chars.charAt(pos);
            ++i;
        }
        if (Constants.isAndroid) {
            peerId[8] = 65;
        }
        return peerId;
    }

    public static byte[] createWebSeedPeerID() {
        byte[] peerId = new byte[20];
        peerId[0] = 45;
        peerId[1] = 87;
        peerId[2] = 83;
        int i = 3;
        while (i < 20) {
            int pos = (int)(Math.random() * (double)chars.length());
            peerId[i] = (byte)chars.charAt(pos);
            ++i;
        }
        return peerId;
    }

    private static LocationProvider getCountryProvider() {
        if (country_provider != null && country_provider.isDestroyed()) {
            country_provider = null;
            country_provider_last_check = 0L;
        }
        if (country_provider == null) {
            long now = SystemTime.getMonotonousTime();
            if (country_provider_last_check == 0L || now - country_provider_last_check > 20000L) {
                country_provider_last_check = now;
                List<LocationProvider> providers = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getLocationProviders();
                for (LocationProvider provider : providers) {
                    if (!provider.hasCapabilities(3L)) continue;
                    country_provider = provider;
                }
            }
        }
        return country_provider;
    }

    public static String[] getCountryDetails(Peer peer) {
        return PeerUtils.getCountryDetails(PluginCoreUtils.unwrap(peer));
    }

    public static String[] getCountryDetails(PEPeer peer) {
        LocationProvider lp;
        if (peer == null) {
            return null;
        }
        String[] details = (String[])peer.getUserData(country_key);
        if (details == null && (lp = PeerUtils.getCountryProvider()) != null) {
            try {
                String ip = peer.getIp();
                if (HostNameToIPResolver.isDNSName(ip)) {
                    InetAddress peer_address = HostNameToIPResolver.syncResolve(ip);
                    String code = lp.getISO3166CodeForIP(peer_address);
                    String name = lp.getCountryNameForIP(peer_address, Locale.getDefault());
                    details = code != null && name != null ? new String[]{code, name} : new String[]{};
                } else {
                    String cat = AENetworkClassifier.categoriseAddress(ip);
                    details = cat != "Public" ? new String[]{cat, cat} : new String[]{};
                }
                peer.setUserData(country_key, details);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return details;
    }

    public static String[] getCountryDetails(InetAddress address) {
        if (address == null) {
            return null;
        }
        String[] details = null;
        LocationProvider lp = PeerUtils.getCountryProvider();
        if (lp != null) {
            try {
                String code = lp.getISO3166CodeForIP(address);
                String name = lp.getCountryNameForIP(address, Locale.getDefault());
                if (code != null && name != null) {
                    details = new String[]{code, name};
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return details;
    }

    public static String getNetwork(PEPeer peer) {
        if (peer == null) {
            return null;
        }
        String net = (String)peer.getUserData(net_key);
        if (net == null) {
            net = AENetworkClassifier.categoriseAddress(peer.getIp());
            peer.setUserData(net_key, net);
        }
        return net;
    }

    public static NetworkInterface getLocalNetworkInterface(PEPeer peer) {
        NetworkInterface result;
        block23: {
            if (network_admin == null) {
                return null;
            }
            result = null;
            try {
                InetSocketAddress socket_address;
                TransportBase tb;
                NetworkConnectionBase con;
                Object data = peer.getUserData(ni_key);
                if (data instanceof NetworkInterface) {
                    result = (NetworkInterface)data;
                    break block23;
                }
                if (data == ni_null || (con = peer.getNetworkConnection()) == null || !((tb = con.getTransportBase()) instanceof Transport)) break block23;
                Transport transport = (Transport)tb;
                TransportStartpoint start = transport.getTransportStartpoint();
                if (start != null) {
                    InetSocketAddress socket_address2 = start.getProtocolStartpoint().getAddress();
                    if (socket_address2 != null) {
                        InetAddress address = socket_address2.getAddress();
                        Object[] details = network_admin.getInterfaceForAddress(address);
                        Object o = details[0];
                        if (o instanceof NetworkInterface) {
                            result = (NetworkInterface)o;
                            peer.setUserData(ni_key, result);
                            peer.setUserData(ni_address_key, address);
                        } else {
                            peer.setUserData(ni_key, ni_null);
                        }
                    }
                    break block23;
                }
                if (transport.isTCP()) break block23;
                TransportEndpoint end = transport.getTransportEndpoint();
                InetAddress udp_bind = null;
                if (end != null && (socket_address = end.getProtocolEndpoint().getAddress()) != null) {
                    int type = socket_address.getAddress() instanceof Inet4Address ? 1 : 2;
                    try {
                        udp_bind = network_admin.getSingleHomedServiceBindAddress(type);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (udp_bind == null) {
                    udp_bind = network_admin.getSingleHomedServiceBindAddress();
                }
                if (udp_bind != null && !udp_bind.isAnyLocalAddress()) {
                    Object[] details = network_admin.getInterfaceForAddress(udp_bind);
                    Object o = details[0];
                    if (o instanceof NetworkInterface) {
                        result = (NetworkInterface)o;
                        peer.setUserData(ni_key, result);
                        peer.setUserData(ni_address_key, udp_bind);
                    } else {
                        peer.setUserData(ni_key, ni_null);
                    }
                    break block23;
                }
                if (end == null || (socket_address = end.getProtocolEndpoint().getAddress()) == null) break block23;
                try (DatagramSocket s = new DatagramSocket();){
                    s.connect(socket_address.getAddress(), 0);
                    InetAddress local = s.getLocalAddress();
                    if (!local.isAnyLocalAddress()) {
                        Object[] details = network_admin.getInterfaceForAddress(local);
                        Object o = details[0];
                        if (o instanceof NetworkInterface) {
                            result = (NetworkInterface)o;
                            peer.setUserData(ni_key, result);
                            peer.setUserData(ni_address_key, local);
                        } else {
                            peer.setUserData(ni_key, ni_null);
                        }
                    }
                }
                catch (Throwable e) {
                    peer.setUserData(ni_key, ni_null);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return result;
    }

    public static InetAddress getLocalAddress(PEPeer peer) {
        if (peer.getUserData(ni_key) == null) {
            PeerUtils.getLocalNetworkInterface(peer);
        }
        return (InetAddress)peer.getUserData(ni_address_key);
    }

    public static String getASN(PEPeer peer) {
        String[] result = PeerUtils.getASandASN(peer);
        if (result != null) {
            return result[1];
        }
        return null;
    }

    public static String[] getASandASN(final PEPeer peer) {
        if (network_admin == null) {
            return asn_failed;
        }
        Object o = peer.getUserData(asn_key);
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o == asn_pending) {
            return null;
        }
        String peer_ip = peer.getIp();
        if (AENetworkClassifier.categoriseAddress(peer_ip) == "Public") {
            peer.setUserData(asn_key, asn_pending);
            try {
                NetworkAdmin.getSingleton().lookupASN(InetAddress.getByName(peer_ip), new NetworkAdminASNListener(){

                    @Override
                    public void success(NetworkAdminASN asn) {
                        peer.setUserData(asn_key, new String[]{asn.getAS(), asn.getASName()});
                    }

                    @Override
                    public void failed(NetworkAdminException error) {
                        peer.setUserData(asn_key, asn_failed);
                    }
                });
                return null;
            }
            catch (Throwable e) {
                peer.setUserData(asn_key, asn_failed);
                return asn_failed;
            }
        }
        peer.setUserData(asn_key, asn_failed);
        return asn_failed;
    }
}

