/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.messaging.bittorrent;

import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.peermanager.messaging.bittorrent.BTMessage;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;

public class BTLTMessage
implements BTMessage {
    public final byte extension_id;
    public final Message base_message;
    public DirectByteBuffer buffer_header;

    public BTLTMessage(Message base_message, byte extension_id) {
        this.base_message = base_message;
        this.extension_id = extension_id;
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        throw new MessageException("BTLTMessage cannot be used for message deserialization!");
    }

    @Override
    public void destroy() {
        if (this.base_message != null) {
            this.base_message.destroy();
        }
        if (this.buffer_header != null) {
            this.buffer_header.returnToPool();
            this.buffer_header = null;
        }
    }

    @Override
    public DirectByteBuffer[] getData() {
        DirectByteBuffer[] orig_data = this.base_message.getData();
        DirectByteBuffer[] new_data = new DirectByteBuffer[orig_data.length + 1];
        if (this.buffer_header == null) {
            this.buffer_header = DirectByteBufferPool.getBuffer((byte)27, 1);
            this.buffer_header.put((byte)11, this.extension_id);
            this.buffer_header.flip((byte)11);
        }
        new_data[0] = this.buffer_header;
        System.arraycopy(orig_data, 0, new_data, 1, orig_data.length);
        return new_data;
    }

    @Override
    public String getDescription() {
        return this.base_message.getDescription();
    }

    @Override
    public String getFeatureID() {
        if (this.base_message == null) {
            return "BT1";
        }
        return this.base_message.getFeatureID();
    }

    @Override
    public int getFeatureSubID() {
        if (this.base_message == null) {
            return 20;
        }
        return this.base_message.getFeatureSubID();
    }

    @Override
    public String getID() {
        return "BT_LT_EXT_MESSAGE";
    }

    @Override
    public byte[] getIDBytes() {
        return BTMessage.ID_BT_LT_EXT_MESSAGE_BYTES;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return 0;
    }
}

