/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.messaging.bittorrent;

import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.peermanager.messaging.bittorrent.BTMessage;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;

public class BTRejectRequest
implements BTMessage {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final int piece_number;
    private final int piece_offset;
    private final int length;
    private final int hashcode;

    public BTRejectRequest(int piece_number, int piece_offset, int length, byte version) {
        this.piece_number = piece_number;
        this.piece_offset = piece_offset;
        this.length = length;
        this.version = version;
        this.hashcode = piece_number + piece_offset + length;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public int getPieceOffset() {
        return this.piece_offset;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public String getID() {
        return "BT_REJECT_REQUEST";
    }

    @Override
    public byte[] getIDBytes() {
        return BTMessage.ID_BT_REJECT_REQUEST_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "BT1";
    }

    @Override
    public int getFeatureSubID() {
        return 16;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_REJECT_REQUEST piece #" + this.piece_number + ":" + this.piece_offset + "->" + (this.piece_offset + this.length - 1);
        }
        return this.description;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)31, 12);
            this.buffer.putInt((byte)11, this.piece_number);
            this.buffer.putInt((byte)11, this.piece_offset);
            this.buffer.putInt((byte)11, this.length);
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) != 12) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] != 12");
        }
        int num = data.getInt((byte)11);
        if (num < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: num < 0");
        }
        int offset = data.getInt((byte)11);
        if (offset < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: offset < 0");
        }
        int length = data.getInt((byte)11);
        if (length < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: length < 0");
        }
        data.returnToPool();
        return new BTRejectRequest(num, offset, length, version);
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof BTRejectRequest) {
            BTRejectRequest other = (BTRejectRequest)obj;
            if (other.piece_number == this.piece_number && other.piece_offset == this.piece_offset && other.length == this.length) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

