/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.uploadslots;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;

public class DownloadingRanker {
    public PEPeer getNextOptimisticPeer(ArrayList<PEPeer> all_peers) {
        return UnchokerUtil.getNextOptimisticPeer(all_peers, true, true);
    }

    public ArrayList<PEPeer> rankPeers(int max_to_unchoke, ArrayList<PEPeer> all_peers) {
        ArrayList<PEPeer> best_peers = new ArrayList<PEPeer>();
        long[] bests = new long[max_to_unchoke];
        int i = 0;
        while (i < all_peers.size()) {
            long rate;
            PEPeer peer = all_peers.get(i);
            if (peer.isInteresting() && UnchokerUtil.isUnchokable(peer, false) && (rate = peer.getStats().getSmoothDataReceiveRate()) > 256L) {
                UnchokerUtil.updateLargestValueFirstSort(rate, bests, peer, best_peers, 0);
            }
            ++i;
        }
        if (best_peers.size() < max_to_unchoke) {
            int start_pos = best_peers.size();
            int i2 = 0;
            while (i2 < all_peers.size()) {
                long uploaded_ratio;
                PEPeer peer = all_peers.get(i2);
                if (peer.isInteresting() && UnchokerUtil.isUnchokable(peer, false) && !best_peers.contains(peer) && (uploaded_ratio = peer.getStats().getTotalDataBytesSent() / (peer.getStats().getTotalDataBytesReceived() + 16383L)) < 3L) {
                    UnchokerUtil.updateLargestValueFirstSort(peer.getStats().getTotalDataBytesReceived(), bests, peer, best_peers, start_pos);
                }
                ++i2;
            }
        }
        return best_peers;
    }
}

