/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.security;

import com.biglybt.core.Core;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.PluginAdapter;
import com.biglybt.pif.PluginEvent;
import com.biglybt.pif.PluginEventListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BGSpongy {
    private static final CopyOnWriteList<PluginInterface> plugins = new CopyOnWriteList();
    private static AESemaphore plugin_init_complete = new AESemaphore("init:waiter");
    private static volatile Core core;
    private static volatile IPCInterface ipc;
    private static Object spongy_install_lock;
    private static boolean spongy_installing;
    private static boolean spongy_installed;
    private static boolean spongy_install_failed;
    private static List<AESemaphore> spongy_install_waiters;

    static {
        spongy_install_lock = new Object();
        spongy_install_waiters = new ArrayList<AESemaphore>();
    }

    public static void initialize(Core _core) {
        core = _core;
        try {
            PluginInterface[] plugins;
            PluginInterface default_pi = core.getPluginManager().getDefaultPluginInterface();
            default_pi.addEventListener(new PluginEventListener(){

                @Override
                public void handleEvent(PluginEvent ev) {
                    int type = ev.getType();
                    if (type == 8) {
                        BGSpongy.pluginAdded((PluginInterface)ev.getValue());
                    }
                    if (type == 9) {
                        BGSpongy.pluginRemoved((PluginInterface)ev.getValue());
                    }
                }
            });
            PluginInterface[] pluginInterfaceArray = plugins = default_pi.getPluginManager().getPlugins(true);
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                PluginInterface pi = pluginInterfaceArray[n2];
                if (pi.getPluginState().isOperational()) {
                    BGSpongy.pluginAdded(pi);
                }
                ++n2;
            }
            default_pi.addListener(new PluginAdapter(){

                @Override
                public void initializationComplete() {
                    plugin_init_complete.releaseForever();
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private static void pluginAdded(PluginInterface pi) {
        String pid = pi.getPluginID();
        if (pid.equals("bgspongy")) {
            plugins.add(pi);
            ipc = pi.getIPC();
        }
    }

    private static void pluginRemoved(PluginInterface pi) {
        String pid = pi.getPluginID();
        if (pid.equals("bgspongy")) {
            plugins.remove(pi);
            if (plugins.isEmpty()) {
                ipc = null;
            }
        }
    }

    public static MessageDigest getDigest(String algorithm, long max_wait) {
        IPCInterface ipc = BGSpongy.getICP(max_wait);
        if (ipc == null) {
            return null;
        }
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("alg", algorithm);
            MessageDigest digest = (MessageDigest)ipc.invoke("getDigest", new Object[]{args});
            return digest;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IPCInterface getICP(long max_wait) {
        AESemaphore waiter;
        block25: {
            IPCInterface result = ipc;
            if (result != null) {
                return result;
            }
            if (!plugin_init_complete.isReleasedForever()) {
                if (max_wait == 0L) {
                    return null;
                }
                if (max_wait < 0L) {
                    plugin_init_complete.reserve();
                } else {
                    long start = SystemTime.getMonotonousTime();
                    if (!plugin_init_complete.reserve(max_wait)) {
                        return null;
                    }
                    max_wait = Math.max(0L, max_wait - (SystemTime.getMonotonousTime() - start));
                }
                result = ipc;
                if (result != null) {
                    return result;
                }
            }
            waiter = null;
            Object object = spongy_install_lock;
            synchronized (object) {
                block23: {
                    block24: {
                        block22: {
                            if (spongy_installed) {
                                return ipc;
                            }
                            if (!spongy_install_failed) break block22;
                            return null;
                        }
                        if (!spongy_installing) break block24;
                        if (max_wait != 0L) {
                            waiter = new AESemaphore("bgspongy");
                            spongy_install_waiters.add(waiter);
                        }
                        break block25;
                    }
                    PluginInterface existing = core.getPluginManager().getPluginInterfaceByID("bgspongy", false);
                    if (existing == null) break block23;
                    return null;
                }
                if (max_wait != 0L) {
                    waiter = new AESemaphore("bgspongy");
                    spongy_install_waiters.add(waiter);
                }
                spongy_installing = true;
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif == null) {
                    BGSpongy.installCompleted(false);
                } else {
                    try {
                        uif.installPlugin("bgspongy", "bgspongy.install", new UIFunctions.actionListener(){

                            @Override
                            public void actionComplete(Object result) {
                                if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                                    BGSpongy.installCompleted(true);
                                } else {
                                    BGSpongy.installCompleted(false);
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        BGSpongy.installCompleted(false);
                    }
                }
            }
        }
        if (waiter != null) {
            if (max_wait > 0L) {
                waiter.reserve(max_wait);
            } else {
                waiter.reserve();
            }
        }
        return ipc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installCompleted(boolean ok) {
        Object object = spongy_install_lock;
        synchronized (object) {
            if (ok) {
                spongy_installed = true;
            } else {
                spongy_install_failed = true;
            }
            spongy_installing = false;
            for (AESemaphore sem : spongy_install_waiters) {
                sem.release();
            }
        }
    }
}

