/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.security.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.security.impl.SESecurityManagerImpl;
import com.biglybt.core.util.SystemProperties;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetPermission;
import java.net.NetworkInterface;
import java.security.Permission;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ClientSecurityManager
extends SecurityManager
implements SESecurityManager.MySecurityManager {
    final ThreadLocal<Boolean> tls_ni = new ThreadLocal();
    private final SESecurityManagerImpl se_sec_man;
    private final SecurityManager old_sec_man;
    private volatile boolean filter_v4;
    private volatile boolean filter_v6;
    private volatile Set<String> filtered_addresses;

    public ClientSecurityManager(SESecurityManagerImpl _se_sec_man) {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"IPV4 Ignore Network Addresses", "IPV6 Ignore Network Addresses"}, n -> {
            this.filter_v4 = COConfigurationManager.getBooleanParameter("IPV4 Ignore Network Addresses");
            this.filter_v6 = COConfigurationManager.getBooleanParameter("IPV6 Ignore Network Addresses");
        });
        this.filtered_addresses = new HashSet<String>();
        this.se_sec_man = _se_sec_man;
        this.old_sec_man = System.getSecurityManager();
        System.setSecurityManager(this);
    }

    @Override
    public void checkAccept(String host, int port) {
    }

    @Override
    public void checkRead(String file) {
    }

    @Override
    public void checkWrite(String file) {
    }

    @Override
    public void checkConnect(String host, int port) {
        if (port == -1 && this.tls_ni.get() == null && this.filtered_addresses.contains(host)) {
            throw new SecurityException("Access denied");
        }
    }

    @Override
    public void checkExit(int status) {
        String prop;
        if (this.old_sec_man != null) {
            this.old_sec_man.checkExit(status);
        }
        if (!this.se_sec_man.canExitVM() && (prop = System.getProperty(SystemProperties.SYSPROP_SECURITY_MANAGER_PERMITEXIT, "0")).equals("0")) {
            throw new SecurityException("VM exit operation prohibited");
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        this.checkPermission(perm, null);
    }

    @Override
    public void checkPermission(Permission perm, Object context2) {
        if (perm instanceof RuntimePermission) {
            String name = perm.getName();
            if (name.equals("stopThread")) {
                if (this.se_sec_man.isStoppableThread()) {
                    return;
                }
                throw new SecurityException("Thread.stop operation prohibited");
            }
            if (name.equals("setSecurityManager")) {
                throw new SecurityException("Permission Denied");
            }
        } else if (perm instanceof NetPermission && this.tls_ni.get() == null && !this.filtered_addresses.isEmpty() && perm.getName().equals("getNetworkInformation")) {
            throw new SecurityException("Permission Denied");
        }
        if (this.old_sec_man != null) {
            if (context2 == null) {
                this.old_sec_man.checkPermission(perm);
            } else {
                this.old_sec_man.checkPermission(perm, context2);
            }
        }
    }

    @Override
    public boolean filterNetworkInterfaces(List<NetworkInterface> interfaces) {
        boolean changed = false;
        try {
            this.tls_ni.set(true);
            HashSet<String> filtered = new HashSet<String>();
            for (NetworkInterface ni : interfaces) {
                try {
                    for (InterfaceAddress ia : ni.getInterfaceAddresses()) {
                        InetAddress address = ia.getAddress();
                        if ((!this.filter_v6 || !(address instanceof Inet6Address)) && (!this.filter_v4 || !(address instanceof Inet4Address))) continue;
                        filtered.add(address.getHostAddress());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!filtered.equals(this.filtered_addresses)) {
                this.filtered_addresses = filtered;
                changed = true;
            }
        }
        finally {
            this.tls_ni.set(null);
        }
        return changed;
    }

    @Override
    public Class[] getClassContext() {
        Class<?>[] res = super.getClassContext();
        if (res.length <= 3) {
            return new Class[0];
        }
        Class[] trimmed = new Class[res.length - 3];
        System.arraycopy(res, 3, trimmed, 0, trimmed.length);
        return trimmed;
    }
}

