/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.security.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.security.CryptoHandler;
import com.biglybt.core.security.CryptoManager;
import com.biglybt.core.security.CryptoManagerException;
import com.biglybt.core.security.CryptoManagerKeyListener;
import com.biglybt.core.security.CryptoManagerPasswordException;
import com.biglybt.core.security.CryptoManagerPasswordHandler;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.security.impl.CryptoHandlerECC;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SHA1;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.gudy.bouncycastle.crypto.engines.RC4Engine;
import org.gudy.bouncycastle.crypto.params.KeyParameter;

public class CryptoManagerImpl
implements CryptoManager {
    private static final int PBE_ITERATIONS = 100;
    private static final String PBE_ALG = "PBEWithMD5AndDES";
    private static CryptoManagerImpl singleton;
    private byte[] secure_id;
    private final CopyOnWriteList password_handlers = new CopyOnWriteList();
    private final CopyOnWriteList keychange_listeners = new CopyOnWriteList();
    private final Map session_passwords = Collections.synchronizedMap(new HashMap());
    private final CryptoHandler ecc_handler;
    private final Map<Integer, CryptoHandler> ecc_handlers = new HashMap<Integer, CryptoHandler>();

    public static synchronized CryptoManager getSingleton() {
        if (singleton == null) {
            singleton = new CryptoManagerImpl();
        }
        return singleton;
    }

    protected CryptoManagerImpl() {
        SESecurityManager.initialise();
        long now = SystemTime.getCurrentTime();
        int i = 0;
        while (i < CryptoManager.HANDLERS.length) {
            int handler = CryptoManager.HANDLERS[i];
            String persist_timeout_key = "core.crypto.pw." + handler + ".persist_timeout";
            String persist_pw_key = "core.crypto.pw." + handler + ".persist_value";
            long timeout = COConfigurationManager.getLongParameter(persist_timeout_key, 0L);
            if (now > timeout) {
                COConfigurationManager.setParameter(persist_timeout_key, 0);
                COConfigurationManager.setParameter(persist_pw_key, "");
            } else {
                this.addPasswordTimer(persist_timeout_key, persist_pw_key, timeout);
            }
            ++i;
        }
        this.ecc_handler = new CryptoHandlerECC(this, 1);
        this.ecc_handlers.put(1, this.ecc_handler);
    }

    protected void addPasswordTimer(final String timeout_key, final String pw_key, final long timeout) {
        if (timeout == Long.MAX_VALUE) {
            return;
        }
        SimpleTimer.addEvent("ClientCryptoManager:pw_timeout", timeout, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                CryptoManagerImpl cryptoManagerImpl = CryptoManagerImpl.this;
                synchronized (cryptoManagerImpl) {
                    if (COConfigurationManager.getLongParameter(timeout_key, 0L) == timeout) {
                        COConfigurationManager.removeParameter(timeout_key);
                        COConfigurationManager.removeParameter(pw_key);
                    }
                }
            }
        });
    }

    @Override
    public byte[] getSecureID() {
        String key = "core.crypto.id";
        if (this.secure_id == null) {
            this.secure_id = COConfigurationManager.getByteParameter(key, null);
        }
        if (this.secure_id == null) {
            this.secure_id = new byte[20];
            RandomUtils.SECURE_RANDOM.nextBytes(this.secure_id);
            COConfigurationManager.setParameter(key, this.secure_id);
            COConfigurationManager.save();
        }
        return this.secure_id;
    }

    private byte[] getOBSID() {
        String key = "core.crypto.obs.id";
        byte[] obs_id = COConfigurationManager.getByteParameter(key, null);
        if (obs_id == null) {
            obs_id = new byte[20];
            RandomUtils.SECURE_RANDOM.nextBytes(obs_id);
            COConfigurationManager.setParameter(key, obs_id);
            COConfigurationManager.save();
        }
        return obs_id;
    }

    @Override
    public byte[] obfuscate(byte[] data) {
        RC4Engine engine = new RC4Engine();
        KeyParameter params = new KeyParameter(new SHA1Simple().calculateHash(this.getOBSID()));
        engine.init(true, params);
        byte[] temp = new byte[1024];
        engine.processBytes(temp, 0, 1024, temp, 0);
        byte[] obs_value = new byte[data.length];
        engine.processBytes(data, 0, data.length, obs_value, 0);
        return obs_value;
    }

    @Override
    public byte[] deobfuscate(byte[] data) {
        return this.obfuscate(data);
    }

    @Override
    public CryptoHandler getECCHandler() {
        return this.ecc_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CryptoHandler getECCHandler(int instance) {
        Map<Integer, CryptoHandler> map = this.ecc_handlers;
        synchronized (map) {
            CryptoHandler h = this.ecc_handlers.get(instance);
            if (h == null) {
                h = new CryptoHandlerECC(this, instance);
                this.ecc_handlers.put(instance, h);
            }
            return h;
        }
    }

    protected byte[] encryptWithPBE(byte[] data, char[] password) throws CryptoManagerException {
        try {
            byte[] salt = new byte[8];
            RandomUtils.SECURE_RANDOM.nextBytes(salt);
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(PBE_ALG);
            SecretKey key = keyFactory.generateSecret(keySpec);
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 100);
            Cipher cipher = Cipher.getInstance(PBE_ALG);
            cipher.init(1, (Key)key, paramSpec);
            byte[] enc = cipher.doFinal(data);
            byte[] res = new byte[salt.length + enc.length];
            System.arraycopy(salt, 0, res, 0, salt.length);
            System.arraycopy(enc, 0, res, salt.length, enc.length);
            return res;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("PBE encryption failed", e);
        }
    }

    protected byte[] decryptWithPBE(byte[] data, char[] password) throws CryptoManagerException {
        boolean fail_is_pw_error = false;
        try {
            byte[] salt = new byte[8];
            System.arraycopy(data, 0, salt, 0, 8);
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(PBE_ALG);
            SecretKey key = keyFactory.generateSecret(keySpec);
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 100);
            Cipher cipher = Cipher.getInstance(PBE_ALG);
            cipher.init(2, (Key)key, paramSpec);
            fail_is_pw_error = true;
            return cipher.doFinal(data, 8, data.length - 8);
        }
        catch (Throwable e) {
            if (fail_is_pw_error) {
                throw new CryptoManagerPasswordException(true, "Password incorrect", e);
            }
            throw new CryptoManagerException("PBE decryption failed", e);
        }
    }

    @Override
    public void clearPasswords() {
        this.clearPasswords(3);
    }

    @Override
    public void clearPasswords(int password_handler_type) {
        this.session_passwords.clear();
        int i = 0;
        while (i < CryptoManager.HANDLERS.length) {
            this.clearPassword(CryptoManager.HANDLERS[i], password_handler_type);
            ++i;
        }
        this.ecc_handler.lock();
    }

    protected void clearPassword(int handler, int password_handler_type) {
        String persist_timeout_key = "core.crypto.pw." + handler + ".persist_timeout";
        String persist_pw_key = "core.crypto.pw." + handler + ".persist_value";
        String persist_pw_key_type = "core.crypto.pw." + handler + ".persist_type";
        int pw_type = (int)COConfigurationManager.getLongParameter(persist_pw_key_type, 1L);
        if (password_handler_type == 3 || password_handler_type == pw_type) {
            COConfigurationManager.removeParameter(persist_timeout_key);
            COConfigurationManager.removeParameter(persist_pw_key);
        }
    }

    protected passwordDetails setPassword(int handler, int pw_type, char[] pw_chars, long timeout) throws CryptoManagerException {
        try {
            String persist_timeout_key = "core.crypto.pw." + handler + ".persist_timeout";
            String persist_pw_key = "core.crypto.pw." + handler + ".persist_value";
            String persist_pw_key_type = "core.crypto.pw." + handler + ".persist_type";
            byte[] salt = this.getPasswordSalt();
            byte[] pw_bytes = new String(pw_chars).getBytes("UTF8");
            SHA1 sha1 = new SHA1();
            sha1.update(ByteBuffer.wrap(salt));
            sha1.update(ByteBuffer.wrap(pw_bytes));
            String encoded_pw = ByteFormatter.encodeString(sha1.digest());
            COConfigurationManager.setParameter(persist_timeout_key, timeout);
            COConfigurationManager.setParameter(persist_pw_key_type, pw_type);
            COConfigurationManager.setParameter(persist_pw_key, encoded_pw);
            passwordDetails result = new passwordDetails(encoded_pw.toCharArray(), pw_type);
            return result;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("setPassword failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected passwordDetails getPassword(int handler, int action, String reason, passwordTester tester, int pw_type) throws CryptoManagerException {
        persist_timeout_key = "core.crypto.pw." + handler + ".persist_timeout";
        persist_pw_key = "core.crypto.pw." + handler + ".persist_value";
        persist_pw_key_type = "core.crypto.pw." + handler + ".persist_type";
        current_timeout = COConfigurationManager.getLongParameter(persist_timeout_key, 0L);
        if (current_timeout < 0L && (pw = (passwordDetails)this.session_passwords.get(persist_pw_key)) != null && pw.getHandlerType() == pw_type) {
            return pw;
        }
        if (current_timeout > SystemTime.getCurrentTime() && (current_pw = COConfigurationManager.getStringParameter(persist_pw_key, "")).length() > 0 && (type = (int)COConfigurationManager.getLongParameter(persist_pw_key_type, 1L)) == pw_type) {
            return new passwordDetails(current_pw.toCharArray(), type);
        }
        it = this.password_handlers.iterator();
        block5: while (it.hasNext()) {
            retry_count = 0;
            last_pw_chars = null;
            provider = (CryptoManagerPasswordHandler)it.next();
            if (pw_type == 0 || pw_type == provider.getHandlerType()) ** GOTO lbl63
            continue;
lbl-1000:
            // 1 sources

            {
                try {
                    details = provider.getPassword(handler, action, retry_count > 0, reason);
                    if (details == null) continue block5;
                    pw_chars = details.getPassword();
                    if (last_pw_chars != null && Arrays.equals(last_pw_chars, pw_chars)) {
                        ++retry_count;
                        continue;
                    }
                    last_pw_chars = pw_chars;
                    salt = this.getPasswordSalt();
                    pw_bytes = new String(pw_chars).getBytes("UTF8");
                    sha1 = new SHA1();
                    sha1.update(ByteBuffer.wrap(salt));
                    sha1.update(ByteBuffer.wrap(pw_bytes));
                    encoded_pw = ByteFormatter.encodeString(sha1.digest());
                    if (tester != null && !tester.testPassword(encoded_pw.toCharArray())) {
                        ++retry_count;
                        continue;
                    }
                    persist_secs = details.getPersistForSeconds();
                    timeout = persist_secs == 0 ? 0L : (persist_secs == 0x7FFFFFFF ? 0x7FFFFFFFFFFFFFFFL : (persist_secs < 0 ? -1L : SystemTime.getCurrentTime() + (long)persist_secs * 1000L));
                    result = new passwordDetails(encoded_pw.toCharArray(), provider.getHandlerType());
                    var25_24 = this;
                    synchronized (var25_24) {
                        COConfigurationManager.setParameter(persist_timeout_key, timeout);
                        COConfigurationManager.setParameter(persist_pw_key_type, provider.getHandlerType());
                        this.session_passwords.remove(persist_pw_key);
                        COConfigurationManager.removeParameter(persist_pw_key);
                        if (timeout < 0L) {
                            this.session_passwords.put(persist_pw_key, result);
                        } else if (timeout > 0L) {
                            COConfigurationManager.setParameter(persist_pw_key, encoded_pw);
                            this.addPasswordTimer(persist_timeout_key, persist_pw_key, timeout);
                        }
                    }
                    provider.passwordOK(handler, details);
                    return result;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    continue block5;
                }
lbl63:
                // 3 sources

                ** while (retry_count < 64)
            }
lbl64:
            // 1 sources

        }
        throw new CryptoManagerPasswordException(false, "No password handlers returned a password");
    }

    protected byte[] getPasswordSalt() {
        return this.getSecureID();
    }

    protected void setSecureID(byte[] id) {
        String key = "core.crypto.id";
        COConfigurationManager.setParameter(key, id);
        COConfigurationManager.save();
        this.secure_id = id;
    }

    protected void keyChanged(CryptoHandler handler) {
        Iterator it = this.keychange_listeners.iterator();
        while (it.hasNext()) {
            try {
                ((CryptoManagerKeyListener)it.next()).keyChanged(handler);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void lockChanged(CryptoHandler handler) {
        Iterator it = this.keychange_listeners.iterator();
        while (it.hasNext()) {
            try {
                ((CryptoManagerKeyListener)it.next()).keyLockStatusChanged(handler);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void addPasswordHandler(CryptoManagerPasswordHandler handler) {
        this.password_handlers.add(handler);
    }

    @Override
    public void removePasswordHandler(CryptoManagerPasswordHandler handler) {
        this.password_handlers.remove(handler);
    }

    @Override
    public void addKeyListener(CryptoManagerKeyListener listener) {
        this.keychange_listeners.add(listener);
    }

    @Override
    public void removeKeyListener(CryptoManagerKeyListener listener) {
        this.keychange_listeners.remove(listener);
    }

    @Override
    public void setSRPParameters(byte[] salt, BigInteger verifier) {
        if (salt == null) {
            COConfigurationManager.removeParameter("core.crypto.srp.def.salt");
            COConfigurationManager.removeParameter("core.crypto.srp.def.verifier");
        } else {
            COConfigurationManager.setParameter("core.crypto.srp.def.salt", salt);
            COConfigurationManager.setParameter("core.crypto.srp.def.verifier", verifier.toByteArray());
        }
    }

    @Override
    public CryptoManager.SRPParameters getSRPParameters() {
        byte[] salt = COConfigurationManager.getByteParameter("core.crypto.srp.def.salt", null);
        byte[] verifier = COConfigurationManager.getByteParameter("core.crypto.srp.def.verifier", null);
        if (salt != null && verifier != null) {
            return new SRPParametersImpl(salt, new BigInteger(verifier));
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            String stuff = "12345";
            CryptoManagerImpl man = (CryptoManagerImpl)CryptoManagerImpl.getSingleton();
            man.addPasswordHandler(new CryptoManagerPasswordHandler(){

                @Override
                public int getHandlerType() {
                    return 1;
                }

                @Override
                public CryptoManagerPasswordHandler.passwordDetails getPassword(int handler_type, int action_type, boolean last_pw_incorrect, String reason) {
                    return new CryptoManagerPasswordHandler.passwordDetails(){

                        @Override
                        public char[] getPassword() {
                            return "trout".toCharArray();
                        }

                        @Override
                        public int getPersistForSeconds() {
                            return 10;
                        }
                    };
                }

                @Override
                public void passwordOK(int handler_type, CryptoManagerPasswordHandler.passwordDetails details) {
                }
            });
            CryptoHandler handler1 = man.getECCHandler();
            CryptoHandlerECC handler2 = new CryptoHandlerECC(man, 2);
            byte[] sig = handler1.sign(stuff.getBytes(), "h1: sign");
            System.out.println(handler1.verify(handler1.getPublicKey("h1: Test verify"), stuff.getBytes(), sig));
            handler1.lock();
            byte[] enc = handler1.encrypt(handler2.getPublicKey("h2: getPublic"), stuff.getBytes(), "h1: encrypt");
            System.out.println("pk1 = " + ByteFormatter.encodeString(handler1.getPublicKey("h1: getPublic")));
            System.out.println("pk2 = " + ByteFormatter.encodeString(handler2.getPublicKey("h2: getPublic")));
            System.out.println("dec: " + new String(handler2.decrypt(handler1.getPublicKey("h1: getPublic"), enc, "h2: decrypt")));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static class SRPParametersImpl
    implements CryptoManager.SRPParameters {
        private final byte[] salt;
        private final BigInteger verifier;

        private SRPParametersImpl(byte[] _salt, BigInteger _verifier) {
            this.salt = _salt;
            this.verifier = _verifier;
        }

        @Override
        public byte[] getSalt() {
            return this.salt;
        }

        @Override
        public BigInteger getVerifier() {
            return this.verifier;
        }
    }

    protected static class passwordDetails {
        private final char[] password;
        private final int type;

        protected passwordDetails(char[] _password, int _type) {
            this.password = _password;
            this.type = _type;
        }

        public char[] getPassword() {
            return this.password;
        }

        public int getHandlerType() {
            return this.type;
        }
    }

    public static interface passwordTester {
        public boolean testPassword(char[] var1);
    }
}

