/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.speedmanager.impl.v2;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.speedmanager.SpeedManagerLimitEstimate;
import com.biglybt.core.speedmanager.impl.v2.SMConfigurationAdapter;
import com.biglybt.core.speedmanager.impl.v2.SpeedLimitConfidence;

public class SMConfigurationAdapterImpl
implements SMConfigurationAdapter {
    @Override
    public SpeedManagerLimitEstimate getUploadLimit() {
        int upMax = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit");
        SpeedLimitConfidence upConf = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter("SpeedLimitMonitor.setting.upload.limit.conf"));
        return new SMConfigLimitEstimate(upMax, upConf);
    }

    @Override
    public SpeedManagerLimitEstimate getDownloadLimit() {
        int upMax = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit");
        SpeedLimitConfidence upConf = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter("SpeedLimitMonitor.setting.download.limit.conf"));
        return new SMConfigLimitEstimate(upMax, upConf);
    }

    @Override
    public void setUploadLimit(SpeedManagerLimitEstimate est) {
    }

    @Override
    public void setDownloadLimit(SpeedManagerLimitEstimate est) {
    }

    static class SMConfigLimitEstimate
    implements SpeedManagerLimitEstimate {
        final int bytesPerSec;
        final float limitEstimateType;

        public SMConfigLimitEstimate(int rateInBytesPerSec, SpeedLimitConfidence conf) {
            this.bytesPerSec = rateInBytesPerSec;
            this.limitEstimateType = conf.asEstimateType();
        }

        @Override
        public int getBytesPerSec() {
            return this.bytesPerSec;
        }

        @Override
        public float getEstimateType() {
            return this.limitEstimateType;
        }

        @Override
        public float getMetricRating() {
            return 0.0f;
        }

        @Override
        public int[][] getSegments() {
            return new int[0][];
        }

        @Override
        public long getWhen() {
            return 0L;
        }

        @Override
        public String getString() {
            StringBuilder sb = new StringBuilder("estimate: ");
            sb.append(this.bytesPerSec);
            sb.append(" (").append(this.limitEstimateType).append(") ");
            return sb.toString();
        }
    }
}

