/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.speedmanager.impl.v2;

import com.biglybt.core.internat.MessageText;

public class SpeedLimitConfidence
implements Comparable {
    public static final SpeedLimitConfidence NONE = new SpeedLimitConfidence("NONE", 0, -0.1f);
    public static final SpeedLimitConfidence LOW = new SpeedLimitConfidence("LOW", 1, 0.0f);
    public static final SpeedLimitConfidence MED = new SpeedLimitConfidence("MED", 2, 0.5f);
    public static final SpeedLimitConfidence HIGH = new SpeedLimitConfidence("HIGH", 3, 0.8f);
    public static final SpeedLimitConfidence ABSOLUTE = new SpeedLimitConfidence("ABSOLUTE", 4, 1.0f);
    private final String name;
    private final int order;
    private final float estimateType;
    private static final String MESSAGE_BUNDLE_PREFIX = "SpeedTestWizard.name.conf.level.";

    private SpeedLimitConfidence(String _name, int _order, float _speedLimitEstimateType) {
        this.name = _name;
        this.order = _order;
        this.estimateType = _speedLimitEstimateType;
    }

    public static SpeedLimitConfidence convertType(float type) {
        if (type <= SpeedLimitConfidence.NONE.estimateType) {
            return NONE;
        }
        if (type <= SpeedLimitConfidence.LOW.estimateType) {
            return LOW;
        }
        if (type <= SpeedLimitConfidence.MED.estimateType) {
            return MED;
        }
        if (type <= SpeedLimitConfidence.HIGH.estimateType) {
            return HIGH;
        }
        return ABSOLUTE;
    }

    public static SpeedLimitConfidence parseString(String setting) {
        SpeedLimitConfidence retVal = NONE;
        if (setting == null) {
            return retVal;
        }
        if ("NONE".equalsIgnoreCase(setting)) {
            return NONE;
        }
        if ("LOW".equalsIgnoreCase(setting)) {
            return LOW;
        }
        if ("MED".equalsIgnoreCase(setting)) {
            return MED;
        }
        if ("HIGH".equalsIgnoreCase(setting)) {
            return HIGH;
        }
        if ("ABSOLUTE".equalsIgnoreCase(setting)) {
            return ABSOLUTE;
        }
        return retVal;
    }

    public float asEstimateType() {
        return this.estimateType;
    }

    public static String asEstimateTypeString(float type) {
        if (type == -0.1f) {
            return "Unknown";
        }
        if (type == 0.0f) {
            return "Estimate";
        }
        if (type == 1.0f) {
            return "Fixed";
        }
        return "";
    }

    public String getString() {
        return this.name;
    }

    public String getInternationalizedString() {
        return MessageText.getString(MESSAGE_BUNDLE_PREFIX + this.name.toLowerCase());
    }

    public boolean isGreater(SpeedLimitConfidence limitConf) {
        return this.compareTo(limitConf) > 0;
    }

    public int compareTo(SpeedLimitConfidence limitConf) {
        return this.order - limitConf.order;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof SpeedLimitConfidence)) {
            throw new ClassCastException("Only comparable to SpeedLimitConfidence class.");
        }
        SpeedLimitConfidence casted = (SpeedLimitConfidence)obj;
        return this.compareTo(casted);
    }
}

