/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.stats.impl;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.peermanager.utils.PeerClassifier;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.xml.util.XUXmlWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class StatsWriterImpl
extends XUXmlWriter {
    final Core core;

    protected StatsWriterImpl(Core _core) {
        this.core = _core;
    }

    protected void write(File to_file) throws IOException {
        try {
            this.setOutputStream(FileUtil.newFileOutputStream(to_file));
            this.writeSupport();
        }
        finally {
            this.closeOutputStream();
        }
    }

    protected void write(OutputStream os) throws IOException {
        try {
            this.setOutputStream(os);
            this.writeSupport();
        }
        finally {
            this.flushOutputStream();
        }
    }

    protected void writeSupport() {
        this.writeLineRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        boolean export_peer_stats = COConfigurationManager.getBooleanParameter("Stats Export Peer Details");
        boolean export_file_stats = COConfigurationManager.getBooleanParameter("Stats Export File Details");
        String xsl = COConfigurationManager.getStringParameter("Stats XSL File");
        if (xsl.length() > 0) {
            this.writeLineRaw("<?xml-stylesheet type=\"text/xsl\" href=\"" + xsl + "\"?>");
        }
        this.writeLineRaw("<STATS>");
        GlobalManager global = this.core.getGlobalManager();
        try {
            this.indent();
            this.writeTag("AZUREUS_VERSION", "3.4.0.0");
            this.writeLineRaw("<GLOBAL>");
            try {
                this.indent();
                GlobalManagerStats gm_stats = global.getStats();
                this.writeRawCookedAverageTag("DOWNLOAD_SPEED", gm_stats.getDataReceiveRate() + gm_stats.getProtocolReceiveRate());
                this.writeRawCookedAverageTag("UPLOAD_SPEED", gm_stats.getDataSendRate() + gm_stats.getProtocolSendRate());
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</GLOBAL>");
            this.writeLineRaw("<DOWNLOADS>");
            try {
                this.indent();
                List<DownloadManager> _dms = global.getDownloadManagers();
                DownloadManager[] dms = new DownloadManager[_dms.size()];
                _dms.toArray(dms);
                Arrays.sort(dms, new Comparator<DownloadManager>(){

                    @Override
                    public int compare(DownloadManager d1, DownloadManager d2) {
                        int d1_index = d1.getPosition();
                        int d2_index = d2.getPosition();
                        if (d1.isDownloadComplete(false)) {
                            d1_index += 1000000;
                        }
                        if (d2.isDownloadComplete(false)) {
                            d2_index += 1000000;
                        }
                        return d1_index - d2_index;
                    }
                });
                int i = 0;
                while (i < dms.length) {
                    block43: {
                        DownloadManager dm = dms[i];
                        DownloadManagerStats dm_stats = dm.getStats();
                        DownloadManagerState dm_state = dm.getDownloadState();
                        this.writeLineRaw("<DOWNLOAD>");
                        try {
                            this.indent();
                            this.writeLineRaw("<TORRENT>");
                            TOTorrent torrent = dm.getTorrent();
                            try {
                                this.indent();
                                this.writeTag("NAME", dm.getDisplayName());
                                this.writeTag("TORRENT_FILE", dm.getTorrentFileName());
                                if (torrent != null) {
                                    this.writeTag("HASH", TorrentUtils.nicePrintTorrentHash(torrent, true));
                                    this.writeRawCookedTag("SIZE", torrent.getSize());
                                    this.writeTag("PIECE_LENGTH", torrent.getPieceLength());
                                    this.writeTag("PIECE_COUNT", torrent.getNumberOfPieces());
                                    this.writeTag("FILE_COUNT", torrent.getFiles().length);
                                    this.writeTag("COMMENT", dm.getTorrentComment());
                                    this.writeTag("CREATED_BY", dm.getTorrentCreatedBy());
                                    this.writeTag("CREATION_DATE", torrent.getCreationDate());
                                }
                            }
                            finally {
                                this.exdent();
                            }
                            this.writeLineRaw("</TORRENT>");
                            this.writeTag("DOWNLOAD_STATUS", DisplayFormatters.formatDownloadStatusDefaultLocale(dm));
                            this.writeTag("DOWNLOAD_DIR", dm.getSaveLocation().toString());
                            if (torrent != null) {
                                if (torrent.isSimpleTorrent()) {
                                    this.writeTag("TARGET_FILE", dm.getSaveLocation().toString());
                                } else {
                                    this.writeTag("TARGET_DIR", dm.getSaveLocation().toString());
                                }
                            }
                            this.writeTag("TRACKER_STATUS", dm.getTrackerStatus());
                            this.writeTag("COMPLETED", dm_stats.getCompleted());
                            this.writeTag("NON_DND_COMPLETED", dm.isDownloadComplete(false));
                            this.writeRawCookedTag("DOWNLOADED", dm_stats.getTotalDataBytesReceived());
                            this.writeRawCookedTag("UPLOADED", dm_stats.getTotalDataBytesSent());
                            this.writeRawCookedTag("DISCARDED", dm_stats.getDiscarded());
                            this.writeRawCookedAverageTag("DOWNLOAD_SPEED", dm_stats.getDataReceiveRate());
                            this.writeRawCookedAverageTag("UPLOAD_SPEED", dm_stats.getDataSendRate());
                            this.writeRawCookedAverageTag("TOTAL_SPEED", dm_stats.getTotalAverage());
                            this.writeRawCookedAverageTag("DOWNLOAD_SPEED_SMOOTH", dm_stats.getSmoothedDataReceiveRate());
                            this.writeRawCookedAverageTag("UPLOAD_SPEED_SMOOTH", dm_stats.getSmoothedDataSendRate());
                            this.writeTag("ELAPSED", dm_stats.getElapsedTime());
                            this.writeTag("ETA", DisplayFormatters.formatETA(dm_stats.getSmoothedETA()));
                            this.writeTag("HASH_FAILS", dm_stats.getHashFailCount());
                            this.writeTag("SHARE_RATIO", dm_stats.getShareRatio());
                            long[] share_prog_info = DisplayFormatters.getShareRatioProgressInfo(dm);
                            long sr = share_prog_info[0];
                            long timestamp = share_prog_info[1];
                            long next_eta = share_prog_info[2];
                            String sr_str = String.valueOf(sr);
                            String eta_str = next_eta == -1L ? "-" : (next_eta == -2L ? "\u221e" : DisplayFormatters.formatETA(next_eta));
                            String timestamp_str = timestamp <= 0L ? "-" : this.formatDate(timestamp);
                            this.writeTag("SHARE_RATIO_PROGRESS", String.valueOf(eta_str) + "; " + sr_str + "; " + timestamp_str);
                            int up_idle = dm_stats.getTimeSinceLastDataSentInSeconds();
                            this.writeRawCookedElapsedTag("UP_IDLE", up_idle);
                            long downloading_for = dm_stats.getSecondsDownloading();
                            this.writeRawCookedElapsedTag("DOWNLOADING_FOR", downloading_for);
                            long only_seeding_for = dm_stats.getSecondsOnlySeeding();
                            this.writeRawCookedElapsedTag("ONLY_SEEDING_FOR", only_seeding_for);
                            long added_time = dm_state.getLongParameter("stats.download.added.time");
                            this.writeRawCookedDateTag("DATE_ADDED", added_time);
                            long completed_time = dm_state.getLongParameter("stats.download.completed.time");
                            this.writeRawCookedDateTag("DATE_COMPLETED", completed_time);
                            long last_active = dm_state.getLongParameter("stats.download.last.active.time");
                            if (last_active == 0L) {
                                last_active = dm_state.getLongParameter("stats.download.completed.time");
                            }
                            if (last_active == 0L) {
                                last_active = dm_state.getLongParameter("stats.download.added.time");
                            }
                            this.writeRawCookedDateTag("LAST_ACTIVE", last_active);
                            this.writeTag("TOTAL_SEEDS", dm.getNbSeeds());
                            this.writeTag("TOTAL_LEECHERS", dm.getNbPeers());
                            if (export_file_stats) {
                                try {
                                    this.writeLineRaw("<FILES>");
                                    this.indent();
                                    DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                                    int j = 0;
                                    while (j < files.length) {
                                        DiskManagerFileInfo file = files[j];
                                        try {
                                            this.writeLineRaw("<FILE>");
                                            this.indent();
                                            this.writeTag("NAME", file.getTorrentFile().getRelativePath());
                                            this.writeTag("DND", file.isSkipped());
                                            this.writeRawCookedTag("SIZE", file.getLength());
                                            this.writeRawCookedTag("DOWNLOADED", file.getDownloaded());
                                        }
                                        finally {
                                            this.exdent();
                                            this.writeLineRaw("</FILE>");
                                        }
                                        ++j;
                                    }
                                }
                                finally {
                                    this.exdent();
                                    this.writeLineRaw("</FILES>");
                                }
                            }
                            if (!export_peer_stats) break block43;
                            try {
                                this.writeLineRaw("<PEERS>");
                                this.indent();
                                PEPeerManager pm = dm.getPeerManager();
                                if (pm == null) break block43;
                                for (PEPeer peer : pm.getPeers()) {
                                    PEPeerStats peer_stats = peer.getStats();
                                    byte[] id = peer.getId();
                                    if (id == null) continue;
                                    try {
                                        try {
                                            String peer_id = PeerClassifier.getPrintablePeerID(id);
                                            peer_id = StatsWriterImpl.escapeXML(peer_id);
                                            String type = StatsWriterImpl.escapeXML(peer.getClient());
                                            this.writeLineRaw("<PEER hex_id=\"" + ByteFormatter.encodeString(id) + "\" printable_id=\"" + peer_id + "\" type=\"" + type + "\">");
                                            this.indent();
                                            this.writeTag("IP", peer.getIp());
                                            this.writeTag("IS_SEED", peer.isSeed());
                                            this.writeRawCookedTag("DOWNLOADED", peer_stats.getTotalDataBytesReceived());
                                            this.writeRawCookedTag("UPLOADED", peer_stats.getTotalDataBytesSent());
                                            this.writeRawCookedAverageTag("DOWNLOAD_SPEED", peer_stats.getDataReceiveRate());
                                            this.writeRawCookedAverageTag("UPLOAD_SPEED", peer_stats.getDataSendRate());
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            this.exdent();
                                            this.writeLineRaw("</PEER>");
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        this.exdent();
                                        this.writeLineRaw("</PEER>");
                                        throw throwable;
                                    }
                                    this.exdent();
                                    this.writeLineRaw("</PEER>");
                                }
                            }
                            finally {
                                this.exdent();
                                this.writeLineRaw("</PEERS>");
                            }
                        }
                        finally {
                            this.exdent();
                        }
                    }
                    this.writeLineRaw("</DOWNLOAD>");
                    ++i;
                }
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</DOWNLOADS>");
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</STATS>");
    }

    protected void writeRawCookedTag(String tag, long raw) {
        this.writeLineRaw("<" + tag + ">");
        try {
            this.indent();
            this.writeTag("TEXT", DisplayFormatters.formatByteCountToKiBEtc(raw));
            this.writeTag("RAW", raw);
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</" + tag + ">");
    }

    protected void writeRawCookedAverageTag(String tag, long raw) {
        this.writeLineRaw("<" + tag + ">");
        try {
            this.indent();
            this.writeTag("TEXT", DisplayFormatters.formatByteCountToKiBEtcPerSec(raw));
            this.writeTag("RAW", raw);
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</" + tag + ">");
    }

    protected void writeRawCookedElapsedTag(String tag, long raw) {
        this.writeLineRaw("<" + tag + ">");
        try {
            this.indent();
            this.writeTag("TEXT", raw < 0L ? "\u221e" : TimeFormatter.format(raw));
            this.writeTag("RAW", raw < 0L ? -1L : raw);
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</" + tag + ">");
    }

    private String formatDate(long millis) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(new Date(millis).toInstant().atZone(ZoneId.systemDefault()));
    }

    protected void writeRawCookedDateTag(String tag, long raw) {
        this.writeLineRaw("<" + tag + ">");
        try {
            this.indent();
            this.writeTag("TEXT", raw < 0L ? "" : this.formatDate(raw));
            this.writeTag("RAW", raw < 0L ? -1L : raw);
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</" + tag + ">");
    }
}

