/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.stats.impl;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.stats.StatsWriterPeriodic;
import com.biglybt.core.stats.impl.StatsWriterImpl;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import java.io.File;

public class StatsWriterPeriodicImpl
implements StatsWriterPeriodic,
COConfigurationListener,
TimerEventPerformer {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static StatsWriterPeriodicImpl singleton;
    private boolean started;
    private long last_write_time = 0L;
    private final Core core;
    private TimerEventPeriodic event;
    private boolean config_enabled;
    private int config_period;
    private String config_dir;
    private String config_file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized StatsWriterPeriodic create(Core _core) {
        Class<StatsWriterPeriodicImpl> clazz = StatsWriterPeriodicImpl.class;
        synchronized (StatsWriterPeriodicImpl.class) {
            if (singleton == null) {
                singleton = new StatsWriterPeriodicImpl(_core);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    protected StatsWriterPeriodicImpl(Core _core) {
        this.core = _core;
    }

    @Override
    public void perform(TimerEvent event2) {
        this.update();
    }

    protected void update() {
        try {
            this.writeStats();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected synchronized void readConfigValues() {
        this.config_enabled = COConfigurationManager.getBooleanParameter("Stats Enable");
        this.config_period = COConfigurationManager.getIntParameter("Stats Period");
        this.config_dir = COConfigurationManager.getStringParameter("Stats Dir").trim();
        this.config_file = COConfigurationManager.getStringParameter("Stats File").trim();
        if (this.config_enabled) {
            long targetFrequency = 1000 * (this.config_period < 30000 ? this.config_period : 30000);
            if (this.event != null && this.event.getFrequency() != targetFrequency) {
                this.event.cancel();
                this.event = null;
            }
            if (this.event == null) {
                this.event = SimpleTimer.addPeriodicEvent("StatsWriter", targetFrequency, this);
            }
        } else if (this.event != null) {
            this.event.cancel();
            this.event = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStats() {
        StatsWriterPeriodicImpl statsWriterPeriodicImpl = this;
        synchronized (statsWriterPeriodicImpl) {
            if (!this.config_enabled) {
                return;
            }
            int period = this.config_period;
            long now = SystemTime.getMonotonousTime() / 1000L;
            if (now - this.last_write_time < (long)(period - 1)) {
                return;
            }
            this.last_write_time = now;
            try {
                File file_name = FileUtil.newFile(this.config_dir.isEmpty() ? File.separator : this.config_dir, this.config_file.isEmpty() ? "BiglyBT_Stats.xml" : this.config_file);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Stats Logged to '" + file_name + "'"));
                }
                new StatsWriterImpl(this.core).write(file_name);
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "Stats Logging fails", e));
            }
        }
    }

    @Override
    public void configurationSaved() {
        this.readConfigValues();
        this.writeStats();
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        COConfigurationManager.addListener(this);
        this.configurationSaved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        COConfigurationManager.removeListener(this);
        StatsWriterPeriodicImpl statsWriterPeriodicImpl = this;
        synchronized (statsWriterPeriodicImpl) {
            if (this.event != null) {
                this.event.cancel();
                this.event = null;
            }
        }
    }
}

