/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.history.DownloadHistoryManager;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionManager;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.download.DownloadManager;
import java.util.ArrayList;
import java.util.List;

public class SubscriptionUtils {
    private static final Object HS_KEY = new Object();
    private static final Object DH_DATES_KEY = new Object();
    public static final int HS_NONE = 0;
    public static final int HS_LIBRARY = 1;
    public static final int HS_ARCHIVE = 2;
    public static final int HS_HISTORY = 3;
    public static final int HS_UNKNOWN = 4;
    public static final int HS_FETCHING = 5;
    private static GlobalManager gm;
    private static DownloadManager dm;
    private static DownloadHistoryManager hm;

    public static SubscriptionDownloadDetails[] getAllCachedDownloadDetails(Core core) {
        List<com.biglybt.core.download.DownloadManager> dms = core.getGlobalManager().getDownloadManagers();
        ArrayList<SubscriptionDownloadDetails> result = new ArrayList<SubscriptionDownloadDetails>();
        SubscriptionManager sub_man = SubscriptionManagerFactory.getSingleton();
        int i = 0;
        while (i < dms.size()) {
            com.biglybt.core.download.DownloadManager dm = dms.get(i);
            TOTorrent torrent = dm.getTorrent();
            if (torrent != null) {
                try {
                    Subscription[] subs = sub_man.getKnownSubscriptions(torrent.getHash());
                    if (subs != null && subs.length > 0) {
                        if (sub_man.hideSearchTemplates()) {
                            ArrayList<Subscription> filtered = new ArrayList<Subscription>();
                            Subscription[] subscriptionArray = subs;
                            int n = subs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Subscription s = subscriptionArray[n2];
                                if (!s.isSearchTemplate()) {
                                    filtered.add(s);
                                }
                                ++n2;
                            }
                            if (filtered.size() > 0) {
                                result.add(new SubscriptionDownloadDetails(dm, filtered.toArray(new Subscription[filtered.size()])));
                            }
                        } else {
                            result.add(new SubscriptionDownloadDetails(dm, subs));
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++i;
        }
        return result.toArray(new SubscriptionDownloadDetails[result.size()]);
    }

    public static String getSubscriptionChatKey(Subscription subs) {
        try {
            String key = null;
            Engine engine = subs.getEngine();
            if (engine instanceof WebEngine) {
                WebEngine web_engine = (WebEngine)subs.getEngine();
                key = web_engine.getSearchUrl(true);
            } else {
                key = subs.getQueryKey();
            }
            if (key != null) {
                key = "Subscription: " + key;
            }
            return key;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void peekChatAsync(String net, String key, Runnable done) {
        try {
            Class<?> utils = SubscriptionUtils.class.getClassLoader().loadClass("com.biglybt.plugin.net.buddy.BuddyPluginUtils");
            if (utils != null) {
                utils.getMethod("peekChatAsync", String.class, String.class, Runnable.class).invoke(null, net, key, done);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getHashStatus(SubscriptionResult result) {
        if (result == null || result.isDeleted()) {
            return 0;
        }
        String hash_str = result.getAssetHash();
        if (hash_str == null) {
            return 4;
        }
        byte[] hash = Base32.decode(hash_str);
        if (hash == null) {
            return 4;
        }
        long now = SystemTime.getMonotonousTime();
        Object object = HS_KEY;
        synchronized (object) {
            if (gm == null) {
                Core core = CoreFactory.getSingleton();
                gm = core.getGlobalManager();
                dm = core.getPluginManager().getDefaultPluginInterface().getDownloadManager();
                hm = (DownloadHistoryManager)gm.getDownloadHistoryManager();
            }
        }
        com.biglybt.core.download.DownloadManager dl = gm.getDownloadManager(new HashWrapper(hash));
        int hs_result = dl != null ? (dl.getDownloadState().getFlag(512L) ? 5 : 1) : (dm.lookupDownloadStub(hash) != null ? 2 : (hm.getDates(hash, false) != null ? 3 : 0));
        return hs_result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getDownloadHistoryDates(SearchSubsResultBase result) {
        long time22;
        if (result == null) {
            return null;
        }
        byte[] hash = result.getHash();
        if (hash == null) {
            return null;
        }
        long now = SystemTime.getMonotonousTime();
        Object[] entry = (Object[])result.getUserData(DH_DATES_KEY);
        if (entry != null && now - (time22 = ((Long)entry[0]).longValue()) < 10000L) {
            return (long[])entry[1];
        }
        Object time22 = HS_KEY;
        synchronized (time22) {
            if (gm == null) {
                Core core = CoreFactory.getSingleton();
                gm = core.getGlobalManager();
                dm = core.getPluginManager().getDefaultPluginInterface().getDownloadManager();
                hm = (DownloadHistoryManager)gm.getDownloadHistoryManager();
            }
        }
        long[] dates = hm.getDates(hash, false);
        result.setUserData(DH_DATES_KEY, new Object[]{now + (long)RandomUtils.nextInt(2500), dates});
        return dates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getHashStatus(SearchSubsResultBase result) {
        long time22;
        if (result == null) {
            return 0;
        }
        byte[] hash = result.getHash();
        if (hash == null || hash.length != 20) {
            return 4;
        }
        long now = SystemTime.getMonotonousTime();
        Object[] entry = (Object[])result.getUserData(HS_KEY);
        if (entry != null && now - (time22 = ((Long)entry[0]).longValue()) < 10000L) {
            return (Integer)entry[1];
        }
        Object time22 = HS_KEY;
        synchronized (time22) {
            if (gm == null) {
                Core core = CoreFactory.getSingleton();
                gm = core.getGlobalManager();
                dm = core.getPluginManager().getDefaultPluginInterface().getDownloadManager();
                hm = (DownloadHistoryManager)gm.getDownloadHistoryManager();
            }
        }
        com.biglybt.core.download.DownloadManager dl = gm.getDownloadManager(new HashWrapper(hash));
        int hs_result = dl != null ? (dl.getDownloadState().getFlag(512L) ? 5 : 1) : (dm.lookupDownloadStub(hash) != null ? 2 : (hm.getDates(hash, false) != null ? 3 : 0));
        result.setUserData(HS_KEY, new Object[]{now + (long)RandomUtils.nextInt(2500), hs_result});
        return hs_result;
    }

    public static List<Subscription> getDependsOnClosure(Subscription subs) {
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        SubscriptionUtils.getDependsOn(subs, result);
        return result;
    }

    private static void getDependsOn(Subscription subs, List<Subscription> result) {
        List<Subscription> deps;
        if (subs != null && (deps = subs.getDependsOn()) != null) {
            for (Subscription dep : deps) {
                if (result.contains(dep)) continue;
                result.add(dep);
                SubscriptionUtils.getDependsOn(dep, result);
            }
        }
    }

    public static class SubscriptionDownloadDetails {
        private com.biglybt.core.download.DownloadManager download;
        private Subscription[] subscriptions;

        protected SubscriptionDownloadDetails(com.biglybt.core.download.DownloadManager dm, Subscription[] subs) {
            this.download = dm;
            this.subscriptions = subs;
        }

        public com.biglybt.core.download.DownloadManager getDownload() {
            return this.download;
        }

        public Subscription[] getSubscriptions() {
            return this.subscriptions;
        }
    }
}

