/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs.impl;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.lws.LightWeightSeed;
import com.biglybt.core.lws.LightWeightSeedAdapter;
import com.biglybt.core.lws.LightWeightSeedManager;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.MetaSearchManagerFactory;
import com.biglybt.core.metasearch.impl.web.rss.RSSEngine;
import com.biglybt.core.security.CryptoECCUtils;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionException;
import com.biglybt.core.subs.SubscriptionListener;
import com.biglybt.core.subs.SubscriptionManager;
import com.biglybt.core.subs.SubscriptionPopularityListener;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.subs.impl.SubscriptionBodyImpl;
import com.biglybt.core.subs.impl.SubscriptionHistoryImpl;
import com.biglybt.core.subs.impl.SubscriptionManagerImpl;
import com.biglybt.core.subs.impl.SubscriptionResultFilterImpl;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentCreator;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.util.JSONUtils;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.gudy.bouncycastle.util.encoders.Base64;
import org.json.simple.JSONObject;

public class SubscriptionImpl
implements Subscription,
DataSourceResolver.ExportableDataSource {
    private static final int MAX_ASSOCIATIONS;
    private static final int MIN_RECENT_ASSOC_TO_RETAIN = 16;
    private SubscriptionManagerImpl manager;
    private byte[] public_key;
    private byte[] private_key;
    private String name;
    private String name_ex;
    private int version;
    private int az_version;
    private boolean is_public;
    private boolean is_anonymous;
    private volatile int subscription_type = -1;
    private Map singleton_details;
    private byte[] hash;
    private byte[] sig;
    private int sig_data_size;
    private int add_type;
    private long add_time;
    private boolean is_subscribed;
    private int highest_prompted_version;
    private byte[] short_id;
    private String id;
    private List<association> associations = new ArrayList<association>();
    private int fixed_random;
    private long popularity = -1L;
    private long last_auto_upgrade_check = -1L;
    private boolean published;
    private boolean server_published;
    private boolean server_publication_outstanding;
    private boolean singleton_sp_attempted;
    private String local_name;
    private LightWeightSeed lws;
    private int lws_skip_check;
    private boolean destroyed;
    private Map history_map;
    private Map schedule_map;
    private Map user_data = new LightHashMap();
    private final SubscriptionHistoryImpl history;
    private String referer;
    private Map verify_cache_details;
    private boolean verify_cache_result;
    private String creator_ref;
    private String category;
    private long tag_id = -1L;
    private int view_options;
    private String parent;
    private List<String> depends_on;
    private String exec_on_new_result;
    private AtomicLong newest_result_time_next = new AtomicLong(1L);
    private volatile long newest_result_time_seq;
    private volatile long newest_result_time;
    private AtomicLong md_mutator = new AtomicLong(RandomUtils.nextAbsoluteLong());
    private static final int LT_SUBSCRIPTION_CHANGED = 1;
    private static final int LT_SUBSCRIPTION_DOWNLOADED = 2;
    private static ListenerManager<SubscriptionListener> listener_aggregator;
    private final ListenerManager<SubscriptionListener> listeners = ListenerManager.createManager("Subscription:l", new ListenerManagerDispatcher<SubscriptionListener>(){

        @Override
        public void dispatch(SubscriptionListener listener, int type, Object value) {
            listener_aggregator.dispatch(listener, type, value);
        }
    });

    static {
        int max_assoc = 256;
        try {
            max_assoc = Integer.parseInt(System.getProperty(SystemProperties.SYSPROP_SUBS_MAX_ASSOCIATIONS, "" + max_assoc));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        MAX_ASSOCIATIONS = max_assoc;
        listener_aggregator = ListenerManager.createAsyncManager("Subscription:a", new ListenerManagerDispatcher<SubscriptionListener>(){

            @Override
            public void dispatch(SubscriptionListener listener, int type, Object _value) {
                Object[] value = (Object[])_value;
                Subscription subs = (Subscription)value[0];
                switch (type) {
                    case 1: {
                        listener.subscriptionChanged(subs, (Integer)value[1]);
                        break;
                    }
                    case 2: {
                        listener.subscriptionDownloaded(subs);
                    }
                }
            }
        });
    }

    protected static byte[] intToBytes(int version) {
        return new byte[]{(byte)(version >> 24), (byte)(version >> 16), (byte)(version >> 8), (byte)version};
    }

    protected static int bytesToInt(byte[] bytes) {
        return bytes[0] << 24 & 0xFF000000 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
    }

    protected static String getSkeletonJSON(Engine engine, int check_interval_mins) {
        JSONObject map = new JSONObject();
        map.put("engine_id", new Long(engine.getId()));
        map.put("search_term", "");
        map.put("filters", new HashMap());
        map.put("options", new HashMap());
        HashMap<String, Serializable> schedule = new HashMap<String, Serializable>();
        schedule.put("interval", new Long(check_interval_mins));
        ArrayList<String> days = new ArrayList<String>();
        int i = 1;
        while (i <= 7) {
            days.add(String.valueOf(i));
            ++i;
        }
        schedule.put("days", days);
        map.put("schedule", schedule);
        SubscriptionImpl.embedEngines(map, engine);
        return JSONUtils.encodeToJSON(map);
    }

    protected static String getSkeletonJSON(Engine engine, String term, String networks, int check_interval_mins) {
        JSONObject map = new JSONObject();
        map.put("engine_id", new Long(engine.getId()));
        map.put("search_term", term);
        if (networks != null) {
            map.put("networks", networks);
        }
        map.put("filters", new HashMap());
        map.put("options", new HashMap());
        HashMap<String, Serializable> schedule = new HashMap<String, Serializable>();
        schedule.put("interval", new Long(check_interval_mins));
        ArrayList<String> days = new ArrayList<String>();
        int i = 1;
        while (i <= 7) {
            days.add(String.valueOf(i));
            ++i;
        }
        schedule.put("days", days);
        map.put("schedule", schedule);
        SubscriptionImpl.embedEngines(map, engine);
        return JSONUtils.encodeToJSON(map);
    }

    protected SubscriptionImpl(SubscriptionManagerImpl _manager, String _name, boolean _public, boolean _anonymous, Map _singleton_details, String _json_content, int _add_type) throws SubscriptionException {
        this.manager = _manager;
        this.history_map = new HashMap();
        this.history = new SubscriptionHistoryImpl(this.manager, this);
        this.name = _name;
        this.is_public = _public;
        this.is_anonymous = _anonymous;
        this.singleton_details = _singleton_details;
        this.version = 1;
        this.az_version = 1;
        this.add_type = _add_type;
        this.add_time = SystemTime.getCurrentTime();
        this.is_subscribed = true;
        try {
            KeyPair kp = CryptoECCUtils.createKeys();
            this.public_key = CryptoECCUtils.keyToRawdata(kp.getPublic());
            this.private_key = CryptoECCUtils.keyToRawdata(kp.getPrivate());
            this.fixed_random = RandomUtils.nextInt();
            this.init();
            String json_content = this.embedEngines(_json_content);
            SubscriptionBodyImpl body = new SubscriptionBodyImpl(this.manager, this.name, this.is_public, this.is_anonymous, json_content, this.public_key, this.version, this.az_version, this.singleton_details);
            this.syncToBody(body);
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to create subscription", e);
        }
    }

    protected SubscriptionImpl(SubscriptionManagerImpl _manager, Map map) throws IOException {
        this.manager = _manager;
        this.fromMap(map);
        this.history = new SubscriptionHistoryImpl(this.manager, this);
        this.init();
    }

    protected SubscriptionImpl(SubscriptionManagerImpl _manager, SubscriptionBodyImpl _body, int _add_type, boolean _is_subscribed) throws SubscriptionException {
        this.manager = _manager;
        this.history_map = new HashMap();
        this.history = new SubscriptionHistoryImpl(this.manager, this);
        this.syncFromBody(_body);
        this.add_type = _add_type;
        this.add_time = SystemTime.getCurrentTime();
        this.is_subscribed = _is_subscribed;
        this.fixed_random = RandomUtils.nextInt();
        this.init();
        this.syncToBody(_body);
    }

    protected void syncFromBody(SubscriptionBodyImpl body) throws SubscriptionException {
        this.public_key = body.getPublicKey();
        this.version = body.getVersion();
        this.az_version = body.getAZVersion();
        this.name = body.getName();
        this.is_public = body.isPublic();
        this.is_anonymous = body.isAnonymous();
        this.singleton_details = body.getSingletonDetails();
        if (this.az_version > 1) {
            throw new SubscriptionException(MessageText.getString("subscription.version.bad", new String[]{this.name}));
        }
    }

    protected void syncToBody(SubscriptionBodyImpl body) throws SubscriptionException {
        body.writeVuzeFile(this);
        this.hash = body.getHash();
        this.sig = body.getSig();
        this.sig_data_size = body.getSigDataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map toMap() throws IOException {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", this.name.getBytes(Constants.UTF_8));
            map.put("public_key", this.public_key);
            map.put("version", new Long(this.version));
            map.put("az_version", new Long(this.az_version));
            map.put("is_public", new Long(this.is_public ? 1 : 0));
            map.put("is_anonymous", new Long(this.is_anonymous ? 1 : 0));
            if (this.singleton_details != null) {
                map.put("sin_details", this.singleton_details);
                map.put("spa", new Long(this.singleton_sp_attempted ? 1 : 0));
            }
            if (this.local_name != null) {
                map.put("local_name", this.local_name);
            }
            map.put("hash", this.hash);
            map.put("sig", this.sig);
            map.put("sig_data_size", new Long(this.sig_data_size));
            if (this.private_key != null) {
                map.put("private_key", this.private_key);
            }
            map.put("add_type", new Long(this.add_type));
            map.put("add_time", new Long(this.add_time));
            map.put("subscribed", new Long(this.is_subscribed ? 1 : 0));
            map.put("pop", new Long(this.popularity));
            map.put("rand", new Long(this.fixed_random));
            map.put("hupv", new Long(this.highest_prompted_version));
            map.put("sp", new Long(this.server_published ? 1 : 0));
            map.put("spo", new Long(this.server_publication_outstanding ? 1 : 0));
            if (this.associations.size() > 0) {
                ArrayList l_assoc = new ArrayList();
                map.put("assoc", l_assoc);
                int i = 0;
                while (i < this.associations.size()) {
                    association assoc = this.associations.get(i);
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    l_assoc.add(m);
                    m.put("h", assoc.getHash());
                    m.put("w", new Long(assoc.getWhen()));
                    ++i;
                }
            }
            map.put("history", this.history_map);
            if (this.creator_ref != null) {
                map.put("cref", this.creator_ref.getBytes(Constants.UTF_8));
            }
            if (this.category != null) {
                map.put("cat", this.category.getBytes(Constants.UTF_8));
            }
            if (this.tag_id != -1L) {
                map.put("tag", this.tag_id);
            }
            if (this.view_options != 0) {
                map.put("vo", this.view_options);
            }
            if (this.parent != null) {
                map.put("par", this.parent.getBytes(Constants.UTF_8));
            }
            if (this.depends_on != null) {
                ArrayList<byte[]> dep = new ArrayList<byte[]>();
                map.put("dep", dep);
                for (String s : this.depends_on) {
                    dep.add(s.getBytes(Constants.UTF_8));
                }
            }
            if (this.exec_on_new_result != null) {
                map.put("eonr", this.exec_on_new_result.getBytes(Constants.UTF_8));
            }
            return map;
        }
    }

    protected void fromMap(Map map) throws IOException {
        byte[] b_eonr;
        List b_depends_on;
        byte[] b_parent;
        Long l_vo;
        Long l_tag_id;
        byte[] b_cat;
        byte[] b_cref;
        List l_assoc;
        byte[] b_local_name;
        this.name = new String((byte[])map.get("name"), Constants.UTF_8);
        this.public_key = (byte[])map.get("public_key");
        this.private_key = (byte[])map.get("private_key");
        this.version = ((Long)map.get("version")).intValue();
        this.az_version = (int)MapUtils.importLong(map, "az_version", 1L);
        this.is_public = ((Long)map.get("is_public")).intValue() == 1;
        Long anon = (Long)map.get("is_anonymous");
        this.is_anonymous = anon != null && anon == 1L;
        this.singleton_details = (Map)map.get("sin_details");
        this.hash = (byte[])map.get("hash");
        this.sig = (byte[])map.get("sig");
        this.sig_data_size = ((Long)map.get("sig_data_size")).intValue();
        this.fixed_random = ((Long)map.get("rand")).intValue();
        this.add_type = ((Long)map.get("add_type")).intValue();
        this.add_time = (Long)map.get("add_time");
        this.is_subscribed = ((Long)map.get("subscribed")).intValue() == 1;
        this.popularity = (Long)map.get("pop");
        this.highest_prompted_version = ((Long)map.get("hupv")).intValue();
        this.server_published = ((Long)map.get("sp")).intValue() == 1;
        this.server_publication_outstanding = ((Long)map.get("spo")).intValue() == 1;
        Long l_spa = (Long)map.get("spa");
        if (l_spa != null) {
            boolean bl = this.singleton_sp_attempted = l_spa == 1L;
        }
        if ((b_local_name = (byte[])map.get("local_name")) != null) {
            this.local_name = new String(b_local_name, Constants.UTF_8);
        }
        if ((l_assoc = (List)map.get("assoc")) != null) {
            int i = 0;
            while (i < l_assoc.size()) {
                Map m = (Map)l_assoc.get(i);
                byte[] hash = (byte[])m.get("h");
                long when = (Long)m.get("w");
                this.associations.add(new association(hash, when));
                ++i;
            }
        }
        this.history_map = (Map)map.get("history");
        if (this.history_map == null) {
            this.history_map = new HashMap();
        }
        if ((b_cref = (byte[])map.get("cref")) != null) {
            this.creator_ref = new String(b_cref, Constants.UTF_8);
        }
        if ((b_cat = (byte[])map.get("cat")) != null) {
            this.category = new String(b_cat, Constants.UTF_8);
        }
        if ((l_tag_id = (Long)map.get("tag")) != null) {
            this.tag_id = l_tag_id;
        }
        if ((l_vo = (Long)map.get("vo")) != null) {
            this.view_options = l_vo.intValue();
        }
        if ((b_parent = (byte[])map.get("par")) != null) {
            this.parent = new String(b_parent, Constants.UTF_8);
        }
        if ((b_depends_on = (List)map.get("dep")) != null) {
            this.depends_on = new ArrayList<String>(b_depends_on.size());
            for (byte[] b : b_depends_on) {
                this.depends_on.add(new String(b, Constants.UTF_8));
            }
        }
        if ((b_eonr = (byte[])map.get("eonr")) != null) {
            this.exec_on_new_result = new String(b_eonr, Constants.UTF_8);
        }
    }

    @Override
    public DataSourceResolver.ExportedDataSource exportDataSource() {
        return new DataSourceResolver.ExportedDataSource(){

            @Override
            public Class<? extends DataSourceResolver.DataSourceImporter> getExporter() {
                return SubscriptionManagerImpl.class;
            }

            @Override
            public Map<String, Object> getExport() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", SubscriptionImpl.this.getID());
                map.put("version", SubscriptionImpl.this.version);
                map.put("anon", SubscriptionImpl.this.is_anonymous ? 1L : 0L);
                if (SubscriptionImpl.this.singleton_details != null) {
                    HashMap<String, String> sd = new HashMap<String, String>(SubscriptionImpl.this.singleton_details);
                    byte[] key = (byte[])sd.get("key");
                    if (key instanceof byte[]) {
                        sd.put("key", Base32.encode(key));
                    }
                    map.put("singleton", sd);
                }
                int vo = SubscriptionImpl.this.getViewOptions();
                map.put("vo", vo);
                SubscriptionHistoryImpl history = SubscriptionImpl.this.getHistory();
                map.put("h_cm", history.getCheckFrequencyMins());
                String[] dl_nets = history.getDownloadNetworks();
                if (dl_nets != null) {
                    map.put("h_dln", Arrays.asList(dl_nets));
                }
                return map;
            }
        };
    }

    protected Map getScheduleConfig() {
        if (this.schedule_map == null) {
            try {
                Map map = JSONUtils.decodeJSON(this.getJSON());
                this.schedule_map = (Map)map.get("schedule");
                if (this.schedule_map == null) {
                    this.schedule_map = new HashMap();
                }
            }
            catch (Throwable e) {
                this.log("Failed to load schedule", e);
                this.schedule_map = new HashMap();
            }
        }
        return this.schedule_map;
    }

    protected Map getHistoryConfig() {
        return this.history_map;
    }

    protected void updateHistoryConfig(Map _history_map, int reason) {
        this.history_map = _history_map;
        this.fireChanged(reason);
    }

    protected void upgrade(SubscriptionBodyImpl body) throws SubscriptionException {
        this.syncFromBody(body);
        this.syncToBody(body);
        this.fireChanged(1);
    }

    protected void init() {
        this.short_id = SubscriptionBodyImpl.deriveShortID(this.public_key, this.singleton_details);
        this.id = null;
    }

    public boolean isSingleton() {
        return this.singleton_details != null;
    }

    @Override
    public boolean isShareable() {
        try {
            return this.getEngine().isShareable() && !this.isSingleton();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    @Override
    public List<Subscription> getDependsOn() {
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        if (this.depends_on != null) {
            for (String id : this.depends_on) {
                try {
                    SubscriptionImpl sub = this.manager.getSubscriptionByID(id);
                    if (sub == null || result.contains(sub)) continue;
                    result.add(sub);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public void setDependsOn(List<Subscription> subs) {
        if (subs == null || subs.isEmpty()) {
            this.depends_on = null;
        } else {
            this.depends_on = new ArrayList<String>(subs.size());
            for (Subscription s : subs) {
                String id;
                if (s == this || this.depends_on.contains(id = s.getID())) continue;
                this.depends_on.add(id);
            }
        }
        this.manager.configDirty(this, 1);
        this.fireChanged(1);
    }

    @Override
    public String getExecuteOnNewResult() {
        return this.exec_on_new_result;
    }

    @Override
    public void setExecuteOnNewResult(String eonr) {
        this.exec_on_new_result = eonr == null || eonr.isEmpty() ? null : eonr;
        this.manager.configDirty(this, 1);
        this.fireChanged(1);
    }

    @Override
    public boolean isSubscriptionTemplate() {
        return this.getSubscriptionType() == 2;
    }

    private int getSubscriptionType() {
        if (this.subscription_type == -1) {
            if (this.getName(false).startsWith("Search Template:")) {
                this.subscription_type = 1;
            } else {
                this.subscription_type = 0;
                try {
                    Engine engine = this.getEngine();
                    if (engine instanceof RSSEngine && ((RSSEngine)engine).getSearchUrl().startsWith("subscription:?type=template")) {
                        this.subscription_type = 2;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        return this.subscription_type;
    }

    @Override
    public boolean isSearchTemplate() {
        return this.getSubscriptionType() == 1;
    }

    protected Map getSingletonDetails() {
        return this.singleton_details;
    }

    protected boolean getSingletonPublishAttempted() {
        return this.singleton_sp_attempted;
    }

    protected void setSingletonPublishAttempted() {
        if (!this.singleton_sp_attempted) {
            this.singleton_sp_attempted = true;
            this.manager.configDirty(this, 1);
        }
    }

    @Override
    public String getName() {
        return this.getName(true);
    }

    @Override
    public String getName(boolean use_local) {
        return this.local_name == null ? this.name : this.local_name;
    }

    @Override
    public String getURI() {
        String str = "sub:?name=" + UrlUtils.encode(this.getName()) + "&id=" + Base32.encode(this.getShortID()) + "&v=" + this.getVersion();
        if (this.is_anonymous) {
            str = String.valueOf(str) + "&a=1";
        }
        return "azplug:?id=subscription&arg=" + UrlUtils.encode(str);
    }

    @Override
    public void requestAttention() {
        this.manager.selectSubscription(this);
    }

    @Override
    public void setLocalName(String str) {
        this.local_name = str;
        this.manager.configDirty(this, 1);
        this.fireChanged(1);
    }

    @Override
    public void setName(String _name) throws SubscriptionException {
        if (!this.name.equals(_name)) {
            boolean ok = false;
            String old_name = this.name;
            int old_version = this.version++;
            try {
                this.name = _name;
                SubscriptionBodyImpl body = new SubscriptionBodyImpl(this.manager, this);
                this.syncToBody(body);
                this.versionUpdated(body, false);
                ok = true;
            }
            finally {
                if (!ok) {
                    this.name = old_name;
                    this.version = old_version;
                }
            }
            this.fireChanged(1);
        }
    }

    @Override
    public String getNameEx() {
        if (this.name_ex == null) {
            try {
                Map map = JSONUtils.decodeJSON(this.getJSON());
                String search_term = (String)map.get("search_term");
                Map filters = (Map)map.get("filters");
                Engine engine = this.manager.getEngine(this, map, true);
                String engine_name = engine.getNameEx();
                this.name_ex = this.name.startsWith(engine_name) ? this.name : (engine_name.startsWith(this.name) ? engine_name : String.valueOf(this.name) + ": " + engine.getNameEx());
                if (search_term != null && search_term.length() > 0) {
                    this.name_ex = String.valueOf(this.name_ex) + ", query=" + search_term;
                }
                if (filters != null && filters.size() > 0) {
                    this.name_ex = String.valueOf(this.name_ex) + ", filters=" + new SubscriptionResultFilterImpl(this, filters).getString();
                }
            }
            catch (Throwable e) {
                this.name_ex = String.valueOf(this.name) + ": " + Debug.getNestedExceptionMessage(e);
            }
        }
        return this.name_ex;
    }

    @Override
    public String getQueryKey() {
        try {
            Map map = JSONUtils.decodeJSON(this.getJSON());
            String search_term = (String)map.get("search_term");
            Map filters = (Map)map.get("filters");
            Engine engine = this.manager.getEngine(this, map, true);
            String name = engine.getNameEx();
            if (search_term != null && search_term.length() > 0) {
                name = String.valueOf(name) + ", query=" + search_term;
            }
            if (filters != null && filters.size() > 0) {
                name = String.valueOf(name) + ", filters=" + new SubscriptionResultFilterImpl(this, filters).getString();
            }
            return name;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public long getAddTime() {
        return this.add_time;
    }

    @Override
    public int getAddType() {
        return this.add_type;
    }

    @Override
    public boolean isPublic() {
        return this.is_public;
    }

    @Override
    public boolean isAnonymous() {
        return this.is_anonymous;
    }

    @Override
    public void setPublic(boolean _is_public) throws SubscriptionException {
        if (this.is_public != _is_public) {
            boolean ok = false;
            boolean old_public = this.is_public;
            int old_version = this.version++;
            try {
                this.is_public = _is_public;
                SubscriptionBodyImpl body = new SubscriptionBodyImpl(this.manager, this);
                this.syncToBody(body);
                this.versionUpdated(body, false);
                ok = true;
            }
            finally {
                if (!ok) {
                    this.version = old_version;
                    this.is_public = old_public;
                }
            }
            this.fireChanged(1);
        }
    }

    protected boolean getServerPublicationOutstanding() {
        return this.server_publication_outstanding;
    }

    protected void setServerPublicationOutstanding() {
        if (!this.server_publication_outstanding) {
            this.server_publication_outstanding = true;
            this.fireChanged(1);
        }
    }

    protected void setServerPublished() {
        if (this.server_publication_outstanding || !this.server_published) {
            this.server_published = true;
            this.server_publication_outstanding = false;
            this.fireChanged(1);
        }
    }

    protected boolean getServerPublished() {
        return this.server_published;
    }

    @Override
    public String getJSON() throws SubscriptionException {
        try {
            SubscriptionBodyImpl body = new SubscriptionBodyImpl(this.manager, this);
            return body.getJSON();
        }
        catch (Throwable e) {
            this.history.setFatalError(Debug.getNestedExceptionMessage(e));
            if (e instanceof SubscriptionException) {
                throw (SubscriptionException)e;
            }
            throw new SubscriptionException("Failed to read subscription", e);
        }
    }

    @Override
    public boolean setJSON(String _json) throws SubscriptionException {
        SubscriptionBodyImpl body;
        String old_json;
        String json = this.embedEngines(_json);
        if (!json.equals(old_json = (body = new SubscriptionBodyImpl(this.manager, this)).getJSON())) {
            boolean ok = false;
            int old_version = this.version++;
            try {
                body.setJSON(json);
                this.syncToBody(body);
                this.versionUpdated(body, true);
                this.referer = null;
                ok = true;
            }
            finally {
                if (!ok) {
                    this.version = old_version;
                }
            }
            this.fireChanged(1);
            return true;
        }
        return false;
    }

    protected String embedEngines(String json_in) {
        Map map = JSONUtils.decodeJSON(json_in);
        long engine_id = (Long)map.get("engine_id");
        String json_out = json_in;
        if (engine_id >= Integer.MAX_VALUE || engine_id < 0L) {
            Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngine(engine_id);
            if (engine == null) {
                this.log("Private search template with id '" + engine_id + "' not found!!!!");
            } else {
                try {
                    SubscriptionImpl.embedEngines(map, engine);
                    json_out = JSONUtils.encodeToJSON(map);
                    this.log("Embedded private search template '" + engine.getName() + "'");
                }
                catch (Throwable e) {
                    this.log("Failed to embed private search template", e);
                }
            }
        }
        return json_out;
    }

    protected static void embedEngines(Map map, Engine engine) {
        HashMap engines = new HashMap();
        map.put("engines", engines);
        HashMap<String, String> engine_map = new HashMap<String, String>();
        try {
            String engine_str = new String(Base64.encode(BEncoder.encode(engine.exportToBencodedMap())), Constants.UTF_8);
            engine_map.put("content", engine_str);
            engines.put(String.valueOf(engine.getId()), engine_map);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected Engine extractEngine(Map json_map, long id) {
        Map engine_map;
        Map engines = (Map)json_map.get("engines");
        if (engines != null && (engine_map = (Map)engines.get(String.valueOf(id))) != null) {
            String engine_str = (String)engine_map.get("content");
            try {
                Map<String, Object> map = BDecoder.decode(Base64.decode(engine_str.getBytes(Constants.UTF_8)));
                return MetaSearchManagerFactory.getSingleton().getMetaSearch().importFromBEncodedMap(map);
            }
            catch (Throwable e) {
                this.log("failed to import engine", e);
            }
        }
        return null;
    }

    @Override
    public Subscription cloneWithNewEngine(Engine engine) throws SubscriptionException {
        try {
            String json = this.getJSON();
            Map map = JSONUtils.decodeJSON(json);
            long id = (Long)map.get("engine_id");
            if (id == engine.getId()) {
                SubscriptionImpl.embedEngines(map, engine);
                SubscriptionImpl subs = new SubscriptionImpl(this.manager, this.getName(), engine.isPublic(), this.isAnonymous(), null, JSONUtils.encodeToJSON(map), 1);
                subs = this.manager.addSubscription(subs);
                this.setLocalName(String.valueOf(this.getName(false)) + " (old)");
                return subs;
            }
            throw new SubscriptionException("Engine mismatch");
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to export engine", e);
        }
    }

    @Override
    public Engine getEngine() throws SubscriptionException {
        return this.getEngine(true);
    }

    protected Engine getEngine(boolean local_only) throws SubscriptionException {
        Map map = JSONUtils.decodeJSON(this.getJSON());
        return this.manager.getEngine(this, map, local_only);
    }

    protected void engineUpdated(Engine engine) {
        try {
            String json = this.getJSON();
            Map map = JSONUtils.decodeJSON(json);
            long id = (Long)map.get("engine_id");
            if (id == engine.getId() && this.setJSON(json)) {
                this.log("Engine has been updated, saved");
            }
        }
        catch (Throwable e) {
            this.log("Engine update failed", e);
        }
    }

    @Override
    public boolean setDetails(String _name, boolean _is_public, String _json) throws SubscriptionException {
        SubscriptionBodyImpl body;
        String old_json;
        boolean json_changed;
        boolean bl = json_changed = !(_json = this.embedEngines(_json)).equals(old_json = (body = new SubscriptionBodyImpl(this.manager, this)).getJSON());
        if (!_name.equals(this.name) || _is_public != this.is_public || json_changed) {
            boolean ok = false;
            String old_name = this.name;
            boolean old_public = this.is_public;
            int old_version = this.version++;
            try {
                this.is_public = _is_public;
                this.name = _name;
                body.setJSON(_json);
                this.syncToBody(body);
                this.versionUpdated(body, json_changed);
                ok = true;
            }
            finally {
                if (!ok) {
                    this.version = old_version;
                    this.is_public = old_public;
                    this.name = old_name;
                }
            }
            this.fireChanged(1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void versionUpdated(SubscriptionBodyImpl body, boolean json_changed) {
        if (json_changed) {
            try {
                Map map = JSONUtils.decodeJSON(body.getJSON());
                this.schedule_map = (Map)map.get("schedule");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.name_ex = null;
        if (this.is_public) {
            this.manager.updatePublicSubscription(this);
            this.setPublished(false);
            SubscriptionImpl subscriptionImpl = this;
            synchronized (subscriptionImpl) {
                int i = 0;
                while (i < this.associations.size()) {
                    this.associations.get(i).setPublished(false);
                    ++i;
                }
            }
        }
    }

    @Override
    public byte[] getPublicKey() {
        return this.public_key;
    }

    public byte[] getShortID() {
        return this.short_id;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = Base32.encode(this.getShortID());
        }
        return this.id;
    }

    protected byte[] getPrivateKey() {
        return this.private_key;
    }

    protected int getFixedRandom() {
        return this.fixed_random;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getAZVersion() {
        return this.az_version;
    }

    protected void setHighestUserPromptedVersion(int v) {
        if (v < this.version) {
            v = this.version;
        }
        if (this.highest_prompted_version != v) {
            this.highest_prompted_version = v;
            this.fireChanged(1);
        }
    }

    protected int getHighestUserPromptedVersion() {
        return this.highest_prompted_version;
    }

    @Override
    public int getHighestVersion() {
        return Math.max(this.version, this.highest_prompted_version);
    }

    @Override
    public void resetHighestVersion() {
        if (this.highest_prompted_version > 0) {
            this.highest_prompted_version = 0;
            this.fireChanged(1);
            this.manager.checkUpgrade(this);
        }
    }

    @Override
    public boolean isMine() {
        if (this.private_key == null) {
            return false;
        }
        return !this.isSingleton() || this.add_type == 1;
    }

    @Override
    public boolean isUpdateable() {
        return this.private_key != null;
    }

    @Override
    public boolean isSubscribed() {
        return this.is_subscribed;
    }

    @Override
    public void setSubscribed(boolean s) {
        if (this.is_subscribed != s) {
            this.is_subscribed = s;
            if (this.is_subscribed) {
                this.manager.setSelected(this);
            } else {
                this.reset();
            }
            this.fireChanged(1);
        }
    }

    @Override
    public boolean isAutoDownloadSupported() {
        return this.history.isAutoDownloadSupported();
    }

    @Override
    public void getPopularity(final SubscriptionPopularityListener listener) throws SubscriptionException {
        new AEThread2("subs:popwait", true){

            @Override
            public void run() {
                try {
                    SubscriptionImpl.this.manager.getPopularity(SubscriptionImpl.this, new SubscriptionPopularityListener(){

                        @Override
                        public void gotPopularity(long pop) {
                            if (pop != SubscriptionImpl.this.popularity) {
                                SubscriptionImpl.this.popularity = pop;
                                SubscriptionImpl.this.fireChanged(1);
                            }
                            listener.gotPopularity(SubscriptionImpl.this.popularity);
                        }

                        @Override
                        public void failed(SubscriptionException e) {
                            if (SubscriptionImpl.this.popularity == -1L) {
                                listener.failed(new SubscriptionException("Failed to read popularity", e));
                            } else {
                                listener.gotPopularity(SubscriptionImpl.this.popularity);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    if (SubscriptionImpl.this.popularity == -1L) {
                        listener.failed(new SubscriptionException("Failed to read popularity", e));
                    }
                    listener.gotPopularity(SubscriptionImpl.this.popularity);
                }
            }
        }.start();
    }

    @Override
    public long getCachedPopularity() {
        return this.popularity;
    }

    protected void setCachedPopularity(long pop) {
        if (pop != this.popularity) {
            this.popularity = pop;
            this.fireChanged(1);
        }
    }

    @Override
    public String getReferer() {
        if (this.referer == null) {
            try {
                Map map = JSONUtils.decodeJSON(this.getJSON());
                Engine engine = this.manager.getEngine(this, map, false);
                if (engine != null) {
                    this.referer = engine.getReferer();
                }
            }
            catch (Throwable e) {
                this.log("Failed to get referer", e);
            }
            if (this.referer == null) {
                this.referer = "";
            }
        }
        return this.referer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPublish() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            if (this.destroyed) {
                return;
            }
            if (this.isSingleton()) {
                return;
            }
            if (!this.isSubscribed()) {
                return;
            }
            if (this.popularity > 100L) {
                if (this.lws_skip_check == 2) {
                    return;
                }
                if (this.lws_skip_check == 0) {
                    if (RandomUtils.nextInt((int)((this.popularity + 99L) / 100L)) == 0) {
                        this.lws_skip_check = 1;
                    } else {
                        this.lws_skip_check = 2;
                        return;
                    }
                }
            }
            if (this.hash != null) {
                boolean create = false;
                if (this.lws == null) {
                    create = true;
                } else if (!Arrays.equals(this.lws.getHash().getBytes(), this.hash)) {
                    this.lws.remove();
                    create = true;
                }
                if (create) {
                    try {
                        File original_data_location = this.manager.getVuzeFile(this);
                        if (original_data_location.exists()) {
                            File versioned_data_location = FileUtil.newFile(original_data_location.getParent(), String.valueOf(original_data_location.getName()) + "." + this.getVersion());
                            if (!versioned_data_location.exists() && !FileUtil.copyFile(original_data_location, versioned_data_location)) {
                                throw new Exception("Failed to copy file to '" + versioned_data_location + "'");
                            }
                            this.lws = LightWeightSeedManager.getSingleton().add(this.getName(), new HashWrapper(this.hash), TorrentUtils.getDecentralisedEmptyURL(), versioned_data_location, this.isAnonymous() ? "I2P" : "Public", new LightWeightSeedAdapter(){

                                @Override
                                public TOTorrent getTorrent(byte[] hash, URL announce_url, File data_location) throws Exception {
                                    SubscriptionImpl.this.log("Generating light-weight torrent: hash=" + ByteFormatter.encodeString(hash));
                                    TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(data_location, announce_url, 262144L);
                                    TOTorrent t = creator.create();
                                    t.setHashOverride(hash);
                                    return t;
                                }
                            });
                        }
                    }
                    catch (Throwable e) {
                        this.log("Failed to create light-weight-seed", e);
                    }
                }
            }
        }
    }

    protected synchronized boolean canAutoUpgradeCheck() {
        if (this.isSingleton()) {
            return false;
        }
        long now = SystemTime.getMonotonousTime();
        if (this.last_auto_upgrade_check == -1L || now - this.last_auto_upgrade_check > 14400000L) {
            this.last_auto_upgrade_check = now;
            return true;
        }
        return false;
    }

    @Override
    public void addAssociation(byte[] hash) {
        if (hash.length != 20) {
            Debug.out("Invalid hash: " + ByteFormatter.encodeString(hash));
            return;
        }
        this.addAssociationSupport(hash, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean addAssociationSupport(byte[] hash, boolean internal) {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            int i = 0;
            while (true) {
                if (i >= this.associations.size()) {
                    this.associations.add(new association(hash, SystemTime.getCurrentTime()));
                    if (MAX_ASSOCIATIONS > 0 && this.associations.size() > MAX_ASSOCIATIONS) {
                        this.associations.remove(RandomUtils.nextInt(MAX_ASSOCIATIONS - 16));
                    }
                    break;
                }
                association assoc = this.associations.get(i);
                if (Arrays.equals(assoc.getHash(), hash)) {
                    return false;
                }
                ++i;
            }
        }
        if (!internal) {
            this.fireChanged(1);
            this.manager.associationAdded(this, hash);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasAssociation(byte[] hash) {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            int i = 0;
            while (true) {
                if (i >= this.associations.size()) {
                    return false;
                }
                association assoc = this.associations.get(i);
                if (Arrays.equals(assoc.getHash(), hash)) {
                    return true;
                }
                ++i;
            }
        }
    }

    @Override
    public void addPotentialAssociation(String result_id, String key) {
        this.manager.addPotentialAssociation(this, result_id, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAssociationCount() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            return this.associations.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected association getAssociationForPublish() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            int num_assoc = this.associations.size();
            int i = num_assoc - 1;
            while (i >= Math.max(0, num_assoc - 16)) {
                association assoc = this.associations.get(i);
                if (!assoc.getPublished()) {
                    assoc.setPublished(true);
                    return assoc;
                }
                --i;
            }
            int rem = this.associations.size() - 16;
            if (rem > 0) {
                ArrayList<association> l = new ArrayList<association>(this.associations.subList(0, rem));
                Collections.shuffle(l);
                int i2 = 0;
                while (i2 < l.size()) {
                    association assoc = (association)l.get(i2);
                    if (!assoc.getPublished()) {
                        assoc.setPublished(true);
                        return assoc;
                    }
                    ++i2;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAssociationsRemainingForPublish() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            int result = 0;
            for (association a : this.associations) {
                if (a.getPublished()) continue;
                ++result;
            }
            return result;
        }
    }

    protected boolean getPublished() {
        return this.published;
    }

    protected void setPublished(boolean b) {
        this.published = b;
    }

    protected int getVerifiedPublicationVersion(Map details) {
        if (this.isSingleton()) {
            return this.getVersion();
        }
        if (!this.verifyPublicationDetails(details)) {
            return -1;
        }
        return SubscriptionImpl.getPublicationVersion(details);
    }

    protected static int getPublicationVersion(Map details) {
        return ((Long)details.get("v")).intValue();
    }

    protected byte[] getPublicationHash() {
        return this.hash;
    }

    protected static byte[] getPublicationHash(Map details) {
        return (byte[])details.get("h");
    }

    protected static int getPublicationSize(Map details) {
        return ((Long)details.get("z")).intValue();
    }

    protected Map getPublicationDetails() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("v", new Long(this.version));
        if (this.singleton_details == null) {
            result.put("h", this.hash);
            result.put("z", new Long(this.sig_data_size));
            result.put("s", this.sig);
        } else {
            result.put("x", this.singleton_details);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifyPublicationDetails(Map details) {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            if (BEncoder.mapsAreIdentical(this.verify_cache_details, details)) {
                return this.verify_cache_result;
            }
        }
        byte[] hash = (byte[])details.get("h");
        int version = ((Long)details.get("v")).intValue();
        int size = ((Long)details.get("z")).intValue();
        byte[] sig = (byte[])details.get("s");
        boolean result = SubscriptionBodyImpl.verify(this.public_key, hash, version, size, sig);
        SubscriptionImpl subscriptionImpl2 = this;
        synchronized (subscriptionImpl2) {
            this.verify_cache_details = details;
            this.verify_cache_result = result;
        }
        return result;
    }

    @Override
    public void setCreatorRef(String ref) {
        this.creator_ref = ref;
        this.fireChanged(1);
    }

    @Override
    public String getCreatorRef() {
        return this.creator_ref;
    }

    @Override
    public void setCategory(String _category) {
        if (_category == null && this.category == null) {
            return;
        }
        if (_category != null && this.category != null && _category.equals(this.category)) {
            return;
        }
        this.manager.setCategoryOnExisting(this, this.category, _category);
        this.category = _category;
        this.fireChanged(1);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setTagID(long _tag_id) {
        if (_tag_id == this.tag_id) {
            return;
        }
        this.tag_id = _tag_id;
        this.fireChanged(1);
    }

    @Override
    public long getTagID() {
        return this.tag_id;
    }

    @Override
    public int getViewOptions() {
        return this.view_options;
    }

    @Override
    public void setViewOptions(int _options) {
        if (_options == this.view_options) {
            return;
        }
        this.view_options = _options;
        this.fireChanged(1);
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public void setParent(String _parent) {
        if (_parent == null && this.parent == null) {
            return;
        }
        if (_parent != null && this.parent != null && _parent.equals(this.parent)) {
            return;
        }
        this.parent = _parent;
        this.fireChanged(1);
    }

    @Override
    public long getMetadataMutationIndicator() {
        return this.md_mutator.get();
    }

    protected void fireChanged(int reason) {
        if (reason == 1) {
            this.md_mutator.incrementAndGet();
        }
        this.manager.configDirty(this, reason);
        this.listeners.dispatch(1, new Object[]{this, reason});
    }

    protected void fireDownloaded() {
        this.listeners.dispatch(2, new Object[]{this});
    }

    @Override
    public void addListener(SubscriptionListener l) {
        this.listeners.addListener(l);
    }

    @Override
    public void removeListener(SubscriptionListener l) {
        this.listeners.removeListener(l);
    }

    @Override
    public SubscriptionHistoryImpl getHistory() {
        return this.history;
    }

    @Override
    public SubscriptionManager getManager() {
        return this.manager;
    }

    @Override
    public VuzeFile getVuzeFile() throws SubscriptionException {
        try {
            return VuzeFileHandler.getSingleton().loadVuzeFile(this.manager.getVuzeFile(this).getAbsolutePath());
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to get Vuze file", e);
        }
    }

    @Override
    public VuzeFile getSearchTemplateVuzeFile() {
        if (!this.isSearchTemplate()) {
            return null;
        }
        Object[] details = this.manager.getSearchTemplateVuzeFile(this);
        if (details != null) {
            return (VuzeFile)details[0];
        }
        return null;
    }

    @Override
    public boolean isSearchTemplateImportable() {
        return this.manager.isSearchTemplateImportable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        LightWeightSeed l;
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            this.destroyed = true;
            l = this.lws;
        }
        if (l != null) {
            l.remove();
        }
    }

    @Override
    public void reset() {
        this.getHistory().reset();
        try {
            this.getEngine().reset();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public void remove() {
        this.destroy();
        this.manager.removeSubscription(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRemoved() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            return this.destroyed;
        }
    }

    @Override
    public SubscriptionResult[] getResults(boolean include_deleted) {
        return this.getHistory().getResults(include_deleted);
    }

    protected void invalidateNewestResultTime() {
        this.newest_result_time_next.incrementAndGet();
    }

    @Override
    public long getNewestResultTime() {
        SubscriptionResult[] results;
        long latest = this.newest_result_time;
        long seq = this.newest_result_time_seq;
        long next = this.newest_result_time_next.get();
        if (this.newest_result_time_seq == next) {
            return latest;
        }
        latest = 0L;
        SubscriptionResult[] subscriptionResultArray = results = this.getResults(false);
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            long timeFound;
            SubscriptionResult result = subscriptionResultArray[n2];
            if (!result.isDeleted() && !result.getRead() && (timeFound = result.getTimeFound()) > latest) {
                latest = timeFound;
            }
            ++n2;
        }
        this.newest_result_time = latest;
        this.newest_result_time_seq = next;
        return latest;
    }

    @Override
    public long getNextUpdateTime() {
        return this.manager.getScheduler().getNextUpdateTime(this);
    }

    @Override
    public SubscriptionResultFilterImpl getFilters() throws SubscriptionException {
        Map map = JSONUtils.decodeJSON(this.getJSON());
        Map filters = (Map)map.get("filters");
        return new SubscriptionResultFilterImpl(this, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object data) {
        Map map = this.user_data;
        synchronized (map) {
            if (data == null) {
                this.user_data.remove(key);
            } else {
                this.user_data.put(key, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        Map map = this.user_data;
        synchronized (map) {
            return this.user_data.get(key);
        }
    }

    protected void log(String str) {
        this.manager.log(String.valueOf(this.getString()) + ": " + str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log(String.valueOf(this.getString()) + ": " + str, e);
    }

    @Override
    public String getString() {
        return "name=" + this.name + ",sid=" + ByteFormatter.encodeString(this.short_id) + ",ver=" + this.version + ",pub=" + this.is_public + ",anon=" + this.is_anonymous + ",mine=" + this.isMine() + ",sub=" + this.is_subscribed + (this.is_subscribed ? ",hist={" + this.history.getString() + "}" : "") + ",pop=" + this.popularity + (this.server_publication_outstanding ? ",spo=true" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate(IndentWriter writer) {
        String engine_str;
        try {
            engine_str = "" + this.getEngine().getId();
        }
        catch (Throwable e) {
            engine_str = Debug.getNestedExceptionMessage(e);
        }
        writer.println(String.valueOf(this.getString()) + ": engine=" + engine_str);
        try {
            writer.indent();
            SubscriptionImpl subscriptionImpl = this;
            synchronized (subscriptionImpl) {
                int i = 0;
                while (i < this.associations.size()) {
                    this.associations.get(i).generate(writer);
                    ++i;
                }
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected static class association {
        private byte[] hash;
        private long when;
        private boolean published;

        protected association(byte[] _hash, long _when) {
            this.hash = _hash;
            this.when = _when;
        }

        protected byte[] getHash() {
            return this.hash;
        }

        protected long getWhen() {
            return this.when;
        }

        protected boolean getPublished() {
            return this.published;
        }

        protected void setPublished(boolean b) {
            this.published = b;
        }

        protected String getString() {
            return String.valueOf(ByteFormatter.encodeString(this.hash)) + ", pub=" + this.published;
        }

        protected void generate(IndentWriter writer) {
            writer.println(this.getString());
        }
    }
}

