/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.custom.Customization;
import com.biglybt.core.custom.CustomizationManager;
import com.biglybt.core.custom.CustomizationManagerFactory;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.lws.LightWeightSeed;
import com.biglybt.core.lws.LightWeightSeedManager;
import com.biglybt.core.messenger.config.PlatformSubscriptionsMessenger;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.MetaSearchListener;
import com.biglybt.core.metasearch.MetaSearchManagerFactory;
import com.biglybt.core.metasearch.impl.plugin.PluginEngine;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.metasearch.impl.web.rss.RSSEngine;
import com.biglybt.core.security.CryptoECCUtils;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionAssociationLookup;
import com.biglybt.core.subs.SubscriptionDownloadListener;
import com.biglybt.core.subs.SubscriptionException;
import com.biglybt.core.subs.SubscriptionHistory;
import com.biglybt.core.subs.SubscriptionLookupListener;
import com.biglybt.core.subs.SubscriptionManager;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.SubscriptionManagerListener;
import com.biglybt.core.subs.SubscriptionPopularityListener;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.subs.SubscriptionScheduler;
import com.biglybt.core.subs.SubscriptionUtils;
import com.biglybt.core.subs.impl.SubscriptionBodyImpl;
import com.biglybt.core.subs.impl.SubscriptionHistoryImpl;
import com.biglybt.core.subs.impl.SubscriptionImpl;
import com.biglybt.core.subs.impl.SubscriptionRSSFeed;
import com.biglybt.core.subs.impl.SubscriptionResultImpl;
import com.biglybt.core.subs.impl.SubscriptionSchedulerImpl;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.CopyOnWriteMap;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileComponent;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.core.vuzefile.VuzeFileProcessor;
import com.biglybt.net.magneturi.MagnetURIHandler;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadCompletionListener;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadPeerListener;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadWillBeAddedListener;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.torrent.TorrentManager;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.ScriptProvider;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pif.utils.Utilities;
import com.biglybt.pif.utils.search.SearchException;
import com.biglybt.pif.utils.search.SearchInstance;
import com.biglybt.pif.utils.search.SearchObserver;
import com.biglybt.pif.utils.search.SearchProvider;
import com.biglybt.pif.utils.search.SearchResult;
import com.biglybt.pifimpl.PluginUtils;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import com.biglybt.pifimpl.local.utils.SearchMatcher;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.plugin.dht.DHTPluginContact;
import com.biglybt.plugin.dht.DHTPluginInterface;
import com.biglybt.plugin.dht.DHTPluginKeyStats;
import com.biglybt.plugin.dht.DHTPluginOperationListener;
import com.biglybt.plugin.dht.DHTPluginValue;
import com.biglybt.plugin.magnet.MagnetPlugin;
import com.biglybt.plugin.magnet.MagnetPluginProgressListener;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.util.MapUtils;
import com.biglybt.util.UrlFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gudy.bouncycastle.util.encoders.Base64;

public class SubscriptionManagerImpl
implements SubscriptionManager,
DataSourceResolver.DataSourceImporter,
AEDiagnosticsEvidenceGenerator {
    private static final String CONFIG_FILE = "subscriptions.config";
    private static final String LOGGER_NAME = "Subscriptions";
    private static final String CONFIG_DEF_CHECK_MINS = "subscriptions.check.period.mins.default";
    private static final String CONFIG_MAX_RESULTS = "subscriptions.max.non.deleted.results";
    private static final String CONFIG_AUTO_START_DLS = "subscriptions.auto.start.downloads";
    private static final String CONFIG_AUTO_START_MIN_MB = "subscriptions.auto.start.min.mb";
    private static final String CONFIG_AUTO_START_MAX_MB = "subscriptions.auto.start.max.mb";
    private static final String CONFIG_AUTO_MARK_READ = "subscriptions.auto.dl.mark.read.days";
    private static final String CONFIG_ADD_HASHES = "subscriptions.auto.dl.add.hashes";
    private static final String CONFIG_RSS_ENABLE = "subscriptions.config.rss_enable";
    private static final String CONFIG_ENABLE_SEARCH = "subscriptions.config.search_enable";
    private static final String CONFIG_HIDE_SEARCH_TEMPLATES = "subscriptions.config.hide_search_templates";
    private static final String CONFIG_DL_SUBS_ENABLE = "subscriptions.config.dl_subs_enable";
    private static final String CONFIG_DL_RATE_LIMITS = "subscriptions.config.rate_limits";
    private static final String CONFIG_ACTIVATE_ON_CHANGE = "subscriptions.config.activate.sub.on.change";
    private static final String CONFIG_MARK_LIB_RESULTS_READ = "subscriptions.config.mark.lib.results.read";
    private static final int DELETE_UNUSED_AFTER_MILLIS = 1209600000;
    private static final int PUB_ASSOC_CONC_MAX;
    private static final int PUB_SLEEPING_ASSOC_CONC_MAX = 1;
    private static SubscriptionManagerImpl singleton;
    private static boolean pre_initialised;
    private static final int random_seed;
    private boolean started;
    private static final int TIMER_PERIOD = 30000;
    private static final int ASSOC_CHECK_PERIOD = 300000;
    private static final int ASSOC_CHECK_TICKS = 10;
    private static final int ASSOC_PUBLISH_PERIOD = 300000;
    private static final int ASSOC_PUBLISH_TICKS = 10;
    private static final int CHAT_CHECK_PERIOD = 180000;
    private static final int CHAT_CHECK_TICKS = 6;
    private static final int SERVER_PUB_CHECK_PERIOD = 600000;
    private static final int SERVER_PUB_CHECK_TICKS = 20;
    private static final int TIDY_POT_ASSOC_PERIOD = 1800000;
    private static final int TIDY_POT_ASSOC_TICKS = 60;
    private static final int SET_SELECTED_PERIOD = 82800000;
    private static final int SET_SELECTED_FIRST_TICK = 6;
    private static final int SET_SELECTED_TICKS = 2760;
    private static final Object SP_LAST_ATTEMPTED;
    private static final Object SP_CONSEC_FAIL;
    private Core core;
    private volatile DHTPluginInterface dht_plugin_public;
    private CopyOnWriteMap<String, SubscriptionImpl> subscription_map = new CopyOnWriteMap();
    private boolean config_dirty;
    private int publish_associations_active;
    private boolean publish_next_asyc_pending;
    private boolean publish_subscription_active;
    private TorrentAttribute ta_subs_download;
    private TorrentAttribute ta_subs_download_rd;
    private TorrentAttribute ta_subscription_info;
    private TorrentAttribute ta_category;
    private TorrentAttribute ta_networks;
    private boolean periodic_lookup_in_progress;
    private int priority_lookup_pending;
    private CopyOnWriteList<SubscriptionManagerListener> listeners = new CopyOnWriteList();
    private SubscriptionSchedulerImpl scheduler;
    private List<Object[]> potential_associations = new ArrayList<Object[]>();
    private Map<HashWrapper, Object[]> potential_associations2 = new HashMap<HashWrapper, Object[]>();
    private Map<HashWrapper, Object[]> potential_associations3 = new HashMap<HashWrapper, Object[]>();
    private boolean meta_search_listener_added;
    private Pattern exclusion_pattern = Pattern.compile("azdev[0-9]+\\.azureus\\.com");
    private SubscriptionRSSFeed rss_publisher;
    private AEDiagnosticsLogger logger;
    private Map<SubscriptionImpl, Object[]> result_cache = new HashMap<SubscriptionImpl, Object[]>();
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher("SubsManDispatcher");
    private static final Object SUBS_CHAT_KEY;
    private Map<String, AtomicInteger> imported_sids = new HashMap<String, AtomicInteger>();
    private AsyncDispatcher chat_write_dispatcher = new AsyncDispatcher("Subscriptions:cwd");
    private Set<String> chat_st_done = new HashSet<String>();
    private LinkedList<BuddyPluginBeta.ChatInstance> chat_assoc_done = new LinkedList();
    private static final Object LIB_MUTATION_KEY;
    private static final AtomicInteger lib_mutation_count;
    private static AsyncDispatcher library_checker;
    private static AsyncDispatcher result_exec;
    private boolean js_plugin_install_tried;
    private SubscriptionImpl last_gmar;
    private Map<String, String> gmar_cache = new HashMap<String, String>();

    static {
        int max_conc_assoc_pub = 3;
        try {
            max_conc_assoc_pub = Integer.parseInt(System.getProperty(SystemProperties.SYSPROP_SUBS_MAX_CONCURRENT_ASSOC_PUBLISH, "" + max_conc_assoc_pub));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        PUB_ASSOC_CONC_MAX = max_conc_assoc_pub;
        random_seed = RandomUtils.nextInt(256);
        SP_LAST_ATTEMPTED = new Object();
        SP_CONSEC_FAIL = new Object();
        SUBS_CHAT_KEY = new Object();
        LIB_MUTATION_KEY = new Object();
        lib_mutation_count = new AtomicInteger(0);
        library_checker = new AsyncDispatcher("Subs::libcheck");
        result_exec = new AsyncDispatcher("Subs::resexec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInitialise() {
        Class<SubscriptionManagerImpl> clazz = SubscriptionManagerImpl.class;
        synchronized (SubscriptionManagerImpl.class) {
            if (pre_initialised) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            pre_initialised = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

                @Override
                public void process(VuzeFile[] files, int expected_types) {
                    int i = 0;
                    while (i < files.length) {
                        VuzeFile vf = files[i];
                        VuzeFileComponent[] comps = vf.getComponents();
                        ArrayList<Subscription> new_subscriptions = new ArrayList<Subscription>();
                        ArrayList<Subscription> new_templates = new ArrayList<Subscription>();
                        int j = 0;
                        while (j < comps.length) {
                            VuzeFileComponent comp2 = comps[j];
                            int type = comp2.getType();
                            if (type == 16 || type == 32) {
                                try {
                                    Subscription subs = ((SubscriptionManagerImpl)SubscriptionManagerImpl.getSingleton(false)).importSubscription(type, comp2.getContent(), (expected_types & 0x30) == 0);
                                    if (subs.isSubscriptionTemplate()) {
                                        new_templates.add(subs);
                                    } else {
                                        new_subscriptions.add(subs);
                                    }
                                    comp2.setProcessed();
                                    comp2.setData(Subscription.VUZE_FILE_COMPONENT_SUBSCRIPTION_KEY, subs);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            ++j;
                        }
                        if (!new_templates.isEmpty()) {
                            for (Subscription s : new_subscriptions) {
                                s.setDependsOn(new_templates);
                            }
                        }
                        ++i;
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubscriptionManager getSingleton(boolean stand_alone) {
        SubscriptionManagerImpl.preInitialise();
        Class<SubscriptionManagerImpl> clazz = SubscriptionManagerImpl.class;
        synchronized (SubscriptionManagerImpl.class) {
            if (singleton != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return singleton;
            }
            singleton = new SubscriptionManagerImpl(stand_alone);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (!stand_alone) {
                singleton.initialise();
            }
            return singleton;
        }
    }

    protected SubscriptionManagerImpl(boolean stand_alone) {
        if (!stand_alone) {
            this.loadConfig();
            AEDiagnostics.addWeakEvidenceGenerator(this);
            DataSourceResolver.registerExporter(this);
            CustomizationManager cust_man = CustomizationManagerFactory.getSingleton();
            Customization cust = cust_man.getActiveCustomization();
            if (cust != null) {
                boolean new_version;
                String cust_name = COConfigurationManager.getStringParameter("subscriptions.custom.name", "");
                String cust_version = COConfigurationManager.getStringParameter("subscriptions.custom.version", "0");
                boolean new_name = !cust_name.equals(cust.getName());
                boolean bl = new_version = Constants.compareVersions(cust_version, cust.getVersion()) < 0;
                if (new_name || new_version) {
                    this.log("Customization: checking templates for " + cust.getName() + "/" + cust.getVersion());
                    try {
                        InputStream[] streams = cust.getResources("subs");
                        int i = 0;
                        while (i < streams.length) {
                            block18: {
                                InputStream is = streams[i];
                                try {
                                    VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(is);
                                    if (vf == null) break block18;
                                    VuzeFileComponent[] comps = vf.getComponents();
                                    int j = 0;
                                    while (j < comps.length) {
                                        VuzeFileComponent comp2 = comps[j];
                                        int type = comp2.getType();
                                        if (type == 16 || type == 32) {
                                            try {
                                                this.importSubscription(type, comp2.getContent(), false);
                                                comp2.setProcessed();
                                            }
                                            catch (Throwable e) {
                                                Debug.printStackTrace(e);
                                            }
                                        }
                                        ++j;
                                    }
                                }
                                finally {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                            ++i;
                        }
                    }
                    finally {
                        COConfigurationManager.setParameter("subscriptions.custom.name", cust.getName());
                        COConfigurationManager.setParameter("subscriptions.custom.version", cust.getVersion());
                    }
                }
            }
            this.scheduler = new SubscriptionSchedulerImpl(this);
        }
        SimpleTimer.addPeriodicEvent("SubscriptionCacheCheck", 10000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                long now = SystemTime.getMonotonousTime();
                Map map = SubscriptionManagerImpl.this.result_cache;
                synchronized (map) {
                    Iterator it = SubscriptionManagerImpl.this.result_cache.values().iterator();
                    while (it.hasNext()) {
                        long time = (Long)((Object[])it.next())[1];
                        if (now - time <= 15000L) continue;
                        it.remove();
                    }
                }
            }
        });
    }

    protected void initialise() {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                SubscriptionManagerImpl.this.initWithCore(core);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initWithCore(Core _core) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        this.core = _core;
        final PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        this.rss_publisher = new SubscriptionRSSFeed(this, default_pi);
        TorrentManager tm = default_pi.getTorrentManager();
        this.ta_subs_download = tm.getPluginAttribute("azsubs.subs_dl");
        this.ta_subs_download_rd = tm.getPluginAttribute("azsubs.subs_dl_rd");
        this.ta_subscription_info = tm.getPluginAttribute("azsubs.subs_info");
        this.ta_category = tm.getAttribute("Category");
        this.ta_networks = tm.getAttribute("Networks");
        PluginInterface dht_plugin_pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        if (dht_plugin_pi != null) {
            this.dht_plugin_public = (DHTPlugin)dht_plugin_pi.getPlugin();
            default_pi.getDownloadManager().addListener(new DownloadManagerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void downloadAdded(Download download) {
                    Torrent torrent = download.getTorrent();
                    if (torrent != null) {
                        Object[] entry;
                        byte[] hash = torrent.getHash();
                        Map map = SubscriptionManagerImpl.this.potential_associations2;
                        synchronized (map) {
                            entry = (Object[])SubscriptionManagerImpl.this.potential_associations2.remove(new HashWrapper(hash));
                        }
                        if (entry != null) {
                            SubscriptionImpl[] subs = (SubscriptionImpl[])entry[0];
                            String subs_str = "";
                            int i = 0;
                            while (i < subs.length) {
                                subs_str = String.valueOf(subs_str) + (i == 0 ? "" : ",") + subs[i].getName();
                                ++i;
                            }
                            SubscriptionManagerImpl.this.log("Applying deferred asocciation for " + ByteFormatter.encodeString(hash) + " -> " + subs_str);
                            SubscriptionManagerImpl.this.recordAssociationsSupport(hash, subs, (Boolean)entry[1]);
                        }
                        if (!download.getFlag(512L)) {
                            SubscriptionManagerImpl.this.libraryMutated();
                        }
                    }
                }

                @Override
                public void downloadRemoved(Download download) {
                }
            }, false);
            default_pi.getDownloadManager().addDownloadWillBeAddedListener(new DownloadWillBeAddedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void initialised(Download download) {
                    Torrent torrent = download.getTorrent();
                    if (torrent != null) {
                        Subscription[] subs;
                        Object[] entry;
                        byte[] hash = torrent.getHash();
                        HashWrapper hw = new HashWrapper(hash);
                        Map map = SubscriptionManagerImpl.this.potential_associations2;
                        synchronized (map) {
                            entry = (Object[])SubscriptionManagerImpl.this.potential_associations2.get(hw);
                        }
                        if (entry != null) {
                            subs = (SubscriptionImpl[])entry[0];
                            SubscriptionManagerImpl.this.prepareDownload(download, subs, null);
                        } else {
                            subs = SubscriptionManagerImpl.this.potential_associations3;
                            synchronized (subs) {
                                entry = (Object[])SubscriptionManagerImpl.this.potential_associations3.get(hw);
                            }
                            if (entry != null) {
                                subs = (Subscription[])entry[0];
                                SubscriptionResult[] results = (SubscriptionResult[])entry[1];
                                SubscriptionManagerImpl.this.prepareDownload(download, subs, results);
                            }
                        }
                    }
                }
            });
            TorrentUtils.addTorrentAttributeListener(new TorrentUtils.torrentAttributeListener(){

                @Override
                public void attributeSet(TOTorrent torrent, String attribute, Object value) {
                    if (attribute == "obtained_from") {
                        try {
                            SubscriptionManagerImpl.this.checkPotentialAssociations(torrent.getHash(), (String)value);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            });
            DelayedTask delayed_task = UtilitiesImpl.addDelayedTask(LOGGER_NAME, new Runnable(){

                @Override
                public void run() {
                    new AEThread2("Subscriptions:delayInit", true){

                        @Override
                        public void run() {
                            this.asyncInit();
                        }
                    }.start();
                }

                protected void asyncInit() {
                    Download[] downloads = default_pi.getDownloadManager().getDownloads();
                    int i = 0;
                    while (i < downloads.length) {
                        Download download = downloads[i];
                        if (download.getBooleanAttribute(SubscriptionManagerImpl.this.ta_subs_download)) {
                            boolean delete_it;
                            Map rd = download.getMapAttribute(SubscriptionManagerImpl.this.ta_subs_download_rd);
                            if (rd == null) {
                                delete_it = true;
                            } else {
                                boolean bl = delete_it = !SubscriptionManagerImpl.this.recoverSubscriptionUpdate(download, rd);
                            }
                            if (delete_it) {
                                SubscriptionManagerImpl.this.removeDownload(download, true);
                            }
                        }
                        ++i;
                    }
                    default_pi.getDownloadManager().addListener(new DownloadManagerListener(){

                        @Override
                        public void downloadAdded(final Download download) {
                            if (!SubscriptionManagerImpl.this.downloadIsIgnored(download)) {
                                if (!SubscriptionManagerImpl.this.dht_plugin_public.isInitialising()) {
                                    SubscriptionManagerImpl.this.lookupAssociations(download.getMapAttribute(SubscriptionManagerImpl.this.ta_subscription_info) == null);
                                } else {
                                    new AEThread2("Subscriptions:delayInit", true){

                                        @Override
                                        public void run() {
                                            SubscriptionManagerImpl.this.lookupAssociations(download.getMapAttribute(SubscriptionManagerImpl.this.ta_subscription_info) == null);
                                        }
                                    }.start();
                                }
                            }
                        }

                        @Override
                        public void downloadRemoved(Download download) {
                        }
                    }, false);
                    i = 0;
                    while (i < PUB_ASSOC_CONC_MAX) {
                        if (SubscriptionManagerImpl.this.publishAssociations()) break;
                        ++i;
                    }
                    SubscriptionManagerImpl.this.publishSubscriptions();
                    COConfigurationManager.addParameterListener(SubscriptionManagerImpl.CONFIG_MAX_RESULTS, new ParameterListener(){

                        @Override
                        public void parameterChanged(String name) {
                            final int max_results = COConfigurationManager.getIntParameter(SubscriptionManagerImpl.CONFIG_MAX_RESULTS);
                            new AEThread2("Subs:max results changer", true){

                                @Override
                                public void run() {
                                    SubscriptionManagerImpl.this.checkMaxResults(max_results);
                                }
                            }.start();
                        }
                    });
                    SimpleTimer.addPeriodicEvent("SubscriptionChecker", 30000L, new TimerEventPerformer(){
                        private int ticks;

                        @Override
                        public void perform(TimerEvent event2) {
                            ++this.ticks;
                            SubscriptionManagerImpl.this.checkStuff(this.ticks);
                        }
                    });
                }
            });
            delayed_task.queue();
        }
        if (this.isSearchEnabled()) {
            try {
                default_pi.getUtilities().registerSearchProvider(new SearchProvider(){
                    private Map<Integer, Object> properties = new HashMap<Integer, Object>();
                    {
                        this.properties.put(1, MessageText.getString("ConfigView.section.Subscriptions"));
                        try {
                            URL url = MagnetURIHandler.getSingleton().registerResource(new MagnetURIHandler.ResourceProvider(){

                                @Override
                                public String getUID() {
                                    return String.valueOf(SubscriptionManager.class.getName()) + ".2";
                                }

                                @Override
                                public String getFileType() {
                                    return "png";
                                }

                                @Override
                                public byte[] getData() {
                                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/biglybt/ui/images/subscription_icon_1616.png");
                                    if (is == null) {
                                        return null;
                                    }
                                    try {
                                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                        try {
                                            int len;
                                            byte[] buffer = new byte[8192];
                                            while ((len = is.read(buffer)) > 0) {
                                                baos.write(buffer, 0, len);
                                            }
                                        }
                                        finally {
                                            is.close();
                                        }
                                        return baos.toByteArray();
                                    }
                                    catch (Throwable e) {
                                        return null;
                                    }
                                }
                            });
                            this.properties.put(2, url.toExternalForm());
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }

                    @Override
                    public SearchInstance search(Map<String, Object> search_parameters, SearchObserver observer) throws SearchException {
                        try {
                            return SubscriptionManagerImpl.this.searchSubscriptions(search_parameters, observer);
                        }
                        catch (Throwable e) {
                            throw new SearchException("Search failed", e);
                        }
                    }

                    @Override
                    public Object getProperty(int property) {
                        return this.properties.get(property);
                    }

                    @Override
                    public void setProperty(int property, Object value) {
                        this.properties.put(property, value);
                    }
                });
            }
            catch (Throwable e) {
                Debug.out("Failed to register search provider");
            }
        }
        default_pi.getUtilities().registerJSONRPCServer(new Utilities.JSONServer(){
            private List<String> methods = new ArrayList<String>();
            {
                this.methods.add("vuze-subs-list");
            }

            @Override
            public String getName() {
                return SubscriptionManagerImpl.LOGGER_NAME;
            }

            @Override
            public List<String> getSupportedMethods() {
                return this.methods;
            }

            @Override
            public Map call(String method, Map args) throws PluginException {
                throw new PluginException("derp");
            }
        });
    }

    protected boolean isClosing() {
        return CoreFactory.getSingleton().isStopping();
    }

    protected Object[] getSearchTemplateVuzeFile(SubscriptionImpl sub) {
        try {
            String subs_url_str = ((RSSEngine)sub.getEngine()).getSearchUrl(true);
            URL subs_url = new URL(subs_url_str);
            byte[] vf_bytes = FileUtil.readInputStreamAsByteArray(subs_url.openConnection().getInputStream());
            VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(vf_bytes);
            if (MetaSearchManagerFactory.getSingleton().isImportable(vf)) {
                return new Object[]{vf, vf_bytes};
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return null;
    }

    public boolean isSearchTemplateImportable(SubscriptionImpl sub) {
        try {
            String subs_url_str = ((RSSEngine)sub.getEngine()).getSearchUrl(true);
            URL subs_url = new URL(subs_url_str);
            byte[] vf_bytes = FileUtil.readInputStreamAsByteArray(subs_url.openConnection().getInputStream());
            VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(vf_bytes);
            return MetaSearchManagerFactory.getSingleton().isImportable(vf);
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    public SearchInstance searchSubscriptions(Map<String, Object> search_parameters, final SearchObserver observer) throws SearchException {
        final String term = (String)search_parameters.get("s");
        final SearchInstance si = new SearchInstance(){

            @Override
            public void cancel() {
                Debug.out("Cancelled");
            }
        };
        if (term == null) {
            try {
                observer.complete();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        } else {
            new AEThread2("Subscriptions:search", true){

                @Override
                public void run() {
                    HashSet<String> hashes = new HashSet<String>();
                    SearchMatcher matcher = new SearchMatcher(term);
                    try {
                        try {
                            List matches = SubscriptionManagerImpl.this.matchSubscriptionResults(matcher);
                            for (SubscriptionResult result : matches) {
                                final Map<Integer, Object> result_properties = result.toPropertyMap();
                                byte[] hash = (byte[])result_properties.get(21);
                                if (hash != null) {
                                    String hash_str = Base32.encode(hash);
                                    if (hashes.contains(hash_str)) continue;
                                    hashes.add(hash_str);
                                }
                                SearchResult search_result = new SearchResult(){

                                    @Override
                                    public Object getProperty(int property_name) {
                                        return result_properties.get(property_name);
                                    }
                                };
                                try {
                                    observer.resultReceived(si, search_result);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                            HashMap<String, Object[]> template_matches = new HashMap<String, Object[]>();
                            Engine[] engines = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngines(false, false);
                            HashMap<Subscription, ArrayList<String>> sub_dl_name_map = null;
                            SubscriptionImpl[] subscriptionImplArray = SubscriptionManagerImpl.this.getSubscriptions(false);
                            int e = subscriptionImplArray.length;
                            int search_result = 0;
                            while (search_result < e) {
                                SubscriptionImpl sub = subscriptionImplArray[search_result];
                                if (sub.isSearchTemplate()) {
                                    String sub_name = sub.getName(false);
                                    Engine sub_engine = sub.getEngine();
                                    if (!sub_engine.isActive() && sub_engine instanceof RSSEngine) {
                                        int t_ver;
                                        int pos = sub_name.indexOf(":");
                                        String t_name = sub_name.substring(pos + 1);
                                        if ((pos = t_name.indexOf("(v")) == -1) {
                                            t_ver = 1;
                                        } else {
                                            String s = t_name.substring(pos + 2, t_name.length() - 1);
                                            t_name = t_name.substring(0, pos);
                                            try {
                                                t_ver = Integer.parseInt(s);
                                            }
                                            catch (Throwable e2) {
                                                t_ver = 1;
                                            }
                                        }
                                        t_name = t_name.trim();
                                        boolean skip = false;
                                        Engine[] engineArray = engines;
                                        int n = engines.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            Engine e3 = engineArray[n2];
                                            if (e3 != sub_engine && e3.sameLogicAs(sub_engine)) {
                                                skip = true;
                                                break;
                                            }
                                            if (e3.getName().equalsIgnoreCase(t_name) && e3.getVersion() >= t_ver) {
                                                skip = true;
                                            }
                                            ++n2;
                                        }
                                        if (!skip) {
                                            List names;
                                            if (sub_dl_name_map == null) {
                                                SubscriptionUtils.SubscriptionDownloadDetails[] sdds;
                                                sub_dl_name_map = new HashMap<Subscription, ArrayList<String>>();
                                                SubscriptionUtils.SubscriptionDownloadDetails[] subscriptionDownloadDetailsArray = sdds = SubscriptionUtils.getAllCachedDownloadDetails(SubscriptionManagerImpl.this.core);
                                                int n3 = sdds.length;
                                                n = 0;
                                                while (n < n3) {
                                                    SubscriptionUtils.SubscriptionDownloadDetails sdd = subscriptionDownloadDetailsArray[n];
                                                    String name = sdd.getDownload().getDisplayName();
                                                    if (matcher.matches(name)) {
                                                        Subscription[] x;
                                                        Subscription[] subscriptionArray = x = sdd.getSubscriptions();
                                                        int n4 = x.length;
                                                        int n5 = 0;
                                                        while (n5 < n4) {
                                                            Subscription s = subscriptionArray[n5];
                                                            ArrayList<String> g = (ArrayList<String>)sub_dl_name_map.get(s);
                                                            if (g == null) {
                                                                g = new ArrayList<String>();
                                                                sub_dl_name_map.put(s, g);
                                                            }
                                                            g.add(name);
                                                            ++n5;
                                                        }
                                                    }
                                                    ++n;
                                                }
                                            }
                                            if ((names = (List)sub_dl_name_map.get(sub)) != null) {
                                                String key = t_name.toLowerCase();
                                                Object[] entry = (Object[])template_matches.get(key);
                                                if (entry == null) {
                                                    entry = new Object[]{sub, t_ver};
                                                    template_matches.put(key, entry);
                                                } else if (t_ver > (Integer)entry[1]) {
                                                    entry[0] = sub;
                                                    entry[1] = t_ver;
                                                }
                                            }
                                        }
                                    }
                                }
                                ++search_result;
                            }
                            ArrayList<SubscriptionImpl> interesting = new ArrayList<SubscriptionImpl>();
                            for (Object[] entry : template_matches.values()) {
                                interesting.add((SubscriptionImpl)entry[0]);
                            }
                            Collections.sort(interesting, new Comparator<Subscription>(){

                                @Override
                                public int compare(Subscription o1, Subscription o2) {
                                    long res = o2.getCachedPopularity() - o1.getCachedPopularity();
                                    if (res < 0L) {
                                        return -1;
                                    }
                                    if (res > 0L) {
                                        return 1;
                                    }
                                    return 0;
                                }
                            });
                            int added = 0;
                            for (final SubscriptionImpl sub : interesting) {
                                if (added >= 3) {
                                    break;
                                }
                                try {
                                    Object[] vf_entry = SubscriptionManagerImpl.this.getSearchTemplateVuzeFile(sub);
                                    if (vf_entry == null) continue;
                                    final byte[] vf_bytes = (byte[])vf_entry[1];
                                    final URL url = MagnetURIHandler.getSingleton().registerResource(new MagnetURIHandler.ResourceProvider(){

                                        @Override
                                        public String getUID() {
                                            return String.valueOf(SubscriptionManager.class.getName()) + ".sid." + sub.getID();
                                        }

                                        @Override
                                        public String getFileType() {
                                            return "vuze";
                                        }

                                        @Override
                                        public byte[] getData() {
                                            return vf_bytes;
                                        }
                                    });
                                    SearchResult search_result2 = new SearchResult(){

                                        @Override
                                        public Object getProperty(int property_name) {
                                            if (property_name == 1) {
                                                return sub.getName();
                                            }
                                            if (property_name == 12 || property_name == 16) {
                                                return url.toExternalForm();
                                            }
                                            if (property_name == 2) {
                                                return new Date(sub.getAddTime());
                                            }
                                            if (property_name == 3) {
                                                return 1024L;
                                            }
                                            if (property_name == 5 || property_name == 9) {
                                                return sub.getCachedPopularity();
                                            }
                                            if (property_name == 17) {
                                                return 100L;
                                            }
                                            return null;
                                        }
                                    };
                                    ++added;
                                    try {
                                        observer.resultReceived(si, search_result2);
                                    }
                                    catch (Throwable e4) {
                                        Debug.out(e4);
                                    }
                                }
                                catch (Throwable e5) {
                                    Debug.out(e5);
                                }
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            observer.complete();
                        }
                    }
                    finally {
                        observer.complete();
                    }
                }
            }.start();
        }
        return si;
    }

    private List<SubscriptionResult> matchSubscriptionResults(SearchMatcher matcher) {
        ArrayList<SubscriptionResult> result = new ArrayList<SubscriptionResult>();
        SubscriptionImpl[] subscriptionImplArray = this.getSubscriptions(true);
        int n = subscriptionImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            SubscriptionResult[] results;
            SubscriptionImpl sub = subscriptionImplArray[n2];
            SubscriptionResult[] subscriptionResultArray = results = sub.getResults(false);
            int n3 = results.length;
            int n4 = 0;
            while (n4 < n3) {
                SubscriptionResult r = subscriptionResultArray[n4];
                Map<Integer, Object> properties = r.toPropertyMap();
                String name = (String)properties.get(1);
                if (name != null && matcher.matches(name)) {
                    result.add(r);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    protected void checkMaxResults(int max) {
        SubscriptionImpl[] subs = this.getSubscriptions();
        int i = 0;
        while (i < subs.length) {
            ((SubscriptionHistoryImpl)subs[i].getHistory()).checkMaxResults(max);
            ++i;
        }
    }

    @Override
    public SubscriptionScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean isRSSPublishEnabled() {
        return COConfigurationManager.getBooleanParameter(CONFIG_RSS_ENABLE, false);
    }

    @Override
    public void setRSSPublishEnabled(boolean enabled) {
        COConfigurationManager.setParameter(CONFIG_RSS_ENABLE, enabled);
    }

    @Override
    public boolean isSearchEnabled() {
        return COConfigurationManager.getBooleanParameter(CONFIG_ENABLE_SEARCH, true);
    }

    @Override
    public void setSearchEnabled(boolean enabled) {
        COConfigurationManager.setParameter(CONFIG_ENABLE_SEARCH, enabled);
    }

    @Override
    public boolean hideSearchTemplates() {
        return COConfigurationManager.getBooleanParameter(CONFIG_HIDE_SEARCH_TEMPLATES, true);
    }

    @Override
    public boolean isSubsDownloadEnabled() {
        return COConfigurationManager.getBooleanParameter(CONFIG_DL_SUBS_ENABLE, true);
    }

    @Override
    public void setSubsDownloadEnabled(boolean enabled) {
        COConfigurationManager.setParameter(CONFIG_DL_SUBS_ENABLE, enabled);
    }

    @Override
    public void setRateLimits(String limits) {
        COConfigurationManager.setParameter(CONFIG_DL_RATE_LIMITS, limits);
    }

    @Override
    public String getRateLimits() {
        return COConfigurationManager.getStringParameter(CONFIG_DL_RATE_LIMITS, "");
    }

    @Override
    public void setActivateSubscriptionOnChange(boolean b) {
        COConfigurationManager.setParameter(CONFIG_ACTIVATE_ON_CHANGE, b);
    }

    @Override
    public boolean getActivateSubscriptionOnChange() {
        return COConfigurationManager.getBooleanParameter(CONFIG_ACTIVATE_ON_CHANGE, false);
    }

    @Override
    public void setMarkResultsInLibraryRead(boolean b) {
        COConfigurationManager.setParameter(CONFIG_MARK_LIB_RESULTS_READ, b);
    }

    @Override
    public boolean getMarkResultsInLibraryRead() {
        return COConfigurationManager.getBooleanParameter(CONFIG_MARK_LIB_RESULTS_READ, true);
    }

    @Override
    public String getRSSLink() {
        return this.rss_publisher.getFeedURL();
    }

    @Override
    public Subscription create(String name, boolean public_subs, String json) throws SubscriptionException {
        name = this.getUniqueName(name);
        boolean is_anonymous = false;
        SubscriptionImpl subs = new SubscriptionImpl(this, name, public_subs, is_anonymous, null, json, 1);
        this.log("Created new subscription: " + subs.getString());
        if (subs.isPublic()) {
            this.updatePublicSubscription(subs);
        }
        return this.addSubscription(subs);
    }

    @Override
    public SubscriptionImpl createSingletonRSS(String name, URL url, int check_interval_mins, boolean is_anon) throws SubscriptionException {
        return this.createSingletonRSSSupport(name, url, true, check_interval_mins, is_anon, 1, true);
    }

    @Override
    public Subscription createFromURI(String uri) throws SubscriptionException {
        String[] bits;
        final AESemaphore sem = new AESemaphore("subswait");
        final Object[] result = new Object[1];
        byte[] sid = null;
        int version = -1;
        boolean is_anon = false;
        int pos = uri.indexOf(63);
        String[] stringArray = bits = uri.substring(pos + 1).split("&");
        int n = bits.length;
        int n2 = 0;
        while (n2 < n) {
            String bit = stringArray[n2];
            String[] temp = bit.split("=");
            if (temp.length == 2) {
                String lhs = temp[0].toLowerCase(Locale.US);
                String rhs = temp[1];
                if (lhs.equals("id")) {
                    sid = Base32.decode(rhs);
                } else if (lhs.equals("v")) {
                    version = Integer.parseInt(rhs);
                } else if (lhs.equals("a")) {
                    is_anon = rhs.equals("1");
                }
            }
            ++n2;
        }
        if (sid == null || version == -1) {
            throw new SubscriptionException("Invalid URI");
        }
        this.lookupSubscription("URI", new byte[20], sid, version, is_anon, new subsLookupListener(){

            @Override
            public void found(byte[] hash, Subscription subscription) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(byte[] hash, SubscriptionException error) {
                Object[] objectArray = result;
                synchronized (result) {
                    result[0] = error;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    sem.release();
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(byte[] hash, Subscription[] subscriptions) {
                Object[] objectArray = result;
                synchronized (result) {
                    result[0] = subscriptions.length > 0 ? subscriptions[0] : new SubscriptionException("Subscription not found");
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    sem.release();
                    return;
                }
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
        sem.reserve();
        if (result[0] instanceof Subscription) {
            return (Subscription)result[0];
        }
        throw (SubscriptionException)result[0];
    }

    protected SubscriptionImpl lookupSingletonRSS(String name, URL url, boolean is_public, int check_interval_mins, boolean is_anon) throws SubscriptionException {
        this.checkURL(url);
        Map singleton_details = this.getSingletonMap(name, url, is_public, check_interval_mins, is_anon);
        byte[] sid = SubscriptionBodyImpl.deriveSingletonShortID(singleton_details);
        return this.getSubscriptionFromSID(sid);
    }

    protected SubscriptionImpl createSingletonRSSSupport(String name, URL url, boolean is_public, int check_interval_mins, boolean is_anon, int add_type, boolean subscribe) throws SubscriptionException {
        this.checkURL(url);
        try {
            SubscriptionImpl existing = this.lookupSingletonRSS(name, url, is_public, check_interval_mins, is_anon);
            if (existing != null) {
                return existing;
            }
            Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().createRSSEngine(name, url);
            String json = SubscriptionImpl.getSkeletonJSON(engine, check_interval_mins);
            Map singleton_details = this.getSingletonMap(name, url, is_public, check_interval_mins, is_anon);
            SubscriptionImpl subs = new SubscriptionImpl(this, name, is_public, is_anon, singleton_details, json, add_type);
            subs.setSubscribed(subscribe);
            this.log("Created new singleton subscription: " + subs.getString());
            subs = this.addSubscription(subs);
            if (subs.isPublic() && subs.isMine() && subs.isSearchTemplate()) {
                this.updatePublicSubscription(subs);
            }
            return subs;
        }
        catch (SubscriptionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to create subscription", e);
        }
    }

    protected String getUniqueName(String name) {
        int i = 0;
        while (i < 1024) {
            String test_name = String.valueOf(name) + (i == 0 ? "" : " (" + i + ")");
            if (this.getSubscriptionFromName(test_name) == null) {
                return test_name;
            }
            ++i;
        }
        return name;
    }

    protected Map getSingletonMap(String name, URL url, boolean is_public, int check_interval_mins, boolean is_anon) throws SubscriptionException {
        try {
            HashMap<String, Object> singleton_details = new HashMap<String, Object>();
            if (url.getProtocol().equalsIgnoreCase("vuze")) {
                singleton_details.put("key", url.toExternalForm().getBytes(Constants.BYTE_ENCODING_CHARSET));
            } else {
                singleton_details.put("key", url.toExternalForm().getBytes("UTF-8"));
            }
            String name2 = name.length() > 64 ? name.substring(0, 64) : name;
            singleton_details.put("name", name2);
            if (check_interval_mins != -1) {
                singleton_details.put("ci", new Long(check_interval_mins));
            }
            if (is_anon) {
                singleton_details.put("a", new Long(1L));
            }
            return singleton_details;
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to create subscription", e);
        }
    }

    protected SubscriptionImpl createSingletonSubscription(Map singleton_details, int add_type, boolean subscribe) throws SubscriptionException {
        try {
            String name = MapUtils.getMapString(singleton_details, "name", "(Anonymous)");
            URL url = new URL(MapUtils.getMapString(singleton_details, "key", null));
            int check_interval_mins = (int)MapUtils.importLong(singleton_details, "ci", -1L);
            boolean is_anon = MapUtils.importLong(singleton_details, "a", 0L) != 0L;
            SubscriptionImpl s = this.createSingletonRSSSupport(name, url, true, check_interval_mins, is_anon, add_type, subscribe);
            return s;
        }
        catch (Throwable e) {
            this.log("Creation of singleton from " + singleton_details + " failed", e);
            throw new SubscriptionException("Creation of singleton from " + singleton_details + " failed", e);
        }
    }

    @Override
    public void requestSubscription(URL url, Map<String, Object> options) {
        for (SubscriptionManagerListener listener : this.listeners) {
            try {
                listener.subscriptionRequested(url, options);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void requestSubscription(SearchProvider sp, Map<String, Object> search_parameters) throws com.biglybt.pif.utils.subscriptions.SubscriptionException {
        try {
            Boolean silent;
            Long max_age_secs;
            String pid;
            Engine engine = MetaSearchManagerFactory.getSingleton().getEngine(sp);
            if (engine == null) {
                throw new SubscriptionException("Engine not found ");
            }
            Boolean anonymous = (Boolean)search_parameters.get("_anonymous_");
            String term = (String)search_parameters.get("s");
            String[] networks = (String[])search_parameters.get("n");
            String networks_str = null;
            if (networks != null && networks.length > 0) {
                networks_str = "";
                String[] stringArray = networks;
                int n = networks.length;
                int n2 = 0;
                while (n2 < n) {
                    String network = stringArray[n2];
                    networks_str = String.valueOf(networks_str) + (networks_str.length() == 0 ? "" : ",") + network;
                    ++n2;
                }
            }
            int period = 60;
            if (engine instanceof PluginEngine && (pid = ((PluginEngine)engine).getPluginID()) != null && pid.equals("aercm")) {
                period = 5;
            }
            String json = SubscriptionImpl.getSkeletonJSON(engine, term, networks_str, period);
            String name = (String)search_parameters.get("t");
            if (name == null || name.length() == 0) {
                name = String.valueOf(engine.getName()) + ": " + search_parameters.get("s");
            }
            boolean anon = anonymous != null && anonymous != false;
            SubscriptionImpl subs = new SubscriptionImpl(this, name, engine.isPublic(), anon, null, json, 1);
            if (anon) {
                subs.getHistory().setDownloadNetworks(new String[]{"I2P"});
            }
            if ((max_age_secs = (Long)search_parameters.get("a")) != null && max_age_secs > 0L) {
                subs.getHistory().setMaxAgeSecs(max_age_secs);
            }
            this.log("Created new subscription: " + subs.getString());
            subs = this.addSubscription(subs);
            Number freq = (Number)search_parameters.get("_frequency_");
            if (freq != null) {
                subs.getHistory().setCheckFrequencyMins(freq.intValue());
            }
            if (subs.isPublic()) {
                this.updatePublicSubscription(subs);
            }
            if ((silent = (Boolean)search_parameters.get("_silent_")) == null || !silent.booleanValue()) {
                subs.requestAttention();
            }
        }
        catch (Throwable e) {
            throw new com.biglybt.pif.utils.subscriptions.SubscriptionException("Failed to create subscription", e);
        }
    }

    @Override
    public Subscription createRSS(String name, URL url, int check_interval_mins, Map user_data) throws SubscriptionException {
        return this.createRSS(name, url, check_interval_mins, false, user_data);
    }

    @Override
    public Subscription createRSS(String name, URL url, int check_interval_mins, boolean is_anonymous, Map user_data) throws SubscriptionException {
        this.checkURL(url);
        try {
            name = this.getUniqueName(name);
            Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().createRSSEngine(name, url);
            String json = SubscriptionImpl.getSkeletonJSON(engine, check_interval_mins);
            SubscriptionImpl subs = new SubscriptionImpl(this, engine.getName(), engine.isPublic(), is_anonymous, null, json, 1);
            if (user_data != null) {
                for (Map.Entry entry : user_data.entrySet()) {
                    subs.setUserData(entry.getKey(), entry.getValue());
                }
            }
            this.log("Created new subscription: " + subs.getString());
            subs = this.addSubscription(subs);
            if (subs.isPublic()) {
                this.updatePublicSubscription(subs);
            }
            return subs;
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to create subscription", e);
        }
    }

    @Override
    public Subscription createSubscriptionTemplate(String name) throws SubscriptionException {
        try {
            return this.createRSS(name, new URL("subscription:?type=template"), -1, false, null);
        }
        catch (SubscriptionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to create subscription template", e);
        }
    }

    protected void checkURL(URL url) throws SubscriptionException {
        String protocol;
        if (!(url.getHost().trim().length() != 0 || (protocol = url.getProtocol().toLowerCase()).equals("tor") || protocol.equals("i2p") || protocol.equals("azplug") || protocol.equals("file") || protocol.equals("subscription") || protocol.equals("vuze"))) {
            throw new SubscriptionException("Invalid URL '" + url + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubscriptionImpl addSubscription(SubscriptionImpl subs) {
        SubscriptionImpl existing;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            String id = subs.getID();
            existing = this.subscription_map.get(id);
            if (existing == null) {
                this.subscription_map.put(id, subs);
                this.saveConfig();
            }
        }
        if (existing != null) {
            this.log("Attempted to add subscription when already present: " + subs.getString());
            subs.destroy();
            return existing;
        }
        if (subs.isMine()) {
            this.addMetaSearchListener();
        }
        if (subs.getCachedPopularity() == -1L) {
            try {
                subs.getPopularity(new SubscriptionPopularityListener(){

                    @Override
                    public void gotPopularity(long popularity) {
                    }

                    @Override
                    public void failed(SubscriptionException error) {
                    }
                });
            }
            catch (Throwable e) {
                this.log("", e);
            }
        }
        Iterator<SubscriptionManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().subscriptionAdded(subs);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (subs.isSubscribed() && subs.isPublic()) {
            this.setSelected(subs);
        }
        if (this.dht_plugin_public != null) {
            new AEThread2("Publish check", true){

                @Override
                public void run() {
                    SubscriptionManagerImpl.this.publishSubscriptions();
                }
            }.start();
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetaSearchListener() {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.meta_search_listener_added) {
                return;
            }
            this.meta_search_listener_added = true;
        }
        MetaSearchManagerFactory.getSingleton().getMetaSearch().addListener(new MetaSearchListener(){

            @Override
            public void engineAdded(Engine engine) {
            }

            @Override
            public void engineUpdated(Engine engine) {
                for (SubscriptionImpl subs : SubscriptionManagerImpl.this.subscription_map.getReadOnlyMap().values()) {
                    if (!subs.isMine()) continue;
                    subs.engineUpdated(engine);
                }
            }

            @Override
            public void engineRemoved(Engine engine) {
            }

            @Override
            public void engineStateChanged(Engine engine) {
            }
        });
    }

    protected void changeSubscription(SubscriptionImpl subs, int reason) {
        if (!subs.isRemoved()) {
            Iterator<SubscriptionManagerListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().subscriptionChanged(subs, reason);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected void selectSubscription(SubscriptionImpl subs) {
        if (!subs.isRemoved()) {
            Iterator<SubscriptionManagerListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().subscriptionSelected(subs);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(SubscriptionImpl subs) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.subscription_map.remove(subs.getID()) == null) {
                return;
            }
            this.saveConfig();
        }
        try {
            Engine engine = subs.getEngine(true);
            if (engine.getType() == 4) {
                engine.delete();
                this.log("Removed engine " + engine.getName() + " due to subscription removal");
            }
        }
        catch (Throwable e) {
            this.log("Failed to check for engine deletion", e);
        }
        Iterator<SubscriptionManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().subscriptionRemoved(subs);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        try {
            FileUtil.deleteResilientFile(this.getResultsFile(subs));
            Map<SubscriptionImpl, Object[]> e = this.result_cache;
            synchronized (e) {
                this.result_cache.remove(subs);
            }
            File vuze_file = this.getVuzeFile(subs);
            vuze_file.delete();
            FileUtil.newFile(vuze_file.getParent(), String.valueOf(vuze_file.getName()) + ".bak").delete();
        }
        catch (Throwable e) {
            this.log("Failed to delete results/vuze file", e);
        }
    }

    protected void updatePublicSubscription(final SubscriptionImpl subs) {
        if (!(!subs.isSingleton() || subs.isMine() && subs.isSearchTemplate())) {
            subs.setServerPublished();
        } else {
            final AESemaphore sem = new AESemaphore("pub:async");
            this.async_dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        Long l_last_pub = (Long)subs.getUserData(SP_LAST_ATTEMPTED);
                        Long l_consec_fail = (Long)subs.getUserData(SP_CONSEC_FAIL);
                        if (l_last_pub != null && l_consec_fail != null) {
                            long delay = 600000L;
                            int i = 0;
                            while ((long)i < l_consec_fail) {
                                if ((delay <<= 1) > 86400000L) break;
                                ++i;
                            }
                            if (l_last_pub + delay > SystemTime.getMonotonousTime()) {
                                return;
                            }
                        }
                        try {
                            File vf = SubscriptionManagerImpl.this.getVuzeFile(subs);
                            byte[] bytes = FileUtil.readFileAsByteArray(vf);
                            byte[] encoded_subs = Base64.encode(bytes);
                            PlatformSubscriptionsMessenger.updateSubscription(!subs.getServerPublished(), subs.getName(false), subs.getPublicKey(), subs.getPrivateKey(), subs.getShortID(), subs.getVersion(), subs.isAnonymous(), new String(encoded_subs));
                            subs.setUserData(SP_LAST_ATTEMPTED, null);
                            subs.setUserData(SP_CONSEC_FAIL, null);
                            subs.setServerPublished();
                            SubscriptionManagerImpl.this.log("    Updated public subscription " + subs.getString());
                        }
                        catch (Throwable e) {
                            SubscriptionManagerImpl.this.log("    Failed to update public subscription " + subs.getString(), e);
                            subs.setUserData(SP_LAST_ATTEMPTED, new Long(SystemTime.getMonotonousTime()));
                            subs.setUserData(SP_CONSEC_FAIL, new Long(l_consec_fail == null ? 1L : l_consec_fail + 1L));
                            subs.setServerPublicationOutstanding();
                        }
                    }
                    finally {
                        sem.release();
                    }
                }
            });
            sem.reserve(5000L);
        }
    }

    protected void checkSingletonPublish(SubscriptionImpl subs) throws SubscriptionException {
        if (subs.getSingletonPublishAttempted()) {
            throw new SubscriptionException("Singleton publish already attempted");
        }
        subs.setSingletonPublishAttempted();
        try {
            File vf = this.getVuzeFile(subs);
            byte[] bytes = FileUtil.readFileAsByteArray(vf);
            byte[] encoded_subs = Base64.encode(bytes);
            KeyPair kp = CryptoECCUtils.createKeys();
            byte[] public_key = CryptoECCUtils.keyToRawdata(kp.getPublic());
            byte[] private_key = CryptoECCUtils.keyToRawdata(kp.getPrivate());
            PlatformSubscriptionsMessenger.updateSubscription(true, subs.getName(false), public_key, private_key, subs.getShortID(), 1, subs.isAnonymous(), new String(encoded_subs));
            this.log("    created singleton public subscription " + subs.getString());
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to publish singleton", e);
        }
    }

    protected void checkServerPublications(List subs) {
        int i = 0;
        while (i < subs.size()) {
            SubscriptionImpl sub = (SubscriptionImpl)subs.get(i);
            if (sub.getServerPublicationOutstanding()) {
                this.updatePublicSubscription(sub);
            }
            ++i;
        }
    }

    protected void checkStuff(int ticks) {
        long now = SystemTime.getCurrentTime();
        ArrayList<SubscriptionImpl> subs = new ArrayList<SubscriptionImpl>(this.subscription_map.getReadOnlyMap().values());
        SubscriptionImpl expired_subs = null;
        for (SubscriptionImpl sub : subs) {
            long age;
            if (!sub.isMine() && !sub.isSubscribed() && (age = now - sub.getAddTime()) > 1209600000L) {
                if (expired_subs != null && sub.getAddTime() >= expired_subs.getAddTime()) continue;
                expired_subs = sub;
                continue;
            }
            sub.checkPublish();
        }
        if (expired_subs != null) {
            this.log("Removing unsubscribed subscription '" + expired_subs.getName() + "' as expired");
            expired_subs.remove();
        }
        if (ticks % 6 == 0) {
            ArrayList<SubscriptionImpl> subs_copy = new ArrayList<SubscriptionImpl>(subs);
            Collections.shuffle(subs_copy);
            long mono_now = SystemTime.getMonotonousTime();
            for (final SubscriptionImpl sub : subs_copy) {
                Long data;
                if (!sub.isSubscribed() || sub.isSearchTemplate() || (data = (Long)sub.getUserData(SUBS_CHAT_KEY)) != null && (data < 0L || mono_now - data < 14400000L)) continue;
                String chat_key = SubscriptionUtils.getSubscriptionChatKey(sub);
                if (chat_key != null) {
                    sub.setUserData(SUBS_CHAT_KEY, -1L);
                    SubscriptionUtils.peekChatAsync(sub.isAnonymous() ? "I2P" : "Public", chat_key, new Runnable(){

                        @Override
                        public void run() {
                            sub.setUserData(SUBS_CHAT_KEY, SystemTime.getMonotonousTime());
                        }
                    });
                    break;
                }
                sub.setUserData(SUBS_CHAT_KEY, -2L);
            }
        }
        if (ticks % 10 == 0) {
            this.lookupAssociations(false);
        }
        if (ticks % 10 == 0) {
            int rem = this.getPublishRemainingCount();
            if (rem == 0) {
                this.log("No associations to publish");
            } else {
                this.log(String.valueOf(rem) + " associations remaining to publish");
                this.publishAssociations();
            }
        }
        if (ticks % 20 == 0) {
            this.checkServerPublications(subs);
        }
        if (ticks % 60 == 0) {
            this.tidyPotentialAssociations();
        }
        if (ticks == 6 || ticks % 2760 == 0) {
            this.setSelected(subs);
        }
    }

    public Subscription importSubscription(int type, Map map, boolean warn_user) throws SubscriptionException {
        boolean log_errors = true;
        try {
            try {
                String details;
                UIManager ui_manager;
                long res;
                String subs_name;
                if (type == 32) {
                    String details2;
                    UIManager ui_manager2;
                    long res2;
                    String name = new String((byte[])map.get("name"), "UTF-8");
                    URL url = new URL(new String((byte[])map.get("url"), "UTF-8"));
                    Long l_interval = (Long)map.get("check_interval_mins");
                    int check_interval_mins = l_interval == null ? -1 : l_interval.intValue();
                    Long l_public = (Long)map.get("public");
                    boolean is_public = l_public == null ? true : l_public == 1L;
                    Long l_anon = (Long)map.get("anon");
                    boolean is_anon = l_anon == null ? false : l_anon == 1L;
                    SubscriptionImpl existing = this.lookupSingletonRSS(name, url, is_public, check_interval_mins, is_anon);
                    if (UrlFilter.getInstance().urlCanRPC(url.toExternalForm())) {
                        warn_user = false;
                    }
                    if (existing != null && existing.isSubscribed()) {
                        if (warn_user) {
                            UIManager ui_manager3 = StaticUtilities.getUIManager(120000L);
                            String details3 = MessageText.getString("subscript.add.dup.desc", new String[]{existing.getName()});
                            ui_manager3.showMessageBox("subscript.add.dup.title", "!" + details3 + "!", 1L);
                        }
                        this.selectSubscription(existing);
                        return existing;
                    }
                    if (warn_user && (res2 = (ui_manager2 = StaticUtilities.getUIManager(120000L)).showMessageBox("subscript.add.title", "!" + (details2 = MessageText.getString("subscript.add.desc", new String[]{name})) + "!", 12L)) != 4L) {
                        log_errors = false;
                        throw new SubscriptionException("User declined addition");
                    }
                    if (existing == null) {
                        SubscriptionImpl new_subs = this.createSingletonRSSSupport(name, url, is_public, check_interval_mins, is_anon, 2, true);
                        this.log("Imported new singleton subscription: " + new_subs.getString());
                        return new_subs;
                    }
                    existing.setSubscribed(true);
                    this.selectSubscription(existing);
                    return existing;
                }
                SubscriptionBodyImpl body = new SubscriptionBodyImpl(this, map);
                SubscriptionImpl existing = this.getSubscriptionFromSID(body.getShortID());
                if (existing != null && existing.isSubscribed()) {
                    String details4;
                    UIManager ui_manager4;
                    long res3;
                    if (existing.getVersion() >= body.getVersion()) {
                        this.log("Not upgrading subscription: " + existing.getString() + " as supplied (" + body.getVersion() + ") is not more recent than existing (" + existing.getVersion() + ")");
                        if (warn_user) {
                            UIManager ui_manager5 = StaticUtilities.getUIManager(120000L);
                            String details5 = MessageText.getString("subscript.add.dup.desc", new String[]{existing.getName()});
                            ui_manager5.showMessageBox("subscript.add.dup.title", "!" + details5 + "!", 1L);
                        }
                        this.selectSubscription(existing);
                        return existing;
                    }
                    if (warn_user && (res3 = (ui_manager4 = StaticUtilities.getUIManager(120000L)).showMessageBox("subscript.add.upgrade.title", "!" + (details4 = MessageText.getString("subscript.add.upgrade.desc", new String[]{existing.getName()})) + "!", 12L)) != 4L) {
                        throw new SubscriptionException("User declined upgrade");
                    }
                    this.log("Upgrading subscription: " + existing.getString());
                    existing.upgrade(body);
                    this.saveConfig();
                    this.subscriptionUpdated();
                    return existing;
                }
                SubscriptionImpl new_subs = null;
                if (existing == null) {
                    new_subs = new SubscriptionImpl(this, body, 2, true);
                    subs_name = new_subs.getName();
                } else {
                    subs_name = existing.getName();
                }
                if (warn_user && (res = (ui_manager = StaticUtilities.getUIManager(120000L)).showMessageBox("subscript.add.title", "!" + (details = MessageText.getString("subscript.add.desc", new String[]{subs_name})) + "!", 12L)) != 4L) {
                    throw new SubscriptionException("User declined addition");
                }
                if (new_subs == null) {
                    existing.setSubscribed(true);
                    this.selectSubscription(existing);
                    return existing;
                }
                this.log("Imported new subscription: " + new_subs.getString());
                new_subs = this.addSubscription(new_subs);
                return new_subs;
            }
            catch (Throwable e) {
                throw new SubscriptionException("Subscription import failed", e);
            }
        }
        catch (SubscriptionException e) {
            if (warn_user && log_errors) {
                UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                String details = MessageText.getString("subscript.import.fail.desc", new String[]{Debug.getNestedExceptionMessage(e)});
                ui_manager.showMessageBox("subscript.import.fail.title", "!" + details + "!", 1L);
            }
            throw e;
        }
    }

    public SubscriptionImpl[] getSubscriptions() {
        Collection<SubscriptionImpl> subs = this.subscription_map.getReadOnlyMap().values();
        return subs.toArray(new SubscriptionImpl[subs.size()]);
    }

    public SubscriptionImpl[] getSubscriptions(boolean subscribed_only) {
        if (!subscribed_only) {
            return this.getSubscriptions();
        }
        Collection<SubscriptionImpl> subs = this.subscription_map.getReadOnlyMap().values();
        ArrayList<SubscriptionImpl> result = new ArrayList<SubscriptionImpl>(subs.size());
        for (SubscriptionImpl sub : subs) {
            if (!sub.isSubscribed()) continue;
            result.add(sub);
        }
        return result.toArray(new SubscriptionImpl[result.size()]);
    }

    @Override
    public int getSubscriptionCount(boolean subscribed_only) {
        if (subscribed_only) {
            int total = 0;
            Collection<SubscriptionImpl> subs = this.subscription_map.getReadOnlyMap().values();
            for (SubscriptionImpl sub : subs) {
                if (!sub.isSubscribed()) continue;
                ++total;
            }
            return total;
        }
        return this.subscription_map.size();
    }

    protected SubscriptionImpl getSubscriptionFromName(String name) {
        Collection<SubscriptionImpl> subs = this.subscription_map.getReadOnlyMap().values();
        for (SubscriptionImpl sub : subs) {
            if (!sub.getName().equalsIgnoreCase(name)) continue;
            return sub;
        }
        return null;
    }

    @Override
    public SubscriptionImpl getSubscriptionByID(String id) {
        return this.subscription_map.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object importDataSource(final Map<String, Object> map) {
        final String sid = (String)map.get("id");
        Subscription subs = this.getSubscriptionByID(sid);
        if (subs != null) {
            try {
                subs.getManager().getScheduler().downloadAsync(subs, true);
                return subs;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            return subs;
        }
        Map sd = (Map)map.get("singleton");
        if (sd != null) {
            String key = (String)sd.get("key");
            sd.put("key", Base32.decode(key));
            try {
                subs = this.createSingletonSubscription(sd, 2, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        final Subscription[] result = new Subscription[]{subs};
        final Runnable apply_props = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Subscription[] subscriptionArray = result;
                synchronized (result) {
                    Subscription subs = result[0];
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    if (subs != null) {
                        Number vo;
                        List list;
                        Number check_mins = (Number)map.get("h_cm");
                        SubscriptionHistory history = subs.getHistory();
                        if (check_mins != null) {
                            history.setCheckFrequencyMins(check_mins.intValue());
                        }
                        if ((list = (List)map.get("h_dln")) != null) {
                            history.setDownloadNetworks(list.toArray(new String[0]));
                        }
                        if ((vo = (Number)map.get("vo")) != null) {
                            subs.setViewOptions(vo.intValue());
                        }
                        subs.setSubscribed(true);
                        try {
                            subs.getManager().getScheduler().downloadAsync(subs, true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    return;
                }
            }
        };
        if (subs == null) {
            final int version = ((Number)map.get("version")).intValue();
            final boolean anon = ((Number)map.get("anon")).intValue() != 0;
            final AESemaphore sem = new AESemaphore("");
            final boolean[] returned = new boolean[1];
            new AEThread2("async"){

                @Override
                public void run() {
                    try {
                        SubscriptionManagerImpl.this.lookupSubscription("Import of '" + sid + "'", new byte[20], Base32.decode(sid), version, anon, new subsLookupListener(){

                            @Override
                            public void found(byte[] hash, Subscription subscription) {
                            }

                            @Override
                            public void failed(byte[] hash, SubscriptionException error) {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void complete(byte[] hash, Subscription[] subscriptions) {
                                boolean enable_callback;
                                Subscription[] subscriptionArray = SubscriptionManagerImpl.this.imported_sids;
                                synchronized (subscriptionArray) {
                                    AtomicInteger ai = (AtomicInteger)SubscriptionManagerImpl.this.imported_sids.get(sid);
                                    if (ai == null) {
                                        ai = new AtomicInteger(0);
                                        SubscriptionManagerImpl.this.imported_sids.put(sid, ai);
                                    }
                                    enable_callback = ai.incrementAndGet() < 16;
                                }
                                subscriptionArray = result;
                                synchronized (result) {
                                    if (subscriptions.length > 0) {
                                        Runnable callback;
                                        result[0] = subscriptions[0];
                                        apply_props.run();
                                        if (returned[0] && enable_callback && (callback = (Runnable)map.get("callback")) != null) {
                                            callback.run();
                                        }
                                    }
                                    // ** MonitorExit[var4_3] (shouldn't be in output)
                                    return;
                                }
                            }

                            @Override
                            public boolean isCancelled() {
                                return false;
                            }
                        });
                    }
                    finally {
                        sem.release();
                    }
                }
            }.start();
            sem.reserve(2500L);
            Subscription[] subscriptionArray = result;
            // MONITORENTER : result
            returned[0] = true;
            subs = result[0];
            // MONITOREXIT : subscriptionArray
        }
        apply_props.run();
        return subs;
    }

    protected SubscriptionImpl getSubscriptionFromSID(byte[] sid) {
        return this.getSubscriptionByID(Base32.encode(sid));
    }

    protected File getSubsDir() throws IOException {
        File dir = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
        if (!(dir = FileUtil.newFile(dir, "subs")).exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create '" + dir + "'");
        }
        return dir;
    }

    protected File getVuzeFile(SubscriptionImpl subs) throws IOException {
        File dir = this.getSubsDir();
        return FileUtil.newFile(dir, VuzeFileHandler.getVuzeFileName(ByteFormatter.encodeString(subs.getShortID())));
    }

    protected File getResultsFile(SubscriptionImpl subs) throws IOException {
        File dir = this.getSubsDir();
        return FileUtil.newFile(dir, String.valueOf(ByteFormatter.encodeString(subs.getShortID())) + ".results");
    }

    @Override
    public int getKnownSubscriptionCount() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        Download[] downloads = pi.getDownloadManager().getDownloads();
        ByteArrayHashMap<String> results = new ByteArrayHashMap<String>(Math.max(16, downloads.length * 2));
        try {
            Download[] downloadArray = downloads;
            int n = downloads.length;
            int n2 = 0;
            while (n2 < n) {
                List s;
                Download download = downloadArray[n2];
                Map m = download.getMapAttribute(this.ta_subscription_info);
                if (m != null && (s = (List)m.get("s")) != null && s.size() > 0) {
                    int i = 0;
                    while (i < s.size()) {
                        byte[] sid = (byte[])s.get(i);
                        results.put(sid, "");
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            this.log("Failed to get known subscriptions", e);
        }
        return results.size();
    }

    @Override
    public Subscription[] getKnownSubscriptions(byte[] hash) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        try {
            List s;
            Map m;
            Download download = pi.getDownloadManager().getDownload(hash);
            if (download != null && (m = download.getMapAttribute(this.ta_subscription_info)) != null && (s = (List)m.get("s")) != null && s.size() > 0) {
                ArrayList<SubscriptionImpl> result = new ArrayList<SubscriptionImpl>(s.size());
                boolean hide_search = this.hideSearchTemplates();
                int i = 0;
                while (i < s.size()) {
                    byte[] sid = (byte[])s.get(i);
                    SubscriptionImpl subs = this.getSubscriptionFromSID(sid);
                    if (!(subs == null || !this.isVisible(subs) || hide_search && subs.isSearchTemplate())) {
                        result.add(subs);
                    }
                    ++i;
                }
                return result.toArray(new Subscription[result.size()]);
            }
        }
        catch (Throwable e) {
            this.log("Failed to get known subscriptions", e);
        }
        return new Subscription[0];
    }

    protected boolean subscriptionExists(Download download, SubscriptionImpl subs) {
        List s;
        byte[] sid = subs.getShortID();
        Map m = download.getMapAttribute(this.ta_subscription_info);
        if (m != null && (s = (List)m.get("s")) != null && s.size() > 0) {
            int i = 0;
            while (i < s.size()) {
                byte[] x = (byte[])s.get(i);
                if (Arrays.equals(x, sid)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean downloadIsIgnored(Download download) {
        return download.getTorrent() == null || !download.isPersistent();
    }

    protected boolean isVisible(SubscriptionImpl subs) {
        if (Constants.isCVSVersion() || subs.isSubscribed()) {
            return true;
        }
        try {
            Engine engine = subs.getEngine(true);
            if (engine instanceof WebEngine) {
                String url = ((WebEngine)engine).getSearchUrl();
                try {
                    String host = new URL(url).getHost();
                    return !this.exclusion_pattern.matcher(host).matches();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Throwable e) {
            this.log("isVisible failed for " + subs.getString(), e);
            return false;
        }
    }

    @Override
    public Subscription[] getLinkedSubscriptions(byte[] hash) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        try {
            List s;
            Map m;
            Download download = pi.getDownloadManager().getDownload(hash);
            if (download != null && (m = download.getMapAttribute(this.ta_subscription_info)) != null && (s = (List)m.get("s")) != null && s.size() > 0) {
                ArrayList<SubscriptionImpl> result = new ArrayList<SubscriptionImpl>(s.size());
                int i = 0;
                while (i < s.size()) {
                    byte[] sid = (byte[])s.get(i);
                    SubscriptionImpl subs = this.getSubscriptionFromSID(sid);
                    if (subs != null && subs.hasAssociation(hash)) {
                        result.add(subs);
                    }
                    ++i;
                }
                return result.toArray(new Subscription[result.size()]);
            }
        }
        catch (Throwable e) {
            this.log("Failed to get known subscriptions", e);
        }
        return new Subscription[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupAssociations(boolean high_priority) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.periodic_lookup_in_progress) {
                if (high_priority) {
                    ++this.priority_lookup_pending;
                }
                return;
            }
            this.periodic_lookup_in_progress = true;
        }
        try {
            PluginInterface pi = PluginInitializer.getDefaultInterface();
            Download[] downloads = pi.getDownloadManager().getDownloads();
            long now = SystemTime.getCurrentTime();
            long newest_time = 0L;
            Download newest_download = null;
            int i = 0;
            while (i < downloads.length) {
                Download download = downloads[i];
                if (!this.downloadIsIgnored(download)) {
                    long create_time;
                    int time_between_checks;
                    List subs;
                    int sub_count;
                    long last_check;
                    LightHashMap map = download.getMapAttribute(this.ta_subscription_info);
                    map = map == null ? new LightHashMap() : new LightHashMap(map);
                    Long l_last_check = (Long)map.get("lc");
                    long l = last_check = l_last_check == null ? 0L : l_last_check;
                    if (last_check > now) {
                        last_check = now;
                        map.put("lc", new Long(last_check));
                        download.setMapAttribute(this.ta_subscription_info, map);
                    }
                    int n = sub_count = (subs = (List)map.get("s")) == null ? 0 : subs.size();
                    if (sub_count <= 8 && now - last_check >= (long)(time_between_checks = (sub_count + 1) * 24 * 60 * 60 * 1000 + (int)((create_time = download.getCreationTime()) % 4L * 60L * 60L * 1000L)) && create_time > newest_time) {
                        newest_time = create_time;
                        newest_download = download;
                    }
                }
                ++i;
            }
            if (newest_download != null) {
                DHTPluginInterface dht_plugin = this.selectDHTPlugin(newest_download);
                if (dht_plugin != null) {
                    byte[] hash = newest_download.getTorrent().getHash();
                    this.log("Association lookup starts for " + newest_download.getName() + "/" + ByteFormatter.encodeString(hash));
                    this.lookupAssociationsSupport(dht_plugin, hash, newest_download.getName(), new SubscriptionLookupListener(){

                        @Override
                        public void found(byte[] hash, Subscription subscription) {
                        }

                        @Override
                        public void failed(byte[] hash, SubscriptionException error) {
                            SubscriptionManagerImpl.this.log("Association lookup failed for " + ByteFormatter.encodeString(hash), error);
                            SubscriptionManagerImpl.this.associationLookupComplete();
                        }

                        @Override
                        public void complete(byte[] hash, Subscription[] subs) {
                            SubscriptionManagerImpl.this.log("Association lookup complete for " + ByteFormatter.encodeString(hash));
                            SubscriptionManagerImpl.this.associationLookupComplete();
                        }
                    });
                } else {
                    this.associationLookupComplete();
                }
            } else {
                this.associationLookupComplete();
            }
        }
        catch (Throwable e) {
            this.log("Association lookup check failed", e);
            this.associationLookupComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associationLookupComplete() {
        boolean recheck;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            this.periodic_lookup_in_progress = false;
            boolean bl = recheck = this.priority_lookup_pending > 0;
            if (recheck) {
                --this.priority_lookup_pending;
            }
        }
        if (recheck) {
            new AEThread2("SM:priAssLookup", true){

                @Override
                public void run() {
                    SubscriptionManagerImpl.this.lookupAssociations(false);
                }
            }.start();
        }
    }

    protected void setSelected(List subs) {
        ArrayList<byte[]> sids = new ArrayList<byte[]>();
        ArrayList<SubscriptionImpl> used_subs = new ArrayList<SubscriptionImpl>();
        final ArrayList<SubscriptionImpl> dht_pops = new ArrayList<SubscriptionImpl>();
        int i = 0;
        while (i < subs.size()) {
            SubscriptionImpl sub = (SubscriptionImpl)subs.get(i);
            if (sub.isSubscribed()) {
                if (sub.isPublic()) {
                    if (!sub.isAnonymous()) {
                        used_subs.add(sub);
                        sids.add(sub.getShortID());
                    } else {
                        dht_pops.add(sub);
                    }
                } else {
                    this.checkInitialDownload(sub);
                }
            }
            ++i;
        }
        if (sids.size() > 0) {
            try {
                List[] result = PlatformSubscriptionsMessenger.setSelected(sids);
                List versions = result[0];
                List popularities = result[1];
                this.log("Popularity update: updated " + sids.size());
                int i2 = 0;
                while (i2 < sids.size()) {
                    SubscriptionImpl sub = (SubscriptionImpl)used_subs.get(i2);
                    int latest_version = ((Long)versions.get(i2)).intValue();
                    if (latest_version > sub.getVersion()) {
                        this.updateSubscription(sub, latest_version);
                    } else {
                        this.checkInitialDownload(sub);
                    }
                    if (latest_version > 0) {
                        try {
                            long pop = (Long)popularities.get(i2);
                            if (pop >= 0L && pop != sub.getCachedPopularity()) {
                                sub.setCachedPopularity(pop);
                            }
                        }
                        catch (Throwable e) {
                            this.log("Popularity update: Failed to extract popularity", e);
                        }
                    } else {
                        dht_pops.add(sub);
                    }
                    ++i2;
                }
            }
            catch (Throwable e) {
                this.log("Popularity update: Failed to record selected subscriptions", e);
            }
        } else {
            this.log("Popularity update: No selected, public subscriptions");
        }
        if (dht_pops.size() <= 3) {
            i = 0;
            while (i < dht_pops.size()) {
                this.updatePopularityFromDHT((SubscriptionImpl)dht_pops.get(i), false);
                ++i;
            }
        } else {
            new AEThread2("SM:asyncPop", true){

                @Override
                public void run() {
                    int i = 0;
                    while (i < dht_pops.size()) {
                        SubscriptionManagerImpl.this.updatePopularityFromDHT((SubscriptionImpl)dht_pops.get(i), true);
                        ++i;
                    }
                }
            }.start();
        }
    }

    protected void checkUpgrade(SubscriptionImpl sub) {
        this.setSelected(sub);
    }

    protected void setSelected(final SubscriptionImpl sub) {
        if (sub.isSubscribed()) {
            if (sub.isPublic()) {
                new DelayedEvent("SM:setSelected", 0L, new AERunnable(){

                    @Override
                    public void runSupport() {
                        block14: {
                            try {
                                try {
                                    if (!sub.isAnonymous()) {
                                        ArrayList<byte[]> sids = new ArrayList<byte[]>();
                                        sids.add(sub.getShortID());
                                        List[] result = PlatformSubscriptionsMessenger.setSelected(sids);
                                        SubscriptionManagerImpl.this.log("setSelected: " + sub.getName());
                                        int latest_version = ((Long)result[0].get(0)).intValue();
                                        if (latest_version == 0) {
                                            if (sub.isSingleton()) {
                                                SubscriptionManagerImpl.this.checkSingletonPublish(sub);
                                            }
                                        } else if (latest_version > sub.getVersion()) {
                                            SubscriptionManagerImpl.this.updateSubscription(sub, latest_version);
                                        }
                                        if (latest_version > 0) {
                                            try {
                                                long pop = (Long)result[1].get(0);
                                                if (pop >= 0L && pop != sub.getCachedPopularity()) {
                                                    sub.setCachedPopularity(pop);
                                                }
                                                break block14;
                                            }
                                            catch (Throwable e) {
                                                SubscriptionManagerImpl.this.log("Popularity update: Failed to extract popularity", e);
                                            }
                                            break block14;
                                        }
                                        SubscriptionManagerImpl.this.updatePopularityFromDHT(sub, true);
                                        break block14;
                                    }
                                    SubscriptionManagerImpl.this.updatePopularityFromDHT(sub, true);
                                }
                                catch (Throwable e) {
                                    SubscriptionManagerImpl.this.log("setSelected: failed for " + sub.getName(), e);
                                    SubscriptionManagerImpl.this.checkInitialDownload(sub);
                                }
                            }
                            finally {
                                SubscriptionManagerImpl.this.checkInitialDownload(sub);
                            }
                        }
                    }
                });
            } else {
                this.checkInitialDownload(sub);
            }
        }
    }

    protected void checkInitialDownload(SubscriptionImpl subs) {
        if (subs.getHistory().getLastScanTime() == 0L) {
            this.scheduler.download(subs, true, new SubscriptionDownloadListener(){

                @Override
                public void complete(Subscription subs) {
                    SubscriptionManagerImpl.this.log("Initial download of " + subs.getName() + " complete");
                }

                @Override
                public void failed(Subscription subs, SubscriptionException error) {
                    SubscriptionManagerImpl.this.log("Initial download of " + subs.getName() + " failed", error);
                }
            });
        }
    }

    @Override
    public SubscriptionAssociationLookup lookupAssociations(byte[] hash, String description, String[] networks, SubscriptionLookupListener listener) throws SubscriptionException {
        return this.lookupAssociations(this.selectDHTPlugin(networks), hash, description, listener);
    }

    @Override
    public SubscriptionAssociationLookup lookupAssociations(byte[] hash, SubscriptionLookupListener listener) throws SubscriptionException {
        return this.lookupAssociations(hash, "<>", listener);
    }

    @Override
    public SubscriptionAssociationLookup lookupAssociations(byte[] hash, String description, SubscriptionLookupListener listener) throws SubscriptionException {
        DHTPluginInterface dht_plugin;
        try {
            Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(hash);
            dht_plugin = download != null ? this.selectDHTPlugin(download) : this.dht_plugin_public;
        }
        catch (Throwable e) {
            dht_plugin = this.dht_plugin_public;
        }
        return this.lookupAssociations(dht_plugin, hash, description, listener);
    }

    private SubscriptionAssociationLookup lookupAssociations(DHTPluginInterface dht_plugin, final byte[] hash, final String description, final SubscriptionLookupListener listener) throws SubscriptionException {
        if (dht_plugin != null) {
            if (!dht_plugin.isInitialising()) {
                return this.lookupAssociationsSupport(dht_plugin, hash, description, listener);
            }
            final boolean[] cancelled = new boolean[1];
            final long[] timeout = new long[1];
            final SubscriptionAssociationLookup[] actual_res = new SubscriptionAssociationLookup[1];
            SubscriptionAssociationLookup res = new SubscriptionAssociationLookup(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cancel() {
                    SubscriptionManagerImpl.this.log("    Association lookup cancelled");
                    SubscriptionAssociationLookup[] subscriptionAssociationLookupArray = actual_res;
                    synchronized (actual_res) {
                        cancelled[0] = true;
                        if (actual_res[0] != null) {
                            actual_res[0].cancel();
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void setTimeout(long millis) {
                    SubscriptionAssociationLookup[] subscriptionAssociationLookupArray = actual_res;
                    synchronized (actual_res) {
                        timeout[0] = millis;
                        if (actual_res[0] != null) {
                            actual_res[0].setTimeout(millis);
                        }
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return;
                    }
                }
            };
            final DHTPluginInterface f_dht_plugin = dht_plugin;
            new AEThread2("SM:initwait", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SubscriptionAssociationLookup x = SubscriptionManagerImpl.this.lookupAssociationsSupport(f_dht_plugin, hash, description, listener);
                        SubscriptionAssociationLookup[] subscriptionAssociationLookupArray = actual_res;
                        synchronized (actual_res) {
                            actual_res[0] = x;
                            if (cancelled[0]) {
                                x.cancel();
                            }
                            if (timeout[0] != 0L) {
                                x.setTimeout(timeout[0]);
                            }
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                        }
                    }
                    catch (SubscriptionException e) {
                        listener.failed(hash, e);
                    }
                    {
                        return;
                    }
                }
            }.start();
            return res;
        }
        throw new SubscriptionException("No DHT available");
    }

    protected SubscriptionAssociationLookup lookupAssociationsSupport(final DHTPluginInterface dht_plugin, final byte[] hash, final String description, final SubscriptionLookupListener _listener) throws SubscriptionException {
        this.log("Looking up associations for '" + ByteFormatter.encodeString(hash));
        String key = "subscription:assoc:" + ByteFormatter.encodeString(hash);
        final boolean[] cancelled = new boolean[1];
        final SubscriptionException timeout_exception = new SubscriptionException("Timeout");
        final SubscriptionLookupListener listener = new SubscriptionLookupListener(){
            private boolean done = false;
            private List<Subscription> subs = new ArrayList<Subscription>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void found(byte[] hash, Subscription subscription) {
                27 var3_3 = this;
                synchronized (var3_3) {
                    if (this.done) {
                        return;
                    }
                    this.subs.add(subscription);
                }
                _listener.found(hash, subscription);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(byte[] hash, Subscription[] subscriptions) {
                27 var3_3 = this;
                synchronized (var3_3) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                }
                _listener.complete(hash, subscriptions);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(byte[] hash, SubscriptionException error) {
                Subscription[] subscriptions;
                27 var4_3 = this;
                synchronized (var4_3) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    subscriptions = this.subs.toArray(new Subscription[this.subs.size()]);
                }
                if (error == timeout_exception) {
                    _listener.complete(hash, subscriptions);
                } else {
                    _listener.failed(hash, error);
                }
            }
        };
        dht_plugin.get(this.getKeyBytes(key), "Subs assoc read: " + Base32.encode(hash).substring(0, 16), (byte)0, 30, 60000 * (dht_plugin != this.dht_plugin_public ? 2 : 1), true, true, new DHTPluginOperationListener(){
            private Map<HashWrapper, Integer> hits = new HashMap<HashWrapper, Integer>();
            private AESemaphore hits_sem = new AESemaphore("Subs:lookup");
            private List<Subscription> found_subscriptions = new ArrayList<Subscription>();
            private boolean complete;
            private AsyncDispatcher dispatcher = new AsyncDispatcher("SubsMan:AL");

            @Override
            public boolean diversified() {
                return true;
            }

            @Override
            public void starts(byte[] key) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                if (this.isCancelled2()) {
                    return;
                }
                byte[] val = value.getValue();
                if (val.length > 4) {
                    Object v;
                    final int ver = val[0] << 16 & 0xFF0000 | val[1] << 8 & 0xFF00 | val[2] & 0xFF;
                    final byte[] sid = new byte[val.length - 4];
                    System.arraycopy(val, 4, sid, 0, sid.length);
                    HashWrapper hw = new HashWrapper(sid);
                    boolean new_sid = false;
                    Map<HashWrapper, Integer> map = this.hits;
                    synchronized (map) {
                        if (this.complete) {
                            return;
                        }
                        v = this.hits.get(hw);
                        if (v != null) {
                            if (ver > (Integer)v) {
                                this.hits.put(hw, new Integer(ver));
                            }
                        } else {
                            new_sid = true;
                            this.hits.put(hw, new Integer(ver));
                        }
                    }
                    if (new_sid) {
                        SubscriptionManagerImpl.this.log("    Found subscription " + ByteFormatter.encodeString(sid) + " version " + ver);
                        SubscriptionImpl subs = SubscriptionManagerImpl.this.getSubscriptionFromSID(sid);
                        if (subs != null) {
                            v = this.hits;
                            synchronized (v) {
                                this.found_subscriptions.add(subs);
                            }
                            try {
                                listener.found(hash, subs);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            this.hits_sem.release();
                        } else {
                            this.dispatcher.dispatch(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    boolean is_anon = dht_plugin != SubscriptionManagerImpl.this.dht_plugin_public;
                                    SubscriptionManagerImpl.this.lookupSubscription(description, hash, sid, ver, is_anon, new subsLookupListener(){
                                        private boolean sem_done = false;

                                        @Override
                                        public void found(byte[] hash2, Subscription subscription) {
                                        }

                                        @Override
                                        public void complete(byte[] hash2, Subscription[] subscriptions) {
                                            this.done(subscriptions);
                                        }

                                        @Override
                                        public void failed(byte[] hash2, SubscriptionException error) {
                                            this.done(new Subscription[0]);
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        protected void done(Subscription[] subs) {
                                            block14: {
                                                Object object = this;
                                                synchronized (object) {
                                                    if (this.sem_done) {
                                                        return;
                                                    }
                                                    this.sem_done = true;
                                                }
                                                try {
                                                    if (this.isCancelled()) {
                                                        return;
                                                    }
                                                    if (subs.length <= 0) break block14;
                                                    object = hits;
                                                    synchronized (object) {
                                                        found_subscriptions.add(subs[0]);
                                                    }
                                                    try {
                                                        listener.found(hash, subs[0]);
                                                    }
                                                    catch (Throwable e) {
                                                        Debug.printStackTrace(e);
                                                    }
                                                }
                                                finally {
                                                    hits_sem.release();
                                                }
                                            }
                                        }

                                        @Override
                                        public boolean isCancelled() {
                                            return this.isCancelled2();
                                        }
                                    });
                                }
                            });
                        }
                    }
                }
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            @Override
            public void complete(byte[] original_key, boolean timeout_occurred) {
                new AEThread2("SubsManAL:comp"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Subscription[] s;
                        int num_hits;
                        Map map = hits;
                        synchronized (map) {
                            if (complete) {
                                return;
                            }
                            complete = true;
                            num_hits = hits.size();
                        }
                        int i = 0;
                        while (i < num_hits) {
                            if (this.isCancelled2()) {
                                listener.failed(hash, new SubscriptionException("Cancelled"));
                                return;
                            }
                            hits_sem.reserve();
                            ++i;
                        }
                        Map map2 = hits;
                        synchronized (map2) {
                            s = found_subscriptions.toArray(new SubscriptionImpl[found_subscriptions.size()]);
                        }
                        SubscriptionManagerImpl.this.log("    Association lookup complete - " + s.length + " found");
                        try {
                            SubscriptionManagerImpl.this.recordAssociations(hash, (SubscriptionImpl[])s, true);
                        }
                        finally {
                            listener.complete(hash, s);
                        }
                    }
                }.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean isCancelled2() {
                boolean[] blArray = cancelled;
                synchronized (cancelled) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return cancelled[0];
                }
            }
        });
        return new SubscriptionAssociationLookup(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                SubscriptionManagerImpl.this.log("    Association lookup cancelled");
                boolean[] blArray = cancelled;
                synchronized (cancelled) {
                    cancelled[0] = true;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }

            @Override
            public void setTimeout(long millis) {
                SimpleTimer.addEvent("subs:timeout", SystemTime.getOffsetTime(millis), new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        listener.failed(hash, timeout_exception);
                    }
                });
            }
        };
    }

    protected void getPopularity(SubscriptionImpl subs, SubscriptionPopularityListener listener) throws SubscriptionException {
        block6: {
            if (!subs.isAnonymous()) {
                try {
                    long pop = PlatformSubscriptionsMessenger.getPopularityBySID(subs.getShortID());
                    if (pop >= 0L) {
                        this.log("Got popularity of " + subs.getName() + " from platform: " + pop);
                        listener.gotPopularity(pop);
                        return;
                    }
                    if (!subs.isSingleton()) break block6;
                    try {
                        this.checkSingletonPublish(subs);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    listener.gotPopularity(subs.isSubscribed() ? 1 : 0);
                    return;
                }
                catch (Throwable e) {
                    this.log("Subscription lookup via platform failed", e);
                }
            }
        }
        this.getPopularityFromDHT(subs, listener, true);
    }

    protected void getPopularityFromDHT(final SubscriptionImpl subs, final SubscriptionPopularityListener listener, final boolean sync) {
        final DHTPluginInterface dht_plugin = this.selectDHTPlugin(subs);
        if (dht_plugin != null) {
            if (!dht_plugin.isInitialising()) {
                this.getPopularitySupport(dht_plugin, subs, listener, sync);
            } else {
                new AEThread2("SM:popwait", true){

                    @Override
                    public void run() {
                        SubscriptionManagerImpl.this.getPopularitySupport(dht_plugin, subs, listener, sync);
                    }
                }.start();
            }
        } else {
            listener.failed(new SubscriptionException("DHT unavailable"));
        }
    }

    protected void updatePopularityFromDHT(final SubscriptionImpl subs, boolean sync) {
        this.getPopularityFromDHT(subs, new SubscriptionPopularityListener(){

            @Override
            public void gotPopularity(long popularity) {
                subs.setCachedPopularity(popularity);
            }

            @Override
            public void failed(SubscriptionException error) {
                SubscriptionManagerImpl.this.log("Failed to update subscription popularity from DHT", error);
            }
        }, sync);
    }

    protected void getPopularitySupport(final DHTPluginInterface dht_plugin, final SubscriptionImpl subs, final SubscriptionPopularityListener _listener, final boolean sync) {
        this.log("Getting popularity of " + subs.getName() + " from DHT (" + dht_plugin.getNetwork() + ")");
        byte[] sub_id = subs.getShortID();
        int sub_version = subs.getVersion();
        String key = "subscription:publish:" + ByteFormatter.encodeString(sub_id) + ":" + sub_version;
        byte[][] keys = new byte[][]{subs.getPublicationHash(), this.getKeyBytes(key)};
        final AESemaphore sem = new AESemaphore("SM:pop");
        final long[] result = new long[]{-1L};
        int timeout = 15000 * (subs.isAnonymous() ? 3 : 1);
        final SubscriptionPopularityListener listener = new SubscriptionPopularityListener(){
            private boolean done;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void gotPopularity(long popularity) {
                32 var3_2 = this;
                synchronized (var3_2) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                }
                _listener.gotPopularity(popularity);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(SubscriptionException error) {
                32 var2_2 = this;
                synchronized (var2_2) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                }
                _listener.failed(error);
            }
        };
        byte[][] byArrayArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] hash = byArrayArray[n2];
            dht_plugin.get(hash, "Popularity lookup for subscription " + subs.getName(), (byte)8, 5, timeout, false, true, new DHTPluginOperationListener(){
                private boolean diversified;
                private int hits = 0;

                @Override
                public boolean diversified() {
                    this.diversified = true;
                    return false;
                }

                @Override
                public void starts(byte[] key) {
                }

                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    DHTPluginKeyStats stats2 = dht_plugin.decodeStats(value);
                    if (stats2 != null) {
                        result[0] = Math.max(result[0], (long)stats2.getEntryCount());
                        ++this.hits;
                        if (this.hits >= 3) {
                            this.done();
                        }
                    }
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                    if (this.diversified) {
                        result[0] = result[0] * 11L;
                        if (result[0] == 0L) {
                            result[0] = 10L;
                        }
                    }
                    this.done();
                }

                protected void done() {
                    if (sync) {
                        sem.release();
                    } else if (result[0] == -1L) {
                        SubscriptionManagerImpl.this.log("Failed to get popularity of " + subs.getName() + " from DHT");
                        listener.failed(new SubscriptionException("Timeout"));
                    } else {
                        SubscriptionManagerImpl.this.log("Get popularity of " + subs.getName() + " from DHT: " + result[0]);
                        listener.gotPopularity(result[0]);
                    }
                }
            });
            ++n2;
        }
        if (sync) {
            sem.reserve(timeout);
            if (result[0] == -1L) {
                this.log("Failed to get popularity of " + subs.getName() + " from DHT");
                listener.failed(new SubscriptionException("Timeout"));
            } else {
                this.log("Get popularity of " + subs.getName() + " from DHT: " + result[0]);
                listener.gotPopularity(result[0]);
            }
        }
    }

    private void lookupSubscription(final String description, final byte[] association_hash, final byte[] sid, final int version, boolean is_anon, final subsLookupListener listener) {
        try {
            SubscriptionImpl subs = this.getSubscriptionFromPlatform(sid, is_anon, 3);
            this.log("Added temporary subscription: " + subs.getString());
            subs = this.addSubscription(subs);
            listener.complete(association_hash, new Subscription[]{subs});
            return;
        }
        catch (Throwable e) {
            if (listener.isCancelled()) {
                listener.failed(association_hash, new SubscriptionException("Cancelled"));
                return;
            }
            final String sid_str = ByteFormatter.encodeString(sid);
            this.log("Subscription lookup via platform for " + sid_str + " failed", e);
            if (this.getSubscriptionDownloadCount() > 8) {
                this.log("Too many existing subscription downloads");
                listener.complete(association_hash, new Subscription[0]);
                return;
            }
            this.log("Subscription lookup via DHT starts for " + sid_str);
            String key = "subscription:publish:" + ByteFormatter.encodeString(sid) + ":" + version;
            this.dht_plugin_public.get(this.getKeyBytes(key), "Subs lookup read: " + ByteFormatter.encodeString(sid) + ":" + version, (byte)0, 12, 60000L, false, true, new DHTPluginOperationListener(){
                private boolean listener_handled;

                @Override
                public boolean diversified() {
                    return true;
                }

                @Override
                public void starts(byte[] key) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    block14: {
                        byte[] data = value.getValue();
                        try {
                            final Map details = SubscriptionManagerImpl.this.decodeSubscriptionDetails(data);
                            if (SubscriptionImpl.getPublicationVersion(details) == version) {
                                Map singleton_details = (Map)details.get("x");
                                if (singleton_details == null) {
                                    34 var6_7 = this;
                                    synchronized (var6_7) {
                                        if (this.listener_handled) {
                                            return;
                                        }
                                        this.listener_handled = true;
                                    }
                                    SubscriptionManagerImpl.this.log("    found " + sid_str + ", non-singleton");
                                    new AEThread2("Subs:lookup download", true){

                                        @Override
                                        public void run() {
                                            SubscriptionManagerImpl.this.downloadSubscription(description, association_hash, SubscriptionImpl.getPublicationHash(details), sid, version, SubscriptionImpl.getPublicationSize(details), listener);
                                        }
                                    }.start();
                                    break block14;
                                }
                                34 var6_8 = this;
                                synchronized (var6_8) {
                                    if (this.listener_handled) {
                                        return;
                                    }
                                    this.listener_handled = true;
                                }
                                SubscriptionManagerImpl.this.log("    found " + sid_str + ", singleton");
                                try {
                                    SubscriptionImpl subs = SubscriptionManagerImpl.this.createSingletonSubscription(singleton_details, 3, false);
                                    listener.complete(association_hash, new Subscription[]{subs});
                                }
                                catch (Throwable e) {
                                    listener.failed(association_hash, new SubscriptionException("Subscription creation failed", e));
                                }
                                break block14;
                            }
                            SubscriptionManagerImpl.this.log("    found " + sid_str + " but version mismatch");
                        }
                        catch (Throwable e) {
                            SubscriptionManagerImpl.this.log("    found " + sid_str + " but verification failed", e);
                        }
                    }
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(byte[] original_key, boolean timeout_occurred) {
                    SubscriptionManagerImpl.this.log("    " + sid_str + " complete");
                    34 var3_3 = this;
                    synchronized (var3_3) {
                        if (this.listener_handled) {
                            return;
                        }
                        this.listener_handled = true;
                    }
                    listener.complete(association_hash, new Subscription[0]);
                }
            });
            return;
        }
    }

    protected SubscriptionImpl getSubscriptionFromPlatform(byte[] sid, boolean is_anon, int add_type) throws SubscriptionException {
        try {
            PlatformSubscriptionsMessenger.subscriptionDetails details = PlatformSubscriptionsMessenger.getSubscriptionBySID(sid, is_anon);
            SubscriptionImpl res = this.getSubscriptionFromVuzeFileContent(sid, add_type, details.getContent());
            int pop = details.getPopularity();
            if (pop >= 0) {
                res.setCachedPopularity(pop);
            }
            return res;
        }
        catch (SubscriptionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to read subscription from platform", e);
        }
    }

    protected SubscriptionImpl getSubscriptionFromVuzeFile(byte[] sid, int add_type, File file) throws SubscriptionException {
        String file_str;
        VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
        VuzeFile vf = vfh.loadVuzeFile(file_str = file.getAbsolutePath());
        if (vf == null) {
            this.log("Failed to load vuze file from " + file_str);
            throw new SubscriptionException("Failed to load vuze file from " + file_str);
        }
        return this.getSubscriptionFromVuzeFile(sid, add_type, vf);
    }

    protected SubscriptionImpl getSubscriptionFromVuzeFileContent(byte[] sid, int add_type, String content) throws SubscriptionException {
        VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
        VuzeFile vf = vfh.loadVuzeFile(Base64.decode(content));
        if (vf == null) {
            this.log("Failed to load vuze file from " + content);
            throw new SubscriptionException("Failed to load vuze file from content");
        }
        return this.getSubscriptionFromVuzeFile(sid, add_type, vf);
    }

    protected SubscriptionImpl getSubscriptionFromVuzeFile(byte[] sid, int add_type, VuzeFile vf) throws SubscriptionException {
        VuzeFileComponent[] comps = vf.getComponents();
        int j = 0;
        while (j < comps.length) {
            VuzeFileComponent comp2 = comps[j];
            if (comp2.getType() == 16) {
                Map map = comp2.getContent();
                try {
                    SubscriptionBodyImpl body = new SubscriptionBodyImpl(this, map);
                    SubscriptionImpl new_subs = new SubscriptionImpl(this, body, add_type, false);
                    if (Arrays.equals(new_subs.getShortID(), sid)) {
                        return new_subs;
                    }
                }
                catch (Throwable e) {
                    this.log("Subscription decode failed", e);
                }
            }
            ++j;
        }
        throw new SubscriptionException("Subscription not found");
    }

    private void downloadSubscription(String description, final byte[] association_hash, byte[] torrent_hash, final byte[] sid, int version, int size, final subsLookupListener listener) {
        try {
            Object[] res = this.downloadTorrent(torrent_hash, size);
            if (listener.isCancelled()) {
                listener.failed(association_hash, new SubscriptionException("Cancelled"));
                return;
            }
            if (res == null) {
                listener.complete(association_hash, new Subscription[0]);
                return;
            }
            this.downloadSubscription(description, (TOTorrent)res[0], (InetSocketAddress)res[1], sid, version, "Subscription " + ByteFormatter.encodeString(sid) + " for " + ByteFormatter.encodeString(association_hash), new downloadListener(){

                @Override
                public void complete(File data_file) {
                    boolean reported = false;
                    try {
                        if (listener.isCancelled()) {
                            listener.failed(association_hash, new SubscriptionException("Cancelled"));
                            return;
                        }
                        try {
                            SubscriptionImpl subs = SubscriptionManagerImpl.this.getSubscriptionFromVuzeFile(sid, 3, data_file);
                            SubscriptionManagerImpl.this.log("Added temporary subscription: " + subs.getString());
                            subs = SubscriptionManagerImpl.this.addSubscription(subs);
                            listener.complete(association_hash, new Subscription[]{subs});
                            reported = true;
                        }
                        catch (Throwable e) {
                            SubscriptionManagerImpl.this.log("Subscription decode failed", e);
                        }
                    }
                    finally {
                        if (!reported) {
                            listener.complete(association_hash, new Subscription[0]);
                        }
                    }
                }

                @Override
                public void complete(Download download, File torrent_file) {
                    File data_file = FileUtil.newFile(download.getSavePath(), new String[0]);
                    try {
                        try {
                            SubscriptionManagerImpl.this.removeDownload(download, false);
                            this.complete(data_file);
                        }
                        catch (Throwable e) {
                            SubscriptionManagerImpl.this.log("Failed to remove download", e);
                            listener.complete(association_hash, new Subscription[0]);
                            torrent_file.delete();
                            data_file.delete();
                        }
                    }
                    finally {
                        torrent_file.delete();
                        data_file.delete();
                    }
                }

                @Override
                public void failed(Throwable error) {
                    listener.complete(association_hash, new Subscription[0]);
                }

                @Override
                public Map getRecoveryData() {
                    return null;
                }

                @Override
                public boolean isCancelled() {
                    return listener.isCancelled();
                }
            });
        }
        catch (Throwable e) {
            this.log("Subscription download failed", e);
            listener.complete(association_hash, new Subscription[0]);
        }
    }

    protected int getSubscriptionDownloadCount() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        Download[] downloads = pi.getDownloadManager().getDownloads();
        int res = 0;
        int i = 0;
        while (i < downloads.length) {
            Download download = downloads[i];
            if (download.getBooleanAttribute(this.ta_subs_download)) {
                ++res;
            }
            ++i;
        }
        return res;
    }

    protected void associationAdded(SubscriptionImpl subscription, byte[] association_hash) {
        this.recordAssociations(association_hash, new SubscriptionImpl[]{subscription}, false);
        DHTPluginInterface dht_plugin = this.selectDHTPlugin(subscription);
        if (dht_plugin != null) {
            this.publishAssociations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPotentialAssociation(SubscriptionImpl subs, String result_id, String key) {
        if (key == null) {
            Debug.out("Attempt to add null key!");
            return;
        }
        this.log("Added potential association: " + subs.getName() + "/" + result_id + " -> " + key);
        List<Object[]> list = this.potential_associations;
        synchronized (list) {
            this.potential_associations.add(new Object[]{subs, result_id, key, new Long(System.currentTimeMillis())});
            if (this.potential_associations.size() > 512) {
                this.potential_associations.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPotentialAssociations(byte[] hash, String key) {
        this.log("Checking potential association: " + key + " -> " + ByteFormatter.encodeString(hash));
        SubscriptionImpl subs = null;
        String result_id = null;
        List<Object[]> list = this.potential_associations;
        synchronized (list) {
            Object[] entry;
            Iterator<Object[]> it = this.potential_associations.iterator();
            while (it.hasNext()) {
                entry = it.next();
                String this_key = (String)entry[2];
                if (!key.startsWith(this_key)) continue;
                subs = (SubscriptionImpl)entry[0];
                result_id = (String)entry[1];
                this.log("    key matched to subscription " + subs.getName() + "/" + result_id);
                it.remove();
                break;
            }
            if (subs == null) {
                it = this.potential_associations.iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    SubscriptionImpl subs_temp = (SubscriptionImpl)entry[0];
                    String result_id_temp = (String)entry[1];
                    SubscriptionResult result = subs_temp.getHistory().getResult(result_id_temp);
                    if (result == null) continue;
                    Map<Integer, Object> props = result.toPropertyMap();
                    byte[] result_hash = (byte[])props.get(21);
                    if (result_hash == null) {
                        String url = (String)props.get(23);
                        if (url == null) {
                            url = (String)props.get(12);
                        }
                        if (url != null) {
                            String lc_url = url.toLowerCase(Locale.US);
                            if (lc_url.startsWith("http") && lc_url.length() > 10) {
                                String alt_url = UrlUtils.parseTextForURL(url.substring(10), true);
                                if (key.startsWith(alt_url)) {
                                    result_hash = hash;
                                }
                            } else if (lc_url.startsWith("magnet")) {
                                result_hash = UrlUtils.getTruncatedHashFromMagnetURI(lc_url);
                            }
                        }
                    }
                    if (result_hash == null || !Arrays.equals(result_hash, hash)) continue;
                    subs = subs_temp;
                    result_id = result_id_temp;
                    this.log("    hash matched to subscription " + subs.getName() + "/" + result_id);
                    it.remove();
                    break;
                }
            }
        }
        if (subs == null) {
            this.log("    no potential associations found");
        } else {
            SubscriptionResult result = subs.getHistory().getResult(result_id);
            if (result != null) {
                this.log("    result found, marking as read");
                result.setRead(true);
            } else {
                this.log("    result not found");
            }
            this.log("    adding association");
            subs.addAssociation(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tidyPotentialAssociations() {
        Iterator<Object> it;
        long now = SystemTime.getCurrentTime();
        Object object = this.potential_associations;
        synchronized (object) {
            it = this.potential_associations.iterator();
            while (it.hasNext() && this.potential_associations.size() > 16) {
                Object[] entry = it.next();
                long created = (Long)entry[3];
                if (created > now) {
                    entry[3] = new Long(now);
                    continue;
                }
                if (now - created <= 3600000L) continue;
                SubscriptionImpl subs = (SubscriptionImpl)entry[0];
                String result_id = (String)entry[1];
                String key = (String)entry[2];
                this.log("Removing expired potential association: " + subs.getName() + "/" + result_id + " -> " + key);
                it.remove();
            }
        }
        object = this.potential_associations2;
        synchronized (object) {
            it = this.potential_associations2.entrySet().iterator();
            while (it.hasNext() && this.potential_associations2.size() > 16) {
                Map.Entry map_entry = (Map.Entry)it.next();
                byte[] hash = ((HashWrapper)map_entry.getKey()).getBytes();
                Object[] entry = (Object[])map_entry.getValue();
                long created = (Long)entry[2];
                if (created > now) {
                    entry[2] = new Long(now);
                    continue;
                }
                if (now - created <= 3600000L) continue;
                SubscriptionImpl[] subs = (SubscriptionImpl[])entry[0];
                String subs_str = "";
                int i = 0;
                while (i < subs.length) {
                    subs_str = String.valueOf(subs_str) + (i == 0 ? "" : ",") + subs[i].getName();
                    ++i;
                }
                this.log("Removing expired potential association: " + ByteFormatter.encodeString(hash) + " -> " + subs_str);
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordAssociations(byte[] association_hash, SubscriptionImpl[] subscriptions, boolean full_lookup) {
        HashWrapper hw = new HashWrapper(association_hash);
        Map<HashWrapper, Object[]> map = this.potential_associations2;
        synchronized (map) {
            this.potential_associations2.put(hw, new Object[]{subscriptions, full_lookup, new Long(SystemTime.getCurrentTime())});
        }
        if (this.recordAssociationsSupport(association_hash, subscriptions, full_lookup)) {
            map = this.potential_associations2;
            synchronized (map) {
                this.potential_associations2.remove(hw);
            }
        } else {
            this.log("Deferring association for " + ByteFormatter.encodeString(association_hash));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPrepareTrigger(byte[] hash, Subscription[] subs, SubscriptionResult[] results) {
        Map<HashWrapper, Object[]> map = this.potential_associations3;
        synchronized (map) {
            this.potential_associations3.put(new HashWrapper(hash), new Object[]{subs, results});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePrepareTrigger(byte[] hash) {
        Map<HashWrapper, Object[]> map = this.potential_associations3;
        synchronized (map) {
            this.potential_associations3.remove(new HashWrapper(hash));
        }
    }

    protected void prepareDownload(Download download, Subscription[] subscriptions, SubscriptionResult[] results) {
        block9: {
            try {
                String[] nets;
                Tag tag;
                long tag_id;
                String existing;
                String category;
                DownloadManagerState state;
                com.biglybt.core.download.DownloadManager core_dm;
                if (subscriptions.length <= 0) break block9;
                Subscription subs = subscriptions[0];
                if (results != null && results.length > 0) {
                    try {
                        SubscriptionResult result = results[0];
                        Map<Integer, Object> props = result.toPropertyMap();
                        Long leechers = (Long)props.get(4);
                        Long seeds = (Long)props.get(5);
                        if (leechers != null && seeds != null && leechers >= 0L && seeds >= 0L) {
                            core_dm = PluginCoreUtils.unwrap(download);
                            state = core_dm.getDownloadState();
                            long cache = (seeds & 0xFFFFFFL) << 32 | leechers & 0xFFFFFFL;
                            state.setLongAttribute("scsrc", 1L);
                            state.setLongAttribute("scrapecache", cache);
                        }
                    }
                    catch (Throwable result) {
                        // empty catch block
                    }
                }
                if ((category = subs.getCategory()) != null && (existing = download.getAttribute(this.ta_category)) == null) {
                    download.setAttribute(this.ta_category, category);
                }
                if ((tag_id = subs.getTagID()) >= 0L && (tag = TagManagerFactory.getTagManager().lookupTagByUID(tag_id)) != null && !tag.hasTaggable(core_dm = PluginCoreUtils.unwrap(download))) {
                    tag.addTaggable(core_dm);
                }
                if ((nets = subs.getHistory().getDownloadNetworks()) != null) {
                    core_dm = PluginCoreUtils.unwrap(download);
                    state = core_dm.getDownloadState();
                    state.setNetworks(nets);
                    state.setFlag(4096L, true);
                }
            }
            catch (Throwable e) {
                this.log("Failed to prepare association", e);
            }
        }
    }

    protected boolean recordAssociationsSupport(byte[] association_hash, SubscriptionImpl[] subscriptions, boolean full_lookup) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        boolean download_found = false;
        boolean changed = false;
        boolean assoc_added = false;
        try {
            Download download = pi.getDownloadManager().getDownload(association_hash);
            if (download != null) {
                download_found = true;
                LightHashMap map = download.getMapAttribute(this.ta_subscription_info);
                map = map == null ? new LightHashMap() : new LightHashMap(map);
                ArrayList<byte[]> s = (ArrayList<byte[]>)map.get("s");
                int i = 0;
                while (i < subscriptions.length) {
                    SubscriptionImpl subscription = subscriptions[i];
                    byte[] sid = subscription.getShortID();
                    if (s == null) {
                        s = new ArrayList<byte[]>();
                        s.add(sid);
                        changed = true;
                        map.put("s", s);
                    } else {
                        boolean found = false;
                        int j = 0;
                        while (j < s.size()) {
                            byte[] existing = (byte[])s.get(j);
                            if (Arrays.equals(sid, existing)) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) {
                            s.add(sid);
                            if (subscription.isSubscribed() && subscription.isPublic() && !subscription.isSearchTemplate() && subscription.addAssociationSupport(association_hash, true)) {
                                assoc_added = true;
                            }
                            changed = true;
                        }
                    }
                    ++i;
                }
                if (full_lookup) {
                    map.put("lc", new Long(SystemTime.getCurrentTime()));
                    changed = true;
                }
                if (changed) {
                    download.setMapAttribute(this.ta_subscription_info, map);
                }
                if (subscriptions.length == 1 && subscriptions[0].isSearchTemplate() && !full_lookup) {
                    this.searchTemplateOK(subscriptions[0], download);
                }
            }
        }
        catch (Throwable e) {
            this.log("Failed to record associations", e);
        }
        if (changed) {
            Iterator<SubscriptionManagerListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().associationsChanged(association_hash);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (assoc_added) {
            this.publishAssociations();
        }
        return download_found;
    }

    private void searchTemplateOK(final SubscriptionImpl subs, final Download download) {
        if (BuddyPluginUtils.isBetaChatAvailable()) {
            this.chat_write_dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    String name;
                    int pos;
                    DHTPluginInterface dht = SubscriptionManagerImpl.this.selectDHTPlugin(download);
                    if (dht == null) {
                        return;
                    }
                    String target_net = dht.getNetwork();
                    if (target_net != "Public") {
                        if (!BuddyPluginUtils.isBetaChatAnonAvailable()) {
                            return;
                        }
                        target_net = "I2P";
                    }
                    if ((pos = (name = subs.getName()).indexOf(58)) != -1) {
                        name = name.substring(pos + 1).trim();
                    }
                    if (SubscriptionManagerImpl.this.chat_st_done.contains(name)) {
                        return;
                    }
                    SubscriptionManagerImpl.this.chat_st_done.add(name);
                    final BuddyPluginBeta.ChatInstance chat = BuddyPluginUtils.getChat(target_net, "Search Templates");
                    if (chat != null) {
                        chat.setSharedNickname(false);
                        chat.setSaveMessages(false);
                        final String f_msg = String.valueOf(subs.getURI()) + "[[" + UrlUtils.encode(name) + "]]";
                        final Runnable do_write = new Runnable(){

                            @Override
                            public void run() {
                                HashMap<String, Object> flags = new HashMap<String, Object>();
                                flags.put("o", 3);
                                HashMap<String, Object> options = new HashMap<String, Object>();
                                chat.sendMessage(f_msg, flags, options);
                            }
                        };
                        SubscriptionManagerImpl.this.waitForChat(chat, new AERunnable(){

                            @Override
                            public void runSupport() {
                                List<BuddyPluginBeta.ChatMessage> messages = chat.getMessages();
                                for (BuddyPluginBeta.ChatMessage message : messages) {
                                    if (!message.getMessage().equals(f_msg)) continue;
                                    return;
                                }
                                do_write.run();
                            }
                        });
                    }
                }
            });
        }
    }

    private void assocOK(final SubscriptionImpl subs, final SubscriptionImpl.association assoc) {
        if (BuddyPluginUtils.isBetaChatAvailable()) {
            this.chat_write_dispatcher.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    block11: {
                        try {
                            Download download = SubscriptionManagerImpl.this.core.getPluginManager().getDefaultPluginInterface().getDownloadManager().getDownload(assoc.getHash());
                            if (download == null) break block11;
                            if (TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(download.getTorrent()))) {
                                return;
                            }
                            BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
                            if (beta == null || !beta.getEnableAutoDownloadChats()) {
                                return;
                            }
                            final BuddyPluginBeta.ChatInstance chat = BuddyPluginUtils.getChat(download);
                            if (chat == null) break block11;
                            String net = chat.getNetwork();
                            if (net == "Public" || subs.isAnonymous()) {
                                int pos;
                                LinkedList linkedList = SubscriptionManagerImpl.this.chat_assoc_done;
                                synchronized (linkedList) {
                                    if (!SubscriptionManagerImpl.this.chat_assoc_done.contains(chat)) {
                                        SubscriptionManagerImpl.this.chat_assoc_done.add(chat);
                                        if (SubscriptionManagerImpl.this.chat_assoc_done.size() > 50) {
                                            BuddyPluginBeta.ChatInstance c = (BuddyPluginBeta.ChatInstance)SubscriptionManagerImpl.this.chat_assoc_done.removeFirst();
                                            c.setInteresting(false);
                                            c.destroy();
                                        }
                                    }
                                }
                                String name = subs.getName();
                                if (subs.isSearchTemplate() && (pos = name.indexOf(58)) != -1) {
                                    name = name.substring(pos + 1).trim();
                                }
                                final String f_msg = String.valueOf(subs.isSearchTemplate() ? "Search Template" : "Subscription") + " " + subs.getURI() + "[[" + UrlUtils.encode(name) + "]]";
                                SubscriptionManagerImpl.this.waitForChat(chat, new AERunnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void runSupport() {
                                        List<BuddyPluginBeta.ChatMessage> messages = chat.getMessages();
                                        for (BuddyPluginBeta.ChatMessage message : messages) {
                                            if (!message.getMessage().equals(f_msg)) continue;
                                            LinkedList linkedList = SubscriptionManagerImpl.this.chat_assoc_done;
                                            synchronized (linkedList) {
                                                if (SubscriptionManagerImpl.this.chat_assoc_done.remove(chat)) {
                                                    chat.destroy();
                                                }
                                            }
                                            return;
                                        }
                                        HashMap<String, Object> flags = new HashMap<String, Object>();
                                        flags.put("o", 3);
                                        HashMap<String, Object> options = new HashMap<String, Object>();
                                        chat.setSharedNickname(false);
                                        chat.sendMessage(f_msg, flags, options);
                                    }
                                });
                                break block11;
                            }
                            chat.destroy();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForChat(final BuddyPluginBeta.ChatInstance chat, final AERunnable runnable) {
        TimerEventPeriodic[] event2;
        TimerEventPeriodic[] timerEventPeriodicArray = event2 = new TimerEventPeriodic[1];
        synchronized (event2) {
            event2[0] = SimpleTimer.addPeriodicEvent("Subs:chat:checker", 30000L, new TimerEventPerformer(){
                private int elapsed_time;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void perform(TimerEvent e) {
                    this.elapsed_time += 30000;
                    if (chat.isDestroyed()) {
                        TimerEventPeriodic[] timerEventPeriodicArray = event2;
                        synchronized (event2) {
                            event2[0].cancel();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                    if (chat.getIncomingSyncState() != 0 && this.elapsed_time < 300000) return;
                    TimerEventPeriodic[] timerEventPeriodicArray = event2;
                    synchronized (event2) {
                        event2[0].cancel();
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                        SimpleTimer.addEvent("Subs:chat:checker", SystemTime.getOffsetTime(300000L), new TimerEventPerformer(){

                            @Override
                            public void perform(TimerEvent event2) {
                                if (!chat.isDestroyed()) {
                                    SubscriptionManagerImpl.this.chat_write_dispatcher.dispatch(new AERunnable(){

                                        @Override
                                        public void runSupport() {
                                            if (!chat.isDestroyed()) {
                                                runnable.runSupport();
                                            }
                                        }
                                    });
                                }
                            }
                        });
                        return;
                    }
                }
            });
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean publishAssociations() {
        SubscriptionImpl subs_to_publish = null;
        SubscriptionImpl.association assoc_to_publish = null;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            block10: {
                if (this.publish_associations_active < (this.dht_plugin_public.isSleeping() ? 1 : PUB_ASSOC_CONC_MAX)) break block10;
                return false;
            }
            ++this.publish_associations_active;
            this.log("Publishing Associations Starts (conc=" + this.publish_associations_active + ")");
            ArrayList<SubscriptionImpl> subs = new ArrayList<SubscriptionImpl>(this.subscription_map.getReadOnlyMap().values());
            ArrayList<SubscriptionImpl> shuffled_subs = new ArrayList<SubscriptionImpl>(subs);
            Collections.shuffle(shuffled_subs);
            int i = 0;
            while (i < shuffled_subs.size()) {
                SubscriptionImpl sub = (SubscriptionImpl)shuffled_subs.get(i);
                if (sub.isSubscribed() && sub.isPublic() && (assoc_to_publish = sub.getAssociationForPublish()) != null) {
                    subs_to_publish = sub;
                    break;
                }
                ++i;
            }
        }
        if (assoc_to_publish != null) {
            this.publishAssociation(subs_to_publish, assoc_to_publish);
            return false;
        }
        this.log("Publishing Associations Complete");
        subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            --this.publish_associations_active;
        }
        return true;
    }

    private int getPublishRemainingCount() {
        Collection<SubscriptionImpl> subs = this.subscription_map.getReadOnlyMap().values();
        int result = 0;
        for (SubscriptionImpl sub : subs) {
            if (!sub.isSubscribed() || !sub.isPublic()) continue;
            result += sub.getAssociationsRemainingForPublish();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishAssociation(final SubscriptionImpl subs, final SubscriptionImpl.association assoc) {
        this.log("Checking association '" + subs.getString() + "' -> '" + assoc.getString() + "'");
        byte[] sub_id = subs.getShortID();
        int sub_version = subs.getVersion();
        byte[] assoc_hash = assoc.getHash();
        final String key = "subscription:assoc:" + ByteFormatter.encodeString(assoc_hash);
        final byte[] put_value = new byte[sub_id.length + 4];
        System.arraycopy(sub_id, 0, put_value, 4, sub_id.length);
        put_value[0] = (byte)(sub_version >> 16);
        put_value[1] = (byte)(sub_version >> 8);
        put_value[2] = (byte)sub_version;
        put_value[3] = (byte)subs.getFixedRandom();
        final DHTPluginInterface dht_plugin = this.selectDHTPlugin(subs);
        if (dht_plugin == null) {
            SubscriptionManagerImpl subscriptionManagerImpl = this;
            synchronized (subscriptionManagerImpl) {
                --this.publish_associations_active;
            }
            return;
        }
        dht_plugin.get(this.getKeyBytes(key), "Subs assoc read: " + Base32.encode(assoc_hash).substring(0, 16), (byte)0, 30, 60000 * (subs.isAnonymous() ? 2 : 1), false, false, new DHTPluginOperationListener(){
            private int hits;
            private boolean diversified;
            private int max_ver;

            @Override
            public boolean diversified() {
                this.diversified = true;
                return false;
            }

            @Override
            public void starts(byte[] key2) {
            }

            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                byte[] val = value.getValue();
                if (val.length == put_value.length) {
                    boolean diff = false;
                    int i = 4;
                    while (i < val.length) {
                        if (val[i] != put_value[i]) {
                            diff = true;
                            break;
                        }
                        ++i;
                    }
                    if (!diff) {
                        ++this.hits;
                        int ver = val[0] << 16 & 0xFF0000 | val[1] << 8 & 0xFF00 | val[2] & 0xFF;
                        if (ver > this.max_ver) {
                            this.max_ver = ver;
                        }
                    }
                }
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            @Override
            public void complete(byte[] original_key, boolean timeout_occurred) {
                SubscriptionManagerImpl.this.log("Checked association '" + subs.getString() + "' -> '" + assoc.getString() + "' - max_ver=" + this.max_ver + ",hits=" + this.hits + ",div=" + this.diversified);
                if (this.max_ver > subs.getVersion() && !subs.isMine()) {
                    SubscriptionManagerImpl.this.updateSubscription(subs, this.max_ver);
                }
                if (this.hits < 10 && !this.diversified) {
                    SubscriptionManagerImpl.this.log("    Publishing association '" + subs.getString() + "' -> '" + assoc.getString() + "', existing=" + this.hits + ", net=" + dht_plugin.getNetwork());
                    byte flags = 16;
                    if (this.hits < 3 && !this.diversified) {
                        flags = (byte)(flags | 0x20);
                    }
                    if (subs.isAnonymous()) {
                        flags = (byte)(flags | 0x40);
                    }
                    dht_plugin.put(SubscriptionManagerImpl.this.getKeyBytes(key), "Subs assoc write: " + Base32.encode(assoc.getHash()).substring(0, 16) + " -> " + Base32.encode(subs.getShortID()) + ":" + subs.getVersion(), put_value, flags, new DHTPluginOperationListener(){

                        @Override
                        public boolean diversified() {
                            return true;
                        }

                        @Override
                        public void starts(byte[] key) {
                        }

                        @Override
                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        }

                        @Override
                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                        }

                        @Override
                        public void complete(byte[] key, boolean timeout_occurred) {
                            SubscriptionManagerImpl.this.log("        completed '" + subs.getString() + "' -> '" + assoc.getString() + "'");
                            this.publishNext();
                        }
                    });
                    SubscriptionManagerImpl.this.assocOK(subs, assoc);
                } else {
                    SubscriptionManagerImpl.this.log("    Not publishing association '" + subs.getString() + "' -> '" + assoc.getString() + "', existing =" + this.hits);
                    this.publishNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void publishNext() {
                SubscriptionManagerImpl subscriptionManagerImpl = SubscriptionManagerImpl.this;
                synchronized (subscriptionManagerImpl) {
                    SubscriptionManagerImpl subscriptionManagerImpl2 = SubscriptionManagerImpl.this;
                    subscriptionManagerImpl2.publish_associations_active = subscriptionManagerImpl2.publish_associations_active - 1;
                }
                SubscriptionManagerImpl.this.publishNextAssociation();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishNextAssociation() {
        boolean dht_sleeping = this.dht_plugin_public.isSleeping();
        if (dht_sleeping) {
            SubscriptionManagerImpl subscriptionManagerImpl = this;
            synchronized (subscriptionManagerImpl) {
                if (this.publish_next_asyc_pending) {
                    return;
                }
                this.publish_next_asyc_pending = true;
            }
            SimpleTimer.addEvent("subs:pn:async", SystemTime.getCurrentTime() + 60000L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    SubscriptionManagerImpl subscriptionManagerImpl = SubscriptionManagerImpl.this;
                    synchronized (subscriptionManagerImpl) {
                        SubscriptionManagerImpl.this.publish_next_asyc_pending = false;
                    }
                    SubscriptionManagerImpl.this.publishAssociations();
                }
            });
            return;
        }
        this.publishAssociations();
    }

    protected void subscriptionUpdated() {
        if (this.dht_plugin_public != null) {
            this.publishSubscriptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishSubscriptions() {
        ArrayList<SubscriptionImpl> shuffled_subs;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.publish_subscription_active) {
                return;
            }
            Collection<SubscriptionImpl> subs = this.subscription_map.getReadOnlyMap().values();
            shuffled_subs = new ArrayList<SubscriptionImpl>(subs);
            this.publish_subscription_active = true;
        }
        boolean publish_initiated = false;
        try {
            Collections.shuffle(shuffled_subs);
            int i = 0;
            while (i < shuffled_subs.size()) {
                SubscriptionImpl sub = (SubscriptionImpl)shuffled_subs.get(i);
                if (sub.isSubscribed() && sub.isPublic() && !sub.getPublished()) {
                    sub.setPublished(true);
                    this.publishSubscription(sub);
                    publish_initiated = true;
                    break;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            if (!publish_initiated) {
                this.log("Publishing Subscriptions Complete");
                SubscriptionManagerImpl subscriptionManagerImpl2 = this;
                synchronized (subscriptionManagerImpl2) {
                    this.publish_subscription_active = false;
                }
            }
            throw throwable;
        }
        if (!publish_initiated) {
            this.log("Publishing Subscriptions Complete");
            SubscriptionManagerImpl subscriptionManagerImpl3 = this;
            synchronized (subscriptionManagerImpl3) {
                this.publish_subscription_active = false;
            }
        }
    }

    protected void publishSubscription(final SubscriptionImpl subs) {
        this.log("Checking subscription publication '" + subs.getString() + "'");
        byte[] sub_id = subs.getShortID();
        int sub_version = subs.getVersion();
        final String key = "subscription:publish:" + ByteFormatter.encodeString(sub_id) + ":" + sub_version;
        final DHTPluginInterface dht_plugin = this.selectDHTPlugin(subs);
        if (dht_plugin == null) {
            return;
        }
        dht_plugin.get(this.getKeyBytes(key), "Subs presence read: " + ByteFormatter.encodeString(sub_id) + ":" + sub_version, (byte)0, 24, 60000 * (subs.isAnonymous() ? 2 : 1), false, false, new DHTPluginOperationListener(){
            private int hits;
            private boolean diversified;

            @Override
            public boolean diversified() {
                this.diversified = true;
                return false;
            }

            @Override
            public void starts(byte[] key2) {
            }

            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                byte[] data = value.getValue();
                try {
                    Map details = SubscriptionManagerImpl.this.decodeSubscriptionDetails(data);
                    if (subs.getVerifiedPublicationVersion(details) == subs.getVersion()) {
                        ++this.hits;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            @Override
            public void complete(byte[] original_key, boolean timeout_occurred) {
                block7: {
                    SubscriptionManagerImpl.this.log("Checked subscription publication '" + subs.getString() + "' - hits=" + this.hits + ",div=" + this.diversified);
                    if (this.hits < 10 && !this.diversified) {
                        SubscriptionManagerImpl.this.log("    Publishing subscription '" + subs.getString() + ", existing=" + this.hits);
                        try {
                            byte[] put_value = SubscriptionManagerImpl.this.encodeSubscriptionDetails(subs);
                            if (put_value.length < 512) {
                                byte flags = 0;
                                if (this.hits < 3 && !this.diversified) {
                                    flags = (byte)(flags | 0x20);
                                }
                                if (subs.isAnonymous()) {
                                    flags = (byte)(flags | 0x40);
                                }
                                dht_plugin.put(SubscriptionManagerImpl.this.getKeyBytes(key), "Subs presence write: " + Base32.encode(subs.getShortID()) + ":" + subs.getVersion(), put_value, flags, new DHTPluginOperationListener(){

                                    @Override
                                    public boolean diversified() {
                                        return true;
                                    }

                                    @Override
                                    public void starts(byte[] key) {
                                    }

                                    @Override
                                    public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                                    }

                                    @Override
                                    public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                                    }

                                    @Override
                                    public void complete(byte[] key, boolean timeout_occurred) {
                                        SubscriptionManagerImpl.this.log("        completed '" + subs.getString() + "'");
                                        this.publishNext();
                                    }
                                });
                                break block7;
                            }
                            this.publishNext();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            this.publishNext();
                        }
                    } else {
                        SubscriptionManagerImpl.this.log("    Not publishing subscription '" + subs.getString() + "', existing =" + this.hits);
                        this.publishNext();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void publishNext() {
                SubscriptionManagerImpl subscriptionManagerImpl = SubscriptionManagerImpl.this;
                synchronized (subscriptionManagerImpl) {
                    SubscriptionManagerImpl.this.publish_subscription_active = false;
                }
                SubscriptionManagerImpl.this.publishSubscriptions();
            }
        });
    }

    protected void updateSubscription(final SubscriptionImpl subs, final int new_version) {
        this.log("Subscription " + subs.getString() + " - higher version found: " + new_version);
        if (!subs.canAutoUpgradeCheck()) {
            this.log("    Checked too recently or not updateable, ignoring");
            return;
        }
        if (subs.getHighestUserPromptedVersion() >= new_version) {
            this.log("    User has already been prompted for version " + new_version + " so ignoring");
            return;
        }
        byte[] sub_id = subs.getShortID();
        if (!subs.isAnonymous()) {
            try {
                PlatformSubscriptionsMessenger.subscriptionDetails details = PlatformSubscriptionsMessenger.getSubscriptionBySID(sub_id, false);
                if (!this.askIfCanUpgrade(subs, new_version)) {
                    return;
                }
                VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                VuzeFile vf = vfh.loadVuzeFile(Base64.decode(details.getContent()));
                vfh.handleFiles(new VuzeFile[]{vf}, 16);
                return;
            }
            catch (Throwable e) {
                this.log("Failed to read subscription from platform, trying DHT");
            }
        }
        this.log("Checking subscription '" + subs.getString() + "' upgrade to version " + new_version);
        String key = "subscription:publish:" + ByteFormatter.encodeString(sub_id) + ":" + new_version;
        DHTPluginInterface dht_plugin = this.selectDHTPlugin(subs);
        dht_plugin.get(this.getKeyBytes(key), "Subs update read: " + Base32.encode(sub_id) + ":" + new_version, (byte)0, 12, 60000 * (subs.isAnonymous() ? 2 : 1), false, false, new DHTPluginOperationListener(){
            private byte[] verified_hash;
            private int verified_size;

            @Override
            public boolean diversified() {
                return true;
            }

            @Override
            public void starts(byte[] key) {
            }

            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                byte[] data = value.getValue();
                try {
                    Map details = SubscriptionManagerImpl.this.decodeSubscriptionDetails(data);
                    if (this.verified_hash == null && subs.getVerifiedPublicationVersion(details) == new_version) {
                        this.verified_hash = SubscriptionImpl.getPublicationHash(details);
                        this.verified_size = SubscriptionImpl.getPublicationSize(details);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            @Override
            public void complete(byte[] original_key, boolean timeout_occurred) {
                if (this.verified_hash != null) {
                    SubscriptionManagerImpl.this.log("    Subscription '" + subs.getString() + " upgrade verified as authentic");
                    SubscriptionManagerImpl.this.updateSubscription(subs, new_version, this.verified_hash, this.verified_size);
                } else {
                    SubscriptionManagerImpl.this.log("    Subscription '" + subs.getString() + " upgrade not verified");
                }
            }
        });
    }

    protected byte[] encodeSubscriptionDetails(SubscriptionImpl subs) throws IOException {
        byte[] data;
        byte header;
        Map details = subs.getPublicationDetails();
        details.put("!", new Long(random_seed));
        byte[] encoded = BEncoder.encode(details);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream os = new GZIPOutputStream(baos);
        os.write(encoded);
        os.close();
        byte[] compressed = baos.toByteArray();
        if (compressed.length < encoded.length) {
            header = 1;
            data = compressed;
        } else {
            header = 0;
            data = encoded;
        }
        byte[] result = new byte[data.length + 1];
        result[0] = header;
        System.arraycopy(data, 0, result, 1, data.length);
        return result;
    }

    protected Map decodeSubscriptionDetails(byte[] data) throws IOException {
        byte[] to_decode;
        if (data[0] == 0) {
            to_decode = new byte[data.length - 1];
            System.arraycopy(data, 1, to_decode, 0, data.length - 1);
        } else {
            GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(data, 1, data.length - 1));
            to_decode = FileUtil.readInputStreamAsByteArray(is);
            is.close();
        }
        Map<String, Object> res = BDecoder.decode(to_decode);
        res.remove("!");
        return res;
    }

    protected void updateSubscription(final SubscriptionImpl subs, final int update_version, final byte[] update_hash, final int update_size) {
        this.log("Subscription " + subs.getString() + " - update hash=" + ByteFormatter.encodeString(update_hash) + ", size=" + update_size);
        new AEThread2("SubsUpdate", true){

            @Override
            public void run() {
                try {
                    Object[] res = SubscriptionManagerImpl.this.downloadTorrent(update_hash, update_size);
                    if (res != null) {
                        SubscriptionManagerImpl.this.updateSubscription(subs, update_version, (TOTorrent)res[0], (InetSocketAddress)res[1]);
                    }
                }
                catch (Throwable e) {
                    SubscriptionManagerImpl.this.log("    update failed", e);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] downloadTorrent(byte[] hash, int update_size) {
        TOTorrent torrent;
        InetSocketAddress[] sender;
        block12: {
            block11: {
                byte[] torrent_data;
                block10: {
                    if (!this.isSubsDownloadEnabled()) {
                        this.log("    Can't download subscription " + Base32.encode(hash) + " as feature disabled");
                        return null;
                    }
                    MagnetPlugin magnet_plugin = this.getMagnetPlugin();
                    if (magnet_plugin == null) {
                        this.log("    Can't download, no magnet plugin");
                        return null;
                    }
                    try {
                        sender = new InetSocketAddress[1];
                        torrent_data = magnet_plugin.download(new MagnetPluginProgressListener(){

                            @Override
                            public void reportSize(long size) {
                            }

                            @Override
                            public void reportActivity(String str) {
                                SubscriptionManagerImpl.this.log("    MagnetDownload: " + str);
                            }

                            @Override
                            public void reportCompleteness(int percent) {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void reportContributor(InetSocketAddress address) {
                                InetSocketAddress[] inetSocketAddressArray = sender;
                                synchronized (sender) {
                                    sender[0] = address;
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return;
                                }
                            }

                            @Override
                            public boolean verbose() {
                                return false;
                            }

                            @Override
                            public boolean cancelled() {
                                return false;
                            }
                        }, hash, "", new InetSocketAddress[0], Collections.emptyList(), Collections.emptyMap(), 300000L, 1);
                        if (torrent_data != null) break block10;
                        this.log("    download failed - timeout");
                        return null;
                    }
                    catch (Throwable e) {
                        this.log("    download failed", e);
                        return null;
                    }
                }
                this.log("Subscription torrent downloaded");
                torrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(torrent_data);
                if (torrent.getSize() <= (long)(update_size + 10240)) break block11;
                this.log("Subscription download abandoned, torrent size is " + torrent.getSize() + ", underlying data size is " + update_size);
                return null;
            }
            if (torrent.getSize() <= 0x400000L) break block12;
            this.log("Subscription download abandoned, torrent size is too large (" + torrent.getSize() + ")");
            return null;
        }
        InetSocketAddress[] inetSocketAddressArray = sender;
        synchronized (sender) {
            // ** MonitorExit[var7_8] (shouldn't be in output)
            return new Object[]{torrent, sender[0]};
        }
    }

    private void downloadSubscription(String description, final TOTorrent torrent, final InetSocketAddress peer, byte[] subs_id, int version, String name, final downloadListener listener) {
        try {
            LightWeightSeed lws = LightWeightSeedManager.getSingleton().get(new HashWrapper(torrent.getHash()));
            if (lws != null) {
                this.log("Light weight seed found");
                listener.complete(lws.getDataLocation());
            } else {
                TimerEventPeriodic[] event2;
                String sid = ByteFormatter.encodeString(subs_id);
                File dir = this.getSubsDir();
                if (!(dir = FileUtil.newFile(dir, "temp")).exists() && !dir.mkdirs()) {
                    throw new IOException("Failed to create dir '" + dir + "'");
                }
                final File torrent_file = FileUtil.newFile(dir, String.valueOf(sid) + "_" + version + ".torrent");
                File data_file = FileUtil.newFile(dir, VuzeFileHandler.getVuzeFileName(String.valueOf(sid) + "_" + version));
                PluginInterface pi = PluginInitializer.getDefaultInterface();
                final DownloadManager dm = pi.getDownloadManager();
                Download download = dm.getDownload(torrent.getHash());
                if (download == null) {
                    this.log("Adding download for subscription '" + new String(torrent.getName()) + "'");
                    boolean is_update = this.getSubscriptionFromSID(subs_id) != null;
                    PlatformTorrentUtils.setContentTitle(torrent, "Subscription " + (is_update ? "Update" : "Download") + ": " + description + "(" + name + ")");
                    TorrentUtils.setFlag(torrent, 1, true);
                    TorrentImpl t = new TorrentImpl(torrent);
                    t.setDefaultEncoding();
                    t.writeToFile(torrent_file);
                    download = dm.addDownload(t, torrent_file, data_file);
                    download.setFlag(4L, true);
                    download.setFlag(16384L, true);
                    download.setBooleanAttribute(this.ta_subs_download, true);
                    Map rd = listener.getRecoveryData();
                    if (rd != null) {
                        download.setMapAttribute(this.ta_subs_download_rd, rd);
                    }
                } else {
                    this.log("Existing download found for subscription '" + new String(torrent.getName()) + "'");
                }
                final Download f_download = download;
                event2 = new TimerEventPeriodic[]{SimpleTimer.addPeriodicEvent("SM:cancelTimer", 10000L, new TimerEventPerformer(){
                    private long start_time = SystemTime.getMonotonousTime();

                    @Override
                    public void perform(TimerEvent ev) {
                        boolean kill = false;
                        try {
                            Download download = dm.getDownload(torrent.getHash());
                            if (listener.isCancelled() || download == null) {
                                kill = true;
                            } else {
                                int state = download.getState();
                                if (state == 8) {
                                    SubscriptionManagerImpl.this.log("Download entered error state, removing");
                                    kill = true;
                                } else {
                                    DownloadScrapeResult scrape;
                                    long now = SystemTime.getMonotonousTime();
                                    long running_for = now - this.start_time;
                                    if (running_for > 600000L) {
                                        SubscriptionManagerImpl.this.log("Download hasn't completed in permitted time, removing");
                                        kill = true;
                                    } else if (running_for > 240000L) {
                                        if (download.getStats().getDownloaded() == 0L) {
                                            SubscriptionManagerImpl.this.log("Download has zero downloaded, removing");
                                            kill = true;
                                        }
                                    } else if (running_for > 120000L && ((scrape = download.getLastScrapeResult()) == null || scrape.getSeedCount() <= 0)) {
                                        SubscriptionManagerImpl.this.log("Download has no seeds, removing");
                                        kill = true;
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            SubscriptionManagerImpl.this.log("Download failed", e);
                            kill = true;
                        }
                        if (kill && event2[0] != null) {
                            try {
                                event2[0].cancel();
                                if (!listener.isCancelled()) {
                                    listener.failed(new SubscriptionException("Download abandoned"));
                                }
                            }
                            finally {
                                SubscriptionManagerImpl.this.removeDownload(f_download, true);
                                torrent_file.delete();
                            }
                        }
                    }
                })};
                download.addCompletionListener(new DownloadCompletionListener(){

                    @Override
                    public void onCompletion(Download d) {
                        listener.complete(d, torrent_file);
                    }
                });
                if (download.isComplete()) {
                    listener.complete(download, torrent_file);
                } else {
                    download.setForceStart(true);
                    if (peer != null) {
                        download.addPeerListener(new DownloadPeerListener(){

                            @Override
                            public void peerManagerAdded(Download download, PeerManager peer_manager) {
                                InetSocketAddress tcp = AddressUtils.adjustTCPAddress(peer, true);
                                InetSocketAddress udp = AddressUtils.adjustUDPAddress(peer, true);
                                SubscriptionManagerImpl.this.log("    Injecting peer into download: " + tcp);
                                peer_manager.addPeer(tcp.getAddress().getHostAddress(), tcp.getPort(), udp.getPort(), true);
                            }

                            @Override
                            public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                            }
                        });
                    }
                }
            }
        }
        catch (Throwable e) {
            this.log("Failed to add download", e);
            listener.failed(e);
        }
    }

    protected void updateSubscription(final SubscriptionImpl subs, final int new_version, TOTorrent torrent, InetSocketAddress peer) {
        this.log("Subscription " + subs.getString() + " - update torrent: " + new String(torrent.getName()));
        if (!this.askIfCanUpgrade(subs, new_version)) {
            return;
        }
        this.downloadSubscription(subs.getName(true), torrent, peer, subs.getShortID(), new_version, subs.getName(false), new downloadListener(){

            @Override
            public void complete(File data_file) {
                SubscriptionManagerImpl.this.updateSubscription(subs, data_file);
            }

            @Override
            public void complete(Download download, File torrent_file) {
                SubscriptionManagerImpl.this.updateSubscription(subs, download, torrent_file, FileUtil.newFile(download.getSavePath(), new String[0]));
            }

            @Override
            public void failed(Throwable error) {
                SubscriptionManagerImpl.this.log("Failed to download subscription", error);
            }

            @Override
            public Map getRecoveryData() {
                HashMap<String, Object> rd = new HashMap<String, Object>();
                rd.put("sid", subs.getShortID());
                rd.put("ver", new Long(new_version));
                return rd;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
    }

    protected boolean askIfCanUpgrade(SubscriptionImpl subs, int new_version) {
        subs.setHighestUserPromptedVersion(new_version);
        UIManager ui_manager = StaticUtilities.getUIManager(120000L);
        String details = MessageText.getString("subscript.add.upgradeto.desc", new String[]{String.valueOf(new_version), subs.getName()});
        long res = ui_manager.showMessageBox("subscript.add.upgrade.title", "!" + details + "!", 12L);
        if (res != 4L) {
            this.log("    User declined upgrade");
            return false;
        }
        return true;
    }

    protected boolean recoverSubscriptionUpdate(Download download, final Map rd) {
        byte[] sid = (byte[])rd.get("sid");
        int version = ((Long)rd.get("ver")).intValue();
        final SubscriptionImpl subs = this.getSubscriptionFromSID(sid);
        if (subs == null) {
            this.log("Can't recover '" + download.getName() + "' - subscription " + ByteFormatter.encodeString(sid) + " not found");
            return false;
        }
        this.downloadSubscription(download.getName(), ((TorrentImpl)download.getTorrent()).getTorrent(), null, subs.getShortID(), version, subs.getName(false), new downloadListener(){

            @Override
            public void complete(File data_file) {
                SubscriptionManagerImpl.this.updateSubscription(subs, data_file);
            }

            @Override
            public void complete(Download download, File torrent_file) {
                SubscriptionManagerImpl.this.updateSubscription(subs, download, torrent_file, FileUtil.newFile(download.getSavePath(), new String[0]));
            }

            @Override
            public void failed(Throwable error) {
                SubscriptionManagerImpl.this.log("Failed to download subscription", error);
            }

            @Override
            public Map getRecoveryData() {
                return rd;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
        return true;
    }

    protected void updateSubscription(SubscriptionImpl subs, Download download, File torrent_file, File data_file) {
        try {
            this.removeDownload(download, false);
            try {
                this.updateSubscription(subs, data_file);
            }
            finally {
                if (!data_file.delete()) {
                    this.log("Failed to delete update file '" + data_file + "'");
                }
                if (!torrent_file.delete()) {
                    this.log("Failed to delete update torrent '" + torrent_file + "'");
                }
            }
        }
        catch (Throwable e) {
            this.log("Failed to remove update download", e);
        }
    }

    protected void removeDownload(Download download, boolean remove_data) {
        try {
            download.stopAndRemove(true, remove_data);
            this.log("Removed download '" + download.getName() + "'");
        }
        catch (Throwable e) {
            this.log("Failed to remove download '" + download.getName() + "'", e);
        }
    }

    protected void updateSubscription(SubscriptionImpl subs, File data_location) {
        this.log("Updating subscription '" + subs.getString() + " using '" + data_location + "'");
        VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
        VuzeFile vf = vfh.loadVuzeFile(data_location.getAbsolutePath());
        vfh.handleFiles(new VuzeFile[]{vf}, 16);
    }

    protected MagnetPlugin getMagnetPlugin() {
        PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(MagnetPlugin.class);
        if (pi == null) {
            return null;
        }
        return (MagnetPlugin)pi.getPlugin();
    }

    protected Engine getEngine(SubscriptionImpl subs, Map json_map, boolean local_only) throws SubscriptionException {
        long id = (Long)json_map.get("engine_id");
        Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngine(id);
        if (engine != null) {
            return engine;
        }
        if (!local_only) {
            try {
                if (id >= 0L && id < Integer.MAX_VALUE) {
                    this.log("Engine " + id + " not present, loading");
                    try {
                        engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().addEngine(id);
                        return engine;
                    }
                    catch (Throwable e) {
                        throw new SubscriptionException("Failed to load engine '" + id + "'", e);
                    }
                }
            }
            catch (Throwable e) {
                this.log("Failed to load search template", e);
            }
        }
        if ((engine = subs.extractEngine(json_map, id)) != null) {
            return engine;
        }
        throw new SubscriptionException("Failed to extract engine id " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void libraryMutated() {
        HashMap<SubscriptionImpl, Object[]> to_check;
        Map<SubscriptionImpl, Object[]> map = this.result_cache;
        synchronized (map) {
            lib_mutation_count.incrementAndGet();
            to_check = new HashMap<SubscriptionImpl, Object[]>(this.result_cache);
            this.result_cache.clear();
        }
        for (Map.Entry entry : to_check.entrySet()) {
            LinkedHashMap temp = (LinkedHashMap)((Object[])entry.getValue())[0];
            this.processResults((SubscriptionImpl)entry.getKey(), temp.values(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedHashMap<String, SubscriptionResultImpl> loadResults(SubscriptionImpl subs) {
        LinkedHashMap<String, SubscriptionResultImpl> results;
        boolean check_results = false;
        Map<SubscriptionImpl, Object[]> map = this.result_cache;
        synchronized (map) {
            block12: {
                Integer mut = (Integer)subs.getUserData(LIB_MUTATION_KEY);
                check_results = mut == null || mut.intValue() != lib_mutation_count.get();
                subs.setUserData(LIB_MUTATION_KEY, lib_mutation_count.get());
                Object[] entry = this.result_cache.get(subs);
                if (entry != null) {
                    entry[1] = SystemTime.getMonotonousTime();
                    return (LinkedHashMap)entry[0];
                }
                results = new LinkedHashMap<String, SubscriptionResultImpl>(1024);
                try {
                    File f = this.getResultsFile(subs);
                    Map map2 = FileUtil.readResilientFile(f);
                    List list = (List)map2.get("results");
                    if (list == null) break block12;
                    SubscriptionHistoryImpl history = subs.getHistory();
                    int i = 0;
                    while (i < list.size()) {
                        Map result_map = (Map)list.get(i);
                        try {
                            SubscriptionResultImpl result = new SubscriptionResultImpl(history, result_map);
                            results.put(result.getID(), result);
                        }
                        catch (Throwable e) {
                            this.log("Failed to decode result '" + result_map + "'", e);
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    this.log("Failed to load results for '" + subs.getName() + "' - continuing with empty result set", e);
                }
            }
            this.result_cache.put(subs, new Object[]{results, SystemTime.getMonotonousTime()});
            if (this.result_cache.size() > 5) {
                SubscriptionImpl oldest_sub = null;
                long oldest_time = Long.MAX_VALUE;
                for (Map.Entry<SubscriptionImpl, Object[]> x : this.result_cache.entrySet()) {
                    long time = (Long)x.getValue()[1];
                    if (time >= oldest_time) continue;
                    oldest_time = time;
                    oldest_sub = x.getKey();
                }
                this.result_cache.remove(oldest_sub);
            }
        }
        if (check_results) {
            this.processResults(subs, results.values(), false);
        }
        return results;
    }

    protected void setCategoryOnExisting(SubscriptionImpl subscription, String old_category, String new_category) {
        Download[] downloads;
        PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        Download[] downloadArray = downloads = default_pi.getDownloadManager().getDownloads();
        int n = downloads.length;
        int n2 = 0;
        while (n2 < n) {
            String existing;
            Download d = downloadArray[n2];
            if (this.subscriptionExists(d, subscription) && ((existing = d.getAttribute(this.ta_category)) == null || existing.equals(old_category))) {
                d.setAttribute(this.ta_category, new_category);
            }
            ++n2;
        }
    }

    @Override
    public int getDefaultCheckFrequencyMins() {
        int def = COConfigurationManager.getIntParameter(CONFIG_DEF_CHECK_MINS, 120);
        if (def <= 0) {
            def = 120;
        }
        return def;
    }

    @Override
    public void setDefaultCheckFrequencyMins(int def) {
        if (def != this.getDefaultCheckFrequencyMins()) {
            COConfigurationManager.setParameter(CONFIG_DEF_CHECK_MINS, def);
        }
    }

    @Override
    public int getMaxNonDeletedResults() {
        return COConfigurationManager.getIntParameter(CONFIG_MAX_RESULTS);
    }

    @Override
    public void setMaxNonDeletedResults(int max) {
        if (max != this.getMaxNonDeletedResults()) {
            COConfigurationManager.setParameter(CONFIG_MAX_RESULTS, max);
        }
    }

    @Override
    public boolean getAutoStartDownloads() {
        return COConfigurationManager.getBooleanParameter(CONFIG_AUTO_START_DLS);
    }

    @Override
    public void setAutoStartDownloads(boolean auto_start) {
        if (auto_start != this.getAutoStartDownloads()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_START_DLS, auto_start);
        }
    }

    @Override
    public int getAutoStartMinMB() {
        return COConfigurationManager.getIntParameter(CONFIG_AUTO_START_MIN_MB);
    }

    @Override
    public void setAutoStartMinMB(int mb) {
        if (mb != this.getAutoStartMinMB()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_START_MIN_MB, mb);
        }
    }

    @Override
    public int getAutoStartMaxMB() {
        return COConfigurationManager.getIntParameter(CONFIG_AUTO_START_MAX_MB);
    }

    @Override
    public void setAutoStartMaxMB(int mb) {
        if (mb != this.getAutoStartMaxMB()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_START_MAX_MB, mb);
        }
    }

    @Override
    public int getAutoDownloadMarkReadAfterDays() {
        return COConfigurationManager.getIntParameter(CONFIG_AUTO_MARK_READ);
    }

    @Override
    public void setAutoDownloadMarkReadAfterDays(int days) {
        if (days != this.getAutoDownloadMarkReadAfterDays()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_MARK_READ, days);
        }
    }

    @Override
    public boolean getAddHashDirs() {
        return COConfigurationManager.getBooleanParameter(CONFIG_ADD_HASHES);
    }

    @Override
    public void setAddHashDirs(boolean b) {
        if (b != this.getAddHashDirs()) {
            COConfigurationManager.setParameter(CONFIG_ADD_HASHES, b);
        }
    }

    protected boolean shouldAutoStart(Torrent torrent) {
        if (this.getAutoStartDownloads()) {
            long min = (long)(this.getAutoStartMinMB() * 1024) * 1024L;
            long max = (long)(this.getAutoStartMaxMB() * 1024) * 1024L;
            if (min <= 0L && max <= 0L) {
                return true;
            }
            long size = torrent.getSize();
            if (min > 0L && size < min) {
                return false;
            }
            return max <= 0L || size <= max;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveResults(SubscriptionImpl subs, SubscriptionResultImpl[] results, List<SubscriptionResultImpl> new_unread_results) {
        ArrayList<SubscriptionResultImpl> saved_results = new ArrayList<SubscriptionResultImpl>(results.length);
        Map<SubscriptionImpl, Object[]> map = this.result_cache;
        synchronized (map) {
            this.result_cache.remove(subs);
            try {
                ArrayList<SubscriptionResultImpl> deleted_old_results = new ArrayList<SubscriptionResultImpl>(results.length);
                int now_days = (int)(SystemTime.getCurrentTime() / 86400000L);
                SubscriptionResultImpl[] subscriptionResultImplArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    SubscriptionResultImpl result = subscriptionResultImplArray[n2];
                    if (result.isDeleted()) {
                        int days = result.getDeletedLastSeen();
                        if (days > 0 && now_days - days > 14) {
                            deleted_old_results.add(result);
                        } else {
                            saved_results.add(result);
                        }
                    } else {
                        saved_results.add(result);
                    }
                    ++n2;
                }
                if (deleted_old_results.size() > 10000) {
                    Collections.sort(deleted_old_results, (r1, r2) -> r2.getDeletedLastSeen() - r1.getDeletedLastSeen());
                    int i = 0;
                    while (i < 5000) {
                        saved_results.add((SubscriptionResultImpl)deleted_old_results.get(i));
                        ++i;
                    }
                } else {
                    for (SubscriptionResultImpl result : deleted_old_results) {
                        saved_results.add(result);
                    }
                }
                File f = this.getResultsFile(subs);
                HashMap map2 = new HashMap();
                ArrayList<Map> list = new ArrayList<Map>(results.length);
                map2.put("results", list);
                for (SubscriptionResultImpl result : saved_results) {
                    list.add(result.toBEncodedMap());
                }
                FileUtil.writeResilientFileIncrementally(f, map2);
            }
            catch (Throwable e) {
                this.log("Failed to save results for '" + subs.getName(), e);
            }
        }
        subs.invalidateNewestResultTime();
        if (new_unread_results != null && !new_unread_results.isEmpty()) {
            this.processResults(subs, new_unread_results, true);
        }
    }

    private void processResults(SubscriptionImpl subs, Collection<SubscriptionResultImpl> results, boolean has_new_results) {
        if (has_new_results) {
            this.checkGloballyMarkedRead(results);
            String script = subs.getExecuteOnNewResult();
            if (script != null && !script.isEmpty()) {
                ArrayList<SubscriptionResultImpl> new_results = new ArrayList<SubscriptionResultImpl>(results.size());
                for (SubscriptionResultImpl result : results) {
                    if (result.isDeleted() || result.getRead()) continue;
                    new_results.add(result);
                }
                if (!new_results.isEmpty()) {
                    result_exec.dispatch(() -> this.evalScript(subs, script, new_results, "subs:newResult"));
                }
            }
        }
        if (this.getMarkResultsInLibraryRead()) {
            for (SubscriptionResultImpl test_result : results) {
                if (test_result.isDeleted() || test_result.getRead()) continue;
                library_checker.dispatch(() -> {
                    ArrayList<String> id_list = new ArrayList<String>(results.size());
                    SubscriptionResultImpl last_result = null;
                    for (SubscriptionResultImpl result : results) {
                        int res = SubscriptionUtils.getHashStatus(result);
                        if (res != 1 && res != 2 && res != 3) continue;
                        last_result = result;
                        id_list.add(result.getID());
                    }
                    int hits = id_list.size();
                    if (hits == 1) {
                        last_result.setRead(true);
                    } else if (hits > 1) {
                        boolean[] read = new boolean[hits];
                        Arrays.fill(read, true);
                        subs.getHistory().markResults(id_list.toArray(new String[hits]), read);
                    }
                });
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkGloballyMarkedRead(Collection<SubscriptionResultImpl> results) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            this.getGMAR(false);
            if (this.last_gmar != null && !this.gmar_cache.isEmpty()) {
                for (SubscriptionResultImpl result : results) {
                    SubscriptionResult sr;
                    if (result.isDeleted()) continue;
                    String rid = null;
                    String hash = result.getAssetHash();
                    if (hash != null) {
                        rid = this.gmar_cache.get(hash);
                    } else {
                        Map<Integer, Object> properties = result.toPropertyMap();
                        String name = (String)properties.get(1);
                        Long size = (Long)properties.get(3);
                        if (name != null && size != null) {
                            String ns = String.valueOf(name) + ":" + size;
                            rid = this.gmar_cache.get(ns);
                        }
                    }
                    if (rid == null || (sr = this.last_gmar.getHistory().getResult(rid)) == null || sr.isDeleted()) continue;
                    result.setRead(true);
                }
            }
        }
    }

    protected void evalScript(SubscriptionImpl subs, String script, List<SubscriptionResultImpl> subs_results, String intent_key) {
        String start;
        if (subs_results.isEmpty()) {
            return;
        }
        String script_type = "";
        if ((script = script.trim()).length() >= 10 && ((start = script.substring(0, 10).toLowerCase(Locale.US)).startsWith("javascript") || start.startsWith("plugin"))) {
            int p1 = script.indexOf(40);
            int p2 = script.lastIndexOf(41);
            if (p1 != -1 && p2 != -1) {
                if ((script = script.substring(p1 + 1, p2).trim()).startsWith("\"") && script.endsWith("\"")) {
                    script = script.substring(1, script.length() - 1);
                }
                script = script.replaceAll("\\\\\"", "\"");
                String string = script_type = start.startsWith("javascript") ? "javascript" : "plugin";
            }
        }
        if (script_type == "") {
            String error = "Unrecognised script type: " + script;
            Debug.out(error);
            return;
        }
        boolean provider_found = false;
        List<ScriptProvider> providers = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getScriptProviders();
        for (ScriptProvider p : providers) {
            if (p.getScriptType() != script_type) continue;
            provider_found = true;
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            String intent = String.valueOf(intent_key) + "(\"" + subs.getName() + "\",\"" + subs_results.get(0).getID() + (subs_results.size() == 1 ? "" : "...") + "\")";
            bindings.put("intent", intent);
            bindings.put("subscription", subs);
            bindings.put("subscription_results", subs_results);
            try {
                Object object = p.eval(script, bindings);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (script_type == "javascript" && !provider_found && !this.js_plugin_install_tried) {
            this.js_plugin_install_tried = true;
            PluginUtils.installJavaScriptPlugin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        if (!FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
            return;
        }
        this.log("Loading configuration");
        boolean some_are_mine = false;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
            List l_subs = (List)map.get("subs");
            if (l_subs != null) {
                HashMap<String, SubscriptionImpl> loaded = new HashMap<String, SubscriptionImpl>();
                int i = 0;
                while (i < l_subs.size()) {
                    Map m = (Map)l_subs.get(i);
                    try {
                        SubscriptionImpl sub = new SubscriptionImpl(this, m);
                        loaded.put(sub.getID(), sub);
                        if (sub.isMine()) {
                            some_are_mine = true;
                        }
                        this.log("    loaded " + sub.getString());
                    }
                    catch (Throwable e) {
                        this.log("Failed to import subscription from " + m, e);
                    }
                    ++i;
                }
                this.subscription_map.putAll(loaded);
            }
        }
        if (some_are_mine) {
            this.addMetaSearchListener();
        }
    }

    protected void configDirty(SubscriptionImpl subs, int reason) {
        this.changeSubscription(subs, reason);
        this.configDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("Subscriptions:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    SubscriptionManagerImpl subscriptionManagerImpl = SubscriptionManagerImpl.this;
                    synchronized (subscriptionManagerImpl) {
                        if (!SubscriptionManagerImpl.this.config_dirty) {
                            return;
                        }
                        SubscriptionManagerImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        this.log("Saving configuration");
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            this.config_dirty = false;
            if (this.subscription_map.isEmpty()) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                HashMap map = new HashMap();
                ArrayList<Map> l_subs = new ArrayList<Map>();
                map.put("subs", l_subs);
                for (SubscriptionImpl sub : this.subscription_map.getReadOnlyMap().values()) {
                    try {
                        l_subs.add(sub.toMap());
                    }
                    catch (Throwable e) {
                        this.log("Failed to save subscription " + sub.getString(), e);
                    }
                }
                FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
            }
        }
    }

    private byte[] getKeyBytes(String key) {
        try {
            return key.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Debug.out(e);
            return key.getBytes();
        }
    }

    private AEDiagnosticsLogger getLogger() {
        if (this.logger == null) {
            this.logger = AEDiagnostics.getLogger(LOGGER_NAME);
        }
        return this.logger;
    }

    public void log(String s, Throwable e) {
        AEDiagnosticsLogger diag_logger = this.getLogger();
        diag_logger.log(s);
        diag_logger.log(e);
    }

    public void log(String s) {
        AEDiagnosticsLogger diag_logger = this.getLogger();
        diag_logger.log(s);
    }

    @Override
    public void addListener(SubscriptionManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(SubscriptionManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println(LOGGER_NAME);
        try {
            writer.indent();
            SubscriptionImpl[] subs = this.getSubscriptions();
            int i = 0;
            while (i < subs.length) {
                SubscriptionImpl sub = subs[i];
                sub.generate(writer);
                ++i;
            }
        }
        finally {
            writer.exdent();
        }
    }

    private DHTPluginInterface selectDHTPlugin(SubscriptionImpl subs) {
        if (subs.isAnonymous()) {
            List<DistributedDatabase> ddbs = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getDistributedDatabases(new String[]{"I2P"});
            if (ddbs.size() > 0) {
                return ddbs.get(0).getDHTPlugin();
            }
            return null;
        }
        return this.dht_plugin_public;
    }

    private DHTPluginInterface selectDHTPlugin(Download download) {
        String[] networks = download.getListAttribute(this.ta_networks);
        return this.selectDHTPlugin(networks);
    }

    private DHTPluginInterface selectDHTPlugin(String[] networks) {
        if (networks.length > 0) {
            String[] stringArray = networks;
            int n = networks.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                if (net == "Public") {
                    return this.dht_plugin_public;
                }
                ++n2;
            }
            List<DistributedDatabase> ddbs = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getDistributedDatabases(new String[]{"I2P"});
            if (ddbs.size() > 0) {
                return ddbs.get(0).getDHTPlugin();
            }
        }
        return null;
    }

    @Override
    public Subscription subscribeToSubscription(String uri) throws Exception {
        SubscriptionManager manager = SubscriptionManagerFactory.getSingleton();
        Subscription subs = manager.createFromURI(uri);
        if (!subs.isSubscribed()) {
            subs.setSubscribed(true);
        }
        if (subs.isSearchTemplate()) {
            try {
                VuzeFile vf = subs.getSearchTemplateVuzeFile();
                if (vf != null) {
                    VuzeFileHandler.getSingleton().handleFiles(new VuzeFile[]{vf}, 0);
                    VuzeFileComponent[] vuzeFileComponentArray = vf.getComponents();
                    int n = vuzeFileComponentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VuzeFileComponent comp2 = vuzeFileComponentArray[n2];
                        Engine engine = (Engine)comp2.getData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY);
                        if (engine != null && (engine.getSelectionState() == 0 || engine.getSelectionState() == 3)) {
                            engine.setSelectionState(2);
                        }
                        ++n2;
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        } else {
            subs.requestAttention();
        }
        return subs;
    }

    @Override
    public Subscription subscribeToRSS(String name, URL url, int interval, boolean is_public, String creator_ref) throws Exception {
        Subscription subs = SubscriptionManagerFactory.getSingleton().createSingletonRSS(name, url, interval, false);
        if (!subs.getName(false).equals(name)) {
            subs.setName(name);
        }
        if (subs.isPublic() != is_public) {
            subs.setPublic(is_public);
        }
        if (!subs.isSubscribed()) {
            subs.setSubscribed(true);
        }
        if (creator_ref != null) {
            subs.setCreatorRef(creator_ref);
        }
        subs.requestAttention();
        return subs;
    }

    private SubscriptionImpl getGMAR(boolean create_if_missing) {
        String gmar_id;
        SubscriptionImpl gmar;
        if (this.last_gmar != null && this.last_gmar.isRemoved()) {
            this.last_gmar = null;
            this.gmar_cache.clear();
        }
        SubscriptionImpl subscriptionImpl = gmar = (gmar_id = COConfigurationManager.getStringParameter("subscriptions.gmar.id", null)) == null ? null : this.getSubscriptionByID(gmar_id);
        if (gmar == null && create_if_missing) {
            try {
                gmar = this.createSingletonRSS(MessageText.getString("subs.globally.marked.as.read"), new URL("subscription:?type=gmar"), -1, false);
                COConfigurationManager.setParameter("subscriptions.gmar.id", gmar.getID());
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (gmar != null && gmar != this.last_gmar) {
            this.last_gmar = gmar;
            SubscriptionResult[] subscriptionResultArray = gmar.getResults(false);
            int n = subscriptionResultArray.length;
            int n2 = 0;
            while (n2 < n) {
                SubscriptionResult result = subscriptionResultArray[n2];
                String hash = result.getAssetHash();
                if (hash != null) {
                    this.gmar_cache.put(hash, result.getID());
                }
                Map<Integer, Object> properties = result.toPropertyMap();
                String name = (String)properties.get(1);
                Long size = (Long)properties.get(3);
                if (name != null && size != null) {
                    String ns = String.valueOf(name) + ":" + size;
                    this.gmar_cache.put(ns, result.getID());
                }
                ++n2;
            }
        }
        return gmar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markReadInAllSubscriptions(SearchSubsResultBase[] results) {
        HashSet<String> hashes = new HashSet<String>();
        HashSet<String> name_sizes = new HashSet<String>();
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            SubscriptionImpl gmar = this.getGMAR(true);
            ArrayList<SubscriptionResultImpl> gmar_results = new ArrayList<SubscriptionResultImpl>(results.length);
            SearchSubsResultBase[] searchSubsResultBaseArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String hash_str;
                SearchSubsResultBase result = searchSubsResultBaseArray[n2];
                byte[] hash = result.getHash();
                String string = hash_str = hash == null ? null : Base32.encode(hash);
                if (hash_str != null) {
                    hashes.add(hash_str);
                }
                String name = result.getName();
                long size = result.getSize();
                String ns = String.valueOf(name) + ":" + size;
                name_sizes.add(ns);
                if (gmar != null) {
                    SubscriptionResultImpl sr = new SubscriptionResultImpl(gmar.getHistory(), result);
                    gmar_results.add(sr);
                    if (hash_str != null) {
                        this.gmar_cache.put(hash_str, sr.getID());
                    }
                    this.gmar_cache.put(ns, sr.getID());
                }
                ++n2;
            }
            if (gmar_results.size() > 0) {
                gmar.getHistory().reconcileResults(null, gmar_results.toArray(new SubscriptionResultImpl[0]), true);
            }
        }
        SubscriptionImpl[] subscriptionImplArray = this.getSubscriptions(true);
        int n = subscriptionImplArray.length;
        int n3 = 0;
        while (n3 < n) {
            SubscriptionImpl subs = subscriptionImplArray[n3];
            if (!subs.isSearchTemplate() && !subs.isSubscriptionTemplate()) {
                subs.getHistory().markResults(hashes, name_sizes);
            }
            ++n3;
        }
    }

    protected static interface downloadListener {
        public void complete(File var1);

        public void complete(Download var1, File var2);

        public void failed(Throwable var1);

        public Map getRecoveryData();

        public boolean isCancelled();
    }

    static interface subsLookupListener
    extends SubscriptionLookupListener {
        public boolean isCancelled();
    }
}

