/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.tag.TagGroup;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pifimpl.local.utils.FormattersImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;

public class TagUtils {
    private static final Object MOC_CACHE = new Object();
    private static final Comparator<String> comp = new FormattersImpl().getAlphanumericComparator(true);
    private static final Comparator<Tag> tag_comparator = (o1, o2) -> {
        int type2;
        int type1;
        String g2;
        String g1 = o1.getGroup();
        if (g1 != (g2 = o2.getGroup())) {
            if (g1 == null) {
                return 1;
            }
            if (g2 == null) {
                return -1;
            }
            int res = comp.compare(g1, g2);
            if (res != 0) {
                return res;
            }
        }
        if (o1 instanceof Category && o2 instanceof Category && (type1 = ((Category)o1).getType()) != (type2 = ((Category)o2).getType())) {
            if (type1 == 1) {
                return -1;
            }
            if (type1 == 2) {
                return 1;
            }
            return type2 == 1 ? 1 : -1;
        }
        return comp.compare(o1.getTagName(true), o2.getTagName(true));
    };
    private static final Comparator<Tag> tag_icon_comparator = (o1, o2) -> {
        int i2;
        int i1 = o1.getImageSortOrder();
        int result = Integer.compare(i1, i2 = o2.getImageSortOrder());
        if (result == 0) {
            result = comp.compare(o1.getTagName(true), o2.getTagName(true));
        }
        return result;
    };
    private static Comparator<TagGroup> tag_group_comparator = (o1, o2) -> comp.compare(o1.getName(), o2.getName());

    public static Comparator<Tag> getTagComparator() {
        return tag_comparator;
    }

    public static Comparator<TagGroup> getTagGroupComparator() {
        return tag_group_comparator;
    }

    public static List<TagType> sortTagTypes(Collection<TagType> _tag_types) {
        ArrayList<TagType> tag_types = new ArrayList<TagType>(_tag_types);
        Collections.sort(tag_types, new Comparator<TagType>(){
            final Comparator<String> comp = new FormattersImpl().getAlphanumericComparator(true);

            @Override
            public int compare(TagType o1, TagType o2) {
                return this.comp.compare(o1.getTagTypeName(true), o2.getTagTypeName(true));
            }
        });
        return tag_types;
    }

    public static List<Tag> sortTags(Collection<Tag> _tags) {
        ArrayList<Tag> tags = new ArrayList<Tag>(_tags);
        if (tags.size() < 2) {
            return tags;
        }
        Collections.sort(tags, tag_comparator);
        return tags;
    }

    public static List<TagGroup> sortTagGroups(Collection<TagGroup> _groups) {
        ArrayList<TagGroup> groups = new ArrayList<TagGroup>(_groups);
        if (groups.size() < 2) {
            return groups;
        }
        Collections.sort(groups, TagUtils.getTagGroupComparator());
        return groups;
    }

    public static List<String> sortTagGroups(List<String> _groups) {
        ArrayList<String> groups = new ArrayList<String>(_groups);
        if (groups.size() < 2) {
            return groups;
        }
        Collections.sort(groups, comp);
        return groups;
    }

    public static List<Tag> sortTagIcons(Collection<Tag> _tags) {
        ArrayList<Tag> tags = new ArrayList<Tag>(_tags);
        if (tags.size() < 2) {
            return tags;
        }
        Collections.sort(tags, tag_icon_comparator);
        return tags;
    }

    public static String getTagTooltip(Tag tag) {
        return TagUtils.getTagTooltip(tag, false);
    }

    public static String getTagTooltip(Tag tag, boolean skip_name) {
        if (tag instanceof Category) {
            return TagUtils.getCategoryTooltip((Category)tag, skip_name);
        }
        TagType tag_type = tag.getTagType();
        String str = skip_name ? "" : String.valueOf(tag_type.getTagTypeName(true)) + ": " + tag.getTagName(true);
        String desc = tag.getDescription();
        if (desc != null) {
            if (str.length() > 0) {
                str = String.valueOf(str) + "\r\n";
            }
            str = String.valueOf(str) + desc;
        }
        if (tag_type.hasTagTypeFeature(1L)) {
            int up_pri;
            int current_down;
            int limit_down;
            int current_up;
            TagFeatureRateLimit rl = (TagFeatureRateLimit)((Object)tag);
            String up_str = "";
            String down_str = "";
            int limit_up = rl.getTagUploadLimit();
            if (limit_up > 0) {
                up_str = String.valueOf(up_str) + MessageText.getString("label.limit") + "=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(limit_up);
            }
            if ((current_up = rl.getTagCurrentUploadRate()) >= 0) {
                up_str = String.valueOf(up_str) + (up_str.length() == 0 ? "" : ", ") + MessageText.getString("label.current") + "=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(current_up);
            }
            if ((limit_down = rl.getTagDownloadLimit()) > 0) {
                down_str = String.valueOf(down_str) + MessageText.getString("label.limit") + "=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(limit_down);
            }
            if ((current_down = rl.getTagCurrentDownloadRate()) >= 0) {
                down_str = String.valueOf(down_str) + (down_str.length() == 0 ? "" : ", ") + MessageText.getString("label.current") + "=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(current_down);
            }
            if (up_str.length() > 0) {
                str = String.valueOf(str) + "\r\n    " + MessageText.getString("iconBar.up") + ": " + up_str;
            }
            if (down_str.length() > 0) {
                str = String.valueOf(str) + "\r\n    " + MessageText.getString("iconBar.down") + ": " + down_str;
            }
            if ((up_pri = rl.getTagUploadPriority()) > 0) {
                str = String.valueOf(str) + "\r\n    " + MessageText.getString("cat.upload.priority");
            }
        }
        if (tag_type.hasTagTypeFeature(16L)) {
            File mor;
            File copy_on_comp;
            File move_on_comp;
            File init_loc;
            TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag);
            if (fl.supportsTagInitialSaveFolder() && (init_loc = fl.getTagInitialSaveFolder()) != null) {
                str = String.valueOf(str) + "\r\n    " + MessageText.getString("label.init.save.loc") + "=" + init_loc.getAbsolutePath();
            }
            if (fl.supportsTagMoveOnComplete() && (move_on_comp = fl.getTagMoveOnCompleteFolder()) != null) {
                str = String.valueOf(str) + "\r\n    " + MessageText.getString("label.move.on.comp") + "=" + move_on_comp.getAbsolutePath();
            }
            if (fl.supportsTagCopyOnComplete() && (copy_on_comp = fl.getTagCopyOnCompleteFolder()) != null) {
                str = String.valueOf(str) + "\r\n    " + MessageText.getString("label.copy.on.comp") + "=" + copy_on_comp.getAbsolutePath();
            }
            if (fl.supportsTagMoveOnRemove() && (mor = fl.getTagMoveOnRemoveFolder()) != null) {
                str = String.valueOf(str) + "\r\n    " + MessageText.getString("label.move.on.rem") + "=" + mor.getAbsolutePath();
            }
            if (fl.supportsTagMoveOnAssign() && (mor = fl.getTagMoveOnAssignFolder()) != null) {
                str = String.valueOf(str) + "\r\n    " + MessageText.getString("label.move.on.assign") + "=" + mor.getAbsolutePath();
            }
        }
        if (str.startsWith("\r\n")) {
            str = str.substring(2);
        }
        return str;
    }

    private static String getCategoryTooltip(Category category, boolean skip_name) {
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        List<DownloadManager> dms = category.getDownloadManagers(gm.getDownloadManagers());
        long ttlActive = 0L;
        long ttlSize = 0L;
        long ttlRSpeed = 0L;
        long ttlSSpeed = 0L;
        int count = 0;
        for (DownloadManager dm : dms) {
            if (!category.hasTaggable(dm)) continue;
            ++count;
            if (dm.getState() == 50 || dm.getState() == 60) {
                ++ttlActive;
            }
            DownloadManagerStats stats2 = dm.getStats();
            ttlSize += stats2.getSizeExcludingDND();
            ttlRSpeed += stats2.getDataReceiveRate();
            ttlSSpeed += stats2.getDataSendRate();
        }
        String up_details = "";
        String down_details = "";
        if (category.getType() != 1) {
            String up_str = MessageText.getString("GeneralView.label.maxuploadspeed");
            String down_str = MessageText.getString("GeneralView.label.maxdownloadspeed");
            String unlimited_str = MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited");
            int up_speed = category.getUploadSpeed();
            int down_speed = category.getDownloadSpeed();
            up_details = String.valueOf(up_str) + ": " + (up_speed == 0 ? unlimited_str : DisplayFormatters.formatByteCountToKiBEtc(up_speed));
            down_details = String.valueOf(down_str) + ": " + (down_speed == 0 ? unlimited_str : DisplayFormatters.formatByteCountToKiBEtc(down_speed));
        }
        if (count == 0) {
            return String.valueOf(down_details) + "\n" + up_details + "\nTotal: 0";
        }
        return String.valueOf(up_details.length() == 0 ? "" : String.valueOf(down_details) + "\n" + up_details + "\n") + "Total: " + count + "\n" + "Downloading/Seeding: " + ttlActive + "\n" + "\n" + "Total Speed: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlRSpeed) + " / " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlSSpeed) + "\n" + "Average Speed: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlRSpeed / (ttlActive == 0L ? 1L : ttlActive)) + " / " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlSSpeed / (ttlActive == 0L ? 1L : ttlActive)) + "\n" + "Size: " + DisplayFormatters.formatByteCountToKiBEtc(ttlSize);
    }

    public static TagFeatureFileLocation selectInitialDownloadLocation(Collection<Tag> tags) {
        if (tags.size() > 0) {
            ArrayList<Tag> sl_tags = new ArrayList<Tag>(tags.size());
            for (Tag tag : tags) {
                File save_loc;
                TagFeatureFileLocation fl;
                if (!(tag instanceof TagFeatureFileLocation) || !(fl = (TagFeatureFileLocation)((Object)tag)).supportsTagInitialSaveFolder() || (save_loc = fl.getTagInitialSaveFolder()) == null) continue;
                sl_tags.add(tag);
            }
            if (sl_tags.size() > 0) {
                if (sl_tags.size() > 1) {
                    Collections.sort(sl_tags, new Comparator<Tag>(){

                        @Override
                        public int compare(Tag o1, Tag o2) {
                            return o1.getTagID() - o2.getTagID();
                        }
                    });
                }
                return (TagFeatureFileLocation)sl_tags.get(0);
            }
        }
        return null;
    }

    public static List<Tag> getActiveMoveOnCompleteTags(DownloadManager dm, boolean allow_caching, Consumer<String> logger) {
        Object[] cache;
        if (allow_caching && (cache = (Object[])dm.getUserData(MOC_CACHE)) != null && SystemTime.getMonotonousTime() - (Long)cache[0] < 10000L) {
            return (List)cache[1];
        }
        List<Tag> dm_tags = TagManagerFactory.getTagManager().getTagsForTaggable(dm);
        ArrayList<Tag> applicable_tags = new ArrayList<Tag>();
        if (dm_tags != null) {
            for (Tag tag : dm_tags) {
                File move_to;
                TagFeatureFileLocation fl;
                if (!tag.getTagType().hasTagTypeFeature(16L) || !(fl = (TagFeatureFileLocation)((Object)tag)).supportsTagMoveOnComplete() || (move_to = fl.getTagMoveOnCompleteFolder()) == null) continue;
                if (!move_to.exists()) {
                    move_to.mkdirs();
                }
                if (move_to.isDirectory() && move_to.canWrite()) {
                    applicable_tags.add(tag);
                    continue;
                }
                logger.accept("Ignoring invalid tag move-to location: " + move_to);
            }
            if (!applicable_tags.isEmpty() && applicable_tags.size() > 1) {
                Collections.sort(applicable_tags, new Comparator<Tag>(){

                    @Override
                    public int compare(Tag o1, Tag o2) {
                        return o1.getTagID() - o2.getTagID();
                    }
                });
                String str = "";
                for (Tag tag : applicable_tags) {
                    str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + tag.getTagName(true);
                }
                logger.accept("Multiple applicable tags found: " + str + " - selecting first");
            }
        }
        if (allow_caching) {
            dm.setUserData(MOC_CACHE, new Object[]{SystemTime.getMonotonousTime(), applicable_tags});
        }
        return applicable_tags;
    }

    public static boolean isInternalTagName(String tag) {
        return tag.startsWith("_") && tag.endsWith("_");
    }
}

