/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag.impl;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.download.DownloadManagerStateFactory;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TagSwarmTag;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.impl.TagTypeBase;
import com.biglybt.core.tag.impl.TagTypeWithState;
import com.biglybt.core.tag.impl.TagWithState;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TagTypeSwarmTag
extends TagTypeWithState {
    private static final int[] color_default = new int[]{205, 200, 240};
    private final AtomicInteger next_tag_id = new AtomicInteger(0);

    protected TagTypeSwarmTag() {
        super(7, 0, "tag.type.swarm");
        this.addTagType();
        DownloadManagerStateFactory.addGlobalListener(new DownloadManagerStateAttributeListener(){

            @Override
            public void attributeEventOccurred(DownloadManager dm, String attribute, int event_type) {
                String[] tags = dm.getDownloadState().getListAttribute("stag");
                if (tags != null && tags.length > 0) {
                    String[] stringArray = tags;
                    int n = tags.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tag = stringArray[n2];
                        if (!TagUtils.isInternalTagName(tag)) {
                            TagSwarmTagImpl st = (TagSwarmTagImpl)TagTypeSwarmTag.this.getTag(tag, true);
                            if (st == null) {
                                try {
                                    st = TagTypeSwarmTag.this.createTag(tag, true);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            } else {
                                st.setLastSeenTime();
                            }
                        }
                        ++n2;
                    }
                }
            }
        }, "stag", 1);
    }

    @Override
    public boolean isTagTypeAuto() {
        return false;
    }

    @Override
    public int[] getColorDefault() {
        return color_default;
    }

    @Override
    public boolean isTagTypePersistent() {
        return true;
    }

    @Override
    public TagSwarmTagImpl createTag(String name, boolean auto_add) throws TagException {
        TagSwarmTagImpl new_tag = new TagSwarmTagImpl((TagTypeBase)this, this.next_tag_id.incrementAndGet(), name);
        if (auto_add) {
            this.addTag(new_tag);
        }
        return new_tag;
    }

    @Override
    protected Tag createTag(int tag_id, Map<String, Object> details) {
        TagSwarmTagImpl new_tag = new TagSwarmTagImpl((TagTypeBase)this, tag_id, details);
        this.next_tag_id.set(Math.max(this.next_tag_id.get(), tag_id + 1));
        return new_tag;
    }

    static class TagSwarmTagImpl
    extends TagWithState
    implements TagSwarmTag {
        private static final String AT_SWARM_TAG_LAST_SEEN = "swarmtag:last.seen";

        private TagSwarmTagImpl(TagTypeBase tag_type, int id, String name) {
            super(tag_type, id, name);
            this.writeLongAttribute(AT_SWARM_TAG_LAST_SEEN, SystemTime.getCurrentTime());
        }

        private TagSwarmTagImpl(TagTypeBase tag_type, int id, Map<String, Object> details) {
            super(tag_type, id, details);
        }

        @Override
        public int getTaggableTypes() {
            return 0;
        }

        @Override
        public void addTaggable(Taggable t) {
        }

        @Override
        public void removeTaggable(Taggable t) {
        }

        @Override
        protected boolean getCanBePublicDefault() {
            return false;
        }

        @Override
        public long getLastSeenTime() {
            return this.readLongAttribute(AT_SWARM_TAG_LAST_SEEN, 0L);
        }

        protected void setLastSeenTime() {
            this.writeLongAttribute(AT_SWARM_TAG_LAST_SEEN, SystemTime.getCurrentTime());
        }
    }
}

