/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag.impl;

import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.TaggableResolver;
import com.biglybt.core.tag.impl.TagTypeBase;
import com.biglybt.core.tag.impl.TagWithState;
import com.biglybt.core.util.CopyOnWriteList;
import java.util.List;
import java.util.Map;

public class TagTypeWithState
extends TagTypeBase {
    private final CopyOnWriteList<Tag> tags = new CopyOnWriteList();
    private TaggableResolver resolver;

    protected TagTypeWithState(int tag_type, int tag_features, String tag_name) {
        super(tag_type, tag_features, tag_name);
    }

    protected TagTypeWithState(int tag_type, TaggableResolver _resolver, int tag_features, String tag_name) {
        super(tag_type, tag_features, tag_name);
        this.resolver = _resolver;
    }

    @Override
    protected Taggable resolveTaggable(String id) {
        if (this.resolver == null) {
            return super.resolveTaggable(id);
        }
        return this.resolver.resolveTaggable(id);
    }

    @Override
    protected TaggableResolver getResolver() {
        return this.resolver;
    }

    @Override
    protected void removeTaggable(TaggableResolver _resolver, Taggable taggable) {
        if (this.resolver == _resolver) {
            for (Tag t : this.tags) {
                if (!t.hasTaggable(taggable)) continue;
                t.removeTaggable(taggable);
            }
        }
        super.removeTaggable(_resolver, taggable);
    }

    protected Tag createTag(int id, Map<String, Object> state) throws TagException {
        throw new TagException("Not supported");
    }

    @Override
    public void addTag(Tag t) {
        this.tags.add(t);
        if (t instanceof TagWithState) {
            this.getTagManager().tagCreated((TagWithState)t);
        }
        super.addTag(t);
    }

    @Override
    public void removeTag(Tag t) {
        this.tags.remove(t);
        if (t instanceof TagWithState) {
            this.getTagManager().tagRemoved((TagWithState)t);
        }
        super.removeTag(t);
    }

    @Override
    public List<Tag> getTags() {
        return this.tags.getList();
    }

    @Override
    public int getTagCount() {
        return this.tags.size();
    }
}

