/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.torrent.HasBeenOpenedListener;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginInterface;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class PlatformTorrentUtils {
    private static final long MIN_SPEED_DEFAULT = 102400L;
    public static final boolean DEBUG_CACHING = System.getProperty("az3.debug.caching", "0").equals("1");
    private static final String TOR_AZ_PROP_MAP = "Content";
    private static final String TOR_AZ_PROP_CVERSION = "_Version_";
    private static final String TOR_AZ_PROP_HASH = "Content Hash";
    private static final String TOR_AZ_PROP_TITLE = "Title";
    private static final String TOR_AZ_PROP_DESCRIPTION = "Description";
    private static final String TOR_AZ_PROP_CONTENT_TYPE = "Content Type";
    private static final String TOR_AZ_PROP_AUTHOR = "Author";
    private static final String TOR_AZ_PROP_PUBLISHER = "Publisher";
    private static final String TOR_AZ_PROP_URL = "URL";
    private static final String TOR_AZ_PROP_THUMBNAIL = "Thumbnail";
    private static final String TOR_AZ_PROP_THUMBNAIL_URL = "Thumbnail.url";
    private static final String TOR_AZ_PROP_PROGRESSIVE = "Progressive";
    private static final String TOR_AZ_PROP_SPEED = "Speed Bps";
    private static final String TOR_AZ_PROP_MIN_SPEED = "Min Speed Bps";
    private static final String TOR_AZ_PROP_QOS_CLASS = "QOS Class";
    private static final String TOR_AZ_PROP_EXPIRESON = "Expires On";
    private static final String TOR_AZ_PROP_PRIMARY_FILE = "Primary File Index";
    private static final ArrayList<HasBeenOpenedListener> hasBeenOpenedListeners = new ArrayList(1);
    private static final String TOR_AZ_PROP_VIDEO_WIDTH = "Video Width";
    private static final String TOR_AZ_PROP_VIDEO_HEIGHT = "Video Height";
    private static final String TOR_AZ_PROP_VIDEO_RUNNINGTIME = "Running Time";
    private static final String TOR_AZ_PROP_DURATION_MILLIS = "Duration";
    private static final String TOR_AZ_PROP_OPENED = "Opened";
    private static final String TOR_AZ_PROP_THUMBNAIL_TYPE = "Thumbnail.type";
    private static ArrayList<String> listPlatformHosts = new ArrayList();
    private static final Map mapPlatformTrackerTorrents;
    private static boolean embeddedPlayerAvail;

    static {
        int i = 0;
        while (i < Constants.APP_DOMAINS.length) {
            listPlatformHosts.add(Constants.APP_DOMAINS[i].toLowerCase());
            ++i;
        }
        mapPlatformTrackerTorrents = new WeakHashMap();
        embeddedPlayerAvail = false;
    }

    public static Map getContentMap(TOTorrent torrent) {
        HashMap mapContent;
        Object objExistingContentMap;
        if (torrent == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap mapAZProps = torrent.getAdditionalMapProperty("azureus_properties");
        if (mapAZProps == null) {
            mapAZProps = new HashMap();
            torrent.setAdditionalMapProperty("azureus_properties", mapAZProps);
        }
        if ((objExistingContentMap = mapAZProps.get(TOR_AZ_PROP_MAP)) instanceof Map) {
            mapContent = (HashMap)objExistingContentMap;
        } else {
            mapContent = new HashMap();
            mapAZProps.put(TOR_AZ_PROP_MAP, mapContent);
        }
        return mapContent;
    }

    static Map getTempContentMap(TOTorrent torrent) {
        HashMap mapContent;
        Object objExistingContentMap;
        if (torrent == null) {
            return new HashMap();
        }
        HashMap mapAZProps = torrent.getAdditionalMapProperty("attributes");
        if (mapAZProps == null) {
            mapAZProps = new HashMap();
            torrent.setAdditionalMapProperty("attributes", mapAZProps);
        }
        if ((objExistingContentMap = mapAZProps.get(TOR_AZ_PROP_MAP)) instanceof Map) {
            mapContent = (HashMap)objExistingContentMap;
        } else {
            mapContent = new HashMap();
            mapAZProps.put(TOR_AZ_PROP_MAP, mapContent);
        }
        return mapContent;
    }

    public static String getContentMapString(TOTorrent torrent, String key) {
        if (torrent == null) {
            return null;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return new String((byte[])obj, Constants.DEFAULT_ENCODING_CHARSET);
        }
        return null;
    }

    private static void setContentMapString(TOTorrent torrent, String key, String value) {
        if (torrent == null) {
            return;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        mapContent.put(key, value);
    }

    private static long getContentMapLong(TOTorrent torrent, String key, long def) {
        if (torrent == null) {
            return def;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        try {
            if (obj instanceof Long) {
                return (Long)obj;
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).longValue();
            }
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            if (obj instanceof byte[]) {
                return Long.parseLong(new String((byte[])obj));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public static Map getContentMapMap(TOTorrent torrent, String key) {
        if (torrent == null) {
            return null;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    private static void setContentMapLong(TOTorrent torrent, String key, long value) {
        if (torrent == null) {
            return;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        mapContent.put(key, new Long(value));
    }

    public static void setContentMapMap(TOTorrent torrent, String key, Map value) {
        if (torrent == null) {
            return;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        mapContent.put(key, value);
    }

    public static String getContentHash(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_HASH);
    }

    public static String getContentTitle(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_TITLE);
    }

    public static void setContentTitle(TOTorrent torrent, String title) {
        PlatformTorrentUtils.setContentMapString(torrent, TOR_AZ_PROP_TITLE, title);
    }

    public static String getContentDescription(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_DESCRIPTION);
    }

    public static void setContentDescription(TOTorrent torrent, String desc) {
        PlatformTorrentUtils.setContentMapString(torrent, TOR_AZ_PROP_DESCRIPTION, desc);
    }

    public static String getContentType(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_CONTENT_TYPE);
    }

    public static void setContentType(TOTorrent torrent, String title) {
        PlatformTorrentUtils.setContentMapString(torrent, TOR_AZ_PROP_CONTENT_TYPE, title);
    }

    public static String getContentAuthor(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_AUTHOR);
    }

    public static String getContentPublisher(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_PUBLISHER);
    }

    public static String getContentURL(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_URL);
    }

    public static long getQOSClass(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_QOS_CLASS, 0L);
    }

    public static void setQOSClass(TOTorrent torrent, long cla) {
        PlatformTorrentUtils.setContentMapLong(torrent, TOR_AZ_PROP_QOS_CLASS, cla);
    }

    public static boolean isFeaturedContent(TOTorrent torrent) {
        String content_type = PlatformTorrentUtils.getContentType(torrent);
        return content_type != null && content_type.equalsIgnoreCase("featured");
    }

    private static void putOrRemove(Map map, String key, Object obj) {
        if (obj == null) {
            map.remove(key);
        } else {
            map.put(key, obj);
        }
    }

    private static void writeTorrentIfExists(TOTorrent torrent) {
        if (!CoreFactory.isCoreRunning()) {
            return;
        }
        Core core = CoreFactory.getSingleton();
        if (core == null || !core.isStarted()) {
            return;
        }
        GlobalManager gm = core.getGlobalManager();
        if (gm == null || gm.getDownloadManager(torrent) == null) {
            return;
        }
        try {
            TorrentUtils.writeToFile(torrent);
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
    }

    public static byte[] getContentThumbnail(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(TOR_AZ_PROP_THUMBNAIL);
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return null;
    }

    public static String getContentThumbnailUrl(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_THUMBNAIL_URL);
    }

    public static void setContentThumbnailUrl(TOTorrent torrent, String url) {
        PlatformTorrentUtils.setContentMapString(torrent, TOR_AZ_PROP_THUMBNAIL_URL, url);
    }

    public static void setContentThumbnail(TOTorrent torrent, byte[] thumbnail) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        PlatformTorrentUtils.putOrRemove(mapContent, TOR_AZ_PROP_THUMBNAIL, thumbnail);
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
    }

    public static List<String> getPlatformHosts() {
        return listPlatformHosts;
    }

    public static void addPlatformHost(String host) {
        List<String> platformHosts = PlatformTorrentUtils.getPlatformHosts();
        if (!platformHosts.contains(host = host.toLowerCase())) {
            platformHosts.add(host);
            mapPlatformTrackerTorrents.clear();
        }
    }

    public static boolean isPlatformHost(String host) {
        Object[] domains = PlatformTorrentUtils.getPlatformHosts().toArray();
        host = host.toLowerCase();
        int i = 0;
        while (i < domains.length) {
            String domain = (String)domains[i];
            if (domain.equals(host)) {
                return true;
            }
            if (host.endsWith("." + domain)) {
                return true;
            }
            ++i;
        }
        if (Constants.isCVSVersion()) {
            try {
                InetAddress ia = InetAddress.getByName(host);
                return ia.isLoopbackAddress() || ia.isLinkLocalAddress() || ia.isSiteLocalAddress();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPlatformTracker(TOTorrent torrent) {
        try {
            if (torrent == null) {
                return false;
            }
            Object oCache = mapPlatformTrackerTorrents.get(torrent);
            if (oCache instanceof Boolean) {
                return (Boolean)oCache;
            }
            URL announceURL = torrent.getAnnounceURL();
            if (announceURL != null && !PlatformTorrentUtils.isPlatformHost(announceURL.getHost())) {
                mapPlatformTrackerTorrents.put(torrent, Boolean.FALSE);
                return false;
            }
            TOTorrentAnnounceURLSet[] sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
            int i = 0;
            while (i < sets.length) {
                URL[] urls = sets[i].getAnnounceURLs();
                int j = 0;
                while (j < urls.length) {
                    if (!PlatformTorrentUtils.isPlatformHost(urls[j].getHost())) {
                        mapPlatformTrackerTorrents.put(torrent, Boolean.FALSE);
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            boolean b = announceURL != null;
            mapPlatformTrackerTorrents.put(torrent, b);
            return b;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            mapPlatformTrackerTorrents.put(torrent, Boolean.FALSE);
            return false;
        }
    }

    public static boolean isAdvancedViewOnly(DownloadManager dm) {
        Boolean oisUpdate = (Boolean)dm.getUserData("isAdvancedViewOnly");
        if (oisUpdate != null) {
            return oisUpdate;
        }
        boolean advanced_view = true;
        if (!dm.getDownloadState().getFlag(16L)) {
            advanced_view = false;
        }
        dm.setUserData("isAdvancedViewOnly", advanced_view);
        return advanced_view;
    }

    public static boolean isContentProgressive(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_PROGRESSIVE, 0L) == 1L;
    }

    public static long getContentStreamSpeedBps(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_SPEED, 0L);
    }

    public static long getContentMinimumSpeedBps(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_MIN_SPEED, 102400L);
    }

    public static long getExpiresOn(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Long l = (Long)mapContent.get(TOR_AZ_PROP_EXPIRESON);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public static int getContentPrimaryFileIndex(TOTorrent torrent) {
        return (int)PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_PRIMARY_FILE, -1L);
    }

    public static void setContentPrimaryFileIndex(TOTorrent torrent, int index) {
        PlatformTorrentUtils.setContentMapLong(torrent, TOR_AZ_PROP_PRIMARY_FILE, index);
    }

    private static long getContentVideoWidth(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_VIDEO_WIDTH, -1L);
    }

    private static long getContentVideoHeight(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_VIDEO_HEIGHT, -1L);
    }

    public static long getContentVideoRunningTime(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_VIDEO_RUNNINGTIME, -1L);
    }

    public static long getContentDurationMillis(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_DURATION_MILLIS, -1L);
    }

    public static void setContentDurationMillis(TOTorrent torrent, long millis) {
        PlatformTorrentUtils.setContentMapLong(torrent, TOR_AZ_PROP_DURATION_MILLIS, millis);
    }

    public static int[] getContentVideoResolution(TOTorrent torrent) {
        long width = PlatformTorrentUtils.getContentVideoWidth(torrent);
        if (width <= 0L) {
            return null;
        }
        long height = PlatformTorrentUtils.getContentVideoHeight(torrent);
        if (height <= 0L) {
            return null;
        }
        return new int[]{(int)width, (int)height};
    }

    public static void log(String str) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.MD");
        diag_logger.log(str);
        if (DEBUG_CACHING) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + "|" + System.currentTimeMillis() + "] " + str);
        }
    }

    public static void log(TOTorrent torrent, String string) {
        String hash = "";
        try {
            hash = torrent.getHashWrapper().toBase32String();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlatformTorrentUtils.log(String.valueOf(hash) + "] " + string);
    }

    public static boolean embeddedPlayerAvail() {
        if (embeddedPlayerAvail) {
            return true;
        }
        try {
            PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp", true);
            if (pi != null) {
                embeddedPlayerAvail = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return embeddedPlayerAvail;
    }

    public static String getContentTitle2(DownloadManager dm) {
        if (dm == null) {
            return null;
        }
        String name = dm.getDownloadState().getDisplayName();
        if ((name == null || name.length() == 0) && (name = PlatformTorrentUtils.getContentTitle(dm.getTorrent())) == null) {
            name = dm.getDisplayName();
        }
        return name;
    }

    public static void setHasBeenOpened(DownloadManager dm, boolean opened) {
        PlatformTorrentUtils.setHasBeenOpened(dm, -1, opened);
    }

    public static void setHasBeenOpened(DownloadManager dm, int file_index, boolean opened) {
        TOTorrent torrent;
        if (file_index != -1) {
            int ff = dm.getDownloadState().getFileFlags(file_index);
            ff = opened ? (ff |= 1) : (ff &= 0xFFFFFFFE);
            dm.getDownloadState().setFileFlags(file_index, ff);
        }
        if ((torrent = dm.getTorrent()) == null) {
            return;
        }
        if (opened == PlatformTorrentUtils.getHasBeenOpened(dm)) {
            return;
        }
        PlatformTorrentUtils.setContentMapLong(torrent, TOR_AZ_PROP_OPENED, opened ? 1 : 0);
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
        Object[] array = hasBeenOpenedListeners.toArray();
        int i = 0;
        while (i < array.length) {
            try {
                HasBeenOpenedListener l = (HasBeenOpenedListener)array[i];
                l.hasBeenOpenedChanged(dm, opened);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            ++i;
        }
    }

    public static boolean getHasBeenOpened(DownloadManager dm) {
        boolean opened;
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return true;
        }
        boolean bl = opened = PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_OPENED, -1L) > 0L;
        return opened || PlatformTorrentUtils.isAdvancedViewOnly(dm);
    }

    public static void addHasBeenOpenedListener(HasBeenOpenedListener l) {
        hasBeenOpenedListeners.add(l);
    }

    public static void removeHasBeenOpenedListener(HasBeenOpenedListener listener) {
        hasBeenOpenedListeners.remove(listener);
    }

    public static int getContentVersion(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Long v = (Long)mapContent.get(TOR_AZ_PROP_CVERSION);
        return v == null ? 0 : v.intValue();
    }

    public static String getContentThumbnailType(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_THUMBNAIL_TYPE);
    }

    private static void incVersion(Map mapContent) {
        Long v = (Long)mapContent.get(TOR_AZ_PROP_CVERSION);
        mapContent.put(TOR_AZ_PROP_CVERSION, v == null ? 0L : v + 1L);
    }

    public static void setContentThumbnail(TOTorrent torrent, byte[] thumbnail, String type) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        PlatformTorrentUtils.putOrRemove(mapContent, TOR_AZ_PROP_THUMBNAIL, thumbnail);
        PlatformTorrentUtils.incVersion(mapContent);
        PlatformTorrentUtils.setContentMapString(torrent, TOR_AZ_PROP_THUMBNAIL_TYPE, type);
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
    }
}

