/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent.impl;

import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.impl.TOTorrentFileImpl;
import com.biglybt.core.torrent.impl.TOTorrentImpl;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.ByteEncodedKeyHashMap;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.TorrentUtils;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TOTorrentCreateV2Impl {
    private static final int block_size = 16384;
    private static final int digest_length = 32;
    private final File root;
    private final long piece_size;
    private final Adapter adapter;
    private ByteArrayHashMap<byte[]> piece_layers = new ByteArrayHashMap();
    private long total_file_size;
    private long total_v1_padding_size;
    private long file_bytes_hashed = 0L;
    private int file_index = 0;
    private int synthetic_pad_file_count;
    private int files_ignored;
    private final boolean flatten_files = false;

    public static byte[] getV2RootHash(File file) throws TOTorrentException {
        TOTorrentCreateV2Impl temp = new TOTorrentCreateV2Impl(file, 16384L, new Adapter(){

            @Override
            public File resolveFile(int index, File file, String relative_file) {
                return file;
            }

            @Override
            public void reportHashedBytes(long bytes) {
            }

            @Override
            public void report(String resource_key) {
            }

            @Override
            public boolean ignore(String name) {
                return false;
            }

            @Override
            public boolean cancelled() {
                return false;
            }
        });
        return temp.handleFile((File)file, (String)"").root_hash;
    }

    protected TOTorrentCreateV2Impl(File _root, long _piece_size, Adapter _adapter) {
        this.root = _root;
        this.piece_size = _piece_size;
        this.adapter = _adapter;
    }

    protected Map<String, Object> create() throws TOTorrentException {
        TreeMap<String, Map> file_tree = new TreeMap<String, Map>();
        if (this.root.isFile()) {
            this.processFile(this.root, file_tree, "");
        } else {
            this.processDirectory(this.root, file_tree, "");
        }
        if (this.total_file_size == 0L) {
            throw new TOTorrentException("V2: No files processed", 2);
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("name", this.root.getName());
        info.put("name.utf-8", this.root.getName());
        info.put("meta version", 2);
        info.put("piece length", this.piece_size);
        info.put("file tree", file_tree);
        HashMap<String, Object> torrent = new HashMap<String, Object>();
        torrent.put("info", info);
        ByteEncodedKeyHashMap pl_map = new ByteEncodedKeyHashMap();
        for (byte[] key : this.piece_layers.keys()) {
            pl_map.put(new String(key, Constants.BYTE_ENCODING_CHARSET), this.piece_layers.get(key));
        }
        torrent.put("piece layers", pl_map);
        return torrent;
    }

    public long getTotalFileSize() {
        return this.total_file_size;
    }

    public long getTotalPadding() {
        return this.total_v1_padding_size;
    }

    public int getIgnoredFiles() {
        return this.files_ignored;
    }

    public void processFile(File file, Map<String, Map> node, String relative_path) throws TOTorrentException {
        long excess;
        if (this.adapter.ignore(file.getName())) {
            ++this.files_ignored;
            return;
        }
        TreeMap file_node = new TreeMap();
        node.put(file.getName(), file_node);
        relative_path = relative_path.isEmpty() ? file.getName() : String.valueOf(relative_path) + File.separator + file.getName();
        if (this.total_file_size % this.piece_size != 0L) {
            ++this.synthetic_pad_file_count;
        }
        FileDetails result = this.handleFile(file, relative_path);
        HashMap<String, Object> details = new HashMap<String, Object>();
        file_node.put("", details);
        long length = result.length;
        details.put("length", length);
        if (length > 0L) {
            details.put("pieces root", result.root_hash);
        }
        if (length > this.piece_size) {
            this.piece_layers.put(result.root_hash, result.pieces_layer);
        }
        if ((excess = (this.total_file_size + this.total_v1_padding_size) % this.piece_size) > 0L) {
            long pad_size = this.piece_size - excess;
            this.total_v1_padding_size += pad_size;
        }
        this.total_file_size += length;
    }

    public void processDirectory(File dir, Map<String, Map> node, String relative_path) throws TOTorrentException {
        if (this.adapter.cancelled()) {
            throw new TOTorrentException("Operation cancelled", 9);
        }
        Object[] files = dir.list();
        if (files == null || files.length == 0) {
            return;
        }
        Arrays.sort(files);
        relative_path = relative_path.isEmpty() ? dir.getName() : String.valueOf(relative_path) + File.separator + dir.getName();
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            if (!((String)name).equals(".") && !((String)name).equals("..")) {
                File file = FileUtil.newFile(dir, new String[]{name});
                if (file.isFile()) {
                    this.processFile(file, node, relative_path);
                } else if (file.isDirectory()) {
                    TreeMap<String, Map> sub_tree = new TreeMap<String, Map>();
                    node.put((String)name, sub_tree);
                    this.processDirectory(file, sub_tree, relative_path);
                }
            }
            ++n2;
        }
    }

    public FileDetails handleFile(File file, String relative_path) throws TOTorrentException {
        long file_length = -1L;
        byte[] root_hash = null;
        byte[] pieces_layer = null;
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[16384];
            File link = this.adapter.resolveFile(this.file_index + this.synthetic_pad_file_count, file, relative_path);
            ++this.file_index;
            if (link != null) {
                file = link;
            }
            if ((file_length = file.length()) > 0L) {
                long highestOneBit = Long.highestOneBit(file_length);
                long leaf_width = file_length == highestOneBit ? file_length : highestOneBit << 1;
                int leaf_count = (int)(leaf_width / 16384L);
                if (leaf_count == 0) {
                    leaf_count = 1;
                }
                ArrayList<byte[]> leaf_digests = new ArrayList<byte[]>(leaf_count);
                try (FileInputStream fis = FileUtil.newFileInputStream(file);){
                    while (true) {
                        if (this.adapter.cancelled()) {
                            throw new TOTorrentException("Operation cancelled", 9);
                        }
                        int len = fis.read(buffer);
                        if (len <= 0) {
                            break;
                        }
                        sha256.update(buffer, 0, len);
                        byte[] digest = sha256.digest();
                        this.file_bytes_hashed += (long)len;
                        this.adapter.reportHashedBytes(this.file_bytes_hashed);
                        leaf_digests.add(digest);
                    }
                }
                byte[] zero_buffer = new byte[32];
                while (leaf_digests.size() < leaf_count) {
                    leaf_digests.add(zero_buffer);
                }
                ArrayList<byte[]> current_level = leaf_digests;
                int current_size = 16384;
                while (current_level.size() > 1) {
                    if (this.adapter.cancelled()) {
                        throw new TOTorrentException("Operation cancelled", 9);
                    }
                    ArrayList<byte[]> next_level = new ArrayList<byte[]>(current_level.size() / 2);
                    int i = 0;
                    while (i < current_level.size()) {
                        sha256.update((byte[])current_level.get(i));
                        sha256.update((byte[])current_level.get(i + 1));
                        byte[] hash = sha256.digest();
                        next_level.add(hash);
                        i += 2;
                    }
                    if ((long)current_size == this.piece_size) {
                        int useful_pieces = (int)(file_length / this.piece_size);
                        if (file_length % this.piece_size != 0L) {
                            ++useful_pieces;
                        }
                        pieces_layer = new byte[32 * useful_pieces];
                        int pos = 0;
                        int i2 = 0;
                        while (i2 < useful_pieces) {
                            System.arraycopy(current_level.get(i2), 0, pieces_layer, pos, 32);
                            pos += 32;
                            ++i2;
                        }
                    }
                    current_level = next_level;
                    current_size *= 2;
                }
                root_hash = (byte[])current_level.get(0);
            }
            return new FileDetails(file_length, root_hash, pieces_layer);
        }
        catch (Throwable e) {
            throw new TOTorrentException("V2 file processing failed", 4, e);
        }
    }

    protected static void setV2FileHashes(TOTorrentImpl torrent) {
        Map file_tree = (Map)torrent.getAdditionalInfoProperties().get("file tree");
        if (file_tree != null) {
            try {
                long piece_length = torrent.getPieceLength();
                ArrayList<TOTorrentFileImpl> v2_files = new ArrayList<TOTorrentFileImpl>();
                long[] torrent_offset = new long[1];
                long[] pad_details = new long[2];
                TOTorrentCreateV2Impl.lashUpV2Files(torrent, v2_files, new LinkedList<byte[]>(), file_tree, piece_length, torrent_offset, pad_details);
                TOTorrentFileImpl[] v1_files = torrent.getFiles();
                if (v1_files.length == v2_files.size()) {
                    int i = 0;
                    while (i < v1_files.length) {
                        TOTorrentFileImpl v1_file = v1_files[i];
                        if (!v1_file.isPadFile()) {
                            TOTorrentFileImpl v2_file = (TOTorrentFileImpl)v2_files.get(i);
                            if (v1_file.getLength() == v2_file.getLength()) {
                                v1_files[i].setRootHash(v2_file.getHashTree().getRootHash());
                            } else {
                                Debug.out("Inconsistent v1/v2 file lengths");
                            }
                        }
                        ++i;
                    }
                } else {
                    Debug.out("Inconsistent v1/v2 files");
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static void lashUpV1Info(TOTorrentImpl torrent) throws TOTorrentException {
        file_tree = (Map)torrent.getAdditionalInfoProperties().get("file tree");
        if (file_tree == null) {
            throw new TOTorrentException("V2 piece layers missing", 6);
        }
        piece_length = torrent.getPieceLength();
        files = new ArrayList<TOTorrentFileImpl>();
        torrent_offset = new long[1];
        pad_details = new long[2];
        TOTorrentCreateV2Impl.lashUpV2Files(torrent, files, new LinkedList<byte[]>(), file_tree, piece_length, torrent_offset, pad_details);
        torrent.setFiles(files.toArray(new TOTorrentFileImpl[files.size()]));
        total_file_sizes = torrent_offset[0];
        piece_count = total_file_sizes / piece_length;
        if (total_file_sizes % piece_length != 0L) {
            ++piece_count;
        }
        pieces = new byte[(int)piece_count][];
        piece_num = 0;
        piece_layers = torrent.getAdditionalMapProperty("piece layers");
        hash_tree_state = piece_layers == null ? TorrentUtils.getHashTreeState(torrent) : null;
        block2: for (TOTorrentFileImpl file : files) {
            if (file.isPadFile() || (length = file.getLength()) <= 0L) continue;
            tree = file.getHashTree();
            pieces_root = tree.getRootHash();
            if (length <= piece_length) {
                pieces[piece_num++] = pieces_root;
                continue;
            }
            file_pieces = file.getNumberOfPieces();
            root_key = new String(pieces_root, Constants.BYTE_ENCODING_CHARSET);
            v0 = piece_layer = piece_layers == null ? null : (byte[])piece_layers.get(root_key);
            if (piece_layer == null) {
                state = hash_tree_state != null ? (Map)hash_tree_state.get(String.valueOf(file.getIndex())) : null;
                if (state == null) {
                    i = 0;
                    while (i < file_pieces) {
                        pieces[piece_num++] = null;
                        ++i;
                    }
                    continue;
                }
                imported_pieces = tree.importState(state);
                for (byte[] hash : imported_pieces) {
                    pieces[piece_num++] = hash;
                }
                continue;
            }
            if (piece_layer.length % 32 != 0) {
                throw new TOTorrentException("V2 piece layer length invalid", 6);
            }
            layer_pieces = piece_layer.length / 32;
            if (file_pieces != layer_pieces) {
                throw new TOTorrentException("V2 piece layer hash count invalid", 6);
            }
            try {
                validated_pieces = tree.addPieceLayer(piece_layer);
                for (byte[] hash : validated_pieces) {
                    pieces[piece_num++] = hash;
                }
                continue;
            }
            catch (Throwable e) {
                Debug.out(e);
                i = 0;
                ** while (i < file_pieces)
            }
lbl-1000:
            // 1 sources

            {
                pieces[piece_num++] = null;
                ++i;
                continue;
lbl60:
                // 1 sources

            }
        }
        if ((long)piece_num != piece_count) {
            throw new TOTorrentException("V2 piece layers inconsistent", 6);
        }
        torrent.setPieces(pieces);
    }

    private static void lashUpV2Files(TOTorrentImpl torrent, List<TOTorrentFileImpl> files, LinkedList<byte[]> path, Map<String, Object> node, long piece_length, long[] torrent_offset, long[] pad_details) throws TOTorrentException {
        ArrayList<String> keys = new ArrayList<String>(node.keySet());
        Collections.sort(keys);
        for (String name : keys) {
            Map kid = (Map)node.get(name);
            if (name.isEmpty()) {
                long offset;
                long l;
                if (!files.isEmpty() && (l = (offset = torrent_offset[0]) % piece_length) > 0L) {
                    long pad_size = piece_length - l;
                    byte[][] byArrayArray = new byte[2][];
                    byArrayArray[0] = ".pad".getBytes(Constants.UTF_8);
                    pad_details[0] = pad_details[0] + 1L;
                    byArrayArray[1] = (String.valueOf(pad_details[0]) + "_" + pad_size).getBytes(Constants.UTF_8);
                    byte[][] pad_file = byArrayArray;
                    pad_details[1] = pad_details[1] + pad_size;
                    TOTorrentFileImpl tf = new TOTorrentFileImpl(torrent, files.size(), torrent_offset[0], pad_size, pad_file, pad_file, null);
                    tf.setAdditionalProperty("attr", "p".getBytes(Constants.UTF_8));
                    torrent_offset[0] = torrent_offset[0] + pad_size;
                    files.add(tf);
                }
                long length = (Long)kid.get("length");
                byte[][] bpath = (byte[][])path.toArray((T[])new byte[path.size()][]);
                byte[] pieces_root = null;
                if (length > 0L && (pieces_root = (byte[])kid.get("pieces root")) == null) {
                    throw new TOTorrentException("Pieces root missing for file " + files.size(), 6);
                }
                TOTorrentFileImpl file = new TOTorrentFileImpl(torrent, files.size(), torrent_offset[0], length, bpath, bpath, pieces_root);
                files.add(file);
                torrent_offset[0] = torrent_offset[0] + length;
                continue;
            }
            path.add(name.getBytes(Constants.UTF_8));
            try {
                TOTorrentCreateV2Impl.lashUpV2Files(torrent, files, path, kid, piece_length, torrent_offset, pad_details);
            }
            finally {
                path.removeLast();
            }
        }
    }

    public static void main(String[] args) {
        try {
            int piece_size = 524288;
            File dir = new File("D:\\Downloads\\bittorrent-v1-v2-hybrid-test");
            TOTorrentCreateV2Impl creator = new TOTorrentCreateV2Impl(dir, piece_size, new Adapter(){

                @Override
                public boolean ignore(String name) {
                    return false;
                }

                @Override
                public File resolveFile(int index, File file, String relative_file) {
                    System.out.println("resolve: " + relative_file);
                    return null;
                }

                @Override
                public void reportHashedBytes(long bytes) {
                }

                @Override
                public void report(String resource_key) {
                    System.out.println(resource_key);
                }

                @Override
                public boolean cancelled() {
                    return false;
                }
            });
            Map<String, Object> torrent = creator.create();
            System.out.println("size=" + creator.total_file_size + ", padding=" + creator.total_v1_padding_size);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected static interface Adapter {
        public boolean ignore(String var1);

        public File resolveFile(int var1, File var2, String var3);

        public void reportHashedBytes(long var1);

        public void report(String var1);

        public boolean cancelled();
    }

    private class FileDetails {
        final long length;
        final byte[] root_hash;
        final byte[] pieces_layer;

        FileDetails(long _length, byte[] _root_hash, byte[] _pieces_layer) {
            this.length = _length;
            this.root_hash = _root_hash;
            this.pieces_layer = _pieces_layer;
        }
    }
}

