/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent.impl;

import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.impl.TOTorrentFileHasherListener;
import com.biglybt.core.util.ED2KHasher;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SHA1Hasher;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class TOTorrentFileHasher {
    private static byte[] fake_sha1_hash = new byte[20];
    private final boolean do_other_per_file_hash;
    private final int piece_length;
    private final List<byte[]> pieces = new LinkedList<byte[]>();
    private final byte[] buffer;
    private int buffer_pos;
    private SHA1Hasher overall_sha1_hash;
    private ED2KHasher overall_ed2k_hash;
    private byte[] sha1_digest;
    private byte[] ed2k_digest;
    private byte[] per_file_sha1_digest;
    private byte[] per_file_ed2k_digest;
    private final TOTorrentFileHasherListener listener;
    private boolean skip_hashing;
    private boolean cancelled;

    protected TOTorrentFileHasher(boolean _do_other_overall_hashes, boolean _do_other_per_file_hash, int _piece_length, TOTorrentFileHasherListener _listener) {
        if (_do_other_overall_hashes) {
            this.overall_sha1_hash = new SHA1Hasher();
            this.overall_ed2k_hash = new ED2KHasher();
        }
        this.do_other_per_file_hash = _do_other_per_file_hash;
        this.piece_length = _piece_length;
        this.listener = _listener;
        this.buffer = new byte[this.piece_length];
    }

    protected void setSkipHashing(boolean b) {
        this.skip_hashing = b;
    }

    protected long add(File _file) throws TOTorrentException {
        if (this.skip_hashing) {
            long file_length;
            long rem = file_length = _file.length();
            while (rem > 0L) {
                int len = (int)Math.min(rem, (long)(this.piece_length - this.buffer_pos));
                rem -= (long)len;
                this.buffer_pos += len;
                if (this.buffer_pos != this.piece_length) continue;
                this.pieces.add(fake_sha1_hash);
                this.buffer_pos = 0;
            }
            return file_length;
        }
        long file_length = 0L;
        InputStream is = null;
        SHA1Hasher sha1_hash = null;
        ED2KHasher ed2k_hash = null;
        try {
            try {
                if (this.do_other_per_file_hash) {
                    sha1_hash = new SHA1Hasher();
                    ed2k_hash = new ED2KHasher();
                }
                is = new BufferedInputStream(FileUtil.newFileInputStream(_file), 65536);
                while (true) {
                    if (this.cancelled) {
                        throw new TOTorrentException("TOTorrentCreate: operation cancelled", 9);
                    }
                    int len = is.read(this.buffer, this.buffer_pos, this.piece_length - this.buffer_pos);
                    if (len <= 0) break;
                    if (this.do_other_per_file_hash) {
                        sha1_hash.update(this.buffer, this.buffer_pos, len);
                        ed2k_hash.update(this.buffer, this.buffer_pos, len);
                    }
                    file_length += (long)len;
                    this.buffer_pos += len;
                    if (this.buffer_pos != this.piece_length) continue;
                    byte[] hash = new SHA1Hasher().calculateHash(this.buffer);
                    if (this.overall_sha1_hash != null) {
                        this.overall_sha1_hash.update(this.buffer);
                        this.overall_ed2k_hash.update(this.buffer);
                    }
                    this.pieces.add(hash);
                    if (this.listener != null) {
                        this.listener.pieceHashed(this.pieces.size());
                    }
                    this.buffer_pos = 0;
                }
                if (this.do_other_per_file_hash) {
                    this.per_file_sha1_digest = sha1_hash.getDigest();
                    this.per_file_ed2k_digest = ed2k_hash.getDigest();
                }
            }
            catch (TOTorrentException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new TOTorrentException("TOTorrentFileHasher: file read fails '" + e.toString() + "'", 4);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return file_length;
    }

    protected void addPad(int pad_length) throws TOTorrentException {
        if (this.skip_hashing) {
            long rem = pad_length;
            while (rem > 0L) {
                int len = (int)Math.min(rem, (long)(this.piece_length - this.buffer_pos));
                rem -= (long)len;
                this.buffer_pos += len;
                if (this.buffer_pos != this.piece_length) continue;
                this.pieces.add(fake_sha1_hash);
                this.buffer_pos = 0;
            }
        } else {
            ByteArrayInputStream is = null;
            try {
                try {
                    is = new ByteArrayInputStream(new byte[pad_length]);
                    while (true) {
                        if (this.cancelled) {
                            throw new TOTorrentException("TOTorrentCreate: operation cancelled", 9);
                        }
                        int len = ((InputStream)is).read(this.buffer, this.buffer_pos, this.piece_length - this.buffer_pos);
                        if (len > 0) {
                            this.buffer_pos += len;
                            if (this.buffer_pos != this.piece_length) continue;
                            byte[] hash = new SHA1Hasher().calculateHash(this.buffer);
                            if (this.overall_sha1_hash != null) {
                                this.overall_sha1_hash.update(this.buffer);
                                this.overall_ed2k_hash.update(this.buffer);
                            }
                            this.pieces.add(hash);
                            if (this.listener != null) {
                                this.listener.pieceHashed(this.pieces.size());
                            }
                            this.buffer_pos = 0;
                            continue;
                        }
                        break;
                    }
                }
                catch (TOTorrentException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new TOTorrentException("TOTorrentFileHasher: file read fails '" + e.toString() + "'", 4);
                }
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected byte[] getPerFileSHA1Digest() {
        return this.per_file_sha1_digest;
    }

    protected byte[] getPerFileED2KDigest() {
        return this.per_file_ed2k_digest;
    }

    protected byte[][] getPieces() throws TOTorrentException {
        try {
            if (this.buffer_pos > 0) {
                byte[] rem = new byte[this.buffer_pos];
                System.arraycopy(this.buffer, 0, rem, 0, this.buffer_pos);
                this.pieces.add(new SHA1Hasher().calculateHash(rem));
                if (this.overall_sha1_hash != null) {
                    this.overall_sha1_hash.update(rem);
                    this.overall_ed2k_hash.update(rem);
                }
                if (this.listener != null) {
                    this.listener.pieceHashed(this.pieces.size());
                }
                this.buffer_pos = 0;
            }
            if (this.overall_sha1_hash != null && this.sha1_digest == null) {
                this.sha1_digest = this.overall_sha1_hash.getDigest();
                this.ed2k_digest = this.overall_ed2k_hash.getDigest();
            }
            byte[][] res = new byte[this.pieces.size()][];
            this.pieces.toArray((T[])res);
            return res;
        }
        catch (Throwable e) {
            throw new TOTorrentException("TOTorrentFileHasher: file read fails '" + e.toString() + "'", 4);
        }
    }

    protected byte[] getED2KDigest() throws TOTorrentException {
        if (this.ed2k_digest == null) {
            this.getPieces();
        }
        return this.ed2k_digest;
    }

    protected byte[] getSHA1Digest() throws TOTorrentException {
        if (this.sha1_digest == null) {
            this.getPieces();
        }
        return this.sha1_digest;
    }

    protected void cancel() {
        this.cancelled = true;
    }
}

