/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrentdownloader.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.torrentdownloader.TorrentDownloader;
import com.biglybt.core.torrentdownloader.TorrentDownloaderCallBackInterface;
import com.biglybt.core.torrentdownloader.TorrentDownloaderFactory;
import com.biglybt.core.torrentdownloader.impl.TorrentDownloaderImpl;
import java.util.ArrayList;
import java.util.List;

public class TorrentDownloaderManager {
    private static TorrentDownloaderManager man = null;
    private boolean autostart = false;
    private GlobalManager gm = null;
    private final List<TorrentDownloader> running = new ArrayList<TorrentDownloader>();
    private final List<TorrentDownloader> queued = new ArrayList<TorrentDownloader>();
    private final List<TorrentDownloader> errors = new ArrayList<TorrentDownloader>();

    public static TorrentDownloaderManager getInstance() {
        if (man == null) {
            man = new TorrentDownloaderManager();
        }
        return man;
    }

    public void init(GlobalManager _gm, boolean _autostart) {
        this.gm = _gm;
        this.autostart = _autostart;
    }

    public TorrentDownloader add(TorrentDownloader dl) {
        if (dl.getDownloadState() == 4) {
            this.errors.add(dl);
        } else if (this.running.contains(dl) || this.queued.contains(dl)) {
            ((TorrentDownloaderImpl)dl).setDownloadState(5);
            ((TorrentDownloaderImpl)dl).notifyListener();
            this.errors.add(dl);
        } else if (this.autostart) {
            dl.start();
        } else {
            this.queued.add(dl);
        }
        return dl;
    }

    public TorrentDownloader download(String url, String fileordir) {
        return this.add(TorrentDownloaderFactory.create(new Callback(), url, null, null, fileordir));
    }

    public TorrentDownloader download(String url) {
        return this.add(TorrentDownloaderFactory.create(new Callback(), url, null, null, null));
    }

    public TorrentDownloader downloadToLocation(String url, String save_path) {
        return this.add(TorrentDownloaderFactory.create(new Callback(save_path), url, null, null, null));
    }

    public void remove(TorrentDownloader inf) {
        if (this.running.contains(inf)) {
            this.running.remove(inf);
        }
        if (this.queued.contains(inf)) {
            this.queued.remove(inf);
        }
    }

    public class Callback
    implements TorrentDownloaderCallBackInterface {
        private String downloaddir;

        public Callback() {
            try {
                this.downloaddir = COConfigurationManager.getDirectoryParameter("Default save path");
            }
            catch (Exception e) {
                this.downloaddir = null;
            }
        }

        private Callback(String path) {
            this.downloaddir = path;
        }

        @Override
        public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
            switch (state) {
                case 1: {
                    if (TorrentDownloaderManager.this.queued.contains(inf)) {
                        TorrentDownloaderManager.this.queued.remove(inf);
                    }
                    if (TorrentDownloaderManager.this.running.contains(inf)) break;
                    TorrentDownloaderManager.this.running.add(inf);
                    break;
                }
                case 3: {
                    TorrentDownloaderManager.this.remove(inf);
                    if (TorrentDownloaderManager.this.gm == null || this.downloaddir == null) break;
                    TorrentDownloaderManager.this.gm.addDownloadManager(inf.getFile().getAbsolutePath(), this.downloaddir);
                    break;
                }
                case 4: {
                    TorrentDownloaderManager.this.remove(inf);
                    TorrentDownloaderManager.this.errors.add(inf);
                }
            }
        }
    }
}

