/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.protocol.udp;

import com.biglybt.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PRUDPPacketReplyAnnounce2
extends PRUDPPacketReply {
    private final boolean is_ipv6;
    protected int interval;
    protected int leechers;
    protected int seeders;
    protected static final int BYTES_PER_ENTRY_IPV4 = 6;
    protected static final int BYTES_PER_ENTRY_IPV6 = 18;
    protected byte[][] addresses;
    protected short[] ports;

    public PRUDPPacketReplyAnnounce2(int trans_id, boolean ipv6) {
        super(1, trans_id);
        this.is_ipv6 = ipv6;
    }

    protected PRUDPPacketReplyAnnounce2(DataInputStream is, int trans_id, boolean ipv6) throws IOException {
        super(1, trans_id);
        this.is_ipv6 = ipv6;
        this.interval = is.readInt();
        this.leechers = is.readInt();
        this.seeders = is.readInt();
        int bpe = this.is_ipv6 ? 18 : 6;
        int num = is.available() / bpe;
        this.addresses = new byte[num][];
        this.ports = new short[num];
        int i = 0;
        while (i < num) {
            this.addresses[i] = new byte[bpe - 2];
            is.read(this.addresses[i]);
            this.ports[i] = is.readShort();
            ++i;
        }
    }

    public boolean isIPV6() {
        return this.is_ipv6;
    }

    public void setInterval(int value) {
        this.interval = value;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setLeechersSeeders(int _leechers, int _seeders) {
        this.leechers = _leechers;
        this.seeders = _seeders;
    }

    public void setPeers(byte[][] _addresses, short[] _ports) {
        this.addresses = _addresses;
        this.ports = _ports;
    }

    public byte[][] getAddresses() {
        return this.addresses;
    }

    public short[] getPorts() {
        return this.ports;
    }

    public int getLeechers() {
        return this.leechers;
    }

    public int getSeeders() {
        return this.seeders;
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeInt(this.interval);
        os.writeInt(this.leechers);
        os.writeInt(this.seeders);
        if (this.addresses != null) {
            int i = 0;
            while (i < this.addresses.length) {
                os.write(this.addresses[i]);
                os.writeShort(this.ports[i]);
                ++i;
            }
        }
    }

    @Override
    public String getString() {
        return String.valueOf(super.getString()) + "[interval=" + this.interval + ",leechers=" + this.leechers + ",seeders=" + this.seeders + ",addresses=" + this.addresses.length + "]";
    }
}

