/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class AESemaphore {
    private final String name;
    private final Semaphore sem;
    private volatile boolean released_forever;

    public AESemaphore(String _name) {
        this.name = _name;
        this.sem = new Semaphore(0);
    }

    public AESemaphore(String _name, int _permits) {
        this.name = _name;
        this.sem = new Semaphore(_permits);
    }

    public String getName() {
        return this.name;
    }

    public void reserve() {
        if (!this.released_forever) {
            this.sem.acquireUninterruptibly();
        }
    }

    public boolean reserve(long max_millis) {
        if (this.released_forever) {
            return true;
        }
        try {
            return this.sem.tryAcquire(max_millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean reserveIfAvailable() {
        if (this.released_forever) {
            return true;
        }
        return this.sem.tryAcquire();
    }

    public void release() {
        if (!this.released_forever) {
            this.sem.release();
        }
    }

    public int getValue() {
        return this.sem.availablePermits();
    }

    public void releaseAllWaiters() {
        this.sem.release(this.sem.getQueueLength());
    }

    public void releaseForever() {
        if (!this.released_forever) {
            this.released_forever = true;
            this.sem.release(0x3FFFFFFF);
        }
    }

    public boolean isReleasedForever() {
        return this.released_forever;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            return "value=" + this.sem.availablePermits() + ",waiting=" + this.sem.getQueueLength();
        }
    }
}

