/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashMapWrapper<S, T> {
    private static final Object NULL = new Object();
    private final S S_NULL = NULL;
    private final T T_NULL = NULL;
    private final ConcurrentHashMap<S, T> map;

    public ConcurrentHashMapWrapper(int initialCapacity) {
        this.map = new ConcurrentHashMap(initialCapacity);
    }

    public ConcurrentHashMapWrapper(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentHashMapWrapper() {
        this.map = new ConcurrentHashMap();
    }

    public ConcurrentHashMapWrapper(Map<S, T> init_map) {
        this.map = new ConcurrentHashMap(init_map.size());
        this.putAll(init_map);
    }

    public void putAll(Map<S, T> from_map) {
        for (Map.Entry<S, T> entry : from_map.entrySet()) {
            S key = entry.getKey();
            T value = entry.getValue();
            if (key == null) {
                key = this.S_NULL;
            }
            if (value == null) {
                value = this.T_NULL;
            }
            this.map.put(key, value);
        }
    }

    public T put(S key, T value) {
        T result;
        if (key == null) {
            key = this.S_NULL;
        }
        if (value == null) {
            value = this.T_NULL;
        }
        if ((result = this.map.put(key, value)) == this.T_NULL) {
            return null;
        }
        return result;
    }

    public T get(S key) {
        T result;
        if (key == null) {
            key = this.S_NULL;
        }
        if ((result = this.map.get(key)) == this.T_NULL) {
            return null;
        }
        return result;
    }

    public T remove(S key) {
        T result;
        if (key == null) {
            key = this.S_NULL;
        }
        if ((result = this.map.remove(key)) == this.T_NULL) {
            return null;
        }
        return result;
    }

    public boolean containsKey(S key) {
        if (key == null) {
            key = this.S_NULL;
        }
        return this.map.containsKey(key);
    }

    public Set<S> keySet() {
        Set result = this.map.keySet();
        if (result.contains(this.S_NULL)) {
            result.remove(this.S_NULL);
            result.add(null);
        }
        return Collections.unmodifiableSet(result);
    }

    public TreeMap<S, T> toTreeMap() {
        TreeMap<S, T> result = new TreeMap<S, T>();
        for (Map.Entry<S, T> entry : this.map.entrySet()) {
            S key = entry.getKey();
            T value = entry.getValue();
            if (key == this.S_NULL) {
                key = null;
            }
            if (value == this.T_NULL) {
                value = null;
            }
            result.put(key, value);
        }
        return result;
    }
}

