/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.CopyOnWriteList;

public class LaunchManager {
    private static final LaunchManager singleton = new LaunchManager();
    final CopyOnWriteList<LaunchController> controllers = new CopyOnWriteList();

    public static LaunchManager getManager() {
        return singleton;
    }

    public void launchRequest(final LaunchTarget target, final LaunchAction action) {
        new AEThread2("LaunchManager:request"){

            @Override
            public void run() {
                for (LaunchController c : LaunchManager.this.controllers) {
                    try {
                        c.handleRequest(target);
                    }
                    catch (Throwable e) {
                        action.actionDenied(e);
                        return;
                    }
                }
                action.actionAllowed();
            }
        }.start();
    }

    public LaunchTarget createTarget(DownloadManager dm) {
        return new LaunchTarget(dm);
    }

    public LaunchTarget createTarget(DiskManagerFileInfo fi) {
        return new LaunchTarget(fi);
    }

    public void addController(LaunchController controller) {
        this.controllers.add(controller);
    }

    public void removeController(LaunchController controller) {
        this.controllers.remove(controller);
    }

    public static interface LaunchAction {
        public void actionAllowed();

        public void actionDenied(Throwable var1);
    }

    public static interface LaunchController {
        public void handleRequest(LaunchTarget var1) throws Throwable;
    }

    public static class LaunchTarget {
        private final DownloadManager dm;
        private DiskManagerFileInfo file_info;

        private LaunchTarget(DownloadManager _dm) {
            this.dm = _dm;
        }

        private LaunchTarget(DiskManagerFileInfo _file_info) {
            this.file_info = _file_info;
            this.dm = this.file_info.getDownloadManager();
        }

        public DownloadManager getDownload() {
            return this.dm;
        }

        public DiskManagerFileInfo getFile() {
            return this.file_info;
        }
    }
}

