/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.DelayedEvent;

public class TimeLimitedTask {
    private final String name;
    private final int max_millis;
    private final int priority;
    private task t;

    public TimeLimitedTask(String _name, int _max_millis, int _priority, task _t) {
        this.name = _name;
        this.max_millis = _max_millis;
        this.priority = _priority;
        this.t = _t;
    }

    public Object run() throws Throwable {
        final Object[] result = new Object[1];
        final AESemaphore sem = new AESemaphore(this.name);
        final Thread thread = new Thread(this.name){

            @Override
            public void run() {
                try {
                    try {
                        result[0] = TimeLimitedTask.this.t.run();
                    }
                    catch (Throwable e) {
                        result[0] = e;
                        TimeLimitedTask.this.t = null;
                        sem.releaseForever();
                    }
                }
                finally {
                    TimeLimitedTask.this.t = null;
                    sem.releaseForever();
                }
            }
        };
        DelayedEvent ev = new DelayedEvent(this.name, this.max_millis, new AERunnable(){

            @Override
            public void runSupport() {
                if (!sem.isReleasedForever()) {
                    SESecurityManager.stopThread(thread);
                }
            }
        });
        thread.setPriority(this.priority);
        thread.setDaemon(true);
        thread.start();
        sem.reserve();
        ev.cancel();
        if (result[0] instanceof Throwable) {
            throw (Throwable)result[0];
        }
        return result[0];
    }

    public static interface task {
        public Object run() throws Exception;
    }
}

