/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TrackersUtil {
    private List<String> trackers = new ArrayList<String>();
    private Map<String, List<List<String>>> multiTrackers = new HashMap<String, List<List<String>>>();
    private Map<String, Map> webseeds = new HashMap<String, Map>();
    private static TrackersUtil instance;
    private static final AEMonitor class_mon;

    static {
        class_mon = new AEMonitor("TrackersUtil:class");
    }

    private TrackersUtil() {
        this.loadList();
    }

    public static TrackersUtil getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TrackersUtil();
            }
            TrackersUtil trackersUtil = instance;
            return trackersUtil;
        }
        finally {
            class_mon.exit();
        }
    }

    public List<String> getTrackersList() {
        if (this.trackers != null) {
            return new ArrayList<String>(this.trackers);
        }
        return null;
    }

    public void addTracker(String trackerAnnounceUrl) {
        if (this.trackers.contains(trackerAnnounceUrl)) {
            return;
        }
        this.trackers.add(0, trackerAnnounceUrl);
        this.saveList();
    }

    public void addMultiTracker(String configName, List<List<String>> groups) {
        this.multiTrackers.put(configName, groups);
        this.saveList();
    }

    public void removeMultiTracker(String configName) {
        this.multiTrackers.remove(configName);
        this.saveList();
    }

    public Map<String, List<List<String>>> getMultiTrackers() {
        return new HashMap<String, List<List<String>>>(this.multiTrackers);
    }

    public void addWebSeed(String configName, Map ws) {
        this.webseeds.put(configName, ws);
        this.saveList();
    }

    public void removeWebSeed(String configName) {
        this.webseeds.remove(configName);
        this.saveList();
    }

    public Map<String, Map> getWebSeeds() {
        return new HashMap<String, Map>(this.webseeds);
    }

    public void clearAllTrackers(boolean save) {
        this.trackers = new ArrayList<String>();
        this.multiTrackers = new HashMap<String, List<List<String>>>();
        this.webseeds = new HashMap<String, Map>();
        if (save) {
            this.saveList();
        }
    }

    private void loadList() {
        block28: {
            File fTrackers = FileUtil.getUserFile("trackers.config");
            if (fTrackers.exists() && fTrackers.isFile()) {
                FileInputStream fin = null;
                BufferedInputStream bin = null;
                try {
                    try {
                        Map mapMT;
                        fin = FileUtil.newFileInputStream(fTrackers);
                        bin = new BufferedInputStream(fin, 8192);
                        Map<String, Object> map = BDecoder.decode(bin);
                        List list = (List)map.get("trackers");
                        if (list != null) {
                            Iterator iter = list.iterator();
                            while (iter.hasNext()) {
                                String tracker = new String((byte[])iter.next());
                                this.trackers.add(tracker);
                            }
                        }
                        if ((mapMT = (Map)map.get("multi-trackers")) != null) {
                            for (String configName : mapMT.keySet()) {
                                List groups = (List)mapMT.get(configName);
                                ArrayList resGroups = new ArrayList(groups.size());
                                for (List theseTrackers : groups) {
                                    ArrayList<String> resTrackers = new ArrayList<String>(theseTrackers.size());
                                    Iterator iterTrackers = theseTrackers.iterator();
                                    while (iterTrackers.hasNext()) {
                                        String tracker = new String((byte[])iterTrackers.next());
                                        resTrackers.add(tracker);
                                    }
                                    resGroups.add(resTrackers);
                                }
                                this.multiTrackers.put(configName, resGroups);
                            }
                        }
                        this.webseeds = (Map)map.get("webseeds");
                        if (this.webseeds == null) {
                            this.webseeds = new HashMap<String, Map>();
                            break block28;
                        }
                        BDecoder.decodeStrings(this.webseeds);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                        if (bin != null) {
                            try {
                                bin.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (fin == null) break block28;
                        try {
                            fin.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                finally {
                    if (bin != null) {
                        try {
                            bin.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
    }

    private void saveList() {
        block12: {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("trackers", this.trackers);
            map.put("multi-trackers", this.multiTrackers);
            map.put("webseeds", this.webseeds);
            FileOutputStream fos = null;
            try {
                try {
                    File fTrackers = FileUtil.getUserFile("trackers.config");
                    fos = FileUtil.newFileOutputStream(fTrackers);
                    fos.write(BEncoder.encode(map));
                    fos.close();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    if (fos == null) break block12;
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

