/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.bloom.impl;

import com.biglybt.core.util.bloom.BloomFilter;
import com.biglybt.core.util.bloom.impl.BloomFilterImpl;
import java.util.Arrays;
import java.util.Map;

public class BloomFilterAddRemove8Bit
extends BloomFilterImpl {
    private final byte[] map;

    public BloomFilterAddRemove8Bit(int _max_entries) {
        super(_max_entries);
        this.map = new byte[this.getMaxEntries()];
    }

    public BloomFilterAddRemove8Bit(Map<String, Object> x) {
        super(x);
        this.map = (byte[])x.get("map");
    }

    @Override
    protected void serialiseToMap(Map<String, Object> x) {
        super.serialiseToMap(x);
        x.put("map", this.map.clone());
    }

    @Override
    public BloomFilter getReplica() {
        return new BloomFilterAddRemove8Bit(this.getMaxEntries());
    }

    @Override
    protected int trimValue(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 255) {
            return 255;
        }
        return value;
    }

    @Override
    protected int getValue(int index) {
        return this.map[index] & 0xFF;
    }

    @Override
    protected int incValue(int index) {
        int original_value = this.getValue(index);
        if (original_value >= 255) {
            return 255;
        }
        this.setValue(index, (byte)(original_value + 1));
        return original_value;
    }

    @Override
    protected int decValue(int index) {
        int original_value = this.getValue(index);
        if (original_value <= 0) {
            return 0;
        }
        this.setValue(index, (byte)(original_value - 1));
        return original_value;
    }

    private void setValue(int index, byte value) {
        this.map[index] = value;
    }

    @Override
    public void clear() {
        Arrays.fill(this.map, (byte)0);
        super.clear();
    }
}

