/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.bloom.impl;

import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.bloom.BloomFilter;
import com.biglybt.core.util.bloom.impl.BloomFilterAddRemove8Bit;
import com.biglybt.util.MapUtils;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public abstract class BloomFilterImpl
implements BloomFilter {
    protected static final String MY_PACKAGE = "com.biglybt.core.util.bloom.impl";
    private static final int HASH_NUM = 5;
    private static final int a2 = 2;
    private static final int a3 = 3;
    private static final int a4 = 5;
    private static final int b2 = 51;
    private static final int b3 = 145;
    private static final int b4 = 216;
    private final int max_entries;
    private int entry_count;
    private long start_time = SystemTime.getMonotonousTime();

    public static BloomFilter deserialiseFromMap(Map<String, Object> map) {
        String impl = MapUtils.getMapString(map, "_impl", "");
        if (impl.startsWith(".")) {
            impl = MY_PACKAGE + impl;
        }
        try {
            Class<?> cla = Class.forName(impl);
            Constructor<?> cons = cla.getDeclaredConstructor(Map.class);
            cons.setAccessible(true);
            return (BloomFilter)cons.newInstance(map);
        }
        catch (Throwable e) {
            Debug.out("Can't construct bloom filter for " + impl, e);
            return null;
        }
    }

    public BloomFilterImpl(int _max_entries) {
        this.max_entries = _max_entries / 2 * 2 + 1;
    }

    public BloomFilterImpl(Map<String, Object> x) {
        this.max_entries = ((Long)x.get("_max")).intValue();
        this.entry_count = ((Long)x.get("_count")).intValue();
    }

    protected void serialiseToMap(Map<String, Object> x) {
        String cla = this.getClass().getName();
        if (cla.startsWith(MY_PACKAGE)) {
            cla = cla.substring(MY_PACKAGE.length());
        }
        x.put("_impl", cla);
        x.put("_max", new Long(this.max_entries));
        x.put("_count", new Long(this.entry_count));
    }

    @Override
    public Map<String, Object> serialiseToMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        this.serialiseToMap(m);
        return m;
    }

    protected int getMaxEntries() {
        return this.max_entries;
    }

    @Override
    public int add(byte[] value) {
        return this.add(this.bytesToInteger(value));
    }

    @Override
    public int remove(byte[] value) {
        return this.remove(this.bytesToInteger(value));
    }

    @Override
    public int count(byte[] value) {
        return this.count(this.bytesToInteger(value));
    }

    @Override
    public boolean contains(byte[] value) {
        return this.contains(this.bytesToInteger(value));
    }

    protected int add(int value) {
        int count = 65535;
        int i = 0;
        while (i < 5) {
            int index = this.getHash(i, value);
            int v = this.incValue(index);
            if (v < count) {
                count = v;
            }
            ++i;
        }
        if (count == 0) {
            ++this.entry_count;
        }
        return this.trimValue(count + 1);
    }

    protected int remove(int value) {
        int count = 65535;
        int i = 0;
        while (i < 5) {
            int index = this.getHash(i, value);
            int v = this.decValue(index);
            if (v < count) {
                count = v;
            }
            ++i;
        }
        if (count == 1 && this.entry_count > 0) {
            --this.entry_count;
        }
        return this.trimValue(count - 1);
    }

    protected int count(int value) {
        int count = 65535;
        int i = 0;
        while (i < 5) {
            int index = this.getHash(i, value);
            int v = this.getValue(index);
            if (v < count) {
                count = v;
            }
            ++i;
        }
        return count;
    }

    protected boolean contains(int value) {
        int i = 0;
        while (i < 5) {
            int index = this.getHash(i, value);
            int v = this.getValue(index);
            if (v == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract int getValue(int var1);

    protected abstract int incValue(int var1);

    protected abstract int decValue(int var1);

    protected abstract int trimValue(int var1);

    protected int getHash(int function, int value) {
        long res;
        switch (function) {
            case 0: {
                res = value;
                break;
            }
            case 1: {
                res = value * value;
                break;
            }
            case 2: {
                res = value * 2 + 51;
                break;
            }
            case 3: {
                res = value * 3 + 145;
                break;
            }
            case 4: {
                res = value * 5 + 216;
                break;
            }
            default: {
                System.out.println("**** BloomFilter hash function doesn't exist ****");
                res = 0L;
            }
        }
        return Math.abs((int)res % this.max_entries);
    }

    protected int bytesToInteger(byte[] data) {
        int res = 1375186049;
        int i = 0;
        while (i < data.length) {
            res = res * 191 + (data[i] & 0xFF);
            ++i;
        }
        return res;
    }

    @Override
    public int getEntryCount() {
        return this.entry_count;
    }

    @Override
    public int getSize() {
        return this.max_entries;
    }

    @Override
    public void clear() {
        this.start_time = SystemTime.getMonotonousTime();
        this.entry_count = 0;
    }

    @Override
    public long getStartTimeMono() {
        return this.start_time;
    }

    protected static byte[] getSerialization(byte[] address, int port) {
        byte[] full_address = new byte[address.length + 2];
        System.arraycopy(address, 0, full_address, 0, address.length);
        full_address[address.length] = (byte)(port >> 8);
        full_address[address.length + 1] = (byte)(port & 0xFF);
        return full_address;
    }

    @Override
    public String getString() {
        return "ent=" + this.entry_count + ",max=" + this.max_entries;
    }

    public static void main(String[] args) {
        Random rand = new Random();
        int fp_count = 0;
        int j = 0;
        while (j < 1000) {
            long start = System.currentTimeMillis();
            BloomFilterAddRemove8Bit b = new BloomFilterAddRemove8Bit(10000);
            int fp = 0;
            int i = 0;
            while (i < 1000) {
                byte[] key = new byte[6];
                rand.nextBytes(key);
                if (i % 2 == 0) {
                    b.add(key);
                    if (!b.contains(key)) {
                        System.out.println("false negative on add!!!!");
                    }
                } else if (b.contains(key)) {
                    ++fp;
                }
                ++i;
            }
            System.out.println(System.currentTimeMillis() - start + ", fp = " + fp);
            if (fp > 0) {
                ++fp_count;
            }
            ++j;
        }
        System.out.println(fp_count);
    }
}

