/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.jman;

import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.AEJavaManagement;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.average.AverageFactory;
import com.biglybt.core.util.average.MovingAverage;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class AEThreadMonitor
implements AEJavaManagement.ThreadStuff,
AEDiagnosticsEvidenceGenerator {
    private static final boolean THREAD_USER_TIME;
    private final ThreadMXBean thread_bean;
    private final LinkedList<String> memory_history = new LinkedList();

    static {
        String prop = System.getProperty(SystemProperties.SYSPROP_THREAD_MON_USERONLY, null);
        THREAD_USER_TIME = prop == null ? Constants.isLinux : !prop.equals("0");
    }

    @Override
    public long getThreadCPUTime() {
        if (this.thread_bean == null) {
            return 0L;
        }
        if (THREAD_USER_TIME) {
            return this.thread_bean.getCurrentThreadUserTime();
        }
        return this.thread_bean.getCurrentThreadCpuTime();
    }

    private long getThreadCpuTime(ThreadMXBean bean, long thread_id) {
        if (THREAD_USER_TIME) {
            return bean.getThreadUserTime(thread_id);
        }
        return bean.getThreadCpuTime(thread_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMemoryHistory() {
        LinkedList<String> linkedList = this.memory_history;
        synchronized (linkedList) {
            return new ArrayList<String>(this.memory_history);
        }
    }

    public AEThreadMonitor() {
        ThreadMXBean threadMXBean = null;
        try {
            threadMXBean = ManagementFactory.getThreadMXBean();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.thread_bean = threadMXBean;
        AEDiagnostics.addWeakEvidenceGenerator(this);
        AEThread2 thread = new AEThread2("AEThreadMonitor"){

            @Override
            public void run() {
                try {
                    try {
                        Class.forName("java.lang.management.ManagementFactory");
                        AEThreadMonitor.this.monitor();
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        thread.setPriority(10);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor() {
        AEDiagnosticsLogger log = AEDiagnostics.getLogger("thread");
        int num_processors = Runtime.getRuntime().availableProcessors();
        if (num_processors < 1) {
            num_processors = 1;
        }
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        log.log("Monitoring starts (processors =" + num_processors + ")");
        if (!bean.isThreadCpuTimeSupported()) {
            log.log("ThreadCpuTime not supported");
            return;
        }
        if (!bean.isThreadCpuTimeEnabled()) {
            log.log("Enabling ThreadCpuTime");
            bean.setThreadCpuTimeEnabled(true);
        }
        HashMap last_times = new HashMap();
        int time_available = 10000;
        long start_mono = SystemTime.getMonotonousTime();
        MovingAverage high_usage_history = AverageFactory.MovingAverage(12);
        boolean huh_mon_active = false;
        while (true) {
            Serializable old_time;
            long start = System.currentTimeMillis();
            try {
                Thread.sleep(10000L);
            }
            catch (Throwable e) {
                log.log(e);
            }
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            long[] ids = bean.getAllThreadIds();
            long[] diffs = new long[ids.length];
            long total_diffs = 0L;
            long biggest_diff = 0L;
            int biggest_index = 0;
            HashMap<Long, Long> new_times = new HashMap<Long, Long>();
            int i = 0;
            while (i < ids.length) {
                long id = ids[i];
                long time = this.getThreadCpuTime(bean, id) / 1000000L;
                old_time = (Long)last_times.get(id);
                if (old_time != null) {
                    long diff = time - old_time;
                    if (diff > biggest_diff) {
                        biggest_diff = diff;
                        biggest_index = i;
                    }
                    diffs[i] = diff;
                    total_diffs += diff;
                }
                new_times.put(id, time);
                ++i;
            }
            ThreadInfo info = bean.getThreadInfo(ids[biggest_index]);
            String thread_name = info == null ? "<dead>" : info.getThreadName();
            int percent = (int)(100L * biggest_diff / 10000L);
            Runtime rt = Runtime.getRuntime();
            String line = "cpu: " + thread_name + "=" + percent + "%, mem: max=" + DisplayFormatters.formatByteCountToKiBEtc(rt.maxMemory()) + ", alloc=" + DisplayFormatters.formatByteCountToKiBEtc(rt.totalMemory()) + ", free=" + DisplayFormatters.formatByteCountToKiBEtc(rt.freeMemory());
            old_time = this.memory_history;
            synchronized (old_time) {
                this.memory_history.addLast(String.valueOf(AEDiagnosticsLogger.getTimestamp()) + ": " + line);
                if (this.memory_history.size() > 75) {
                    this.memory_history.removeFirst();
                }
            }
            log.log("Thread state: elapsed=" + elapsed + ",cpu=" + total_diffs + ",max=" + thread_name + "(" + biggest_diff + "/" + percent + "%),mem:max=" + rt.maxMemory() / 1024L + ",tot=" + rt.totalMemory() / 1024L + ",free=" + rt.freeMemory() / 1024L);
            if (huh_mon_active) {
                boolean interesting = percent > 5 && thread_name.equals("PRUDPPacketHandler:sender");
                double temp = high_usage_history.update(interesting ? 1 : 0);
                if (temp >= 0.5) {
                    Logger.log(new LogAlert(false, 1, "High CPU usage detected in networking code - see <a href=\"https://wiki.biglybt.com/w/High_CPU_Usage\">The Wiki</a> for possible solutions"));
                }
            } else {
                boolean bl = huh_mon_active = SystemTime.getMonotonousTime() - start_mono > 120000L;
            }
            if (biggest_diff > 2500L) {
                info = bean.getThreadInfo(ids[biggest_index], 255);
                if (info == null) {
                    log.log("    no info for max thread");
                } else {
                    StackTraceElement[] elts = info.getStackTrace();
                    StringBuilder str = new StringBuilder(elts.length * 20);
                    str.append("    ");
                    int i2 = 0;
                    while (i2 < elts.length) {
                        if (i2 != 0) {
                            str.append(", ");
                        }
                        str.append(elts[i2]);
                        ++i2;
                    }
                    log.log(str.toString());
                }
            }
            last_times = new_times;
        }
    }

    @Override
    public void dumpThreads() {
        StringWriter sw = new StringWriter();
        IndentWriter iw = new IndentWriter(new PrintWriter(sw));
        this.dumpThreads(iw);
        iw.close();
        String dump = sw.toString();
        Debug.out(dump);
        File logDir = AEDiagnostics.getLogDir();
        FileUtil.writeStringAsFile(FileUtil.newFile(logDir, "ThreadDump.log"), dump);
    }

    @Override
    public void dumpThreads(IndentWriter writer) {
        final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] allThreadIds = threadBean.getAllThreadIds();
        writer.println("Threads " + allThreadIds.length);
        writer.indent();
        ArrayList<ThreadInfo> threadInfos = new ArrayList<ThreadInfo>(allThreadIds.length);
        int i = 0;
        while (i < allThreadIds.length) {
            ThreadInfo info = threadBean.getThreadInfo(allThreadIds[i], 32);
            if (info != null) {
                threadInfos.add(info);
            }
            ++i;
        }
        Collections.sort(threadInfos, new Comparator<ThreadInfo>(){

            @Override
            public int compare(ThreadInfo o1, ThreadInfo o2) {
                long diff = AEThreadMonitor.this.getThreadCpuTime(threadBean, o2.getThreadId()) - AEThreadMonitor.this.getThreadCpuTime(threadBean, o1.getThreadId());
                if (diff == 0L) {
                    return o1.getThreadName().compareToIgnoreCase(o2.getThreadName());
                }
                return diff > 0L ? 1 : -1;
            }
        });
        i = 0;
        while (i < threadInfos.size()) {
            try {
                String sState;
                ThreadInfo threadInfo = (ThreadInfo)threadInfos.get(i);
                long lCpuTime = this.getThreadCpuTime(threadBean, threadInfo.getThreadId());
                if (lCpuTime == 0L) break;
                switch (threadInfo.getThreadState()) {
                    case BLOCKED: {
                        sState = "Blocked";
                        break;
                    }
                    case RUNNABLE: {
                        sState = "Runnable";
                        break;
                    }
                    case NEW: {
                        sState = "New";
                        break;
                    }
                    case TERMINATED: {
                        sState = "Terminated";
                        break;
                    }
                    case TIMED_WAITING: {
                        sState = "Timed Waiting";
                        break;
                    }
                    case WAITING: {
                        sState = "Waiting";
                        break;
                    }
                    default: {
                        sState = "" + (Object)((Object)threadInfo.getThreadState());
                    }
                }
                String sName = threadInfo.getThreadName();
                String sLockName = threadInfo.getLockName();
                writer.println(String.valueOf(sName) + ": " + sState + ", " + lCpuTime / 1000000L + "ms CPU, " + "B/W: " + threadInfo.getBlockedCount() + "/" + threadInfo.getWaitedCount() + (sLockName == null ? "" : "; Locked by " + sLockName + "/" + threadInfo.getLockOwnerName()));
                writer.indent();
                try {
                    StackTraceElement[] stackTrace = threadInfo.getStackTrace();
                    int j = 0;
                    while (j < stackTrace.length) {
                        writer.println(stackTrace[j].toString());
                        ++j;
                    }
                }
                finally {
                    writer.exdent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        writer.exdent();
    }

    @Override
    public void generate(IndentWriter writer) {
        this.dumpThreads(writer);
    }

    @Override
    public String getThreadInfo(Thread thread) {
        try {
            String sState;
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            ThreadInfo threadInfo = threadBean.getThreadInfo(thread.getId());
            long lCpuTime = this.getThreadCpuTime(threadBean, threadInfo.getThreadId());
            switch (threadInfo.getThreadState()) {
                case BLOCKED: {
                    sState = "Blocked";
                    break;
                }
                case RUNNABLE: {
                    sState = "Runnable";
                    break;
                }
                case NEW: {
                    sState = "New";
                    break;
                }
                case TERMINATED: {
                    sState = "Terminated";
                    break;
                }
                case TIMED_WAITING: {
                    sState = "Timed Waiting";
                    break;
                }
                case WAITING: {
                    sState = "Waiting";
                    break;
                }
                default: {
                    sState = "" + (Object)((Object)threadInfo.getThreadState());
                }
            }
            String sName = threadInfo.getThreadName();
            String sLockName = threadInfo.getLockName();
            return String.valueOf(sName) + ": " + sState + ", " + lCpuTime / 1000000L + "ms CPU, " + "B/W: " + threadInfo.getBlockedCount() + "/" + threadInfo.getWaitedCount() + (sLockName == null ? "" : "; Locked by " + sLockName + "/" + threadInfo.getLockOwnerName());
        }
        catch (Throwable e) {
            return null;
        }
    }
}

