/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.protocol.wss;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ipc.IPCException;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class Handler
extends URLStreamHandler {
    private static boolean install_prompted = false;

    @Override
    public URLConnection openConnection(URL u) throws IOException {
        return this.getProxy(u).openConnection();
    }

    private URL getProxy(URL u) throws IOException {
        PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azwebtorrent");
        if (pi == null) {
            Handler.installPlugin();
            throw new IOException("'WebTorrent Support Plugin' is required - go to 'Tools->Plugins->Installation Wizard' to install.");
        }
        IPCInterface ipc = pi.getIPC();
        try {
            URL url = (URL)ipc.invoke("getProxyURL", new Object[]{u});
            return url;
        }
        catch (IPCException ipce) {
            Throwable e = ipce;
            if (e.getCause() != null) {
                e = e.getCause();
            }
            throw new IOException("Communication error with WebTorrent Support Plugin: " + Debug.getNestedExceptionMessage(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installPlugin() {
        Class<Handler> clazz = Handler.class;
        synchronized (Handler.class) {
            if (install_prompted) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            install_prompted = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            if (!Constants.isJava11OrHigher) {
                return;
            }
            new AEThread2("install::async"){

                @Override
                public void run() {
                    boolean install;
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif == null) {
                        return;
                    }
                    String title = MessageText.getString("azwebtorrent.install");
                    String text = MessageText.getString("azwebtorrent.install.text");
                    UIFunctionsUserPrompter prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
                    String remember_id = "azwebtorrent.install.remember.id";
                    if (remember_id != null) {
                        prompter.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                        prompter.setRememberOnlyIfButton(1);
                    }
                    prompter.setAutoCloseInMS(0);
                    prompter.open(null);
                    boolean bl = install = prompter.waitUntilClosed() == 0;
                    if (!install) {
                        return;
                    }
                    uif.installPlugin("azwebtorrent", "azwebtorrent.install", new UIFunctions.actionListener(){

                        @Override
                        public void actionComplete(Object result) {
                        }
                    });
                }
            }.start();
            return;
        }
    }
}

