/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.spi;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginAdapter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.plugin.I2PHelpers;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import sun.net.spi.nameservice.NameService;
import sun.net.spi.nameservice.NameServiceDescriptor;
import sun.net.spi.nameservice.dns.DNSNameService;

public class AENameServiceDescriptor
implements NameServiceDescriptor {
    private static final NameService delegate_ns;
    private static final Method delegate_ns_method_lookupAllHostAddr;
    private static final Object delegate_iai;
    private static final Method delegate_iai_method_lookupAllHostAddr;
    private static final NameService proxy_name_service;
    private static boolean config_listener_added;
    private static volatile boolean tracker_dns_disabled;
    private static volatile boolean tracker_plugin_proxies_permit;
    private static boolean i2p_checked;

    static {
        DNSNameService default_ns = null;
        Method default_lookupAllHostAddr = null;
        NameService new_ns = null;
        try {
            default_ns = new DNSNameService();
            if (default_ns != null) {
                default_lookupAllHostAddr = default_ns.getClass().getMethod("lookupAllHostAddr", String.class);
                new_ns = (NameService)Proxy.newProxyInstance(NameService.class.getClassLoader(), new Class[]{NameService.class}, (InvocationHandler)new NameServiceProxy());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Object iai = null;
        Method iai_lookupAllHostAddr = null;
        try {
            Field field = InetAddress.class.getDeclaredField("impl");
            field.setAccessible(true);
            iai = field.get(null);
            iai_lookupAllHostAddr = iai.getClass().getMethod("lookupAllHostAddr", String.class);
            iai_lookupAllHostAddr.setAccessible(true);
        }
        catch (Throwable e) {
            System.err.println("Issue resolving the default name service...");
        }
        proxy_name_service = new_ns;
        delegate_ns = default_ns;
        delegate_ns_method_lookupAllHostAddr = default_lookupAllHostAddr;
        delegate_iai = iai;
        delegate_iai_method_lookupAllHostAddr = iai_lookupAllHostAddr;
        i2p_checked = false;
    }

    public NameService createNameService() throws Exception {
        if (proxy_name_service == null) {
            throw new Exception("Failed to create proxy name service");
        }
        return proxy_name_service;
    }

    public String getType() {
        return "dns";
    }

    public String getProviderName() {
        return "aednsproxy";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkI2PInstall(final String host_name) {
        Class<AENameServiceDescriptor> clazz = AENameServiceDescriptor.class;
        synchronized (AENameServiceDescriptor.class) {
            if (i2p_checked) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                Core core = CoreFactory.getSingleton();
                if (core != null) {
                    i2p_checked = true;
                    PluginInterface pi = core.getPluginManager().getDefaultPluginInterface();
                    pi.addListener(new PluginAdapter(){

                        @Override
                        public void initializationComplete() {
                            if (I2PHelpers.isI2PInstalled()) {
                                return;
                            }
                            final boolean[] install_outcome = new boolean[1];
                            String enable_i2p_reason = MessageText.getString("azneti2phelper.install.reason.dns", new String[]{host_name});
                            I2PHelpers.installI2PHelper(enable_i2p_reason, "azneti2phelper.install.dns.resolve", install_outcome, new Runnable(){

                                @Override
                                public void run() {
                                    boolean cfr_ignored_0 = install_outcome[0];
                                }
                            });
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }

    private static class NameServiceProxy
    implements InvocationHandler {
        private NameServiceProxy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String method_name = method.getName();
            if (method_name.equals("lookupAllHostAddr")) {
                boolean tracker_request;
                String host_name = (String)args[0];
                if (host_name.equals("http://dns.test.client.biglybittorrent.com/")) {
                    Class<?> ret_type;
                    if (delegate_ns == null) {
                        throw new RuntimeException("Delegate Name Service unavailable");
                    }
                    host_name = "www.google.com";
                    try {
                        Object result = null;
                        if (delegate_iai_method_lookupAllHostAddr != null) {
                            try {
                                result = delegate_iai_method_lookupAllHostAddr.invoke(delegate_iai, host_name);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (result == null) {
                            result = delegate_ns_method_lookupAllHostAddr.invoke((Object)delegate_ns, host_name);
                        }
                    }
                    catch (Throwable e) {
                        if (e instanceof InvocationTargetException) {
                            e = ((InvocationTargetException)e).getTargetException();
                        }
                        if (e instanceof UnknownHostException) {
                            System.err.println("DNS resolution of " + host_name + " failed, DNS unavailable?");
                        }
                        throw new RuntimeException("Delegate lookup failed", e);
                    }
                    if ((ret_type = method.getReturnType()).equals(byte[][].class)) {
                        byte[][] byArrayArray = new byte[1][];
                        byte[] byArray = new byte[4];
                        byArray[0] = 127;
                        byArray[3] = 1;
                        byArrayArray[0] = byArray;
                        return byArrayArray;
                    }
                    InetAddress[] inetAddressArray = new InetAddress[1];
                    byte[] byArray = new byte[4];
                    byArray[0] = 127;
                    byArray[3] = 1;
                    inetAddressArray[0] = InetAddress.getByAddress(byArray);
                    return inetAddressArray;
                }
                boolean bl = tracker_request = TorrentUtils.getTLSTorrentHash() != null;
                if (tracker_request) {
                    NameServiceProxy nameServiceProxy = this;
                    synchronized (nameServiceProxy) {
                        if (!config_listener_added) {
                            config_listener_added = true;
                            COConfigurationManager.addAndFireListener(new COConfigurationListener(){

                                @Override
                                public void configurationSaved() {
                                    boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                                    boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                                    boolean prevent_dns = COConfigurationManager.getBooleanParameter("Proxy.SOCKS.Tracker.DNS.Disable");
                                    tracker_plugin_proxies_permit = enable_proxy && enable_socks && !COConfigurationManager.getBooleanParameter("Proxy.SOCKS.disable.plugin.proxies");
                                    tracker_dns_disabled = enable_proxy && enable_socks && prevent_dns;
                                }
                            });
                        }
                    }
                    if (tracker_plugin_proxies_permit && AENetworkClassifier.categoriseAddress(host_name) != "Public") {
                        throw new RuntimeException("Plugin proxies enabled for SOCKS");
                    }
                    if (tracker_dns_disabled) {
                        throw new UnknownHostException(host_name);
                    }
                }
            }
            return this.invokeSupport(method_name, args);
        }

        private Object invokeSupport(String method_name, Object[] args) throws Throwable {
            if (method_name.equals("getHostByAddr")) {
                byte[] address_bytes = (byte[])args[0];
                return delegate_ns.getHostByAddr(address_bytes);
            }
            if (method_name.equals("lookupAllHostAddr")) {
                String host_name = (String)args[0];
                if (host_name != null && !host_name.equals("null")) {
                    if (host_name.endsWith(".i2p")) {
                        AENameServiceDescriptor.checkI2PInstall(host_name);
                        throw new UnknownHostException(host_name);
                    }
                    if (host_name.endsWith(".onion")) {
                        throw new UnknownHostException(host_name);
                    }
                }
                try {
                    if (delegate_iai_method_lookupAllHostAddr != null) {
                        try {
                            return delegate_iai_method_lookupAllHostAddr.invoke(delegate_iai, host_name);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return delegate_ns_method_lookupAllHostAddr.invoke((Object)delegate_ns, host_name);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            throw new IllegalArgumentException("Unknown method '" + method_name + "'");
        }
    }
}

