/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.vuzefile;

import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileComponent;
import com.biglybt.core.vuzefile.VuzeFileImpl;
import com.biglybt.core.vuzefile.VuzeFileProcessor;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class VuzeFileHandler {
    private static final VuzeFileHandler singleton = new VuzeFileHandler();
    private final CopyOnWriteList<VuzeFileProcessor> processors = new CopyOnWriteList();
    private static final String[] accepted_exts = new String[]{"vuze", "vuz", "biglybt", "big"};
    private static final Set<String> accepted_exts_set = new HashSet<String>(Arrays.asList(accepted_exts));
    private static final String[] filter_exts = new String[]{"*.biglybt", "*.big", "*.vuze", "*.vuz", Constants.FILE_WILDCARD};
    private static final String main_ext = ".biglybt";

    public static VuzeFileHandler getSingleton() {
        return singleton;
    }

    protected VuzeFileHandler() {
    }

    public static boolean isAcceptedVuzeFileName(String original_name) {
        boolean ok;
        String name = original_name.toLowerCase(Locale.US);
        int pos = name.lastIndexOf(".");
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        if (ok = accepted_exts_set.contains(name)) {
            try {
                File test_file = FileUtil.newFile(original_name, new String[0]);
                test_file = VuzeFileHandler.migrateFile(test_file);
                if (test_file.isFile()) {
                    return true;
                }
            }
            catch (Throwable test_file) {
                // empty catch block
            }
            try {
                URL url = new URI(original_name).toURL();
                String protocol = url.getProtocol().toLowerCase();
                ok = protocol.equals("file") || protocol.equals("http") || protocol.equals("https") || protocol.equals("biglybt");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ok;
    }

    public static boolean isAcceptedVuzeFileName(File file) {
        return VuzeFileHandler.isAcceptedVuzeFileName(file.getName());
    }

    public static String getVuzeFileName(String name) {
        int pos;
        if (VuzeFileHandler.isAcceptedVuzeFileName(name) && (pos = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, pos);
        }
        return String.valueOf(name) + VuzeFileHandler.getVuzeFileSuffix();
    }

    public static String getVuzeFileSuffix() {
        return main_ext;
    }

    public static String[] getVuzeFileFilterExtensions() {
        return filter_exts;
    }

    private static File migrateFile(File file) {
        if (file.exists()) {
            return file;
        }
        String name = file.getName();
        int pos = name.lastIndexOf(".");
        if (pos >= 0) {
            String prefix = name.substring(0, pos + 1);
            String[] stringArray = accepted_exts;
            int n = accepted_exts.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                String test_name = String.valueOf(prefix) + ext;
                File test_file = FileUtil.newFile(file.getParentFile(), test_name);
                if (test_file.exists()) {
                    return test_file;
                }
                ++n2;
            }
        }
        return file;
    }

    public VuzeFile loadVuzeFile(String target) {
        try {
            File test_file = FileUtil.newFile(target, new String[0]);
            test_file = VuzeFileHandler.migrateFile(test_file);
            if (test_file.isFile()) {
                return this.getVuzeFile(FileUtil.newFileInputStream(test_file));
            }
            URL url = new URI(target).toURL();
            String protocol = url.getProtocol().toLowerCase();
            if (protocol.equals("http") || protocol.equals("https") || protocol.equals("biglybt")) {
                ResourceDownloader rd = StaticUtilities.getResourceDownloaderFactory().create(url);
                return this.getVuzeFile(rd.download());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public VuzeFile loadVuzeFile(byte[] bytes) {
        return this.loadVuzeFile(new ByteArrayInputStream(bytes));
    }

    public VuzeFile loadVuzeFile(InputStream is) {
        return this.getVuzeFile(is);
    }

    /*
     * Loose catch block
     */
    public VuzeFile loadVuzeFile(File file) {
        VuzeFile vuzeFile;
        FileInputStream is;
        block12: {
            file = VuzeFileHandler.migrateFile(file);
            is = null;
            is = FileUtil.newFileInputStream(file);
            vuzeFile = this.getVuzeFile(is);
            if (is == null) break block12;
            try {
                ((InputStream)is).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return vuzeFile;
        catch (Throwable e) {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    protected VuzeFile getVuzeFile(InputStream is) {
        VuzeFile vuzeFile;
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            Map map;
            int next;
            bis.mark(100);
            boolean is_json = false;
            while ((next = bis.read()) != -1) {
                char c = (char)next;
                if (Character.isWhitespace(c)) continue;
                is_json = c == '{';
                break;
            }
            bis.reset();
            if (is_json) {
                byte[] bytes = FileUtil.readInputStreamAsByteArray(bis, 0x200000);
                map = BDecoder.decodeFromJSON(new String(bytes, "UTF-8"));
            } else {
                map = BDecoder.decode(bis);
            }
            vuzeFile = this.loadVuzeFile(map);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
        is.close();
        return vuzeFile;
    }

    public VuzeFile loadVuzeFile(Map map) {
        if (map.containsKey("vuze") && !map.containsKey("info")) {
            return new VuzeFileImpl(this, (Map)map.get("vuze"));
        }
        return null;
    }

    public VuzeFile loadAndHandleVuzeFile(String target, int expected_types) {
        VuzeFile vf = this.loadVuzeFile(target);
        if (vf == null) {
            return null;
        }
        this.handleFiles(new VuzeFile[]{vf}, expected_types);
        return vf;
    }

    public void handleFiles(VuzeFile[] files, int expected_types) {
        for (VuzeFileProcessor proc : this.processors) {
            try {
                proc.process(files, expected_types);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        int i = 0;
        while (i < files.length) {
            VuzeFile vf = files[i];
            VuzeFileComponent[] comps = vf.getComponents();
            int j = 0;
            while (j < comps.length) {
                VuzeFileComponent comp2 = comps[j];
                if (!comp2.isProcessed()) {
                    Debug.out("Failed to handle Vuze file component " + comp2.getContent());
                }
                ++j;
            }
            ++i;
        }
    }

    public VuzeFile create() {
        return new VuzeFileImpl(this);
    }

    public void addProcessor(VuzeFileProcessor proc) {
        this.processors.add(proc);
    }
}

