/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.xml.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLConverter {
    private static final boolean ADD_ATTRIBUTES_FIRST = true;

    public static Map<String, Object> xmlToMap(byte[] bytes) throws IOException, SAXException, ParserConfigurationException {
        return XMLConverter.xmlToMap(new ByteArrayInputStream(bytes));
    }

    public static Map<String, Object> xmlToMap(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return XMLConverter.xmlToMap(factory.newDocumentBuilder().parse(inputStream));
    }

    public static Map<String, Object> xmlToMap(Node doc) {
        return XMLConverter.xmlToMap(doc.getChildNodes(), null);
    }

    public static Map<String, Object> xmlToMap(NodeList nodelist, Map<String, Object> toMapOrNull) {
        HashMap<String, Object> map = toMapOrNull == null ? new HashMap<String, Object>() : toMapOrNull;
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node = nodelist.item(i);
            if (node != null) {
                String nodeName = node.getNodeName();
                boolean hasAttributes = node.hasAttributes();
                boolean hasChildNodes = node.hasChildNodes();
                if (hasAttributes || hasChildNodes) {
                    HashMap<String, Object> existing = null;
                    if (hasAttributes) {
                        existing = XMLConverter.attributesToMap(map, node, nodeName, null);
                    }
                    if (hasChildNodes) {
                        Node firstChildNode;
                        NodeList childNodes = node.getChildNodes();
                        boolean goDeeper = true;
                        if (childNodes.getLength() == 1 && (firstChildNode = childNodes.item(0)).getNodeType() == 3) {
                            String firstChildNodeVal = firstChildNode.getNodeValue();
                            if (hasAttributes) {
                                HashMap<String, Object> mapContent = existing == null ? new HashMap<String, Object>() : existing;
                                mapContent.put("content", XMLConverter.coerseString(firstChildNodeVal));
                                if (existing == null) {
                                    XMLConverter.addValueToMap(map, nodeName, mapContent);
                                }
                            } else {
                                XMLConverter.addValueToMap(map, nodeName, firstChildNodeVal);
                            }
                            goDeeper = false;
                        }
                        if (goDeeper) {
                            Map<String, Object> valMap = XMLConverter.xmlToMap(childNodes, existing);
                            if (existing == null) {
                                XMLConverter.addValueToMap(map, nodeName, valMap);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return map;
    }

    private static Map<String, Object> attributesToMap(Map<String, Object> mapParent, Node node, String nodeName, Map<String, Object> toMapOrNull) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return toMapOrNull;
        }
        HashMap<String, Object> mapAttributes = toMapOrNull == null ? new HashMap<String, Object>() : toMapOrNull;
        int i = 0;
        while (i < attributes.getLength()) {
            Node item = attributes.item(i);
            XMLConverter.addValueToMap(mapAttributes, item.getNodeName(), item.getNodeValue());
            ++i;
        }
        if (toMapOrNull == null) {
            XMLConverter.addValueToMap(mapParent, nodeName, mapAttributes);
        }
        return mapAttributes;
    }

    private static void addValueToMap(Map<String, Object> map, String key, Object val) {
        if (val instanceof String) {
            val = XMLConverter.coerseString((String)val);
        }
        if (map.containsKey(key)) {
            Object oldVal = map.get(key);
            if (oldVal instanceof Collection) {
                ((Collection)oldVal).add(val);
            } else {
                map.put(key, new ArrayList<Object>(Arrays.asList(oldVal, val)));
            }
        } else {
            map.put(key, val);
        }
    }

    private static Object coerseString(String s) {
        boolean isLikelyValid;
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        char c = s.charAt(0);
        int startPos = 1;
        if (c == '-' && s.length() > 1) {
            char next = s.charAt(1);
            ++startPos;
            isLikelyValid = next >= '0' && next <= '9';
        } else {
            boolean bl = isLikelyValid = c >= '0' && c <= '9';
        }
        if (isLikelyValid) {
            boolean hasDot = false;
            int i = startPos;
            while (isLikelyValid && i < s.length()) {
                c = s.charAt(i);
                if (c == '.') {
                    isLikelyValid = !hasDot;
                    hasDot = true;
                } else {
                    isLikelyValid = c >= '0' && c <= '9' || c == '-' || c == 'e' || c == 'E';
                }
                ++i;
            }
            if (isLikelyValid) {
                try {
                    if (hasDot) {
                        return Double.parseDouble(s);
                    }
                    return Long.parseLong(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return s;
    }
}

