/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.xml.util;

import com.biglybt.core.util.ByteEncodedKeyHashMap;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class XUXmlWriter {
    private static final int INDENT_AMOUNT = 4;
    private String current_indent_string;
    private PrintWriter writer;
    private boolean generic_simple;

    protected XUXmlWriter() {
        this.resetIndent();
    }

    protected XUXmlWriter(OutputStream _output_stream) {
        this.setOutputStream(_output_stream);
        this.resetIndent();
    }

    protected void setOutputStream(OutputStream _output_stream) {
        this.writer = new PrintWriter(new OutputStreamWriter(_output_stream, Constants.DEFAULT_ENCODING_CHARSET));
    }

    protected void setOutputWriter(Writer _writer) {
        this.writer = _writer instanceof PrintWriter ? (PrintWriter)_writer : new PrintWriter(_writer);
    }

    protected void setGenericSimple(boolean simple) {
        this.generic_simple = simple;
    }

    protected void writeTag(String tag, String content) {
        this.writeLineRaw("<" + tag + ">" + XUXmlWriter.escapeXML(content) + "</" + tag + ">");
    }

    protected void writeTag(String tag, long content) {
        this.writeLineRaw("<" + tag + ">" + content + "</" + tag + ">");
    }

    protected void writeTag(String tag, boolean content) {
        this.writeLineRaw("<" + tag + ">" + (content ? "YES" : "NO") + "</" + tag + ">");
    }

    protected void writeLineRaw(String str) {
        this.writer.println(String.valueOf(this.current_indent_string) + str);
    }

    protected void writeLineEscaped(String str) {
        this.writer.println(String.valueOf(this.current_indent_string) + XUXmlWriter.escapeXML(str));
    }

    protected void resetIndent() {
        this.current_indent_string = "";
    }

    protected void indent() {
        int i = 0;
        while (i < 4) {
            this.current_indent_string = String.valueOf(this.current_indent_string) + " ";
            ++i;
        }
    }

    protected void exdent() {
        this.current_indent_string = this.current_indent_string.length() >= 4 ? this.current_indent_string.substring(0, this.current_indent_string.length() - 4) : "";
    }

    public static String escapeXML(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("'", "&apos;");
        str = str.replaceAll("--", "&#45;&#45;");
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || !Character.isDefined((int)c)) {
                chars[i] = 63;
            }
            ++i;
        }
        return new String(chars);
    }

    public static String unescapeXML(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&apos;", "'");
        str = str.replaceAll("&#45;&#45;", "--");
        str = str.replaceAll("&amp;", "&");
        return str;
    }

    public static String[] splitWithEscape(String str, char delim) {
        ArrayList<String> res = new ArrayList<String>();
        String current = "";
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '\\' && i + 1 < chars.length && chars[i + 1] == delim) {
                current = String.valueOf(current) + delim;
                ++i;
            } else if (c == delim) {
                if (current.length() > 0) {
                    res.add(current);
                    current = "";
                }
            } else {
                current = String.valueOf(current) + c;
            }
            ++i;
        }
        if (current.length() > 0) {
            res.add(current);
        }
        return res.toArray(new String[res.size()]);
    }

    protected void flushOutputStream() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    protected void closeOutputStream() {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    protected void writeGenericMapEntry(String name, Object value) {
        if (this.generic_simple) {
            name = name.replace(' ', '_').toUpperCase();
            this.writeLineRaw("<" + name + ">");
            try {
                this.indent();
                this.writeGeneric(value);
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</" + name + ">");
        } else {
            this.writeLineRaw("<KEY name=\"" + XUXmlWriter.escapeXML(name) + "\">");
            try {
                this.indent();
                this.writeGeneric(value);
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</KEY>");
        }
    }

    protected void writeGeneric(Object obj) {
        if (obj instanceof Map) {
            this.writeGeneric((Map)obj);
        } else if (obj instanceof List) {
            this.writeGeneric((List)obj);
        } else if (obj instanceof String) {
            this.writeGeneric((String)obj);
        } else if (obj instanceof byte[]) {
            this.writeGeneric((byte[])obj);
        } else {
            this.writeGeneric((Long)obj);
        }
    }

    protected void writeGeneric(Map map) {
        boolean byte_keys = map instanceof ByteEncodedKeyHashMap;
        if (byte_keys) {
            this.writeLineRaw("<MAP byte_keys=\"true\">");
        } else {
            this.writeLineRaw("<MAP>");
        }
        try {
            this.indent();
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (byte_keys) {
                    byte[] key_bytes = key.getBytes(Constants.BYTE_ENCODING_CHARSET);
                    key = this.encodeBytes(key_bytes);
                    this.writeGenericMapEntry(key, value);
                    continue;
                }
                this.writeGenericMapEntry(key, value);
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</MAP>");
    }

    protected void writeGeneric(List list) {
        this.writeLineRaw("<LIST>");
        try {
            this.indent();
            int i = 0;
            while (i < list.size()) {
                this.writeGeneric(list.get(i));
                ++i;
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</LIST>");
    }

    protected void writeGeneric(byte[] bytes) {
        if (this.generic_simple) {
            try {
                this.writeLineRaw(XUXmlWriter.escapeXML(new String(bytes, "UTF-8")));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.writeTag("BYTES", this.encodeBytes(bytes));
        }
    }

    protected void writeGeneric(String str) {
        if (this.generic_simple) {
            try {
                this.writeLineRaw(XUXmlWriter.escapeXML(str));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.writeTag("STRING", str);
        }
    }

    protected void writeGeneric(Long l) {
        if (this.generic_simple) {
            this.writeLineRaw(l.toString());
        } else {
            this.writeTag("LONG", "" + l);
        }
    }

    protected void writeTag(String tag, byte[] content) {
        this.writeLineRaw("<" + tag + ">" + this.encodeBytes(content) + "</" + tag + ">");
    }

    protected void writeLocalisableTag(String tag, byte[] content) {
        boolean use_bytes = true;
        String utf_string = new String(content, Constants.DEFAULT_ENCODING_CHARSET);
        if (Arrays.equals(content, utf_string.getBytes(Constants.DEFAULT_ENCODING_CHARSET))) {
            use_bytes = false;
        }
        this.writeLineRaw("<" + tag + " encoding=\"" + (use_bytes ? "bytes" : "utf8") + "\">" + (use_bytes ? this.encodeBytes(content) : XUXmlWriter.escapeXML(utf_string)) + "</" + tag + ">");
    }

    protected String encodeBytes(byte[] bytes) {
        String data = ByteFormatter.nicePrint(bytes, true, Integer.MAX_VALUE);
        return data;
    }
}

