/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.natpmp.upnp.impl;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.ThreadPool;
import com.biglybt.net.natpmp.NatPMPDevice;
import com.biglybt.net.natpmp.upnp.impl.NatPMPImpl;
import com.biglybt.net.upnp.UPnP;
import com.biglybt.net.upnp.UPnPAction;
import com.biglybt.net.upnp.UPnPDevice;
import com.biglybt.net.upnp.UPnPDeviceImage;
import com.biglybt.net.upnp.UPnPException;
import com.biglybt.net.upnp.UPnPRootDevice;
import com.biglybt.net.upnp.UPnPRootDeviceListener;
import com.biglybt.net.upnp.UPnPService;
import com.biglybt.net.upnp.UPnPStateVariable;
import com.biglybt.net.upnp.services.UPnPSpecificService;
import com.biglybt.net.upnp.services.UPnPWANConnection;
import com.biglybt.net.upnp.services.UPnPWANConnectionListener;
import com.biglybt.net.upnp.services.UPnPWANConnectionPortMapping;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NatPMPUPnPRootDeviceImpl
implements UPnPRootDevice {
    private UPnP upnp;
    private NatPMPDevice nat_device;
    private String USN = "natpmp";
    private URL location;
    private UPnPDevice device;
    private UPnPService[] services;
    private ThreadPool thread_pool;

    public NatPMPUPnPRootDeviceImpl(UPnP _upnp, NatPMPDevice _nat_device) throws Exception {
        this.upnp = _upnp;
        this.nat_device = _nat_device;
        this.location = new URL("http://undefined/");
        this.device = new NatPMPUPnPDevice();
        this.services = new UPnPService[]{new NatPMPUPnPWANConnection()};
        this.thread_pool = new ThreadPool("NatPMPUPnP", 1, true);
    }

    @Override
    public UPnP getUPnP() {
        return this.upnp;
    }

    @Override
    public String getUSN() {
        return this.USN;
    }

    @Override
    public URL getLocation() {
        return this.location;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.nat_device.getLocalAddress();
    }

    @Override
    public NetworkInterface getNetworkInterface() {
        return this.nat_device.getNetworkInterface();
    }

    @Override
    public String getInfo() {
        return "Nat-PMP";
    }

    @Override
    public UPnPDevice getDevice() {
        return this.device;
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    @Override
    public Map getDiscoveryCache() {
        return null;
    }

    @Override
    public void addListener(UPnPRootDeviceListener l) {
    }

    @Override
    public void removeListener(UPnPRootDeviceListener l) {
    }

    protected class NatPMPUPnPDevice
    implements UPnPDevice {
        protected NatPMPUPnPDevice() {
        }

        @Override
        public String getDeviceType() {
            return "NatPMP";
        }

        @Override
        public String getFriendlyName() {
            return "NatPMP";
        }

        @Override
        public String getManufacturer() {
            return "";
        }

        @Override
        public String getManufacturerURL() {
            return "";
        }

        @Override
        public String getModelDescription() {
            return "";
        }

        @Override
        public String getModelName() {
            return "";
        }

        @Override
        public String getModelNumber() {
            return "";
        }

        @Override
        public String getModelURL() {
            return "";
        }

        @Override
        public String getPresentation() {
            return "";
        }

        @Override
        public UPnPDevice[] getSubDevices() {
            return new UPnPDevice[0];
        }

        @Override
        public UPnPService[] getServices() {
            return NatPMPUPnPRootDeviceImpl.this.services;
        }

        @Override
        public UPnPRootDevice getRootDevice() {
            return NatPMPUPnPRootDeviceImpl.this;
        }

        @Override
        public UPnPDeviceImage[] getImages() {
            return new UPnPDeviceImage[0];
        }
    }

    protected class NatPMPUPnPWANConnection
    implements UPnPWANConnection,
    UPnPService {
        private NatPMPImpl nat_impl;

        protected NatPMPUPnPWANConnection() throws UPnPException {
            this.nat_impl = new NatPMPImpl(NatPMPUPnPRootDeviceImpl.this.nat_device);
        }

        @Override
        public UPnPDevice getDevice() {
            return NatPMPUPnPRootDeviceImpl.this.device;
        }

        @Override
        public String getServiceType() {
            return "urn:schemas-upnp-org:service:WANIPConnection:1";
        }

        @Override
        public String getConnectionType() {
            return "IP";
        }

        @Override
        public List<URL> getControlURLs() throws UPnPException {
            return new ArrayList<URL>(0);
        }

        @Override
        public void setPreferredControlURL(URL url) {
        }

        @Override
        public boolean isConnectable() {
            return true;
        }

        @Override
        public UPnPAction[] getActions() throws UPnPException {
            return new UPnPAction[0];
        }

        @Override
        public UPnPAction getAction(String name) throws UPnPException {
            return null;
        }

        @Override
        public UPnPStateVariable[] getStateVariables() throws UPnPException {
            return new UPnPStateVariable[0];
        }

        @Override
        public UPnPStateVariable getStateVariable(String name) throws UPnPException {
            return null;
        }

        @Override
        public UPnPSpecificService getSpecificService() {
            return this;
        }

        @Override
        public UPnPService getGenericService() {
            return this;
        }

        @Override
        public boolean getDirectInvocations() {
            return true;
        }

        @Override
        public void setDirectInvocations(boolean force) {
        }

        @Override
        public void addPortMapping(final boolean tcp, final int port, final String description) throws UPnPException {
            NatPMPUPnPRootDeviceImpl.this.thread_pool.run(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        NatPMPUPnPWANConnection.this.nat_impl.addPortMapping(tcp, port, description);
                    }
                    catch (UPnPException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        @Override
        public UPnPWANConnectionPortMapping[] getPortMappings() throws UPnPException {
            return this.nat_impl.getPortMappings();
        }

        @Override
        public void deletePortMapping(final boolean tcp, final int port) throws UPnPException {
            NatPMPUPnPRootDeviceImpl.this.thread_pool.run(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        NatPMPUPnPWANConnection.this.nat_impl.deletePortMapping(tcp, port);
                    }
                    catch (UPnPException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        @Override
        public String[] getStatusInfo() throws UPnPException {
            return this.nat_impl.getStatusInfo();
        }

        @Override
        public String getExternalIPAddress() throws UPnPException {
            return this.nat_impl.getExternalIPAddress();
        }

        @Override
        public void periodicallyRecheckMappings(boolean on) {
        }

        @Override
        public int getCapabilities() {
            return -1;
        }

        @Override
        public void addListener(UPnPWANConnectionListener listener) {
        }

        @Override
        public void removeListener(UPnPWANConnectionListener listener) {
        }
    }
}

