/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.udp.uc.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.biglybt.core.stats.CoreStats;
import com.biglybt.core.stats.CoreStatsProvider;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEPriorityMixin;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.SHA1Hasher;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.net.udp.uc.PRUDPPacket;
import com.biglybt.net.udp.uc.PRUDPPacketHandler;
import com.biglybt.net.udp.uc.PRUDPPacketHandlerException;
import com.biglybt.net.udp.uc.PRUDPPacketHandlerStats;
import com.biglybt.net.udp.uc.PRUDPPacketReceiver;
import com.biglybt.net.udp.uc.PRUDPPacketReply;
import com.biglybt.net.udp.uc.PRUDPPacketRequest;
import com.biglybt.net.udp.uc.PRUDPPrimordialHandler;
import com.biglybt.net.udp.uc.PRUDPRequestHandler;
import com.biglybt.net.udp.uc.impl.PRUDPPacketHandlerRequestImpl;
import com.biglybt.net.udp.uc.impl.PRUDPPacketHandlerSocks;
import com.biglybt.net.udp.uc.impl.PRUDPPacketHandlerStatsImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.SocketTimeoutException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.bouncycastle.util.encoders.Base64;

public class PRUDPPacketHandlerImpl
implements PRUDPPacketHandler {
    private static final LogIDs LOGID = LogIDs.NET;
    private boolean TRACE_REQUESTS = false;
    private static int MAX_PACKET_SIZE;
    private static volatile long total_packets_sent;
    private static volatile long total_packets_received;
    private static volatile long total_bytes_sent;
    private static volatile long total_bytes_received;
    private static final long MAX_SEND_QUEUE_DATA_SIZE = 0x200000L;
    private static final long MAX_RECV_QUEUE_DATA_SIZE = 0x100000L;
    private static boolean use_socks;
    private final int port;
    private DatagramSocket socket;
    private CopyOnWriteList<PRUDPPrimordialHandler> primordial_handlers = new CopyOnWriteList();
    private PRUDPRequestHandler request_handler;
    private PRUDPPacketHandlerStatsImpl stats = new PRUDPPacketHandlerStatsImpl(this);
    private Map<Integer, PRUDPPacketHandlerRequestImpl> requests = new LightHashMap<Integer, PRUDPPacketHandlerRequestImpl>();
    private AEMonitor requests_mon = new AEMonitor("PRUDPPH:req");
    private AEMonitor send_queue_mon = new AEMonitor("PRUDPPH:sd", true);
    private long send_queue_data_size;
    private final List[] send_queues = new List[]{new LinkedList(), new LinkedList(), new LinkedList()};
    private AESemaphore send_queue_sem = new AESemaphore("PRUDPPH:sq");
    private AEThread2 send_thread;
    private AEMonitor recv_queue_mon = new AEMonitor("PRUDPPH:rq", true);
    private long recv_queue_data_size;
    private List<Object[]> recv_queue = new ArrayList<Object[]>();
    private AESemaphore recv_queue_sem = new AESemaphore("PRUDPPH:rq");
    private AEThread2 recv_thread;
    private int send_delay = 0;
    private int receive_delay = 0;
    private int queued_request_timeout = 0;
    private long total_requests_received;
    private long total_requests_processed;
    private long total_replies;
    private long last_error_report;
    private AEMonitor bind_address_mon = new AEMonitor("PRUDPPH:bind");
    private InetAddress default_bind_ip;
    private InetAddress explicit_bind_ip;
    private boolean explicit_bind_ip_ad;
    private volatile InetAddress current_bind_ip;
    private volatile InetAddress target_bind_ip;
    private volatile boolean failed;
    private volatile boolean destroyed;
    private AESemaphore destroy_sem = new AESemaphore("PRUDPPacketHandler:destroy");
    private Throwable init_error;
    private PRUDPPacketHandlerImpl altProtocolDelegate;
    private final PacketTransformer packet_transformer;

    static {
        COConfigurationManager.addAndFireParameterListener("network.udp.mtu.size", new ParameterListener(){

            @Override
            public void parameterChanged(String parameter_name) {
                MAX_PACKET_SIZE = COConfigurationManager.getIntParameter(parameter_name);
            }
        });
        HashSet<String> types = new HashSet<String>();
        types.add("net.udp.send.packet.count");
        types.add("net.udp.send.byte.count");
        types.add("net.udp.receive.packet.count");
        types.add("net.udp.receive.byte.count");
        CoreStats.registerProvider(types, new CoreStatsProvider(){

            @Override
            public void updateStats(Set<String> types, Map<String, Object> values) {
                if (types.contains("net.udp.send.packet.count")) {
                    values.put("net.udp.send.packet.count", new Long(total_packets_sent));
                }
                if (types.contains("net.udp.send.byte.count")) {
                    values.put("net.udp.send.byte.count", new Long(total_bytes_sent));
                }
                if (types.contains("net.udp.receive.packet.count")) {
                    values.put("net.udp.receive.packet.count", new Long(total_packets_received));
                }
                if (types.contains("net.udp.receive.byte.count")) {
                    values.put("net.udp.receive.byte.count", new Long(total_bytes_received));
                }
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable.Proxy", "Enable.SOCKS"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameter_name) {
                boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                use_socks = enable_proxy && enable_socks;
            }
        });
    }

    protected PRUDPPacketHandlerImpl(int _port, InetAddress _bind_ip, PacketTransformer _packet_transformer) {
        TimerEventPeriodic[] f_ev;
        this.port = _port;
        this.explicit_bind_ip = _bind_ip;
        this.packet_transformer = _packet_transformer;
        this.default_bind_ip = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
        this.calcBind();
        final AESemaphore init_sem = new AESemaphore("PRUDPPacketHandler:init");
        new AEThread2("PRUDPPacketReciever:" + this.port, true){

            @Override
            public void run() {
                PRUDPPacketHandlerImpl.this.receiveLoop(init_sem);
            }
        }.start();
        TimerEventPeriodic ev = SimpleTimer.addPeriodicEvent("PRUDP:timeouts", 5000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                boolean jobDone = PRUDPPacketHandlerImpl.this.checkTimeouts();
                if (jobDone && f_ev[0] != null) {
                    f_ev[0].cancel();
                }
            }
        });
        f_ev = new TimerEventPeriodic[]{ev};
        init_sem.reserve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPrimordialHandler() {
        CopyOnWriteList<PRUDPPrimordialHandler> copyOnWriteList = this.primordial_handlers;
        synchronized (copyOnWriteList) {
            return this.primordial_handlers.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrimordialHandler(PRUDPPrimordialHandler handler) {
        CopyOnWriteList<PRUDPPrimordialHandler> copyOnWriteList = this.primordial_handlers;
        synchronized (copyOnWriteList) {
            if (this.primordial_handlers.contains(handler)) {
                Debug.out("Primordial handler already added!");
                return;
            }
            int priority = handler instanceof AEPriorityMixin ? ((AEPriorityMixin)((Object)handler)).getPriority() : 2;
            List<PRUDPPrimordialHandler> existing = this.primordial_handlers.getList();
            int insert_at = -1;
            int i = 0;
            while (i < existing.size()) {
                PRUDPPrimordialHandler e = existing.get(i);
                int existing_priority = e instanceof AEPriorityMixin ? ((AEPriorityMixin)((Object)e)).getPriority() : 2;
                if (existing_priority < priority) {
                    insert_at = i;
                    break;
                }
                ++i;
            }
            if (insert_at >= 0) {
                this.primordial_handlers.add(insert_at, handler);
            } else {
                this.primordial_handlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrimordialHandler(PRUDPPrimordialHandler handler) {
        CopyOnWriteList<PRUDPPrimordialHandler> copyOnWriteList = this.primordial_handlers;
        synchronized (copyOnWriteList) {
            if (!this.primordial_handlers.contains(handler)) {
                Debug.out("Primordial handler not found!");
                return;
            }
            this.primordial_handlers.remove(handler);
        }
    }

    @Override
    public void setRequestHandler(PRUDPRequestHandler _request_handler) {
        if (this.request_handler != null && _request_handler != null) {
            throw new RuntimeException("Multiple handlers per endpoint not supported");
        }
        this.request_handler = _request_handler;
        PRUDPPacketHandlerImpl delegate = this.altProtocolDelegate;
        if (delegate != null) {
            delegate.setRequestHandler(_request_handler);
        }
    }

    @Override
    public PRUDPRequestHandler getRequestHandler() {
        return this.request_handler;
    }

    @Override
    public int getPort() {
        if (this.port == 0 && this.socket != null) {
            return this.socket.getLocalPort();
        }
        return this.port;
    }

    @Override
    public InetAddress getCurrentBindAddress() {
        return this.current_bind_ip;
    }

    protected void setDefaultBindAddress(InetAddress address) {
        try {
            this.bind_address_mon.enter();
            this.default_bind_ip = address;
            this.calcBind();
        }
        finally {
            this.bind_address_mon.exit();
        }
    }

    @Override
    public InetAddress getExplicitBindAddress() {
        return this.explicit_bind_ip;
    }

    @Override
    public void setExplicitBindAddress(InetAddress address, boolean autoDelegate) {
        try {
            this.bind_address_mon.enter();
            this.explicit_bind_ip = address;
            this.explicit_bind_ip_ad = autoDelegate;
            this.calcBind();
        }
        finally {
            this.bind_address_mon.exit();
        }
        int loops = 0;
        while (this.current_bind_ip != this.target_bind_ip && !this.failed && !this.destroyed) {
            if (loops >= 100) {
                Debug.out("Giving up on wait for bind ip change to take effect");
                break;
            }
            try {
                Thread.sleep(50L);
                ++loops;
            }
            catch (Throwable e) {
                break;
            }
        }
    }

    protected void calcBind() {
        if (this.explicit_bind_ip != null) {
            if (this.explicit_bind_ip_ad) {
                InetAddress alt;
                InetAddress altAddress = null;
                NetworkAdmin adm = NetworkAdmin.getSingleton();
                try {
                    if (this.explicit_bind_ip instanceof Inet6Address && !this.explicit_bind_ip.isAnyLocalAddress() && adm.hasIPV4Potential()) {
                        altAddress = adm.getSingleHomedServiceBindAddress(1);
                    } else if (this.explicit_bind_ip instanceof Inet4Address && adm.hasIPV6Potential()) {
                        altAddress = adm.getSingleHomedServiceBindAddress(2);
                    }
                }
                catch (UnsupportedAddressTypeException unsupportedAddressTypeException) {
                    // empty catch block
                }
                if (this.altProtocolDelegate != null && !this.altProtocolDelegate.explicit_bind_ip.equals(altAddress)) {
                    this.altProtocolDelegate.destroy();
                    this.altProtocolDelegate = null;
                }
                if (altAddress != null && altAddress.isAnyLocalAddress() && (alt = adm.getAlternativeProtocolBindAddress(this.explicit_bind_ip)) != null) {
                    altAddress = alt;
                }
                this.target_bind_ip = this.explicit_bind_ip;
                if (altAddress != null && this.altProtocolDelegate == null) {
                    this.altProtocolDelegate = new PRUDPPacketHandlerImpl(this.port, altAddress, this.packet_transformer);
                    this.altProtocolDelegate.stats = this.stats;
                    this.altProtocolDelegate.primordial_handlers = this.primordial_handlers;
                    this.altProtocolDelegate.request_handler = this.request_handler;
                }
            } else {
                if (this.altProtocolDelegate != null) {
                    this.altProtocolDelegate.destroy();
                    this.altProtocolDelegate = null;
                }
                this.target_bind_ip = this.explicit_bind_ip;
            }
        } else {
            InetAddress altAddress = null;
            NetworkAdmin adm = NetworkAdmin.getSingleton();
            try {
                if (this.default_bind_ip instanceof Inet6Address && !this.default_bind_ip.isAnyLocalAddress() && adm.hasIPV4Potential()) {
                    altAddress = adm.getSingleHomedServiceBindAddress(1);
                } else if (this.default_bind_ip instanceof Inet4Address && adm.hasIPV6Potential()) {
                    altAddress = adm.getSingleHomedServiceBindAddress(2);
                }
            }
            catch (UnsupportedAddressTypeException unsupportedAddressTypeException) {
                // empty catch block
            }
            if (this.altProtocolDelegate != null && !this.altProtocolDelegate.explicit_bind_ip.equals(altAddress)) {
                this.altProtocolDelegate.destroy();
                this.altProtocolDelegate = null;
            }
            if (altAddress != null && this.altProtocolDelegate == null) {
                this.altProtocolDelegate = new PRUDPPacketHandlerImpl(this.port, altAddress, this.packet_transformer);
                this.altProtocolDelegate.stats = this.stats;
                this.altProtocolDelegate.primordial_handlers = this.primordial_handlers;
                this.altProtocolDelegate.request_handler = this.request_handler;
            }
            this.target_bind_ip = this.default_bind_ip;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void receiveLoop(AESemaphore init_sem) {
        last_socket_close_time = 0L;
        prop_listener = new NetworkAdminPropertyChangeListener(){

            @Override
            public void propertyChanged(String property) {
                if (property == "Default Bind IP") {
                    PRUDPPacketHandlerImpl.this.setDefaultBindAddress(NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress());
                }
            }
        };
        NetworkAdmin.getSingleton().addPropertyChangeListener(prop_listener);
        try {
            try {
                if (true) ** GOTO lbl118
                do {
                    block48: {
                        if (this.socket != null) {
                            try {
                                this.socket.close();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        address = null;
                        new_socket = null;
                        try {
                            if (this.target_bind_ip == null) {
                                address = new InetSocketAddress("127.0.0.1", this.port);
                                new_socket = new DatagramSocket(this.port);
                            } else {
                                address = new InetSocketAddress(this.target_bind_ip, this.port);
                                new_socket = new DatagramSocket(address);
                            }
                            break block48;
                        }
                        catch (BindException e) {
                            rebind_worked = false;
                            delay = 25;
                            i = 0;
                            ** while (i < 16 && !this.failed && !this.destroyed)
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                Thread.sleep(delay);
                                if ((delay *= 2) > 1000) {
                                    delay = 1000;
                                }
                                if (this.target_bind_ip == null) {
                                    address = new InetSocketAddress("127.0.0.1", this.port);
                                    new_socket = new DatagramSocket(this.port);
                                } else {
                                    address = new InetSocketAddress(this.target_bind_ip, this.port);
                                    new_socket = new DatagramSocket(address);
                                }
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(PRUDPPacketHandlerImpl.LOGID, "PRUDPPacketReceiver: rebind to " + this.target_bind_ip + " worked (tries=" + (i + 1) + ") after getting " + Debug.getNestedExceptionMessage(e)));
                                }
                                rebind_worked = true;
                                break;
                            }
                            catch (Throwable var11_17) {
                                ++i;
                            }
                            continue;
                        }
lbl46:
                        // 2 sources

                        if (!rebind_worked) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(PRUDPPacketHandlerImpl.LOGID, "PRUDPPacketReceiver: bind failed with " + Debug.getNestedExceptionMessage(e)));
                            }
                            if (!this.target_bind_ip.isAnyLocalAddress()) throw e;
                            guess = NetworkAdmin.getSingleton().guessRoutableBindAddress();
                            if (guess == null) throw e;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(PRUDPPacketHandlerImpl.LOGID, "PRUDPPacketReceiver: retrying with bind IP guess of " + guess));
                            }
                            try {
                                guess_address = new InetSocketAddress(guess, this.port);
                                new_socket = new DatagramSocket(guess_address);
                                this.target_bind_ip = guess;
                                address = guess_address;
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(PRUDPPacketHandlerImpl.LOGID, "PRUDPPacketReceiver: Switched to explicit bind ip " + this.target_bind_ip + " after initial bind failure with wildcard (" + e.getMessage() + ")"));
                                }
                            }
                            catch (Throwable f) {
                                throw e;
                            }
                        }
                    }
                    new_socket.setReuseAddress(true);
                    new_socket.setSoTimeout(1000);
                    this.socket = new_socket;
                    this.current_bind_ip = this.target_bind_ip;
                    init_sem.release();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(PRUDPPacketHandlerImpl.LOGID, "PRUDPPacketReceiver: receiver established on port " + this.port + (this.current_bind_ip == null ? "" : ", bound to " + this.current_bind_ip)));
                    }
                    buffer = null;
                    successful_accepts = 0L;
                    failed_accepts = 0L;
                    while (!this.failed && !this.destroyed) {
                        if (this.current_bind_ip != this.target_bind_ip) break;
                        try {
                            if (buffer == null) {
                                buffer = new byte[PRUDPPacketHandlerImpl.MAX_PACKET_SIZE];
                            }
                            packet = new DatagramPacket(buffer, buffer.length, address);
                            this.receiveFromSocket(packet);
                            if (packet.getLength() > PRUDPPacketHandlerImpl.MAX_PACKET_SIZE && PRUDPPacketHandlerImpl.MAX_PACKET_SIZE < 8192) {
                                Debug.out("UDP Packet truncated: received length=" + packet.getLength() + ", current max=" + PRUDPPacketHandlerImpl.MAX_PACKET_SIZE);
                                PRUDPPacketHandlerImpl.MAX_PACKET_SIZE = Math.min(packet.getLength() + 256, 8192);
                                buffer = null;
                                continue;
                            }
                            receive_time = SystemTime.getCurrentTime();
                            ++successful_accepts;
                            failed_accepts = 0L;
                            for (PRUDPPrimordialHandler prim_hand : this.primordial_handlers) {
                                if (!prim_hand.packetReceived(packet)) continue;
                                buffer = null;
                                this.stats.primordialPacketReceived(packet.getLength());
                                break;
                            }
                            if (buffer == null) continue;
                            this.process(packet, receive_time);
                        }
                        catch (SocketTimeoutException packet) {
                        }
                        catch (Throwable e) {
                            message = e.getMessage();
                            if (this.socket.isClosed() || message != null && message.toLowerCase().contains("socket closed")) {
                                now = SystemTime.getCurrentTime();
                                if (now - last_socket_close_time < 500L) {
                                    Thread.sleep(250L);
                                }
                                last_socket_close_time = now;
                                if (!Logger.isEnabled()) break;
                                Logger.log(new LogEvent(PRUDPPacketHandlerImpl.LOGID, "PRUDPPacketReceiver: recycled UDP port " + this.port + " after close: ok=" + successful_accepts));
                                break;
                            }
                            ++failed_accepts;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(PRUDPPacketHandlerImpl.LOGID, "PRUDPPacketReceiver: receive failed on port " + this.port + ": ok=" + successful_accepts + ", fails=" + failed_accepts, e));
                            }
                            if ((failed_accepts <= 100L || successful_accepts != 0L) && failed_accepts <= 1000L) continue;
                            Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.port, "UDP"});
                            this.init_error = e;
                            this.failed = true;
                        }
                    }
lbl118:
                    // 5 sources

                    if (this.failed) return;
                } while (!this.destroyed);
                return;
            }
            catch (Throwable e) {
                this.init_error = e;
                if (!(e instanceof BindException) || !Constants.isWindowsVistaOrHigher) {
                    Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"UDP:" + this.port});
                }
                Logger.log(new LogEvent(PRUDPPacketHandlerImpl.LOGID, "PRUDPPacketReceiver: DatagramSocket bind failed on port " + this.port + ", bind=" + this.target_bind_ip, e));
                init_sem.release();
                this.destroy_sem.releaseForever();
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if ((delegate = this.altProtocolDelegate) != null) {
                    delegate.destroy();
                }
                NetworkAdmin.getSingleton().removePropertyChangeListener(prop_listener);
            }
            return;
        }
        finally {
            init_sem.release();
            this.destroy_sem.releaseForever();
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if ((delegate = this.altProtocolDelegate) != null) {
                delegate.destroy();
            }
            NetworkAdmin.getSingleton().removePropertyChangeListener(prop_listener);
        }
    }

    protected boolean checkTimeouts() {
        PRUDPPacketHandlerRequestImpl request2;
        boolean result;
        long now = SystemTime.getCurrentTime();
        ArrayList<PRUDPPacketHandlerRequestImpl> timed_out = new ArrayList<PRUDPPacketHandlerRequestImpl>();
        try {
            this.requests_mon.enter();
            result = this.destroyed;
            Iterator<PRUDPPacketHandlerRequestImpl> it = this.requests.values().iterator();
            while (it.hasNext()) {
                request2 = it.next();
                long sent_time = request2.getSendTime();
                if (!this.destroyed && (sent_time == 0L || now - sent_time < request2.getTimeout())) continue;
                it.remove();
                this.stats.requestTimedOut();
                timed_out.add(request2);
            }
        }
        finally {
            this.requests_mon.exit();
        }
        int i = 0;
        while (i < timed_out.size()) {
            request2 = (PRUDPPacketHandlerRequestImpl)timed_out.get(i);
            if (this.TRACE_REQUESTS && Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "PRUDPPacketHandler: request timeout"));
            }
            try {
                request2.setException(new PRUDPPacketHandlerException("timed out"));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return result;
    }

    protected void process(DatagramPacket dg_packet, long receive_time) {
        block26: {
            try {
                Object request2;
                PRUDPPacket packet;
                boolean request_packet;
                byte[] packet_data = dg_packet.getData();
                int packet_len = dg_packet.getLength();
                if (packet_len == 0) {
                    Debug.out("zero length packet received");
                }
                this.stats.packetReceived(packet_len);
                InetSocketAddress originator = (InetSocketAddress)dg_packet.getSocketAddress();
                if ((packet_data[0] & 0x80) == 0) {
                    request_packet = false;
                    packet = PRUDPPacketReply.deserialiseReply(this, originator, new DataInputStream(new ByteArrayInputStream(packet_data, 0, packet_len)));
                } else {
                    request_packet = true;
                    request2 = PRUDPPacketRequest.deserialiseRequest(this, new DataInputStream(new ByteArrayInputStream(packet_data, 0, packet_len)));
                    ((PRUDPPacketRequest)request2).setReceiveTime(receive_time);
                    packet = request2;
                }
                packet.setSerialisedSize(packet_len);
                packet.setAddress(originator);
                if (request_packet) {
                    ++this.total_requests_received;
                    if (this.TRACE_REQUESTS) {
                        Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: request packet received: " + packet.getString()));
                    }
                    if (this.receive_delay > 0) {
                        try {
                            this.recv_queue_mon.enter();
                            if (this.recv_queue_data_size > 0x100000L) {
                                long now = SystemTime.getCurrentTime();
                                if (now - this.last_error_report > 30000L) {
                                    this.last_error_report = now;
                                    Debug.out("Receive queue size limit exceeded (1048576), dropping request packet [" + this.total_requests_received + "/" + this.total_requests_processed + ":" + this.total_replies + "]");
                                }
                            } else if (this.receive_delay * this.recv_queue.size() > this.queued_request_timeout) {
                                long now = SystemTime.getCurrentTime();
                                if (now - this.last_error_report > 30000L) {
                                    this.last_error_report = now;
                                    Debug.out("Receive queue entry limit exceeded (" + this.recv_queue.size() + "), dropping request packet [" + this.total_requests_received + "/" + this.total_requests_processed + ":" + this.total_replies + "]");
                                }
                            } else {
                                this.recv_queue.add(new Object[]{packet, new Integer(packet_len)});
                                this.recv_queue_data_size += (long)packet_len;
                                this.recv_queue_sem.release();
                                if (this.recv_thread == null) {
                                    this.recv_thread = new AEThread2("PRUDPPacketHandler:receiver"){

                                        @Override
                                        public void run() {
                                            InetAddress bind_ip = PRUDPPacketHandlerImpl.this.current_bind_ip;
                                            boolean set_name = true;
                                            Average request_receive_average = Average.getInstance(1000, 10);
                                            while (true) {
                                                InetAddress bp;
                                                if (!set_name && (bp = PRUDPPacketHandlerImpl.this.current_bind_ip) != bind_ip) {
                                                    bind_ip = bp;
                                                    set_name = true;
                                                }
                                                if (set_name) {
                                                    set_name = false;
                                                    this.setName("PRUDPPacketHandler:receiver: " + bind_ip + ":" + PRUDPPacketHandlerImpl.this.port);
                                                }
                                                try {
                                                    Object[] data;
                                                    boolean got_it = PRUDPPacketHandlerImpl.this.recv_queue_sem.reserve(30000L);
                                                    try {
                                                        PRUDPPacketHandlerImpl.this.recv_queue_mon.enter();
                                                        if (!got_it) {
                                                            if (PRUDPPacketHandlerImpl.this.recv_queue_data_size != 0L) continue;
                                                            PRUDPPacketHandlerImpl.this.recv_thread = null;
                                                            break;
                                                        }
                                                        data = (Object[])PRUDPPacketHandlerImpl.this.recv_queue.remove(0);
                                                        PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl = PRUDPPacketHandlerImpl.this;
                                                        pRUDPPacketHandlerImpl.total_requests_processed = pRUDPPacketHandlerImpl.total_requests_processed + 1L;
                                                        PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl2 = PRUDPPacketHandlerImpl.this;
                                                        pRUDPPacketHandlerImpl2.recv_queue_data_size = pRUDPPacketHandlerImpl2.recv_queue_data_size - (long)((Integer)data[1]).intValue();
                                                        request_receive_average.addValue(1L);
                                                    }
                                                    finally {
                                                        PRUDPPacketHandlerImpl.this.recv_queue_mon.exit();
                                                        continue;
                                                    }
                                                    PRUDPPacketRequest p = (PRUDPPacketRequest)data[0];
                                                    PRUDPRequestHandler handler = PRUDPPacketHandlerImpl.this.request_handler;
                                                    if (handler == null) continue;
                                                    handler.process(p);
                                                    if (PRUDPPacketHandlerImpl.this.receive_delay <= 0) continue;
                                                    int max_req_per_sec = 1000 / PRUDPPacketHandlerImpl.this.receive_delay;
                                                    long request_per_sec = request_receive_average.getAverage();
                                                    if (request_per_sec <= (long)max_req_per_sec) continue;
                                                    Thread.sleep(PRUDPPacketHandlerImpl.this.receive_delay);
                                                }
                                                catch (Throwable e) {
                                                    Debug.printStackTrace(e);
                                                }
                                            }
                                        }
                                    };
                                    this.recv_thread.start();
                                }
                            }
                            break block26;
                        }
                        finally {
                            this.recv_queue_mon.exit();
                        }
                    }
                    PRUDPRequestHandler handler = this.request_handler;
                    if (handler != null) {
                        handler.process((PRUDPPacketRequest)packet);
                    }
                    break block26;
                }
                ++this.total_replies;
                if (this.TRACE_REQUESTS) {
                    Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: reply packet received: " + packet.getString()));
                }
                try {
                    this.requests_mon.enter();
                    request2 = packet.hasContinuation() ? this.requests.get(new Integer(packet.getTransactionId())) : this.requests.remove(new Integer(packet.getTransactionId()));
                }
                finally {
                    this.requests_mon.exit();
                }
                if (request2 == null) {
                    if (this.TRACE_REQUESTS) {
                        Logger.log(new LogEvent(LOGID, 3, "PRUDPPacketReceiver: unmatched reply received, discarding:" + packet.getString()));
                    }
                } else {
                    ((PRUDPPacketHandlerRequestImpl)request2).setReply(packet, (InetSocketAddress)dg_packet.getSocketAddress(), receive_time);
                }
            }
            catch (Throwable e) {
                if (e instanceof IOException) break block26;
                Logger.log(new LogEvent(LOGID, "", e));
            }
        }
    }

    public PRUDPPacket sendAndReceive(PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        return this.sendAndReceive(null, request_packet, destination_address);
    }

    @Override
    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        return this.sendAndReceive(auth, request_packet, destination_address, 30000L);
    }

    @Override
    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address, long timeout) throws PRUDPPacketHandlerException {
        PRUDPPacketHandlerRequestImpl request2 = this.sendAndReceive(auth, request_packet, destination_address, null, timeout, 1);
        return request2.getReply();
    }

    @Override
    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address, long timeout, int priority) throws PRUDPPacketHandlerException {
        PRUDPPacketHandlerRequestImpl request2 = this.sendAndReceive(auth, request_packet, destination_address, null, timeout, priority);
        return request2.getReply();
    }

    @Override
    public void sendAndReceive(PRUDPPacket request_packet, InetSocketAddress destination_address, PRUDPPacketReceiver receiver, long timeout, int priority) throws PRUDPPacketHandlerException {
        this.sendAndReceive(null, request_packet, destination_address, receiver, timeout, priority);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PRUDPPacketHandlerRequestImpl sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, final InetSocketAddress destination_address, PRUDPPacketReceiver receiver, long timeout, int priority) throws PRUDPPacketHandlerException {
        if (this.socket == null) {
            if (this.init_error == null) throw new PRUDPPacketHandlerException("Transport unavailable");
            throw new PRUDPPacketHandlerException("Transport unavailable", this.init_error);
        }
        this.checkTargetAddress(destination_address);
        PRUDPPacketHandlerImpl delegate = this.altProtocolDelegate;
        if (delegate != null && destination_address.getAddress().getClass().isInstance(delegate.explicit_bind_ip)) {
            return delegate.sendAndReceive(auth, request_packet, destination_address, receiver, timeout, priority);
        }
        try {
            DatagramPacket dg_packet;
            int packet_len;
            MyByteArrayOutputStream baos = new MyByteArrayOutputStream(MAX_PACKET_SIZE);
            DataOutputStream os = new DataOutputStream(baos);
            request_packet.serialise(os);
            byte[] _buffer = baos.getBuffer();
            int _length = baos.size();
            request_packet.setSerialisedSize(_length);
            if (auth != null) {
                SHA1Hasher hasher = new SHA1Hasher();
                String user_name = auth.getUserName();
                String password = new String(auth.getPassword());
                byte[] sha1_password = user_name.equals("<internal>") ? Base64.decode(password) : hasher.calculateHash(password.getBytes());
                byte[] user_bytes = new byte[8];
                Arrays.fill(user_bytes, (byte)0);
                int i = 0;
                while (i < user_bytes.length && i < user_name.length()) {
                    user_bytes[i] = (byte)user_name.charAt(i);
                    ++i;
                }
                hasher = new SHA1Hasher();
                hasher.update(_buffer, 0, _length);
                hasher.update(user_bytes);
                hasher.update(sha1_password);
                byte[] overall_hash = hasher.getDigest();
                baos.write(user_bytes);
                baos.write(overall_hash, 0, 8);
                _buffer = baos.getBuffer();
                _length = baos.size();
            }
            if ((packet_len = (dg_packet = new DatagramPacket(_buffer, _length, destination_address)).getLength()) == 0) {
                Debug.out("zero length packet sent");
            }
            PRUDPPacketHandlerRequestImpl request2 = new PRUDPPacketHandlerRequestImpl(receiver, timeout);
            try {
                this.requests_mon.enter();
                if (this.destroyed) {
                    throw new PRUDPPacketHandlerException("Handler destroyed");
                }
                if (this.requests.put(new Integer(request_packet.getTransactionId()), request2) != null) {
                    Debug.out("Duplicate request transaction id!!!!");
                }
            }
            finally {
                this.requests_mon.exit();
            }
            try {
                if (this.send_delay > 0 && priority != 99) {
                    try {
                        this.send_queue_mon.enter();
                        if (this.send_queue_data_size > 0x200000L) {
                            request2.sent();
                            this.sendToSocket(dg_packet);
                            this.stats.packetSent(packet_len);
                            if (this.TRACE_REQUESTS) {
                                Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: request packet sent to " + destination_address + ": " + request_packet.getString()));
                            }
                            Thread.sleep(this.send_delay * 4);
                            return request2;
                        }
                        this.send_queue_data_size += (long)packet_len;
                        this.send_queues[priority].add(new Object[]{dg_packet, request2});
                        if (this.TRACE_REQUESTS) {
                            String str = "";
                            int i = 0;
                            while (i < this.send_queues.length) {
                                str = String.valueOf(str) + (i == 0 ? "" : ",") + this.send_queues[i].size();
                                ++i;
                            }
                            System.out.println("send queue sizes: " + str);
                        }
                        this.send_queue_sem.release();
                        if (this.send_thread != null) return request2;
                        this.send_thread = new AEThread2("PRUDPPacketHandler:sender"){

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public void run() {
                                int[] consecutive_sends = new int[PRUDPPacketHandlerImpl.this.send_queues.length];
                                InetAddress bind_ip = PRUDPPacketHandlerImpl.this.current_bind_ip;
                                boolean set_name = true;
                                while (true) {
                                    InetAddress bp;
                                    if (!set_name && (bp = PRUDPPacketHandlerImpl.this.current_bind_ip) != bind_ip) {
                                        bind_ip = bp;
                                        set_name = true;
                                    }
                                    if (set_name) {
                                        set_name = false;
                                        this.setName("PRUDPPacketHandler:sender: " + bind_ip + ":" + PRUDPPacketHandlerImpl.this.port);
                                    }
                                    try {
                                        DatagramPacket p;
                                        Object[] data;
                                        boolean got_it = PRUDPPacketHandlerImpl.this.send_queue_sem.reserve(30000L);
                                        int selected_priority = 0;
                                        try {
                                            PRUDPPacketHandlerImpl.this.send_queue_mon.enter();
                                            if (!got_it) {
                                                if (PRUDPPacketHandlerImpl.this.send_queue_data_size != 0L) continue;
                                                PRUDPPacketHandlerImpl.this.send_thread = null;
                                                return;
                                            }
                                            int i = 0;
                                            while (i < PRUDPPacketHandlerImpl.this.send_queues.length) {
                                                block16: {
                                                    List queue = PRUDPPacketHandlerImpl.this.send_queues[i];
                                                    int queue_size = queue.size();
                                                    if (queue_size > 0) {
                                                        selected_priority = i;
                                                        if (consecutive_sends[i] >= 4 || i < PRUDPPacketHandlerImpl.this.send_queues.length - 1 && PRUDPPacketHandlerImpl.this.send_queues[i + 1].size() - queue_size > 500) {
                                                            consecutive_sends[i] = 0;
                                                            break block16;
                                                        } else {
                                                            int n = i;
                                                            consecutive_sends[n] = consecutive_sends[n] + 1;
                                                            break;
                                                        }
                                                    }
                                                    consecutive_sends[i] = 0;
                                                }
                                                ++i;
                                            }
                                            data = (Object[])PRUDPPacketHandlerImpl.this.send_queues[selected_priority].remove(0);
                                            p = (DatagramPacket)data[0];
                                            PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl = PRUDPPacketHandlerImpl.this;
                                            pRUDPPacketHandlerImpl.send_queue_data_size = pRUDPPacketHandlerImpl.send_queue_data_size - (long)p.getLength();
                                        }
                                        finally {
                                            PRUDPPacketHandlerImpl.this.send_queue_mon.exit();
                                            continue;
                                        }
                                        p = (DatagramPacket)data[0];
                                        PRUDPPacketHandlerRequestImpl r = (PRUDPPacketHandlerRequestImpl)data[1];
                                        r.sent();
                                        PRUDPPacketHandlerImpl.this.sendToSocket(p);
                                        PRUDPPacketHandlerImpl.this.stats.packetSent(p.getLength());
                                        if (PRUDPPacketHandlerImpl.this.TRACE_REQUESTS) {
                                            Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: request packet sent to " + p.getAddress()));
                                        }
                                        long delay = PRUDPPacketHandlerImpl.this.send_delay;
                                        if (selected_priority == 0) {
                                            delay /= 2L;
                                        }
                                        Thread.sleep(delay);
                                    }
                                    catch (Throwable e) {
                                        Logger.log(new LogEvent(LOGID, 1, "PRUDPPacketHandler: send failed to " + destination_address + ": " + Debug.getNestedExceptionMessage(e)));
                                        continue;
                                    }
                                    break;
                                }
                            }
                        };
                        this.send_thread.start();
                        return request2;
                    }
                    finally {
                        this.send_queue_mon.exit();
                    }
                } else {
                    request2.sent();
                    this.sendToSocket(dg_packet);
                    this.stats.packetSent(packet_len);
                    if (!this.TRACE_REQUESTS) return request2;
                    Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: request packet sent to " + destination_address + ": " + request_packet.getString()));
                }
                return request2;
            }
            catch (Throwable e) {
                try {
                    this.requests_mon.enter();
                    this.requests.remove(new Integer(request_packet.getTransactionId()));
                    throw e;
                }
                finally {
                    this.requests_mon.exit();
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof NullPointerException) {
                Debug.out(e);
            }
            String msg = Debug.getNestedExceptionMessage(e);
            Logger.log(new LogEvent(LOGID, 3, "PRUDPPacketHandler: sendAndReceive to " + destination_address + " failed: " + msg));
            if (!msg.contains("Invalid data length")) throw new PRUDPPacketHandlerException("PRUDPPacketHandler:sendAndReceive failed", e);
            Debug.out("packet=" + request_packet.getString() + ",auth=" + auth);
            Debug.out(e);
            throw new PRUDPPacketHandlerException("PRUDPPacketHandler:sendAndReceive failed", e);
        }
    }

    @Override
    public void send(PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        if (this.socket == null || this.socket.isClosed()) {
            if (this.init_error != null) {
                throw new PRUDPPacketHandlerException("Transport unavailable", this.init_error);
            }
            throw new PRUDPPacketHandlerException("Transport unavailable");
        }
        this.checkTargetAddress(destination_address);
        PRUDPPacketHandlerImpl delegate = this.altProtocolDelegate;
        if (delegate != null && destination_address.getAddress().getClass().isInstance(delegate.explicit_bind_ip)) {
            delegate.send(request_packet, destination_address);
            return;
        }
        try {
            MyByteArrayOutputStream baos = new MyByteArrayOutputStream(MAX_PACKET_SIZE);
            DataOutputStream os = new DataOutputStream(baos);
            request_packet.serialise(os);
            byte[] _buffer = baos.getBuffer();
            int _length = baos.size();
            request_packet.setSerialisedSize(_length);
            DatagramPacket dg_packet = new DatagramPacket(_buffer, _length, destination_address);
            if (this.TRACE_REQUESTS) {
                Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: reply packet sent: " + request_packet.getString()));
            }
            this.sendToSocket(dg_packet);
            this.stats.packetSent(_length);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, 3, "PRUDPPacketHandler: send to " + destination_address + " failed: " + Debug.getNestedExceptionMessage(e)));
            throw new PRUDPPacketHandlerException("PRUDPPacketHandler:send failed", e);
        }
    }

    protected void checkTargetAddress(InetSocketAddress address) throws PRUDPPacketHandlerException {
        if (address.getPort() == 0) {
            throw new PRUDPPacketHandlerException("Invalid port - 0");
        }
        if (address.getAddress() == null) {
            throw new PRUDPPacketHandlerException("Unknown host " + address.getHostName());
        }
    }

    @Override
    public void setDelays(int _send_delay, int _receive_delay, int _queued_request_timeout) {
        PRUDPPacketHandlerImpl delegate;
        this.send_delay = _send_delay;
        this.receive_delay = _receive_delay;
        this.queued_request_timeout = _queued_request_timeout - 5000;
        if (this.queued_request_timeout < 5000) {
            this.queued_request_timeout = 5000;
        }
        if ((delegate = this.altProtocolDelegate) != null) {
            delegate.setDelays(_send_delay, _receive_delay, _queued_request_timeout);
        }
    }

    public long getSendQueueLength() {
        int res = 0;
        int i = 0;
        while (i < this.send_queues.length) {
            res += this.send_queues[i].size();
            ++i;
        }
        PRUDPPacketHandlerImpl delegate = this.altProtocolDelegate;
        if (delegate != null) {
            res = (int)((long)res + delegate.getSendQueueLength());
        }
        return res;
    }

    public long getReceiveQueueLength() {
        long size = this.recv_queue.size();
        PRUDPPacketHandlerImpl delegate = this.altProtocolDelegate;
        if (delegate != null) {
            size += delegate.getReceiveQueueLength();
        }
        return size;
    }

    @Override
    public void primordialSend(byte[] buffer, InetSocketAddress target) throws PRUDPPacketHandlerException {
        if (this.socket == null || this.socket.isClosed()) {
            if (this.init_error != null) {
                throw new PRUDPPacketHandlerException("Transport unavailable", this.init_error);
            }
            throw new PRUDPPacketHandlerException("Transport unavailable");
        }
        this.checkTargetAddress(target);
        PRUDPPacketHandlerImpl delegate = this.altProtocolDelegate;
        if (delegate != null && target.getAddress().getClass().isInstance(delegate.explicit_bind_ip)) {
            delegate.primordialSend(buffer, target);
            return;
        }
        try {
            DatagramPacket dg_packet = new DatagramPacket(buffer, buffer.length, target);
            if (this.TRACE_REQUESTS) {
                Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: reply packet sent: " + buffer.length + " to " + target));
            }
            this.sendToSocket(dg_packet);
            this.stats.primordialPacketSent(buffer.length);
        }
        catch (Throwable e) {
            throw new PRUDPPacketHandlerException(e.getMessage());
        }
    }

    private void sendToSocket(DatagramPacket p) throws IOException {
        ++total_packets_sent;
        total_bytes_sent += (long)p.getLength();
        if (this.packet_transformer != null) {
            this.packet_transformer.transformSend(p);
        }
        this.socket.send(p);
    }

    private void receiveFromSocket(DatagramPacket p) throws IOException {
        this.socket.receive(p);
        ++total_packets_received;
        total_bytes_received += (long)p.getLength();
        if (this.packet_transformer != null) {
            this.packet_transformer.transformReceive(p);
        }
    }

    @Override
    public PRUDPPacketHandlerStats getStats() {
        return this.stats;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        PRUDPPacketHandlerImpl delegate = this.altProtocolDelegate;
        if (delegate != null) {
            delegate.destroy();
        }
        this.destroy_sem.reserve();
    }

    @Override
    public PRUDPPacketHandler openSession(InetSocketAddress target) throws PRUDPPacketHandlerException {
        if (use_socks) {
            return new PRUDPPacketHandlerSocks(target);
        }
        return this;
    }

    @Override
    public void closeSession() throws PRUDPPacketHandlerException {
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private MyByteArrayOutputStream(int size) {
            super(size);
        }

        private byte[] getBuffer() {
            return this.buf;
        }
    }

    protected static interface PacketTransformer {
        public void transformSend(DatagramPacket var1);

        public void transformReceive(DatagramPacket var1);
    }
}

